/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.jpa.internal.jpql.AbstractValidator;
import org.eclipse.persistence.jpa.internal.jpql.DeclarationResolver;
import org.eclipse.persistence.jpa.internal.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.internal.jpql.LiteralType;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.StateFieldResolver;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AggregateFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.internal.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EncapsulatedIdentificationVariableExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.FuncExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Join;
import org.eclipse.persistence.jpa.internal.jpql.parser.JoinFetch;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.internal.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.internal.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.internal.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.internal.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.internal.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.MappingTypeHelper;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IJPAVersion;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SemanticValidator
extends AbstractValidator {
    private CollectionValuedPathExpressionVisitor collectionValuedPathExpressionVisitor;
    private NullValueVisitor nullValueVisitor;
    private boolean registerIdentificationVariable;
    private StateFieldPathExpressionVisitor stateFieldPathExpressionVisitor;
    private UpdateClauseAbstractSchemaNameFinder updateClauseAbstractSchemaNameFinder;
    private List<IdentificationVariable> usedIdentificationVariables;
    private Map<Class<? extends TypeValidator>, TypeValidator> validators;
    private VirtualIdentificationVariableFinder virtualIdentificationVariableFinder;

    public SemanticValidator(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    private void addIdentificationVariable(IdentificationVariable identificationVariable, Map<String, List<IdentificationVariable>> identificationVariables) {
        String variableName;
        String string = variableName = identificationVariable != null ? identificationVariable.getText() : null;
        if (ExpressionTools.stringIsNotEmpty(variableName)) {
            List<IdentificationVariable> variables = identificationVariables.get(variableName = variableName.toUpperCase());
            if (variables == null) {
                variables = new ArrayList<IdentificationVariable>();
                identificationVariables.put(variableName, variables);
            }
            variables.add(identificationVariable);
        }
    }

    private boolean areConstructorParametersEquivalent(ITypeDeclaration[] types1, IType[] types2) {
        if (types1.length == 0 || types2.length == 0) {
            return types2.length == types2.length;
        }
        if (types1.length != types1.length) {
            return false;
        }
        TypeHelper typeHelper = this.getTypeHelper();
        int index = types1.length;
        while (--index >= 0) {
            IType type2;
            IType type1 = typeHelper.convertPrimitive(types1[index].getType());
            if (type1.isAssignableTo(type2 = typeHelper.convertPrimitive(types2[index]))) continue;
            return false;
        }
        return true;
    }

    private Resolver buildStateFieldResolver(Resolver parentResolver, String path) {
        Resolver resolver = parentResolver.getChild(path);
        if (resolver == null) {
            resolver = new StateFieldResolver(parentResolver, path, null);
        }
        return resolver;
    }

    private void collectDeclarationIdentificationVariables(Map<String, List<IdentificationVariable>> identificationVariables) {
        for (DeclarationResolver.Declaration declaration : this.queryContext.getDeclarations()) {
            IdentificationVariable identificationVariable = declaration.identificationVariable;
            this.addIdentificationVariable(identificationVariable, identificationVariables);
            for (IdentificationVariable joinIdentificationVariable : declaration.joins.values()) {
                this.addIdentificationVariable(joinIdentificationVariable, identificationVariables);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectionValuedPathExpression collectionValuedPathExpression(Expression expression) {
        CollectionValuedPathExpressionVisitor visitor = this.collectionValuedPathExpressionVisitor();
        try {
            expression.accept(visitor);
            CollectionValuedPathExpression collectionValuedPathExpression = visitor.expression;
            return collectionValuedPathExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    private CollectionValuedPathExpressionVisitor collectionValuedPathExpressionVisitor() {
        if (this.collectionValuedPathExpressionVisitor == null) {
            this.collectionValuedPathExpressionVisitor = new CollectionValuedPathExpressionVisitor();
        }
        return this.collectionValuedPathExpressionVisitor;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.usedIdentificationVariables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSchemaName findAbstractSchemaName(UpdateItem expression) {
        UpdateClauseAbstractSchemaNameFinder visitor = this.updateClauseAbstractSchemaNameFinder();
        try {
            expression.accept(visitor);
            AbstractSchemaName abstractSchemaName = visitor.expression;
            return abstractSchemaName;
        }
        finally {
            visitor.expression = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdentificationVariable findVirtualIdentificationVariable(AbstractSchemaName expression) {
        VirtualIdentificationVariableFinder visitor = this.virtualIdentificationVariableFinder();
        try {
            expression.accept(visitor);
            IdentificationVariable identificationVariable = visitor.expression;
            return identificationVariable;
        }
        finally {
            visitor.expression = null;
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.validators = new HashMap<Class<? extends TypeValidator>, TypeValidator>();
        this.usedIdentificationVariables = new ArrayList<IdentificationVariable>();
        this.registerIdentificationVariable = true;
    }

    private boolean isBooleanType(Expression expression) {
        return this.isValid(expression, BooleanTypeValidator.class);
    }

    private boolean isComparisonEquivalentType(Expression expression1, Expression expression2) {
        IType type1 = this.getType(expression1);
        IType type2 = this.getType(expression2);
        TypeHelper typeHelper = this.getTypeHelper();
        return type1 == type2 || !type1.isResolvable() || !type2.isResolvable() || typeHelper.isNumericType(type1) && typeHelper.isNumericType(type2) || typeHelper.isDateType(type1) && typeHelper.isDateType(type2) || type1.isAssignableTo(type2) || type2.isAssignableTo(type1);
    }

    private boolean isEquivalentBetweenType(Expression expression1, Expression expression2) {
        IType type1 = this.getType(expression1);
        IType type2 = this.getType(expression2);
        if (!type1.isResolvable() || !type2.isResolvable()) {
            return true;
        }
        TypeHelper typeHelper = this.getTypeHelper();
        if (type1 == type2) {
            return typeHelper.isNumericType(type1) || typeHelper.isStringType(type1) || typeHelper.isDateType(type1);
        }
        return typeHelper.isNumericType(type1) && typeHelper.isNumericType(type2) || typeHelper.isStringType(type1) && typeHelper.isStringType(type2) || typeHelper.isDateType(type1) && typeHelper.isDateType(type2);
    }

    private boolean isIntegralType(Expression expression) {
        if (this.isNumericType(expression)) {
            TypeHelper typeHelper = this.getTypeHelper();
            IType type = this.getType(expression);
            if (type != typeHelper.unknownType()) {
                return typeHelper.isIntegralType(type);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNullValue(Expression expression) {
        NullValueVisitor visitor = this.nullValueVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.valid;
            return bl;
        }
        finally {
            visitor.valid = false;
        }
    }

    private boolean isNumericType(Expression expression) {
        return this.isValid(expression, NumericTypeValidator.class);
    }

    private boolean isStringType(Expression expression) {
        return this.isValid(expression, StringTypeValidator.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid(Expression expression, Class<? extends TypeValidator> validatorClass) {
        TypeValidator validator = this.validator(validatorClass);
        try {
            expression.accept(validator);
            boolean bl = validator.valid;
            return bl;
        }
        finally {
            validator.valid = false;
        }
    }

    private NullValueVisitor nullValueVisitor() {
        if (this.nullValueVisitor == null) {
            this.nullValueVisitor = new NullValueVisitor();
        }
        return this.nullValueVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateFieldPathExpression stateFieldPathExpression(Expression expression) {
        StateFieldPathExpressionVisitor visitor = this.stateFieldPathExpressionVisitor();
        try {
            expression.accept(visitor);
            StateFieldPathExpression stateFieldPathExpression = visitor.expression;
            return stateFieldPathExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    private StateFieldPathExpressionVisitor stateFieldPathExpressionVisitor() {
        if (this.stateFieldPathExpressionVisitor == null) {
            this.stateFieldPathExpressionVisitor = new StateFieldPathExpressionVisitor();
        }
        return this.stateFieldPathExpressionVisitor;
    }

    private UpdateClauseAbstractSchemaNameFinder updateClauseAbstractSchemaNameFinder() {
        if (this.updateClauseAbstractSchemaNameFinder == null) {
            this.updateClauseAbstractSchemaNameFinder = new UpdateClauseAbstractSchemaNameFinder();
        }
        return this.updateClauseAbstractSchemaNameFinder;
    }

    private void validateAggregateFunction(AggregateFunction expression) {
        StateFieldPathExpression pathExpression = this.stateFieldPathExpression(expression.getExpression());
        if (pathExpression != null) {
            this.validateStateFieldPathExpression(pathExpression, false);
        }
    }

    private void validateBooleanType(Expression expression, String messageKey) {
        if (this.isValid(expression, "boolean_primary") && !this.isBooleanType(expression)) {
            this.addProblem(expression, messageKey);
        }
    }

    private void validateCollectionValuedPathExpression(Expression expression, boolean collectionTypeOnly) {
        CollectionValuedPathExpression collectionValuedPathExpression = this.collectionValuedPathExpression(expression);
        if (collectionValuedPathExpression != null && collectionValuedPathExpression.hasIdentificationVariable() && !collectionValuedPathExpression.endsWithDot()) {
            Resolver resolver = this.getResolver(expression);
            IType type = resolver.getType();
            IMapping mapping = resolver.getMapping();
            if (!type.isResolvable() || mapping == null) {
                int startIndex = this.position(expression);
                int endIndex = startIndex + this.length(expression);
                this.addProblem(expression, startIndex, endIndex, "COLLECTION_VALUED_PATH_EXPRESSION_NOT_RESOLVABLE", expression.toParsedText());
            } else if (collectionTypeOnly && !MappingTypeHelper.isCollectionMapping(mapping) || !collectionTypeOnly && !MappingTypeHelper.isRelationshipMapping(mapping)) {
                int startIndex = this.position(expression);
                int endIndex = startIndex + this.length(expression);
                this.addProblem(expression, startIndex, endIndex, "COLLECTION_VALUED_PATH_EXPRESSION_NOT_COLLECTION_TYPE", expression.toParsedText());
            }
        }
    }

    private void validateIdentificationVariables() {
        HashMap<String, List<IdentificationVariable>> identificationVariables = new HashMap<String, List<IdentificationVariable>>();
        this.collectDeclarationIdentificationVariables(identificationVariables);
        for (Map.Entry entry : identificationVariables.entrySet()) {
            List variables = (List)entry.getValue();
            if (variables.size() <= 1) continue;
            for (IdentificationVariable variable : variables) {
                this.addProblem((Expression)variable, "IDENTIFICATION_VARIABLE_INVALID_DUPLICATE", variable.getText());
            }
        }
        for (IdentificationVariable identificationVariable : this.usedIdentificationVariables) {
            String variableName = identificationVariable.getText();
            if (!ExpressionTools.stringIsNotEmpty(variableName) || identificationVariables.containsKey(variableName.toUpperCase())) continue;
            this.addProblem((Expression)identificationVariable, "IDENTIFICATION_VARIABLE_INVALID_NOT_DECLARED", variableName);
        }
    }

    private void validateIntegralType(Expression expression, String messageKey) {
        if (this.isValid(expression, "simple_arithmetic_expression") && !this.isIntegralType(expression)) {
            this.addProblem(expression, messageKey);
        }
    }

    private void validateMapIdentificationVariable(EncapsulatedIdentificationVariableExpression expression) {
        Expression childExpression;
        String variableName;
        if (expression.hasExpression() && ExpressionTools.stringIsNotEmpty(variableName = this.queryContext.literal(childExpression = expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE))) {
            ITypeDeclaration typeDeclaration = this.getTypeDeclaration(childExpression);
            if (!this.getTypeHelper().isMapType(typeDeclaration.getType())) {
                this.addProblem(childExpression, "ENCAPSULATED_IDENTIFICATION_VARIABLE_EXPRESSION_NOT_MAP_VALUED", expression.getIdentifier());
            }
        }
    }

    private void validateNumericType(Expression expression, String messageKey) {
        if (this.isValid(expression, "simple_arithmetic_expression") && !this.isNumericType(expression)) {
            this.addProblem(expression, messageKey);
        }
    }

    private boolean validateStateFieldPathExpression(StateFieldPathExpression expression, boolean associationFieldValid) {
        if (expression.hasIdentificationVariable() && !expression.endsWithDot()) {
            IType type = this.getType(expression);
            IMapping mapping = this.getMapping(expression);
            if (!type.isResolvable()) {
                this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_NOT_RESOLVABLE", expression.toParsedText());
            } else if (mapping == null && type.isEnum()) {
                String enumConstant = expression.getPath(expression.pathSize() - 1);
                boolean found = false;
                for (String constant : type.getEnumConstants()) {
                    if (!constant.equals(enumConstant)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    int startIndex = this.position(expression) + type.getName().length() + 1;
                    int endIndex = startIndex + enumConstant.length();
                    this.addProblem((Expression)expression, startIndex, endIndex, "STATE_FIELD_PATH_EXPRESSION_INVALID_ENUM_CONSTANT", enumConstant);
                }
            } else {
                if (MappingTypeHelper.isTransientMapping(mapping)) {
                    this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_NO_MAPPING", expression.toParsedText());
                } else if (MappingTypeHelper.isCollectionMapping(mapping)) {
                    this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_COLLECTION_TYPE", expression.toParsedText());
                } else if (!associationFieldValid && MappingTypeHelper.isRelationshipMapping(mapping)) {
                    this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_ASSOCIATION_FIELD", expression.toParsedText());
                }
                return true;
            }
        }
        return false;
    }

    private void validateStringType(Expression expression, String messageKey) {
        if (this.isValid(expression, "string_primary") && !this.isStringType(expression)) {
            this.addProblem(expression, messageKey, expression.toParsedText());
        }
    }

    private void validateUpdateItemTypes(UpdateItem expression, IType type) {
        if (expression.hasNewValue()) {
            Expression newValue = expression.getNewValue();
            TypeHelper typeHelper = this.getTypeHelper();
            boolean nullValue = this.isNullValue(newValue);
            if (nullValue) {
                if (typeHelper.isPrimitiveType(type)) {
                    this.addProblem(expression, "UPDATE_ITEM_NULL_NOT_ASSIGNABLE_TO_PRIMITIVE");
                }
                return;
            }
            IType newValueType = this.getType(newValue);
            if (!newValueType.isResolvable() || typeHelper.isDateType(type) && typeHelper.isDateType(newValueType) || typeHelper.isNumericType(type) && typeHelper.isNumericType(newValueType)) {
                return;
            }
            if (!newValueType.isAssignableTo(type)) {
                this.addProblem((Expression)expression, "UPDATE_ITEM_NOT_ASSIGNABLE", newValueType.getName(), type.getName());
            }
        }
    }

    private TypeValidator validator(Class<? extends TypeValidator> validatorClass) {
        TypeValidator validator = this.validators.get(validatorClass);
        if (validator == null) {
            try {
                Constructor<? extends TypeValidator> constructor = validatorClass.getDeclaredConstructor(SemanticValidator.class);
                constructor.setAccessible(true);
                validator = constructor.newInstance(this);
                this.validators.put(validatorClass, validator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return validator;
    }

    private VirtualIdentificationVariableFinder virtualIdentificationVariableFinder() {
        if (this.virtualIdentificationVariableFinder == null) {
            this.virtualIdentificationVariableFinder = new VirtualIdentificationVariableFinder();
        }
        return this.virtualIdentificationVariableFinder;
    }

    @Override
    public void visit(AbsExpression expression) {
        this.validateNumericType(expression.getExpression(), "ABS_EXPRESSION_INVALID_NUMERIC_EXPRESSION");
        super.visit(expression);
    }

    @Override
    public void visit(AbstractSchemaName expression) {
        String abstractSchemaName = expression.getText();
        IManagedType managedType = this.getManagedType(abstractSchemaName);
        if (managedType == null) {
            String variableName;
            IdentificationVariable identificationVariable = this.findVirtualIdentificationVariable(expression);
            String string = variableName = identificationVariable != null ? identificationVariable.getText() : null;
            if (ExpressionTools.stringIsNotEmpty(variableName)) {
                Resolver parentResolver = this.queryContext.getResolver(identificationVariable);
                Resolver resolver = this.buildStateFieldResolver(parentResolver, abstractSchemaName);
                if (!resolver.getType().isResolvable()) {
                    this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_NOT_RESOLVABLE", expression.toParsedText());
                } else if (!MappingTypeHelper.isRelationshipMapping(resolver.getMapping())) {
                    this.addProblem((Expression)expression, "PATH_EXPRESSION_NOT_RELATIONSHIP_MAPPING", expression.toParsedText());
                }
            } else {
                this.addProblem((Expression)expression, "ABSTRACT_SCHEMA_NAME_INVALID", abstractSchemaName);
            }
        } else if (!managedType.getType().isResolvable()) {
            this.addProblem((Expression)expression, "ABSTRACT_SCHEMA_NAME_NOT_RESOLVABLE", abstractSchemaName);
        }
    }

    @Override
    public void visit(AdditionExpression expression) {
        this.validateNumericType(expression.getLeftExpression(), "ADDITION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE");
        this.validateNumericType(expression.getRightExpression(), "ADDITION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(AllOrAnyExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(AndExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        if (!this.isValid(expression.getExpression(), "arithmetic_primary")) {
            int startIndex;
            int endIndex = startIndex = this.position(expression) + 1;
            this.addProblem((Expression)expression, startIndex, endIndex, "ARITHMETIC_FACTOR_INVALID_EXPRESSION", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(AvgFunction expression) {
        this.validateNumericType(expression.getExpression(), "AVG_FUNCTION_INVALID_NUMERIC_EXPRESSION");
        super.visit(expression);
    }

    @Override
    public void visit(BadExpression expression) {
    }

    @Override
    public void visit(BetweenExpression expression) {
        if (expression.hasExpression() && expression.hasLowerBoundExpression() && expression.hasUpperBoundExpression() && (!this.isEquivalentBetweenType(expression.getExpression(), expression.getLowerBoundExpression()) || !this.isEquivalentBetweenType(expression.getExpression(), expression.getUpperBoundExpression()))) {
            this.addProblem(expression, "BETWEEN_EXPRESSION_WRONG_TYPE");
        }
        super.visit(expression);
    }

    @Override
    public void visit(CaseExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(CoalesceExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(CollectionExpression expression) {
        super.visit(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(CollectionMemberDeclaration expression) {
        this.validateCollectionValuedPathExpression(expression.getCollectionValuedPathExpression(), true);
        try {
            this.registerIdentificationVariable = false;
            expression.getIdentificationVariable().accept(this);
        }
        finally {
            this.registerIdentificationVariable = true;
        }
    }

    @Override
    public void visit(CollectionMemberExpression expression) {
        Expression entityExpression;
        IType type;
        IManagedType managedType;
        if (expression.hasEntityExpression() && this.isEmbeddable(managedType = this.getManagedType(type = this.getType(entityExpression = expression.getEntityExpression())))) {
            this.addProblem(entityExpression, "COLLECTION_MEMBER_EXPRESSION_EMBEDDABLE");
        }
        this.validateCollectionValuedPathExpression(expression.getCollectionValuedPathExpression(), true);
        super.visit(expression);
    }

    @Override
    public void visit(CollectionValuedPathExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(ComparisonExpression expression) {
        if (expression.hasLeftExpression() && expression.hasRightExpression() && !this.isComparisonEquivalentType(expression.getLeftExpression(), expression.getRightExpression())) {
            this.addProblem(expression, "COMPARISON_EXPRESSION_WRONG_COMPARISON_TYPE");
        }
        super.visit(expression);
    }

    @Override
    public void visit(ConcatExpression expression) {
        if (expression.hasExpression()) {
            for (Expression child : this.children(expression.getExpression())) {
                this.validateStringType(child, "CONCAT_EXPRESSION_EXPRESSION_WRONG_TYPE");
            }
        }
        super.visit(expression);
    }

    @Override
    public void visit(ConstructorExpression expression) {
        String className = expression.getClassName();
        if (ExpressionTools.stringIsNotEmpty(className)) {
            IType type = this.getType(className);
            if (!type.isResolvable()) {
                int startIndex = this.position(expression) + 4;
                int endIndex = startIndex + className.length();
                this.addProblem((Expression)expression, startIndex, endIndex, "CONSTRUCTOR_EXPRESSION_UNKNOWN_TYPE", new String[0]);
            } else if (expression.hasLeftParenthesis()) {
                boolean validated = false;
                ItemExpression visitor = new ItemExpression();
                expression.getConstructorItems().accept(visitor);
                IType[] calculatedTypes = null;
                for (IConstructor constructor : type.constructors()) {
                    ITypeDeclaration[] types1 = constructor.getParameterTypes();
                    if (visitor.expressions.size() != types1.length) continue;
                    if (calculatedTypes == null) {
                        calculatedTypes = new IType[visitor.expressions.size()];
                        int index = visitor.expressions.size();
                        while (--index >= 0) {
                            calculatedTypes[index] = this.getType(visitor.expressions.get(index));
                        }
                    }
                    if (!(validated = this.areConstructorParametersEquivalent(types1, calculatedTypes))) continue;
                    break;
                }
                if (!validated) {
                    int startIndex = this.position(expression) + 4 + className.length() + 1;
                    int endIndex = startIndex + this.length(expression.getConstructorItems());
                    this.addProblem((Expression)expression, startIndex, endIndex, "CONSTRUCTOR_EXPRESSION_MISMATCHED_PARAMETER_TYPES", new String[0]);
                }
            }
        }
        super.visit(expression);
    }

    @Override
    public void visit(CountFunction expression) {
        Expression childExpression;
        IType type;
        IManagedType managedType;
        if (expression.hasExpression() && expression.hasDistinct() && this.isEmbeddable(managedType = this.getManagedType(type = this.getType(childExpression = expression.getExpression())))) {
            int distinctLength = "DISTINCT".length() + 1;
            int startIndex = this.position(childExpression) - distinctLength;
            int endIndex = startIndex + this.length(childExpression) + distinctLength;
            this.addProblem((Expression)expression, startIndex, endIndex, "COUNT_FUNCTION_DISTINCT_EMBEDDABLE", new String[0]);
        }
        super.visit(expression);
    }

    @Override
    public void visit(DateTime expression) {
    }

    @Override
    public void visit(DeleteClause expression) {
    }

    @Override
    public void visit(DeleteStatement expression) {
        super.visit(expression);
    }

    @Override
    public void visit(DivisionExpression expression) {
        this.validateNumericType(expression.getLeftExpression(), "DIVISION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE");
        this.validateNumericType(expression.getRightExpression(), "DIVISION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(EmptyCollectionComparisonExpression expression) {
        this.validateCollectionValuedPathExpression(expression.getExpression(), true);
        super.visit(expression);
    }

    @Override
    public void visit(EntityTypeLiteral expression) {
        IManagedType managedType;
        String entityTypeName = expression.getEntityTypeName();
        if (ExpressionTools.stringIsNotEmpty(entityTypeName) && (managedType = this.getManagedType(entityTypeName)) == null) {
            int startIndex = this.position(expression);
            int endIndex = startIndex + entityTypeName.length();
            this.addProblem((Expression)expression, startIndex, endIndex, "ENTITY_TYPE_LITERAL_NOT_RESOLVABLE", entityTypeName);
        }
    }

    @Override
    public void visit(EntryExpression expression) {
        this.validateMapIdentificationVariable(expression);
        super.visit(expression);
    }

    @Override
    public void visit(ExistsExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(FromClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(FuncExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(GroupByClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(HavingClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(IdentificationVariable expression) {
        StateFieldPathExpression pathExpression;
        boolean virtual = expression.isVirtual();
        if (!virtual && this.registerIdentificationVariable) {
            this.usedIdentificationVariables.add(expression);
        }
        if (!virtual && this.isJavaPlatform()) {
            String variable = expression.getText();
            if (ExpressionTools.stringIsNotEmpty(variable)) {
                for (IEntity entity : this.getProvider().abstractSchemaTypes()) {
                    String entityName = entity.getName();
                    if (!variable.equalsIgnoreCase(entityName) || this.isValidWithFindQueryBNF(expression, "literal")) continue;
                    int startIndex = this.position(expression);
                    int endIndex = startIndex + variable.length();
                    this.addProblem((Expression)expression, startIndex, endIndex, "IDENTIFICATION_VARIABLE_ENTITY_NAME", new String[0]);
                    break;
                }
            }
        } else if (virtual && (pathExpression = expression.getStateFieldPathExpression()) != null) {
            pathExpression.accept(this);
        }
    }

    @Override
    public void visit(IdentificationVariableDeclaration expression) {
        super.visit(expression);
    }

    @Override
    public void visit(IndexExpression expression) {
        String variableName = this.queryContext.literal(expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE);
        if (ExpressionTools.stringIsNotEmpty(variableName) && !this.queryContext.isCollectionVariableName(variableName)) {
            this.addProblem(expression.getExpression(), "INDEX_EXPRESSION_WRONG_VARIABLE", variableName);
        }
        super.visit(expression);
    }

    @Override
    public void visit(InExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(InputParameter expression) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(Join expression) {
        Expression joinAssociationPath = expression.getJoinAssociationPath();
        this.validateCollectionValuedPathExpression(joinAssociationPath, false);
        joinAssociationPath.accept(this);
        try {
            this.registerIdentificationVariable = false;
            expression.getIdentificationVariable().accept(this);
        }
        finally {
            this.registerIdentificationVariable = true;
        }
    }

    @Override
    public void visit(JoinFetch expression) {
        this.validateCollectionValuedPathExpression(expression.getJoinAssociationPath(), false);
        super.visit(expression);
    }

    @Override
    public void visit(JPQLExpression expression) {
        if (expression.hasQueryStatement()) {
            expression.getQueryStatement().accept(this);
            this.validateIdentificationVariables();
        }
    }

    @Override
    public void visit(KeyExpression expression) {
        this.validateMapIdentificationVariable(expression);
        super.visit(expression);
    }

    @Override
    public void visit(KeywordExpression expression) {
    }

    @Override
    public void visit(LengthExpression expression) {
        this.validateStringType(expression.getExpression(), "LENGTH_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(LikeExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(LocateExpression expression) {
        this.validateStringType(expression.getFirstExpression(), "LOCATE_EXPRESSION_FIRST_EXPRESSION_WRONG_TYPE");
        this.validateStringType(expression.getSecondExpression(), "LOCATE_EXPRESSION_SECOND_EXPRESSION_WRONG_TYPE");
        this.validateNumericType(expression.getThirdExpression(), "LOCATE_EXPRESSION_THIRD_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(LowerExpression expression) {
        this.validateStringType(expression.getExpression(), "LOWER_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(MaxFunction expression) {
        this.validateAggregateFunction(expression);
        super.visit(expression);
    }

    @Override
    public void visit(MinFunction expression) {
        this.validateAggregateFunction(expression);
        super.visit(expression);
    }

    @Override
    public void visit(ModExpression expression) {
        this.validateIntegralType(expression.getFirstExpression(), "MOD_EXPRESSION_FIRST_EXPRESSION_WRONG_TYPE");
        this.validateIntegralType(expression.getSecondExpression(), "MOD_EXPRESSION_SECOND_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        this.validateNumericType(expression.getLeftExpression(), "MULTIPLICATION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE");
        this.validateNumericType(expression.getRightExpression(), "MULTIPLICATION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(NotExpression expression) {
        this.validateBooleanType(expression.getExpression(), "NOT_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(NullComparisonExpression expression) {
        IType type;
        IManagedType managedType;
        StateFieldPathExpression pathExpression = this.stateFieldPathExpression(expression.getExpression());
        if (pathExpression != null && this.isEmbeddable(managedType = this.getManagedType(type = this.getType(pathExpression)))) {
            this.addProblem((Expression)pathExpression, "NULL_COMPARISON_EXPRESSION_INVALID_TYPE", pathExpression.toParsedText());
            return;
        }
        super.visit(expression);
    }

    @Override
    public void visit(NullExpression expression) {
    }

    @Override
    public void visit(NullIfExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(NumericLiteral expression) {
    }

    @Override
    public void visit(ObjectExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(OrderByClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(OrderByItem expression) {
        super.visit(expression);
    }

    @Override
    public void visit(OrExpression expression) {
        super.visit(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(RangeVariableDeclaration expression) {
        expression.getAbstractSchemaName().accept(this);
        try {
            this.registerIdentificationVariable = false;
            expression.getIdentificationVariable().accept(this);
        }
        finally {
            this.registerIdentificationVariable = true;
        }
    }

    @Override
    public void visit(ResultVariable expression) {
        super.visit(expression);
    }

    @Override
    public void visit(SelectClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(SelectStatement expression) {
        Expression selectExpression;
        if (!expression.hasGroupByClause() && expression.hasHavingClause() && !this.isValidWithChildCollectionBypass(selectExpression = expression.getSelectClause().getSelectExpression(), "aggregate_expression")) {
            this.addProblem(selectExpression, "SELECT_STATEMENT_SELECT_CLAUSE_HAS_NON_AGGREGATE_FUNCTIONS");
        }
        super.visit(expression);
    }

    @Override
    public void visit(SimpleFromClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        super.visit(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(SimpleSelectStatement expression) {
        this.queryContext.newSubqueryContext(expression);
        try {
            super.visit(expression);
            this.validateIdentificationVariables();
        }
        finally {
            this.queryContext.disposeSubqueryContext();
        }
    }

    @Override
    public void visit(SizeExpression expression) {
        this.validateCollectionValuedPathExpression(expression.getExpression(), true);
        super.visit(expression);
    }

    @Override
    public void visit(SqrtExpression expression) {
        this.validateNumericType(expression.getExpression(), "SQRT_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        this.validateStateFieldPathExpression(expression, true);
        super.visit(expression);
    }

    @Override
    public void visit(StringLiteral expression) {
    }

    @Override
    public void visit(SubExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(SubstringExpression expression) {
        this.validateStringType(expression.getFirstExpression(), "SUBSTRING_EXPRESSION_FIRST_EXPRESSION_WRONG_TYPE");
        this.validateIntegralType(expression.getSecondExpression(), "SUBSTRING_EXPRESSION_SECOND_EXPRESSION_WRONG_TYPE");
        if (!this.isJavaPlatform() || this.getJPAVersion().isNewerThanOrEqual(IJPAVersion.VERSION_2_0)) {
            this.validateIntegralType(expression.getThirdExpression(), "SUBSTRING_EXPRESSION_THIRD_EXPRESSION_WRONG_TYPE");
        }
        super.visit(expression);
    }

    @Override
    public void visit(SubtractionExpression expression) {
        this.validateNumericType(expression.getLeftExpression(), "SUBTRACTION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE");
        this.validateNumericType(expression.getRightExpression(), "SUBTRACTION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(SumFunction expression) {
        this.validateNumericType(expression.getExpression(), "SUM_FUNCTION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(TreatExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(TrimExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(TypeExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(UnknownExpression expression) {
    }

    @Override
    public void visit(UpdateClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(UpdateItem expression) {
        IManagedType managedType;
        String name;
        AbstractSchemaName abstractSchemaName = this.findAbstractSchemaName(expression);
        String string = name = abstractSchemaName != null ? abstractSchemaName.getText() : null;
        if (ExpressionTools.stringIsNotEmpty(name) && (managedType = this.getManagedType(name)) != null) {
            String stateFieldValue;
            StateFieldPathExpression pathExpression = this.stateFieldPathExpression(expression.getStateFieldPathExpression());
            String string2 = stateFieldValue = pathExpression != null ? pathExpression.toParsedText() : null;
            if (ExpressionTools.stringIsNotEmpty(stateFieldValue)) {
                if (stateFieldValue.indexOf(".") == -1) {
                    IMapping mapping = managedType.getMappingNamed(stateFieldValue);
                    if (mapping == null) {
                        this.addProblem((Expression)pathExpression, "UPDATE_ITEM_NOT_RESOLVABLE", stateFieldValue);
                    } else {
                        this.validateUpdateItemTypes(expression, mapping.getType());
                    }
                } else {
                    IType type = this.getType(pathExpression);
                    if (!type.isResolvable()) {
                        this.addProblem((Expression)pathExpression, "UPDATE_ITEM_NOT_RESOLVABLE", stateFieldValue);
                    } else {
                        this.validateUpdateItemTypes(expression, type);
                    }
                }
            }
        }
        super.visit(expression);
    }

    @Override
    public void visit(UpdateStatement expression) {
        super.visit(expression);
    }

    @Override
    public void visit(UpperExpression expression) {
        this.validateStringType(expression.getExpression(), "UPPER_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(ValueExpression expression) {
        this.validateMapIdentificationVariable(expression);
        super.visit(expression);
    }

    @Override
    public void visit(WhenClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(WhereClause expression) {
        super.visit(expression);
    }

    private class BooleanTypeValidator
    extends TypeValidator {
        private BooleanTypeValidator() {
        }

        boolean isRightType(IType type) {
            return SemanticValidator.this.getTypeHelper().isBooleanType(type);
        }

        public void visit(AllOrAnyExpression expression) {
            this.valid = true;
        }

        public void visit(AndExpression expression) {
            this.valid = true;
        }

        public void visit(BetweenExpression expression) {
            this.valid = true;
        }

        public void visit(ComparisonExpression expression) {
            this.valid = true;
        }

        public void visit(EmptyCollectionComparisonExpression expression) {
            this.valid = true;
        }

        public void visit(ExistsExpression expression) {
            this.valid = true;
        }

        public void visit(KeywordExpression expression) {
            this.valid = true;
        }

        public void visit(LikeExpression expression) {
            this.valid = true;
        }

        public void visit(NotExpression expression) {
            this.valid = true;
        }

        public void visit(NullComparisonExpression expression) {
            this.valid = true;
        }

        public void visit(OrExpression expression) {
            this.valid = true;
        }
    }

    private static class CollectionValuedPathExpressionVisitor
    extends AbstractExpressionVisitor {
        CollectionValuedPathExpression expression;

        private CollectionValuedPathExpressionVisitor() {
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.expression = expression;
        }
    }

    private class ItemExpression
    extends AnonymousExpressionVisitor {
        List<Expression> expressions = new ArrayList<Expression>();

        ItemExpression() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        protected void visit(Expression expression) {
            this.expressions.add(expression);
        }
    }

    private class NullValueVisitor
    extends AbstractExpressionVisitor {
        boolean valid;

        private NullValueVisitor() {
        }

        public void visit(KeywordExpression expression) {
            this.valid = expression.getText() == "NULL";
        }
    }

    private class NumericTypeValidator
    extends TypeValidator {
        private NumericTypeValidator() {
        }

        boolean isRightType(IType type) {
            return SemanticValidator.this.getTypeHelper().isNumericType(type);
        }

        public void visit(AbsExpression expression) {
            this.valid = true;
        }

        public void visit(AdditionExpression expression) {
            this.valid = true;
        }

        public void visit(ArithmeticFactor expression) {
            this.valid = true;
        }

        public void visit(AvgFunction expression) {
            this.valid = true;
        }

        public void visit(CountFunction expression) {
            this.valid = true;
        }

        public void visit(DivisionExpression expression) {
            this.valid = true;
        }

        public void visit(IndexExpression expression) {
            this.valid = true;
        }

        public void visit(LengthExpression expression) {
            this.valid = true;
        }

        public void visit(LocateExpression expression) {
            this.valid = true;
        }

        public void visit(MaxFunction expression) {
            this.valid = true;
        }

        public void visit(MinFunction expression) {
            this.valid = true;
        }

        public void visit(ModExpression expression) {
            this.valid = true;
        }

        public void visit(MultiplicationExpression expression) {
            this.valid = true;
        }

        public void visit(NumericLiteral expression) {
            this.valid = true;
        }

        public void visit(SizeExpression expression) {
            this.valid = true;
        }

        public void visit(SqrtExpression expression) {
            this.valid = true;
        }

        public void visit(SubtractionExpression expression) {
            this.valid = true;
        }

        public void visit(SumFunction expression) {
            this.valid = true;
        }
    }

    private static class StateFieldPathExpressionVisitor
    extends AbstractExpressionVisitor {
        StateFieldPathExpression expression;

        private StateFieldPathExpressionVisitor() {
        }

        public void visit(StateFieldPathExpression expression) {
            this.expression = expression;
        }
    }

    private class StringTypeValidator
    extends TypeValidator {
        private StringTypeValidator() {
        }

        boolean isRightType(IType type) {
            return SemanticValidator.this.getTypeHelper().isStringType(type);
        }

        public void visit(ConcatExpression expression) {
            this.valid = true;
        }

        public void visit(LowerExpression expression) {
            this.valid = true;
        }

        public void visit(StringLiteral expression) {
            this.valid = true;
        }

        public void visit(SubstringExpression expression) {
            this.valid = true;
        }

        public void visit(TrimExpression expression) {
            this.valid = true;
        }

        public void visit(UpperExpression expression) {
            this.valid = true;
        }
    }

    private abstract class TypeValidator
    extends AbstractExpressionVisitor {
        boolean valid;

        private TypeValidator() {
        }

        abstract boolean isRightType(IType var1);

        public final void visit(CaseExpression expression) {
            IType type = SemanticValidator.this.getType(expression);
            this.valid = this.isRightType(type);
        }

        public final void visit(CoalesceExpression expression) {
            IType type = SemanticValidator.this.getType(expression);
            this.valid = this.isRightType(type);
        }

        public final void visit(FuncExpression expression) {
            IType type = SemanticValidator.this.getType(expression);
            this.valid = this.isRightType(type);
        }

        public final void visit(InputParameter expression) {
            this.valid = true;
        }

        public void visit(NullExpression expression) {
            this.valid = true;
        }

        public final void visit(NullIfExpression expression) {
            expression.getFirstExpression().accept(this);
        }

        public final void visit(StateFieldPathExpression expression) {
            IType type = SemanticValidator.this.getType(expression);
            this.valid = this.isRightType(type);
        }

        public final void visit(SubExpression expression) {
            expression.getExpression().accept(this);
        }
    }

    private class UpdateClauseAbstractSchemaNameFinder
    extends AbstractExpressionVisitor {
        AbstractSchemaName expression;

        private UpdateClauseAbstractSchemaNameFinder() {
        }

        public void visit(AbstractSchemaName expression) {
            this.expression = expression;
        }

        public void visit(CollectionExpression expression) {
            expression.getParent().accept(this);
        }

        public void visit(RangeVariableDeclaration expression) {
            expression.getAbstractSchemaName().accept(this);
        }

        public void visit(UpdateClause expression) {
            expression.getRangeVariableDeclaration().accept(this);
        }

        public void visit(UpdateItem expression) {
            expression.getParent().accept(this);
        }
    }

    private static class VirtualIdentificationVariableFinder
    extends AbstractTraverseParentVisitor {
        IdentificationVariable expression;
        private boolean traverse;

        private VirtualIdentificationVariableFinder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(DeleteClause expression) {
            try {
                this.traverse = true;
                expression.getRangeVariableDeclaration().accept(this);
            }
            finally {
                this.traverse = false;
            }
        }

        public void visit(DeleteStatement expression) {
            expression.getDeleteClause().accept(this);
        }

        public void visit(IdentificationVariable expression) {
            this.expression = expression;
        }

        public void visit(RangeVariableDeclaration expression) {
            if (this.traverse) {
                expression.getIdentificationVariable().accept(this);
            } else {
                super.visit(expression);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(UpdateClause expression) {
            try {
                this.traverse = true;
                expression.getRangeVariableDeclaration().accept(this);
            }
            finally {
                this.traverse = false;
            }
        }

        public void visit(UpdateStatement expression) {
            expression.getUpdateClause().accept(this);
        }
    }
}

