/*
 * Decompiled with CFR 0.152.
 */
package org.shop.tools;

import demo.Components;
import demo.Exposure;
import demo.Policy;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.shop.tools.Combohelper;
import org.shop.tools.EntityService;

public class Engine {
    Integer client;
    Integer version;
    Integer prov;
    Integer veh;
    Integer polnum;
    String PU;
    String[] addCol;
    HashMap hmOptionalab;
    HashMap hmSurcharge;
    HashMap hmEndorse;
    HashMap hmDiscount;
    Policy policy;
    Exposure exposure;
    HashMap hmUnsorted = new HashMap();
    HashMap<String, HashMap> optionalTables = new HashMap();
    Map<String, Combohelper> hm;
    HashMap<String, Map<String, Combohelper>> rateTables = new HashMap();
    HashMap<String, List<Components>> rateTablesList = new HashMap();
    List comp = new ArrayList();
    String err;
    String errhold;
    Boolean flagXml = false;
    Integer counter = 0;
    String[] lineSplit = new String[0];
    String[] cov = new String[]{"UA", "UM", "BI", "PD", "DC", "SA", "TP", "AB", "CL", "CM", "SP", "AP", "PHPD", "PHBI"};
    String[][] names = new String[][]{{"UA", "AB", "MA", ""}, {"UM", "BI", "MA", ""}, {"BI", "BI", "MA", ""}, {"PD", "PD", "MA", ""}, {"DC", "DC", "MA", ""}, {"SA", "SA", "MA", ""}, {"TP", "TP", "MA", ""}, {"AB", "AB", "MA", ""}, {"CL", "CL", "CL", ""}, {"CM", "CM", "CM", ""}, {"SP", "SP", "SP", ""}, {"AP", "AP", "AP", ""}, {"PHPD", "PD", "MA", ""}, {"PHBI", "BI", "MA", ""}};
    String[][] covfac = new String[][]{{"1", "UA", "UM", "BI", "PD", "DC", "SA", "TP", "AB", "CL", "AP", "PHPD", "PHBI"}, {"2", "UA", "UM", "BI", "PD", "DC", "SA", "TP", "AB", "CL", "CM", "SP", "AP", "PHPD", "PHBI"}, {"3", "CM"}, {"4", "AB"}, {"5", "UA", "UM", "BI", "PD", "DC", "SA", "TP", "AB", "PHPD", "PHBI"}, {"6", "CL"}, {"7", "CM", "SP"}, {"8", "CL", "CM", "SP", "AP"}, {"9", "UA", "UM", "BI", "PD", "DC", "SA", "TP", "AB", "CL", "PHPD", "PHBI"}, {"10", "UA", "BI", "PD", "SA", "TP"}};
    HashMap hmFlag = new HashMap();

    void setParameters(Policy rec) {
        rec.setClient(this.exposure.getClient());
        rec.setPolnum(this.exposure.getPolnum());
        rec.setPolicynumber(this.exposure.getPolicynumber());
        rec.setVersion(this.exposure.getVersion());
        rec.setUsers(this.exposure.getUsers());
        rec.setUsersgroup(this.exposure.getUsersgroup());
        rec.setLimitall(this.exposure.getLimitall());
        rec.setLl(this.exposure.getLimitall());
        String desc = this.getString(rec, "Description");
        String limit = this.initSplit();
        if (desc.length() > 0 && limit.length() > 0) {
            desc = this.replaceLimit(desc, ":Limitall:", limit);
            desc = this.replaceLimit(desc, ":Ll:", limit);
            rec.setDescription(desc);
        }
        this.policy = rec;
        this.version = this.policy.getVersion();
        this.client = this.policy.getClient();
        this.prov = this.policy.getProvince();
        this.veh = this.policy.getVehicle();
        this.polnum = this.policy.getPolnum();
        this.err = "";
        this.updateEndorseLimit();
    }

    void init(String pu, Exposure expo, String[] col) {
        this.exposure = expo;
        this.PU = pu;
        this.addCol = col;
    }

    void setPolicy(Policy pol) {
        this.policy = pol;
    }

    void startProcess(Boolean boo) throws IllegalArgumentException {
        try {
            this.flagXml = boo;
            this.process(this.policy);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    void process(Policy rec) throws IllegalArgumentException {
        this.counter = this.counter + 1;
        System.out.println("STARTING NEW BATCH PROCESS " + this.counter);
        this.setParameters(rec);
        this.hmUnsorted.clear();
        this.hm = this.rateTables.get("Province" + this.prov + "Vehicle" + this.veh);
        if (this.hm == null) {
            System.out.println("Compiling rates for Province " + this.prov + " Vehicle " + this.veh);
            this.hm = new TreeMap<String, Combohelper>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            this.comp = new ArrayList();
            List<Components> resultList = this.loadRates(1, this.version, this.prov, this.veh);
            this.rateTablesList.put("List1Province" + this.prov + "Vehicle" + this.veh, resultList);
            resultList = this.loadRates(2, this.version, this.prov, this.veh);
            this.rateTablesList.put("List2Province" + this.prov + "Vehicle" + this.veh, resultList);
            this.hm.putAll(this.hmUnsorted);
            this.rateTables.put("Province" + this.prov + "Vehicle" + this.veh, this.hm);
            this.hmOptionalab = new HashMap();
            this.hmSurcharge = new HashMap();
            this.hmEndorse = new HashMap();
            this.hmDiscount = new HashMap();
            this.loadOptionals();
            this.optionalTables.put("Province" + this.prov + "Vehicle" + this.veh + "AB", this.hmOptionalab);
            this.optionalTables.put("Province" + this.prov + "Vehicle" + this.veh + "SUR", this.hmSurcharge);
            this.optionalTables.put("Province" + this.prov + "Vehicle" + this.veh + "END", this.hmEndorse);
            this.optionalTables.put("Province" + this.prov + "Vehicle" + this.veh + "DIS", this.hmDiscount);
            this.hmDiscount.put("Province" + this.prov + "Vehicle" + this.veh + "comp", this.comp);
        } else {
            System.out.println("Reusing rates for Province " + this.prov + " Vehicle " + this.veh);
            this.hmEndorse = new HashMap();
            this.loadEndorse();
            this.hmOptionalab = this.optionalTables.get("Province" + this.prov + "Vehicle" + this.veh + "AB");
            this.hmSurcharge = this.optionalTables.get("Province" + this.prov + "Vehicle" + this.veh + "SUR");
            this.hmDiscount = this.optionalTables.get("Province" + this.prov + "Vehicle" + this.veh + "DIS");
            this.comp = (List)this.hmDiscount.get("Province" + this.prov + "Vehicle" + this.veh + "comp");
        }
        List<Components> resultList1 = this.rateTablesList.get("List1Province" + this.prov + "Vehicle" + this.veh);
        List<Components> resultList2 = this.rateTablesList.get("List2Province" + this.prov + "Vehicle" + this.veh);
        if (this.hm.isEmpty() || resultList1.isEmpty() || resultList2.isEmpty()) {
            this.err = this.err + "\nrate table cannot be loaded for Province " + this.prov + " Vehicle " + this.veh;
        }
        this.removeCB(this.rateTablesList.get("List2Province" + this.prov + "Vehicle" + this.veh), rec);
        this.descPol(rec);
        this.policy = rec;
        int Ur = this.getInteger(rec, "Ur");
        this.errhold = this.err;
        this.err = "";
        this.processDiscount();
        this.processSurcharge();
        this.err = this.flagXml == true ? this.errhold + this.err : this.errhold;
        this.setInteger(rec, "Ur", Ur);
        this.policy = rec = this.calc(rec);
        this.hm.remove("Optionaldiscount1");
        this.hm.remove("OptionaldiscounthasCov");
        this.comp.remove("Optionaldiscount");
        this.hm.remove("Discount1");
        this.hm.remove("DiscounthasCov");
        this.comp.remove("Discount");
        this.errhold = this.err;
        this.err = "";
        this.processEndorse();
        this.processOptionalab();
        this.err = this.flagXml == true ? this.errhold + this.err : this.errhold;
        this.additionalPremium(rec, this.addCol);
        this.saveSeries(rec, this.rateTablesList.get("List1Province" + this.prov + "Vehicle" + this.veh));
        this.saveSeries(rec, this.rateTablesList.get("List2Province" + this.prov + "Vehicle" + this.veh));
        this.saveExtra(rec);
        if (!this.err.isEmpty()) {
            this.err = "PREMIUM ERROR LIST:" + this.err;
            throw new IllegalArgumentException(this.err);
        }
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        entityManager.getTransaction().begin();
        entityManager.merge((Object)rec);
        entityManager.persist((Object)rec);
        entityManager.getTransaction().commit();
    }

    void resetPolicyCount(Integer in) {
        EntityManager entityManager = ((org.shop.editor.EntityService)Lookup.getDefault().lookup(org.shop.editor.EntityService.class)).getEntityManager();
        entityManager.getTransaction().begin();
        List resultList3 = entityManager.createNamedQuery("Policy.polnum").setParameter("client", (Object)this.client).setParameter("polnum", (Object)in).getResultList();
        Integer counter = 1;
        for (Policy pol : resultList3) {
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            pol.setRecordnumber(n);
            entityManager.merge((Object)pol);
        }
        entityManager.getTransaction().commit();
    }

    void saveSeries(Policy pol, List<Components> resultList) {
        System.out.println("Combo:saveSeries: ");
        for (Components c : resultList) {
            String name = c.getNamed();
            String type = c.getTyped();
            if (!this.i2b(c.getSave()).booleanValue() || !type.equals("JComboBox") || name.equals("Limitall")) continue;
            System.out.println("Combo:saveSeries: " + type + " " + name);
            Combohelper ch = this.hm.get(name + this.getInteger(pol, name));
            if (ch == null) continue;
            String str = ":" + name + ":" + ch.getDisplay();
            Integer in = (str = str + this.getString(pol, "Description")).length() > 5000 ? 5000 : str.length();
            this.setString(pol, "Description", str.toString().substring(0, in));
        }
    }

    void saveExtra(Policy pol) {
        System.out.println("Combo:saveExtra: ");
        String str = ":Limitall:" + this.initSplit();
        str = str + this.getString(pol, "Description");
        Combohelper ch = this.hm.get("Br" + this.getInteger(pol, "Br"));
        if (ch != null) {
            String str2 = ch.getDisplay();
            str = str + ":location:" + (str2.length() > 40 ? str2.substring(0, 40) : str2);
        }
        ch = this.hm.get("Dr" + this.getInteger(pol, "Dr"));
        String dr = "";
        if (ch != null) {
            dr = "/" + ch.getDisplay();
        }
        if ((ch = this.hm.get("Clss" + this.getInteger(pol, "Clss"))) != null) {
            String str3 = ch.getDisplay();
            str3 = str3 + " ";
            Integer len = 0;
            len = str3.indexOf(" ");
            str3 = len > -1 ? str3.substring(0, len) : "";
            str3 = str3 + dr;
            str = str + ":ratingclass:" + (str3.length() > 30 ? str3.substring(0, 30) : str3);
        }
        Integer in = str.length() > 5000 ? 5000 : str.length();
        this.setString(pol, "Description", str.substring(0, in));
    }

    public void descPol(Policy pol) {
        String des = pol.getDescription();
        if (des != null && !des.isEmpty()) {
            String[] desarray = des.split(":", -99);
            String desExpo = "";
            String[] arr = new String[]{"modelyear", "make", "bodytype", "vin", "newcost", "weight", "code", "Splitded"};
            for (int i = 1; i < desarray.length; i += 2) {
                if (!this.findGroupString(arr, desarray[i]).booleanValue()) continue;
                desExpo = desExpo + ":" + desarray[i] + ":" + desarray[i + 1];
            }
            pol.setDescription(desExpo);
        }
    }

    public void descExpo(Exposure expo) {
        String des = expo.getDescription();
        if (des != null && !des.isEmpty()) {
            String[] desarray = this.initSplit(des);
            String desExpo = "";
            String[] arr = new String[]{"rep5policy", "rep5name", "rep5time", "rep5exp", "ampm", "rep3business", "rep3broker", "rep3special", "rep3supervisor", "rep3date1", "rep3date2", "rep3dc", "rep3cl", "rep3cm", "rep3sp", "rep3chk"};
            for (int i = 1; i < desarray.length; i += 2) {
                if (!this.findGroupString(arr, desarray[i]).booleanValue()) continue;
                desExpo = desExpo + ":" + desarray[i] + ":" + desarray[i + 1];
            }
            expo.setDescription(desExpo);
        }
    }

    Boolean findGroupString(String[] arr, String in) {
        Boolean found = false;
        for (int i = 0; i < arr.length; ++i) {
            if (!in.equals(arr[i])) continue;
            found = true;
            break;
        }
        return found;
    }

    String replaceLimit(String desc, String srch, String limit) {
        Integer beginIndex = desc.indexOf(srch);
        if (beginIndex > -1) {
            Integer endIndex = desc.indexOf(":", beginIndex + 10);
            String toReplace = endIndex > -1 ? desc.substring(beginIndex, endIndex) : desc.substring(beginIndex);
            desc = desc.replaceFirst(toReplace, srch + limit);
        }
        return desc;
    }

    String[] initSplit(String txt) {
        char[] ch = txt.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            ch[i] = ch[i] == '|' ? 126 : ch[i];
        }
        txt = new String(ch);
        return txt.split("~");
    }

    String initSplit() {
        String[] blank = new String[]{};
        if (this.getString(this.exposure, "Description").length() == 0) {
            this.lineSplit = blank;
        } else {
            this.lineSplit = this.getString(this.exposure, "Description").substring(1).split(":", -99);
            if (this.lineSplit.length < 2) {
                this.lineSplit = blank;
            }
        }
        return this.entry("Limitall");
    }

    String entry(String srch) {
        String spt = "";
        int i = 0;
        while (i + 1 < this.lineSplit.length) {
            if (srch.equalsIgnoreCase(this.lineSplit[i])) {
                spt = this.lineSplit[i + 1];
                break;
            }
            i += 2;
        }
        return spt;
    }

    void addAP() {
        if (this.policy.getCovap().equals(1) || this.policy.getCovcl().equals(1)) {
            this.policy.setOptionaldiscount(Integer.valueOf(1));
            String str = this.getString(this.policy, "Optionaldiscounttext");
            if (str.indexOf("ap") == -1) {
                str = str.isEmpty() ? "|ap|" : str + "ap|";
                this.policy.setOptionaldiscounttext(str);
            }
        }
    }

    List<Components> loadRates(Integer series, Integer versionnumber, Integer province, Integer vehicle) {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        entityManager.getTransaction().begin();
        Integer subversion = this.getSubversion(this.prov, this.veh);
        List resultList = series == 1 ? entityManager.createNamedQuery("Components.series.province.vehicle").setParameter("client", (Object)this.client).setParameter("version", (Object)versionnumber).setParameter("province", (Object)0).setParameter("vehicle", (Object)0).setParameter("series", (Object)1).getResultList() : entityManager.createNamedQuery("Components.series.province.vehicle").setParameter("client", (Object)this.client).setParameter("version", (Object)subversion).setParameter("province", (Object)province).setParameter("vehicle", (Object)vehicle).setParameter("series", (Object)2).getResultList();
        for (Components c2 : resultList) {
            Combohelper ch;
            String name = c2.getNamed();
            List resultList3 = series == 1 ? entityManager.createNamedQuery("Components.series.province.vehicle.name").setParameter("client", (Object)this.client).setParameter("version", (Object)versionnumber).setParameter("province", (Object)0).setParameter("vehicle", (Object)0).setParameter("series", (Object)1).setParameter("name", (Object)name).getResultList() : entityManager.createNamedQuery("Components.series.province.vehicle.name").setParameter("client", (Object)this.client).setParameter("version", (Object)subversion).setParameter("province", (Object)province).setParameter("vehicle", (Object)vehicle).setParameter("series", (Object)2).setParameter("name", (Object)name).getResultList();
            String type = "";
            Integer index = -1;
            Components c32 = null;
            for (Components c32 : resultList3) {
                type = c32.getTyped();
                index = c32.getInitindex();
                if (!type.equals("JComboBox")) continue;
                if (this.i2b(c32.getInitread()).booleanValue()) break;
                type = "";
                break;
            }
            System.out.println("Combo:initAll: " + type + " " + name);
            if (!type.equals("JComboBox")) continue;
            this.comp.add(name);
            for (Components c32 : resultList3) {
                Combohelper ch2 = new Combohelper();
                ch2.setAdditive(this.i2b(c32.getAdditive()));
                ch2.setDesc(c32.getDescription());
                ch2.setDisplay(c32.getDisplay());
                ch2.setCode(c32.getCode());
                this.hmUnsorted.put(name + "," + c32.getCode(), ch2);
            }
            List resultList4 = series == 1 ? entityManager.createNamedQuery("Components.series.province.vehicle.name.notdisplay").setParameter("client", (Object)this.client).setParameter("version", (Object)versionnumber).setParameter("province", (Object)0).setParameter("vehicle", (Object)0).setParameter("series", (Object)1).setParameter("name", (Object)name).getResultList() : entityManager.createNamedQuery("Components.series.province.vehicle.name.notdisplay").setParameter("client", (Object)this.client).setParameter("version", (Object)subversion).setParameter("province", (Object)province).setParameter("vehicle", (Object)vehicle).setParameter("series", (Object)2).setParameter("name", (Object)name).getResultList();
            Boolean boo = true;
            for (Components c32 : resultList4) {
                if (!this.i2b(c32.getInitread()).booleanValue() || !"Code".equals(c32.getCoverage())) continue;
                ch = (Combohelper)this.hmUnsorted.get(name + "," + c32.getCode());
                ch.setCode(c32.getFactor().intValue());
                this.hmUnsorted.put(name + ch.getCode(), ch);
                if (!boo.booleanValue()) continue;
                this.hmUnsorted.put(name + "hasCov", ch);
                boo = false;
            }
            for (Components c32 : resultList4) {
                if (!this.i2b(c32.getInitread()).booleanValue() || "Code".equals(c32.getCoverage())) continue;
                ch = (Combohelper)this.hmUnsorted.get(name + "," + c32.getCode());
                ch = (Combohelper)this.hmUnsorted.get(name + ch.getCode());
                if (ch == null) {
                    ch = (Combohelper)this.hmUnsorted.get(name + "," + c32.getCode());
                }
                if ("Suffix".equals(c32.getCoverage())) {
                    ch.addsuffix("Suffix", c32.getDisplay());
                } else if ("Info".equals(c32.getCoverage())) {
                    ch.setDesc(c32.getDisplay());
                } else {
                    ch.addlink(c32.getCoverage(), c32.getLinked());
                    ch.add(c32.getCoverage() + c32.getSuffix(), new Double(c32.getFactor().floatValue()));
                    ch.addcov(c32.getCoverage(), c32.getCoverage());
                }
                ch.add(c32.getCoverage() + "_Additive", c32.getAdditive().doubleValue());
            }
            for (Components c32 : resultList4) {
                if (!this.i2b(c32.getInitread()).booleanValue() || !"Code".equals(c32.getCoverage())) continue;
                this.hmUnsorted.remove(name + "," + c32.getCode());
            }
        }
        return resultList;
    }

    void removeCB(List<Components> resultList3, Policy pol) {
        for (Components c3 : resultList3) {
            String type = c3.getTyped();
            String name = c3.getNamed();
            if (!this.i2b(c3.getInitread()).booleanValue() || !this.i2b(c3.getEnabled()).booleanValue() || !type.equals("JComboBox")) continue;
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i][3] = "XX";
            }
            Combohelper ch = this.hm.get(name + "hasCov");
            if (ch == null) continue;
            Integer in = ch.resetcov();
            if (!this.i2b(pol.getCovma()).booleanValue()) {
                this.markCov(ch, "MA");
            }
            if (!this.i2b(pol.getCovcl()).booleanValue() && !this.i2b(pol.getCovap()).booleanValue()) {
                this.markCov(ch, "CL");
            }
            if (!this.i2b(pol.getCovcm()).booleanValue() && !this.i2b(pol.getCovap()).booleanValue()) {
                this.markCov(ch, "CM");
            }
            if (!this.i2b(pol.getCovsp()).booleanValue()) {
                this.markCov(ch, "SP");
            }
            Integer out = ch.markcov("Dummy");
            System.out.println("Combo:checkCov: " + name + ": " + out + " active coverages " + " out of " + in);
        }
    }

    void markCov(Combohelper ch, String cov) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!cov.equals(this.names[i][2])) continue;
            this.names[i][3] = "";
            Integer count = ch.markcov(this.names[i][0]);
        }
    }

    void saveFields(Policy src, Policy tgt) {
        String[][] arr = new String[][]{{"Users", "i"}, {"Usersgroup", "s"}, {"Polnum", "i"}, {"Policynumber", "s"}, {"Client", "i"}, {"Version", "i"}, {"Vehicle", "i"}, {"Province", "i"}, {"Optionalabtext", "s"}, {"Optionaldiscounttext", "s"}, {"Optionalendorsetext", "s"}, {"Optionalsurchargetext", "s"}, {"Optionalab", "i"}, {"Optionaldiscount", "i"}, {"Optionalendorse", "i"}, {"Optionalsurcharge", "i"}, {"Covma", "i"}, {"Covab", "i"}, {"Covap", "i"}, {"Covcl", "i"}, {"Covcm", "i"}, {"Covsp", "i"}, {"Num1", "f"}, {"Num2", "f"}, {"Num3", "f"}, {"Num4", "f"}, {"Num5", "f"}, {"Text1", "s"}, {"Text2", "s"}, {"Description", "s"}, {"Limitall", "i"}, {"Recordnumber", "i"}};
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i][1].equals("i")) {
                this.setInteger(tgt, arr[i][0], this.getInteger(src, arr[i][0]));
                continue;
            }
            if (arr[i][1].equals("f")) {
                this.setFloat(tgt, arr[i][0], this.getFloat(src, arr[i][0]));
                continue;
            }
            if (!arr[i][1].equals("s")) continue;
            this.setString(tgt, arr[i][0], this.getString(src, arr[i][0]));
        }
    }

    public void updateSurcharge(Policy pol) {
        if (this.hmSurcharge.get("AdditiveSurcharge") != null) {
            String[] surchg = (String[])this.hmSurcharge.get("AdditiveSurcharge");
            Combohelper chTarget = this.hm.get("Optionaldiscount1");
            if (chTarget == null) {
                chTarget = new Combohelper();
                this.hm.put("Optionaldiscount1", chTarget);
                this.hm.put("OptionaldiscounthasCov", chTarget);
                this.comp.add("Optionaldiscount");
                this.setInteger(pol, "Optionaldiscount", 1);
            }
            for (int j = 0; j < surchg.length; ++j) {
                if (surchg[j].isEmpty()) continue;
                Integer code = this.getInteger(pol, surchg[j]);
                Combohelper chSource = this.hm.get(surchg[j] + code);
                if (chSource == null) continue;
                for (int i = 0; i < this.cov.length; ++i) {
                    String covname;
                    if (this.names[i][3].length() == 0 || chSource.getcov(covname = this.cov[i]) == null) continue;
                    if (chTarget.getcov(covname) == null) {
                        chTarget.addlink(covname, "");
                        chTarget.addcov(covname, covname);
                        chTarget.add(covname, chSource.get(covname));
                        continue;
                    }
                    chTarget.add(covname, chTarget.get(covname) + chSource.get(covname) - 1.0);
                }
            }
        }
    }

    Boolean isSurcharge(String covname, Policy pol) {
        if (this.hmSurcharge.get("AdditiveSurcharge") != null) {
            String[] surchg = (String[])this.hmSurcharge.get("AdditiveSurcharge");
            for (int j = 0; j < surchg.length; ++j) {
                if (!covname.equals(surchg[j])) continue;
                return true;
            }
        }
        return false;
    }

    Policy calc(Policy pol) {
        Policy policy = new Policy();
        this.saveFields(pol, policy);
        this.updateSurcharge(pol);
        Double total = new Double(0.0);
        Double units = 0.0;
        Double multiStd = null;
        if (pol.getUnits() != null) {
            units = pol.getUnits().doubleValue();
        }
        for (int i = 0; i < this.cov.length; ++i) {
            Double flt;
            String name;
            Combohelper chlimit;
            if (this.names[i][3].length() == 0) continue;
            Boolean covFlag = false;
            Double multi = null;
            Double add = null;
            Double premium = new Double(0.0);
            Double multiNoRound = null;
            Double premiumNoRound = new Double(0.0);
            String covname = this.cov[i];
            Integer code = -1;
            System.out.println("Cov:" + covname);
            for (String name2 : (ArrayList)this.comp) {
                if (this.isSurcharge(name2, pol).booleanValue()) {
                    code = this.getInteger(pol, name2);
                    this.setInteger(policy, name2, code);
                    continue;
                }
                if (name2.equals("Limitall") || name2.equals("Rg2") || name2.equals("Price2")) continue;
                code = this.getInteger(pol, name2);
                code = this.flagXml == false && code == 0 ? 1 : code;
                this.setInteger(policy, name2, code);
                Combohelper objch = this.hm.get(name2 + code);
                Combohelper ch = null;
                ch = objch;
                Combohelper chbase = this.hm.get(name2 + "hasCov");
                if (chbase == null || chbase.getcov(covname) == null) continue;
                covFlag = true;
                if (ch == null) {
                    if (name2.startsWith("Rg") || name2.equals("Price")) {
                        ch = this.hm.get(name2 + "," + code);
                    }
                    if (ch == null) {
                        System.out.println("Cov: " + covname + " Class: " + name2 + " missing value !!");
                        this.err = this.err + "\nerroneous value [" + code + "] for field = " + name2 + " for cov = " + covname;
                        continue;
                    }
                }
                String link = ch.getlink(covname);
                Double val = 0.0;
                if (link == null) {
                    if (!name2.startsWith("Rg") && !name2.equals("Price")) continue;
                    String cbrg = null;
                    if (name2.startsWith("Rg")) {
                        if (name2.length() > 2 && !name2.substring(2).equalsIgnoreCase(covname)) continue;
                        cbrg = "Rg2hasCov";
                    } else if (name2.equals("Price")) {
                        cbrg = "Price2hasCov";
                    }
                    Combohelper chrg = this.hm.get(cbrg);
                    if (chrg == null) {
                        this.err = this.err + "\nerroneous value [" + code + "] for field = " + cbrg + " for cov = " + covname;
                        continue;
                    }
                    Double rgincr = chrg.get(covname);
                    if (rgincr == null) {
                        this.err = this.err + "\nrate group incr not found for field = " + cbrg + " for cov = " + covname;
                        continue;
                    }
                    Integer target = ch.getCode();
                    Object[] obj = this.findlast(name2, covname);
                    Integer last = (Integer)obj[0];
                    Double lastvalue = (Double)obj[1];
                    if (last != -1) {
                        Double valflag = chrg.get(covname + "_Additive");
                        val = valflag > 0.0 ? Double.valueOf((double)(target - last) * rgincr + lastvalue) : Double.valueOf(Math.pow(1.0 + rgincr, target - last) * lastvalue);
                    }
                } else {
                    String suffix = "";
                    if (!link.equals("")) {
                        Combohelper chlink = this.hm.get(link + this.getInteger(pol, link));
                        if (chlink == null) {
                            this.err = this.err + "\nerroneous value [" + this.getInteger(pol, link) + "] for field = " + link + " for cov = " + covname;
                            continue;
                        }
                        suffix = chlink.getsuffix("Suffix");
                    }
                    val = ch.get(covname + suffix);
                }
                Double valflag = ch.get(covname + "_Additive");
                if (valflag != null && valflag > 0.0) {
                    add = add == null ? 0.0 : add;
                    add = add + val;
                } else {
                    multi = multi == null ? 1.0 : multi;
                    multi = multi * val;
                }
                System.out.println("cov:" + covname + ", class:" + name2 + ", value:" + val + ", product:" + multi + ", addition:");
                if (!covname.equals("AB") || !name2.equals("Br") && !name2.equals("Clss") && !name2.startsWith("Rg") && !name2.equals("Dr") && !name2.equals("Surcharge1")) continue;
                multiStd = multiStd == null ? 1.0 : multiStd;
                multiStd = multiStd * val;
            }
            add = add == null ? 0.0 : (double)Math.round(add);
            multiNoRound = multi == null ? 0.0 : multi;
            multi = multi == null ? 0.0 : (double)Math.round(multi);
            Double flatExcess = null;
            if (!multi.equals(0.0) && (covname.equals("BI") || covname.equals("PD") || covname.equals("TP"))) {
                String name2;
                name2 = "Ll1";
                code = this.getInteger(pol, name2);
                Combohelper chlimit1 = this.hm.get(name2 + code);
                if (this.client.equals(32) && chlimit1 != null) {
                    name2 = "Ll";
                    code = this.getInteger(pol, name2);
                    chlimit = this.hm.get(name2 + code);
                    if (chlimit1.getsuffix("Suffix") != null && !chlimit1.getsuffix("Suffix").isEmpty() && !chlimit1.getsuffix("Suffix").equals("1")) {
                        flatExcess = chlimit.get("yBI");
                        policy.setNum1(Float.valueOf(flatExcess != null ? flatExcess.floatValue() : 0.0f));
                        flatExcess = 0.0;
                    } else if (chlimit1.getsuffix("Suffix") != null && chlimit1.getsuffix("Suffix").equals("1") && (this.veh == 2 || this.getInteger(pol, "Tr") <= 1)) {
                        Double minExcess = chlimit.get("yPD");
                        policy.setNum2(Float.valueOf(minExcess != null ? minExcess.floatValue() : 0.0f));
                    }
                }
            }
            premium = units * (add + multi);
            premiumNoRound = units * (add + multiNoRound);
            premium = (double)Math.round(premium) * 1.0;
            String covSuffix = this.abxSuffix(covname.equals("AB") && pol.getProvince() != 5, new String[0]);
            if (!covname.equals("AP")) {
                this.setFloat(policy, covname + covSuffix, Float.valueOf(premium.floatValue()));
            }
            premium = this.getFloat(policy, covname).doubleValue();
            if (this.i2b(pol.getCovap()).booleanValue() && (covname.equals("CL") || covname.equals("CM"))) {
                Boolean flagAP = (double)this.getFloat(policy, "AP").floatValue() != 0.0;
                this.setFloat(policy, "AP", Float.valueOf(this.getFloat(policy, "AP").floatValue() + premiumNoRound.floatValue()));
                this.setFloat(policy, covname, Float.valueOf(0.0f));
                if (flagAP.booleanValue()) {
                    Double premiumAP = (double)Math.round(this.getFloat(policy, "AP").doubleValue()) * 1.0;
                    this.setFloat(policy, "AP", Float.valueOf(premiumAP.floatValue()));
                    total = total + premiumAP;
                }
                if (covname.equals("CL")) {
                    this.setFloat(policy, "AV2F", Float.valueOf(premiumNoRound.floatValue()));
                } else {
                    this.setFloat(policy, "TT2F", Float.valueOf(premiumNoRound.floatValue()));
                }
            } else if (!covname.equals("UM") && !covname.equals("AP")) {
                total = total + premium;
            }
            if (covname.equals("BI")) {
                name = "Ll";
                code = this.getInteger(pol, name);
                chlimit = this.hm.get(name + code);
                if (chlimit != null && (flt = chlimit.get("xBI")) != null) {
                    policy.setNum4(Float.valueOf(flt.floatValue()));
                }
                if (flatExcess != null) {
                    flatExcess = flatExcess * units;
                    if (premium != 0.0) {
                        flatExcess = flatExcess / premium;
                    }
                    policy.setNum4(Float.valueOf(flatExcess.floatValue()));
                }
            } else if (covname.equals("PD")) {
                name = "Ll";
                code = this.getInteger(pol, name);
                chlimit = this.hm.get(name + code);
                if (chlimit != null && (flt = chlimit.get("xPD")) != null) {
                    policy.setNum4f(Float.valueOf(flt.floatValue()));
                }
                if (flatExcess != null) {
                    flatExcess = flatExcess * units;
                    if (premium != 0.0) {
                        flatExcess = flatExcess / premium;
                    }
                    policy.setNum4f(Float.valueOf(flatExcess.floatValue()));
                }
            }
            System.out.println("--------------------------------------------------------------");
            if (!covFlag.booleanValue() || !(premium <= 1.0) || covname.equals("UM")) continue;
            System.out.println("A dollar or less calculated, check input: cov:" + covname);
        }
        this.setFloat(policy, "Units", Float.valueOf(units.floatValue()));
        this.setFloat(policy, "TT2", Float.valueOf(total.floatValue()));
        if (units != 0.0) {
            Double av = total / units;
            this.setFloat(policy, "AV2", Float.valueOf(av.floatValue()));
        }
        if (multiStd != null) {
            multiStd = (double)Math.round(units * multiStd) * 1.0;
            this.setFloat(policy, "Num5f", Float.valueOf(multiStd.floatValue()));
        }
        return policy;
    }

    String abxSuffix(Boolean flag, String[] addCol) {
        if (!flag.booleanValue()) {
            return "";
        }
        for (int i = 0; i < addCol.length; i += 2) {
            if (!addCol[i].equalsIgnoreCase("ABX")) continue;
            return "X";
        }
        return "";
    }

    void additionalPremium(Policy pol, String[] addCol) {
        Double hold = 0.0;
        Boolean flagUm = false;
        for (int i = 0; i < addCol.length; i += 2) {
            Float flt;
            if (this.getObjectClass(addCol[i]).equals(Float.class) && (flt = this.getFloat(pol, addCol[i])) != null) {
                hold = hold + flt.doubleValue();
            }
            if (!addCol[i].equalsIgnoreCase("UM")) continue;
            flagUm = true;
        }
        if (!flagUm.booleanValue()) {
            pol.setUm(Float.valueOf(0.0f));
        }
        Double total = this.getFloat(pol, "TT2").doubleValue();
        Double units = this.getFloat(pol, "Units").doubleValue();
        total = total + hold;
        pol.setTt(Float.valueOf(total.floatValue()));
        if (units != 0.0) {
            Double av = total / units;
            pol.setAv(Float.valueOf(av.floatValue()));
        }
    }

    long elapsedtime(long start) {
        long end = System.currentTimeMillis();
        long timeelapsed = (end - start) / 1000L;
        long seconds = timeelapsed % 60L;
        long minutes = timeelapsed % 3600L / 60L;
        System.out.println("Milliseconds" + (end - start) + "Total Seconds Elapsed: " + timeelapsed + ", (minutes:" + minutes + " seconds:" + seconds + ")");
        return end;
    }

    Object[] findlast(String cb, String cov) {
        Combohelper ch;
        Object[] dbl = new Object[]{-1, 0.0};
        Double temp = 0.0;
        for (int i = 0; i < 100 && (ch = this.hm.get(cb + (i + 1))) != null && (temp = ch.get(cov)) != null; ++i) {
            dbl[1] = temp;
            dbl[0] = ch.getCode();
        }
        return dbl;
    }

    void processOptionals() {
        this.processDiscount();
        this.processEndorse();
        this.processOptionalab();
        this.processSurcharge();
    }

    void loadOptionals() {
        this.loadDiscount();
        this.loadEndorse();
        this.loadOptionalab();
        this.loadSurcharge();
        this.loadAdditiveSurcharge();
    }

    Integer getSubversion(Integer prov, Integer veh) {
        Integer subversion;
        block0: {
            subversion = this.version;
            EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
            List resultList2 = entityManager.createNamedQuery("Components.series.province.vehicle.name").setParameter("client", (Object)this.client).setParameter("version", (Object)this.version).setParameter("province", (Object)prov).setParameter("vehicle", (Object)veh).setParameter("series", (Object)3).setParameter("name", (Object)"Subversion").getResultList();
            Iterator it2 = resultList2.iterator();
            if (!it2.hasNext()) break block0;
            Components c2 = (Components)it2.next();
            subversion = c2.getInitindex();
        }
        return subversion;
    }

    void storeFactors(String cb, String rule, Float premium) {
        for (int i = 0; i < this.covfac.length; ++i) {
            if (!this.covfac[i][0].equals(rule)) continue;
            for (int j = 1; j < this.covfac[i].length; ++j) {
                Combohelper ch = this.hm.get(cb + "1");
                if (ch == null) {
                    ch = new Combohelper();
                    ch.setCode(1);
                    this.hm.put(cb + "1", ch);
                    this.hm.put(cb + "hasCov", ch);
                    this.comp.add(cb);
                    this.setInteger(this.policy, cb, 1);
                }
                if (!this.isActiveCov(this.covfac[i][j]).booleanValue()) continue;
                Double discountfactor = ch.get(this.covfac[i][j]);
                Double discount = discountfactor == null ? 0.0 : discountfactor - 1.0;
                discount = discount + (double)premium.floatValue();
                discountfactor = 1.0 + discount;
                ch.addlink(this.covfac[i][j], "");
                ch.add(this.covfac[i][j] + "", (double)discountfactor);
                ch.addcov(this.covfac[i][j], this.covfac[i][j]);
                ch.add(this.covfac[i][j] + "_Additive", 0.0);
            }
            break;
        }
    }

    public Boolean isActiveCov(String cov) {
        for (String name : (ArrayList)this.comp) {
            if (name == null || name.equals("Discount") || name.equals("Price2") || name.equals("Ur") || name.equals("Limitall")) continue;
            Integer code = this.getInteger(this.policy, name);
            Combohelper ch = this.hm.get(name + code);
            if (ch == null || ch.getcov(cov) == null) continue;
            return true;
        }
        return false;
    }

    void processDiscount() {
        String code = "";
        Float premiumtotal = Float.valueOf(0.0f);
        String text = this.policy.getOptionaldiscounttext();
        if (text == null || text.isEmpty()) {
            return;
        }
        HashMap<String, String> hmFlag = new HashMap<String, String>();
        text = text.substring(1);
        String[] arr = this.initSplit(text);
        for (int i = 0; i < arr.length; ++i) {
            Combohelper ch = (Combohelper)this.hmDiscount.get(arr[i]);
            if (ch != null) {
                int j;
                String grp = ch.getlink("Group");
                String cov = "";
                for (j = 0; j < grp.length() && ((cov = (String)hmFlag.get(grp.substring(j, j + 1))) == null || cov.length() <= 0); ++j) {
                }
                if (cov != null && cov.length() != 0) continue;
                for (j = 0; j < grp.length(); ++j) {
                    cov = grp.substring(j, j + 1);
                    hmFlag.put(cov, cov);
                }
                Float premium = Float.valueOf(ch.get("Premium").floatValue());
                String rule = ch.getlink("Rule");
                this.storeFactors("Discount", rule, premium);
                premium = rule.equals("1") ? Float.valueOf(premium.floatValue() * (this.getFloat(this.policy, "TT2").floatValue() - this.getFloat(this.policy, "CM").floatValue() - this.getFloat(this.policy, "SP").floatValue() - this.getFloat(this.policy, "TT2F").floatValue())) : (rule.equals("2") ? Float.valueOf(premium.floatValue() * this.getFloat(this.policy, "TT2").floatValue()) : (rule.equals("3") ? Float.valueOf(premium.floatValue() * (this.getFloat(this.policy, "CM").floatValue() + this.getFloat(this.policy, "TT2F").floatValue())) : (rule.equals("4") ? Float.valueOf(premium.floatValue() * this.getFloat(this.policy, "AB").floatValue()) : (rule.equals("5") ? Float.valueOf(premium.floatValue() * (this.getFloat(this.policy, "TT2").floatValue() - this.getFloat(this.policy, "CL").floatValue() - this.getFloat(this.policy, "AV2F").floatValue() - this.getFloat(this.policy, "CM").floatValue() - this.getFloat(this.policy, "SP").floatValue() - this.getFloat(this.policy, "TT2F").floatValue())) : (rule.equals("6") ? Float.valueOf(premium.floatValue() * (this.getFloat(this.policy, "CL").floatValue() + this.getFloat(this.policy, "AV2F").floatValue())) : (rule.equals("7") ? Float.valueOf(premium.floatValue() * (this.getFloat(this.policy, "CM").floatValue() + this.getFloat(this.policy, "SP").floatValue() + this.getFloat(this.policy, "TT2F").floatValue())) : (rule.equals("8") ? Float.valueOf(premium.floatValue() * -(-this.getFloat(this.policy, "CL").floatValue() - this.getFloat(this.policy, "AV2F").floatValue() - this.getFloat(this.policy, "CM").floatValue() - this.getFloat(this.policy, "SP").floatValue() - this.getFloat(this.policy, "TT2F").floatValue())) : (rule.equals("10") ? Float.valueOf(premium.floatValue() * (this.getFloat(this.policy, "BI").floatValue() + this.getFloat(this.policy, "PD").floatValue() + this.getFloat(this.policy, "TP").floatValue() + this.getFloat(this.policy, "SA").floatValue() + this.getFloat(this.policy, "UA").floatValue())) : Float.valueOf(premium.floatValue() * this.getFloat(this.policy, "Units").floatValue())))))))));
                premiumtotal = Float.valueOf(premiumtotal.floatValue() + premium.floatValue());
                code = code + "|" + ch.getlink("Description");
                continue;
            }
            this.err = this.err + "\nerroneous discount code [" + arr[i] + "]";
        }
        String string = code = code.isEmpty() ? code : code + "|";
        if (premiumtotal.floatValue() != 0.0f) {
            premiumtotal = Float.valueOf((float)Math.round(Math.abs(premiumtotal.floatValue())) * premiumtotal.floatValue() / Math.abs(premiumtotal.floatValue()));
        }
        this.policy.setOptionaldiscounttext(code);
    }

    void processEndorse() {
        String text2 = "";
        String code = "";
        Float premiumtotal = Float.valueOf(0.0f);
        String text = this.policy.getOptionalendorsetext();
        if (text == null || text.isEmpty()) {
            return;
        }
        this.hmFlag.clear();
        text = text.substring(1);
        String[] arr = this.initSplit(text);
        for (int i = 0; i < arr.length; ++i) {
            Combohelper ch = (Combohelper)this.hmEndorse.get(arr[i]);
            String hold2 = "";
            if (ch != null) {
                int j;
                String grp = ch.getlink("Group");
                String cov = "";
                for (j = 0; j < grp.length() && ((cov = (String)this.hmFlag.get(grp.substring(j, j + 1))) == null || cov.length() <= 0); ++j) {
                }
                if (cov != null && cov.length() != 0) continue;
                for (j = 0; j < grp.length(); ++j) {
                    cov = grp.substring(j, j + 1);
                    this.hmFlag.put(cov, cov);
                }
                Float premium = Float.valueOf(ch.get("Premium").floatValue());
                String rule = ch.getlink("Rule");
                if (!rule.equals("1")) {
                    if (rule.equals("2")) {
                        premium = Float.valueOf(premium.floatValue() * (this.getFloat(this.policy, "BI").floatValue() + this.getFloat(this.policy, "SA").floatValue() + this.getFloat(this.policy, "TP").floatValue() + this.getFloat(this.policy, "AB").floatValue()));
                    } else if (rule.equals("3")) {
                        premium = Float.valueOf(premium.floatValue() * this.getFloat(this.policy, "PHBI").floatValue());
                    } else if (rule.equals("4")) {
                        premium = Float.valueOf(premium.floatValue() * (this.getFloat(this.policy, "CM").floatValue() + this.getFloat(this.policy, "TT2F").floatValue()));
                    } else if (rule.equals("5")) {
                        premium = Float.valueOf((premium = Float.valueOf(premium.floatValue() * this.getFloat(this.policy, "DC").floatValue())).floatValue() < 5.0f ? 5.0f : premium.floatValue());
                        premium = Float.valueOf(premium.floatValue() > 25.0f ? 25.0f : premium.floatValue());
                    } else {
                        premium = rule.equals("6") ? Float.valueOf(premium.floatValue() * (this.getFloat(this.policy, "BI").floatValue() + this.getFloat(this.policy, "SA").floatValue() + this.getFloat(this.policy, "TP").floatValue())) : (rule.equals("7") ? Float.valueOf((premium = Float.valueOf(premium.floatValue() * (this.getFloat(this.policy, "CM").floatValue() + this.getFloat(this.policy, "TT2F").floatValue() + this.getFloat(this.policy, "CL").floatValue() + this.getFloat(this.policy, "AV2F").floatValue()))).floatValue() < 50.0f ? 50.0f : premium.floatValue()) : Float.valueOf(premium.floatValue() * this.getFloat(this.policy, "Units").floatValue()));
                    }
                }
                hold2 = "\n" + ch.getlink("Label");
                hold2 = hold2.replaceAll(";", ",");
                text2 = text2 + hold2;
                premiumtotal = Float.valueOf(premiumtotal.floatValue() + premium.floatValue());
                code = code + "|" + ch.getlink("Description");
                continue;
            }
            this.err = this.err + "\nerroneous endorse code [" + arr[i] + "]";
        }
        text2 = !text2.isEmpty() ? text2.substring(1) : null;
        String string = code = code.isEmpty() ? code : code + "|";
        if (premiumtotal.floatValue() != 0.0f) {
            premiumtotal = Float.valueOf((float)Math.round(Math.abs(premiumtotal.floatValue())) * premiumtotal.floatValue() / Math.abs(premiumtotal.floatValue()));
        }
        Integer intval = new Integer(Math.round(premiumtotal.floatValue()));
        this.policy.setOptionalendorseprm(Float.valueOf(intval.floatValue()));
        this.policy.setDescription(this.getString(this.policy, "Description") + ":endorsenumber:" + text2);
        this.policy.setOptionalendorsetext(code);
    }

    void processOptionalab() {
        int i;
        String text = this.policy.getOptionalabtext();
        if (text == null || text.isEmpty()) {
            return;
        }
        String code = "";
        String[] arr1a = new String[]{"Inc"};
        String[] arr1b = new String[]{"I06", "I08", "I10"};
        String[] arr1c = new String[]{"Cde", "Car", "Cgi", "Med", "Mat", "Mma"};
        if (!this.client.equals(32) || this.client.equals(32) && this.getSubversion(this.prov, this.veh) > 1039) {
            arr1c = new String[]{"Cde", "Car", "Cgi", "Med", "Mat", "Mma", "Rep", "Neb", "Cg1", "Edu", "Vis", "Cg2", "Dmg", "Cd1", "Cd2"};
        }
        String[] arr2a = new String[]{"Ial"};
        String[] arr2b = new String[]{"Iyo", "Imi", "Iol"};
        String[] arr3 = new String[]{"Cto"};
        text = text.substring(1);
        String[] arr = this.initSplit(text);
        Float total = Float.valueOf(0.0f);
        String type = this.findGroupString(arr, "Sec") != false ? "x" : "";
        for (i = 0; i < arr.length; ++i) {
            if (!this.findGroupString(arr1a, arr[i]).booleanValue()) continue;
            total = Float.valueOf(total.floatValue() + this.getOptionalabpremium(arr[i], type, Float.valueOf(0.0f)).floatValue());
            code = code + "|" + arr[i];
            break;
        }
        for (i = 0; i < arr.length; ++i) {
            if (!this.findGroupString(arr1b, arr[i]).booleanValue()) continue;
            total = Float.valueOf(total.floatValue() + this.getOptionalabpremium(arr[i], type, Float.valueOf(0.0f)).floatValue());
            code = code + "|" + arr[i];
            break;
        }
        for (i = 0; i < arr.length; ++i) {
            if (!this.findGroupString(arr1c, arr[i]).booleanValue()) continue;
            total = Float.valueOf(total.floatValue() + this.getOptionalabpremium(arr[i], type, Float.valueOf(0.0f)).floatValue());
            code = code + "|" + arr[i];
        }
        for (i = 0; i < arr.length; ++i) {
            if (!this.findGroupString(arr2a, arr[i]).booleanValue()) continue;
            total = Float.valueOf(total.floatValue() + this.getOptionalabpremium(arr[i], type, total).floatValue());
            code = code + "|" + arr[i];
            break;
        }
        for (i = 0; i < arr.length; ++i) {
            if (!this.findGroupString(arr2b, arr[i]).booleanValue()) continue;
            total = Float.valueOf(total.floatValue() + this.getOptionalabpremium(arr[i], type, total).floatValue());
            code = code + "|" + arr[i];
            break;
        }
        for (i = 0; i < arr.length; ++i) {
            if (!this.findGroupString(arr3, arr[i]).booleanValue()) continue;
            total = Float.valueOf(total.floatValue() + this.getOptionalabpremium(arr[i], type, Float.valueOf(0.0f)).floatValue());
            code = code + "|" + arr[i];
        }
        if (total.floatValue() != 0.0f) {
            total = Float.valueOf((float)Math.round(Math.abs(total.floatValue())) * total.floatValue() / Math.abs(total.floatValue()));
        }
        Integer intval = new Integer(Math.round(total.floatValue()));
        this.policy.setOptionalabprm(Float.valueOf(intval.floatValue()));
        code = type.isEmpty() ? code : code + "|Sec";
        code = code.isEmpty() ? code : code + "|";
        this.endorseLabel(code);
        this.policy.setOptionalabtext(code);
        String[] arrnew = new String[arr1a.length + arr1b.length + arr1c.length + arr2a.length + arr2b.length + arr3.length];
        System.arraycopy(arr1a, 0, arrnew, 0, arr1a.length);
        System.arraycopy(arr1b, 0, arrnew, arr1a.length, arr1b.length);
        System.arraycopy(arr1c, 0, arrnew, arr1a.length + arr1b.length, arr1c.length);
        System.arraycopy(arr2a, 0, arrnew, arr1a.length + arr1b.length + arr1c.length, arr2a.length);
        System.arraycopy(arr2b, 0, arrnew, arr1a.length + arr1b.length + arr1c.length + arr2a.length, arr2b.length);
        System.arraycopy(arr3, 0, arrnew, arr1a.length + arr1b.length + arr1c.length + arr2a.length + arr2b.length, arr3.length);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            Boolean boo = true;
            if (this.findGroupString(arrnew, arr[i2]).booleanValue() || arr[i2].equals("Sec")) {
                boo = false;
            }
            this.err = this.err + (boo != false ? "\nerroneous opt ab code [" + arr[i2] + "]" : "");
        }
    }

    void endorseLabel(String txt) {
        char[] ch = txt.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            ch[i] = ch[i] == '|' ? 126 : ch[i];
        }
        txt = new String(ch);
        String[] arr = txt.split("~");
        String text = "";
        for (int i = 0; i < arr.length; ++i) {
            String strMap;
            Integer in = (Integer)this.hmOptionalab.get(arr[i]);
            if (in == null || (strMap = (String)this.hmOptionalab.get("Label" + in)) == null || strMap.isEmpty()) continue;
            text = text.replaceAll(";", ",");
            text = text + "\n" + strMap;
        }
        text = !text.isEmpty() ? text.substring(1) : null;
        this.policy.setDescription(this.getString(this.policy, "Description") + ":optabtxt:" + text);
    }

    void processSurcharge() {
        String code;
        String text = this.policy.getOptionalsurchargetext();
        if (text == null || text.isEmpty()) {
            return;
        }
        this.hmFlag.clear();
        Float total = Float.valueOf(0.0f);
        Float discountFactorab = Float.valueOf(0.0f);
        Float totalPremium = this.getFloat(this.policy, "TT2");
        Float totalPremiumab = this.getFloat(this.policy, "AB");
        text = text.substring(1);
        String[] arr = this.initSplit2(text);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].equals("Gd:01") || arr[i].equals("Gd:00")) continue;
            Float factor = this.getSurchargefactor(arr[i]);
            if (arr[i].indexOf("Dr") > -1) {
                discountFactorab = factor;
                continue;
            }
            total = Float.valueOf(total.floatValue() + factor.floatValue());
        }
        this.storeFactors("Optionaldiscount", "9", total);
        this.storeFactors("Optionaldiscount", "4", discountFactorab);
        Float premiumtotal = Float.valueOf(total.floatValue() * totalPremium.floatValue() + discountFactorab.floatValue() * totalPremiumab.floatValue());
        if (premiumtotal.floatValue() != 0.0f) {
            premiumtotal = Float.valueOf((float)Math.round(Math.abs(premiumtotal.floatValue())) * premiumtotal.floatValue() / Math.abs(premiumtotal.floatValue()));
        }
        code = (code = (String)this.hmFlag.get("surchargetext")) == null || code.isEmpty() ? "" : code + "|";
        this.policy.setOptionalsurchargetext(code);
    }

    Float getSurchargefactor(String str) {
        Object hold;
        Object grp = this.hmSurcharge.get(str + "Group");
        if (grp != null) {
            String cov = (String)this.hmFlag.get(grp);
            if (cov != null && cov.length() > 0) {
                return Float.valueOf(0.0f);
            }
            String code = (String)this.hmFlag.get("surchargetext");
            if (code == null) {
                code = "";
            }
            code = code + "|" + str;
            this.hmFlag.put("surchargetext", code);
            this.hmFlag.put(grp, grp);
        }
        if ((hold = this.hmSurcharge.get(str)) == null) {
            this.err = this.err + "\nerroneous surcharge code [" + str + "]";
        }
        return Float.valueOf(hold == null ? 0.0f : ((Float)hold).floatValue());
    }

    String[] initSplit2(String txt) {
        char[] ch = txt.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            ch[i] = ch[i] == '|' ? 126 : ch[i];
        }
        txt = new String(ch);
        return txt.split("~");
    }

    Float getOptionalabpremium(String str, String type, Float flt) {
        Integer in = (Integer)this.hmOptionalab.get(str + type);
        String cov = (String)this.hmOptionalab.get("Code4" + in);
        Float premium = Float.valueOf(0.0f);
        if (cov == null || cov.length() == 0) {
            premium = Float.valueOf(1.0f);
        } else if (this.policy != null) {
            cov = cov.equals("AB") ? "Num5f" : cov;
            premium = this.getFloat(this.policy, cov);
            if (cov.equals("BI")) {
                premium = Float.valueOf(premium.floatValue() + this.getFloat(this.policy, "TP").floatValue());
                premium = Float.valueOf(premium.floatValue() + this.getFloat(this.policy, "PHBI").floatValue());
            }
        }
        String strMap = (String)this.hmOptionalab.get("Code3" + in);
        if (strMap == null) {
            this.err = this.err + "\nerroneous opt ab code [" + str + "]";
        }
        Float factor = Float.valueOf(strMap == null ? 0.0f : Float.parseFloat(strMap));
        return Float.valueOf((premium.floatValue() + flt.floatValue()) * factor.floatValue());
    }

    void loadSurcharge() {
        this.hmSurcharge.clear();
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Components.series.province.vehicle.name.notdisplay").setParameter("client", (Object)this.client).setParameter("version", (Object)this.getSubversion(this.prov, this.veh)).setParameter("province", (Object)this.prov).setParameter("vehicle", (Object)this.veh).setParameter("series", (Object)3).setParameter("name", (Object)"Surchargehelper").getResultList();
        System.out.println("Load Surcharge: ");
        for (Components c : resultList) {
            String str = c.getCoverage();
            if (str.equals("Code") || str.equals("Display")) continue;
            Integer cnt = c.getCode() - 1;
            String text = "0" + cnt;
            text = text.substring(text.length() - 2);
            this.hmSurcharge.put(c.getCoverage() + ":" + text, c.getFactor());
            this.hmSurcharge.put(c.getCoverage() + ":" + text + "Group", c.getCoverage());
        }
    }

    void loadAdditiveSurcharge() {
        this.hmSurcharge.put("AdditiveSurcharge", new String[0]);
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Components.series.province.vehicle.name.all").setParameter("client", (Object)this.client).setParameter("version", (Object)this.getSubversion(this.prov, this.veh)).setParameter("province", (Object)this.prov).setParameter("vehicle", (Object)this.veh).setParameter("series", (Object)3).setParameter("name", (Object)"AdditiveSurcharge").getResultList();
        System.out.println("Load AdditiveSurcharge: ");
        if (!resultList.isEmpty()) {
            Components c = (Components)resultList.get(0);
            this.hmSurcharge.put("AdditiveSurcharge", c.getDisplay().split(":", -99));
        }
    }

    void loadOptionalab() {
        this.hmOptionalab.clear();
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Components.series.province.vehicle.name.all").setParameter("client", (Object)this.client).setParameter("version", (Object)this.getSubversion(this.prov, this.veh)).setParameter("province", (Object)this.prov).setParameter("vehicle", (Object)this.veh).setParameter("series", (Object)3).setParameter("name", (Object)"Optionalabhelper").getResultList();
        System.out.println("Load Optionalabhelper: ");
        for (Components c : resultList) {
            if (c.getCoverage().equals("Code2")) {
                this.hmOptionalab.put(c.getDisplay(), c.getCode());
                continue;
            }
            if (c.getCoverage().equals("Code")) continue;
            this.hmOptionalab.put(c.getCoverage() + c.getCode(), c.getDisplay());
        }
    }

    void loadDiscount() {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Components.series.province.vehicle.name").setParameter("client", (Object)this.client).setParameter("version", (Object)this.getSubversion(this.prov, this.veh)).setParameter("province", (Object)this.prov).setParameter("vehicle", (Object)this.veh).setParameter("series", (Object)3).setParameter("name", (Object)"Discountopt").getResultList();
        System.out.println("load Discount: ");
        for (Components c : resultList) {
            if (!this.i2b(c.getInitread()).booleanValue()) continue;
            Combohelper ch = new Combohelper(c.getCode(), c.getDisplay(), false);
            ch.add("Premium", c.getFactor().doubleValue());
            ch.addlink("Description", c.getDescription());
            ch.addlink("Rule", c.getInitvalue());
            ch.addlink("Group", c.getLinked());
            this.hmDiscount.put(c.getDescription(), ch);
        }
    }

    void updateEndorseLimit() {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Components.series.province.vehicle.name.all").setParameter("client", (Object)this.client).setParameter("version", (Object)this.getSubversion(this.prov, this.veh)).setParameter("province", (Object)this.prov).setParameter("vehicle", (Object)this.veh).setParameter("series", (Object)3).setParameter("name", (Object)"Endorse").getResultList();
        System.out.println("updateEndorseLimit: ");
        String newLimit = this.initSplit() + " ";
        if (this.policy.getOptionalendorsetext() != null && this.policy.getOptionalendorsetext().indexOf("44R") > -1) {
            block0: for (Components c : resultList) {
                if (!this.i2b(c.getInitread()).booleanValue() || c.getDisplay().indexOf(newLimit) <= -1) continue;
                String newEndorse = c.getDescription();
                String[] arr = this.initSplit(this.policy.getOptionalendorsetext());
                for (int i = 0; i < arr.length; ++i) {
                    if (arr[i].indexOf("44R") <= -1) continue;
                    String oldEndorse = arr[i];
                    this.policy.setOptionalendorsetext(this.policy.getOptionalendorsetext().replaceAll(oldEndorse, newEndorse));
                    continue block0;
                }
            }
        }
    }

    void loadEndorse() {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Components.series.province.vehicle.name.all").setParameter("client", (Object)this.client).setParameter("version", (Object)this.getSubversion(this.prov, this.veh)).setParameter("province", (Object)this.prov).setParameter("vehicle", (Object)this.veh).setParameter("series", (Object)3).setParameter("name", (Object)"Endorse").getResultList();
        System.out.println("load Endorse: ");
        String newLimit = this.initSplit() + " ";
        String srch = "dummy";
        if (this.veh == 2) {
            srch = "PPV RG";
            Integer rgcl = this.getInteger(this.policy, "Rgcl");
            if (rgcl > 0) {
                if (rgcl < 15) {
                    srch = "PPV RG 1 to 14";
                } else if (rgcl < 21) {
                    srch = "PPV RG 15 to 20";
                } else if (rgcl < 27) {
                    srch = "PPV RG 21 to 26";
                } else if (rgcl < 33) {
                    srch = "PPV RG 27 to 32";
                } else if (rgcl < 41) {
                    srch = "PPV RG 33 to 40";
                } else if (rgcl < 46) {
                    srch = "PPV RG 41 to 45";
                }
            }
        } else {
            srch = "Commercial Class 33;35;36;43";
        }
        for (Components c : resultList) {
            if (!this.i2b(c.getInitread()).booleanValue() || c.getDescription().indexOf("44R") > -1 && c.getDisplay().indexOf(newLimit) == -1 || this.client.equals(32) && (c.getDescription().indexOf("043") > -1 && c.getDisplay().indexOf(srch) == -1 || c.getDescription().indexOf("43A") > -1 && c.getDisplay().indexOf(srch) == -1) || this.veh > -1 && (this.veh == 2 && (c.getDisplay().indexOf("COM") > -1 || c.getDisplay().indexOf("Commercial") > -1) || this.veh != 2 && c.getDisplay().indexOf("PPV") > -1)) continue;
            Combohelper ch = new Combohelper(c.getCode(), c.getDisplay(), false);
            ch.add("Premium", c.getFactor().doubleValue());
            ch.addlink("Description", c.getDescription());
            ch.addlink("Rule", c.getInitvalue());
            ch.addlink("Group", c.getLinked());
            ch.addlink("Label", c.getCoverage());
            this.hmEndorse.put(c.getDescription(), ch);
        }
    }

    void applyTrailerdiscount2(Integer in) {
        EntityManager entityManager = ((org.shop.editor.EntityService)Lookup.getDefault().lookup(org.shop.editor.EntityService.class)).getEntityManager();
        entityManager.getTransaction().begin();
        List resultList3 = entityManager.createNamedQuery("Policy.polnum").setParameter("client", (Object)this.client).setParameter("polnum", (Object)in).getResultList();
        List resultList = entityManager.createNamedQuery("Components.series.province.vehicle.name.notdisplay").setParameter("client", (Object)this.client).setParameter("version", (Object)this.getSubversion(5, 3)).setParameter("province", (Object)5).setParameter("vehicle", (Object)3).setParameter("series", (Object)3).setParameter("name", (Object)"Excess").getResultList();
        Float base = this.findFloat(resultList, 1);
        Float exc = this.findFloat(resultList, 2);
        String[] veh = new String[]{"3:4"};
        for (int m = 0; m < veh.length; ++m) {
            Float[][] dat = new Float[resultList3.size()][3];
            for (int j = 0; j < dat.length; ++j) {
                dat[j][0] = Float.valueOf(-1.0f);
            }
            Float tractor = Float.valueOf(0.0f);
            Float trailer = Float.valueOf(0.0f);
            Integer idx = 0;
            for (Policy pol : resultList3) {
                Number factorOld;
                Integer isComm;
                Float units = this.getFloat(pol, "Units");
                if (veh[m].indexOf(pol.getVehicle().toString()) > -1 && pol.getTr() != null && units.floatValue() > 0.0f) {
                    isComm = this.getInteger(pol, "Tr");
                    if (isComm == 1) {
                        tractor = Float.valueOf(tractor.floatValue() + units.floatValue());
                    } else if (isComm > 1) {
                        factorOld = pol.getTRdisc1();
                        if (factorOld == null || ((Float)factorOld).floatValue() == 0.0f) {
                            factorOld = Float.valueOf(1.0f);
                        }
                        trailer = Float.valueOf(trailer.floatValue() + units.floatValue());
                        Float criteria = Float.valueOf(this.getFloat(pol, "Bi").floatValue() + this.getFloat(pol, "Pd").floatValue() + this.getFloat(pol, "Ua").floatValue() + this.getFloat(pol, "Ua").floatValue());
                        dat[idx.intValue()][0] = Float.valueOf(criteria.floatValue() / units.floatValue() * base.floatValue() / ((Float)factorOld).floatValue());
                        dat[idx.intValue()][1] = Float.valueOf(idx.floatValue());
                        dat[idx.intValue()][2] = units;
                    }
                }
                isComm = idx;
                idx = idx + 1;
                factorOld = idx;
            }
            if (trailer.floatValue() == 0.0f) {
                return;
            }
            Arrays.sort(dat, new Comparator<Float[]>(){

                @Override
                public int compare(Float[] o1, Float[] o2) {
                    return o1[0].compareTo(o2[0]);
                }
            });
            Float excess = Float.valueOf(trailer.floatValue() - tractor.floatValue());
            for (int j = 0; j < dat.length; ++j) {
                if (dat[j][1] == null) continue;
                Policy pol = (Policy)resultList3.get(dat[j][1].intValue());
                Float taken = dat[j][2].floatValue() > excess.floatValue() ? excess : dat[j][2];
                excess = Float.valueOf(excess.floatValue() - taken.floatValue());
                Float remainder = Float.valueOf(dat[j][2].floatValue() - taken.floatValue());
                Float factorNew = Float.valueOf((taken.floatValue() * exc.floatValue() + remainder.floatValue() * base.floatValue()) / dat[j][2].floatValue());
                Float factorOld = pol.getTRdisc1();
                if (factorOld == null || factorOld.floatValue() == 0.0f) {
                    factorOld = Float.valueOf(1.0f);
                }
                pol.setTRdisc1(factorNew);
                pol.setBi(Float.valueOf(pol.getBi() == null ? 0.0f : 1.0f * (float)Math.round(pol.getBi().floatValue() * factorNew.floatValue() / factorOld.floatValue())));
                pol.setTp(Float.valueOf(pol.getTp() == null ? 0.0f : 1.0f * (float)Math.round(pol.getTp().floatValue() * factorNew.floatValue() / factorOld.floatValue())));
                pol.setPd(Float.valueOf(pol.getPd() == null ? 0.0f : 1.0f * (float)Math.round(pol.getPd().floatValue() * factorNew.floatValue() / factorOld.floatValue())));
                pol.setUa(Float.valueOf(pol.getUa() == null ? 0.0f : 1.0f * (float)Math.round(pol.getUa().floatValue() * factorNew.floatValue() / factorOld.floatValue())));
                Float total = Float.valueOf(0.0f);
                for (int i = 0; i < this.cov.length; ++i) {
                    if (this.cov[i].equals("UM")) continue;
                    total = Float.valueOf(total.floatValue() + this.getFloat(pol, this.cov[i]).floatValue());
                }
                pol.setTt2(total);
                this.additionalPremium(pol, this.addCol);
                entityManager.merge((Object)pol);
            }
            entityManager.getTransaction().commit();
        }
    }

    public Float findFloat(List<Components> resultList, int in) {
        Double found = 1.0;
        for (Components pol : resultList) {
            if (!pol.getCoverage().equals("TP") || !pol.getCode().equals(in)) continue;
            found = pol.getFactor().doubleValue();
            break;
        }
        return Float.valueOf(found.floatValue());
    }

    void applyTrailerdiscount(Integer in) {
        if (this.client.equals(32)) {
            this.applyTrailerdiscount2(in);
            return;
        }
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        entityManager.getTransaction().begin();
        List resultList3 = entityManager.createNamedQuery("Policy.polnum").setParameter("client", (Object)this.client).setParameter("polnum", (Object)in).getResultList();
        Boolean flag = true;
        String[] veh = new String[]{"3:4", "9:10"};
        for (int m = 0; m < veh.length; ++m) {
            Float[][] factor = null;
            for (Policy pol : resultList3) {
                Float factorOld;
                Float factorNew;
                if (veh[m].indexOf(pol.getVehicle().toString()) <= -1 || pol.getTr() == null || pol.getTr() == 1) continue;
                if (flag.booleanValue()) {
                    factor = this.getTrailerdiscount();
                }
                if (this.client.equals(32)) {
                    factorNew = factor[pol.getProvince()][0];
                    factorOld = pol.getTRdisc1();
                    if (factorOld == null || factorOld.floatValue() == 0.0f) {
                        factorOld = Float.valueOf(1.0f);
                    }
                    pol.setTRdisc1(factorNew);
                    pol.setBi(Float.valueOf(pol.getBi() == null ? 0.0f : pol.getBi().floatValue() * factorNew.floatValue() / factorOld.floatValue()));
                    pol.setTp(Float.valueOf(pol.getTp() == null ? 0.0f : pol.getTp().floatValue() * factorNew.floatValue() / factorOld.floatValue()));
                    pol.setPd(Float.valueOf(pol.getPd() == null ? 0.0f : pol.getPd().floatValue() * factorNew.floatValue() / factorOld.floatValue()));
                    pol.setUa(Float.valueOf(pol.getUa() == null ? 0.0f : pol.getUa().floatValue() * factorNew.floatValue() / factorOld.floatValue()));
                } else {
                    flag = false;
                    factorNew = factor[pol.getProvince()][0];
                    factorOld = pol.getTRdisc1();
                    if (factorOld == null || factorOld.floatValue() == 0.0f) {
                        factorOld = Float.valueOf(1.0f);
                    }
                    pol.setTRdisc1(factorNew);
                    pol.setBi(Float.valueOf(pol.getBi() == null ? 0.0f : pol.getBi().floatValue() * factorNew.floatValue() / factorOld.floatValue()));
                    pol.setTp(Float.valueOf(pol.getTp() == null ? 0.0f : pol.getTp().floatValue() * factorNew.floatValue() / factorOld.floatValue()));
                    factorNew = factor[pol.getProvince()][1];
                    factorOld = pol.getTRdisc2();
                    if (factorOld == null || factorOld.floatValue() == 0.0f) {
                        factorOld = Float.valueOf(1.0f);
                    }
                    pol.setTRdisc2(factorNew);
                    pol.setAb(Float.valueOf(pol.getAb() == null ? 0.0f : pol.getAb().floatValue() * factorNew.floatValue() / factorOld.floatValue()));
                }
                Float total = Float.valueOf(0.0f);
                for (int i = 0; i < this.cov.length; ++i) {
                    if (this.cov[i].equals("UM")) continue;
                    total = Float.valueOf(total.floatValue() + this.getFloat(pol, this.cov[i]).floatValue());
                }
                pol.setTt2(Float.valueOf(total.floatValue()));
                this.additionalPremium(pol, this.addCol);
                entityManager.merge((Object)pol);
            }
        }
        entityManager.getTransaction().commit();
    }

    Float[][] getTrailerdiscount() {
        Object[] columnNames = new String[]{"Item    ", "AB", "NB", "NF", "NS", "ON", "PE", "PQ", "YK", "ALT", "WEST", "EAST", "ALL", "BC", "MB", "SK"};
        Object[][] data = new Object[][]{{"Tractor ", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, {"Trailer ", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, {"Percent ", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, {"TP", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, {"AB", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, {"TPbase", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, {"TPexcess", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, {"ABbase", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, {"ABexcess", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, {"Item    ", "AB", "NB", "NF", "NS", "ON", "PE", "PQ", "YK", "ALT", "WEST", "EAST", "ALL", "BC", "MB", "SK"}};
        DefaultTableModel table = new DefaultTableModel(data, columnNames);
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList1 = entityManager.createNamedQuery("Components.findnameany").setParameter("client", (Object)this.client).setParameter("version", (Object)this.version).setParameter("name", (Object)"Excess").getResultList();
        for (Components comp : resultList1) {
            if (!comp.getVehicle().equals(this.veh)) continue;
            Integer ro2 = comp.getCode();
            Integer co = comp.getProvince();
            if (comp.getCoverage().equals("TP")) {
                table.setValueAt(comp.getFactor(), 4 + ro2, co);
                continue;
            }
            if (!comp.getCoverage().equals("AB")) continue;
            table.setValueAt(comp.getFactor(), 6 + ro2, co);
        }
        List arr1 = entityManager.createNamedQuery("Policy.trailerdiscount").setParameter("client", (Object)this.client).setParameter("polnum", (Object)this.polnum).getResultList();
        for (Object[] object : arr1) {
            if (this.oli(object[3]) == 1) {
                table.setValueAt(this.odf(object[0]), 0, this.oi(object[2]));
                continue;
            }
            if (this.oli(object[3]) <= 1) continue;
            table.setValueAt(this.odf(object[0]), 1, this.oi(object[2]));
        }
        Float[][] arr = new Float[columnNames.length][2];
        for (int i = 1; i < columnNames.length; ++i) {
            Float tractor = (Float)table.getValueAt(0, i);
            Float trailer = (Float)table.getValueAt(1, i);
            Float TPbase = (Float)table.getValueAt(5, i);
            Float TPexcess = (Float)table.getValueAt(6, i);
            Float ABbase = (Float)table.getValueAt(7, i);
            Float ABexcess = (Float)table.getValueAt(8, i);
            Float factor = Float.valueOf(0.0f);
            if (trailer.floatValue() != 0.0f && trailer.floatValue() > tractor.floatValue() && tractor.floatValue() >= 0.0f) {
                factor = Float.valueOf((trailer.floatValue() - tractor.floatValue()) / trailer.floatValue());
            }
            table.setValueAt(factor, 2, i);
            arr[i][0] = Float.valueOf((1.0f - factor.floatValue()) * TPbase.floatValue() + factor.floatValue() * TPexcess.floatValue());
            arr[i][1] = Float.valueOf((1.0f - factor.floatValue()) * ABbase.floatValue() + factor.floatValue() * ABexcess.floatValue());
            table.setValueAt(arr[i][0], 3, i);
            table.setValueAt(arr[i][1], 4, i);
        }
        JTable tab = new JTable();
        tab.setModel(table);
        this.printDebugData(tab);
        return arr;
    }

    private void printDebugData(JTable table) {
        int numRows = table.getRowCount();
        int numCols = table.getColumnCount();
        TableModel model = table.getModel();
        System.out.println("Value of data: ");
        for (int i = 0; i < numRows; ++i) {
            System.out.print("    row " + i + ":");
            for (int j = 0; j < numCols; ++j) {
                System.out.print("  " + model.getValueAt(i, j));
            }
            System.out.println();
        }
        System.out.println("--------------------------");
    }

    Float odf(Object obj) {
        return Float.valueOf(obj == null ? 0.0f : ((Double)obj).floatValue());
    }

    Integer oli(Object obj) {
        return obj == null ? 0 : ((Long)obj).intValue();
    }

    Float getFloat(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Float in = Float.valueOf(0.0f);
        try {
            in = (Float)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Float.valueOf(in == null ? 0.0f : in.floatValue());
    }

    Integer getInteger(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Integer in = 0;
        try {
            in = (Integer)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? 0 : in;
    }

    String getString(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        String in = "";
        try {
            in = (String)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? "" : in;
    }

    Integer oi(Object obj) {
        return obj == null ? 0 : (Integer)obj;
    }

    String os(Object obj) {
        return obj == null ? "" : (String)obj;
    }

    Integer b2i(Boolean b) {
        return b != false ? 1 : 0;
    }

    Boolean i2b(Integer i) {
        return i == null ? false : i == 1;
    }

    public Integer findGroup(String[][] arr, Integer in) {
        Integer found = -1;
        for (int i = 0; i < arr.length; ++i) {
            if (!in.equals(Integer.parseInt(arr[i][1]))) continue;
            found = Integer.parseInt(arr[i][2]);
            break;
        }
        return found;
    }

    void setFloat(Object obj, String name, Float in) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        try {
            obj.getClass().getMethod("set" + p1 + p2, Float.class).invoke(obj, in);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void setInteger(Object obj, String name, Integer in) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        try {
            obj.getClass().getMethod("set" + p1 + p2, Integer.class).invoke(obj, in);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void setString(Object obj, String name, String in) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        try {
            obj.getClass().getMethod("set" + p1 + p2, String.class).invoke(obj, in);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    Class getObjectClass(String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Class<?> in = null;
        Policy pol = new Policy();
        try {
            in = pol.getClass().getMethod("get" + p1 + p2, new Class[0]).getReturnType();
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in;
    }
}

