/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui;

import com.sun.deploy.uitoolkit.impl.fx.ui.FXDialog;
import com.sun.deploy.uitoolkit.impl.fx.ui.resources.ResourceManager;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class FXAboutDialog {
    static void showAboutJavaDialog() {
        final FXDialog dialog = new FXDialog(ResourceManager.getMessage("dialogfactory.aboutDialogTitle"));
        dialog.setResizable(false);
        VBox outerVBox = new VBox();
        VBox topPanel = new VBox();
        topPanel.setId("about-dialog-top-panel");
        outerVBox.getChildren().add(topPanel);
        String javaVersion = System.getProperty("java.version");
        int firstDot = javaVersion.indexOf(".");
        String marketingVersion = javaVersion.substring(firstDot + 1, javaVersion.indexOf(".", firstDot + 1));
        ImageView headerImageView = ResourceManager.getIcon("about.java" + ("6".equals(marketingVersion) ? "6" : "") + ".image");
        topPanel.getChildren().add(headerImageView);
        VBox centerPanel = new VBox();
        centerPanel.setId("about-dialog-center-panel");
        topPanel.getChildren().add(centerPanel);
        StringBuilder textAreaText = new StringBuilder();
        textAreaText.append(FXAboutDialog.getVersionStr());
        textAreaText.append("\n");
        textAreaText.append(ResourceManager.getMessage("about.copyright"));
        textAreaText.append("\n \n");
        textAreaText.append(ResourceManager.getMessage("about.prompt.info"));
        Label textArea = new Label();
        textArea.setWrapText(true);
        textArea.setText(textAreaText.toString());
        textArea.setPrefWidth(headerImageView.prefWidth(-1.0) - 16.0);
        textArea.setMinWidth(Double.NEGATIVE_INFINITY);
        centerPanel.getChildren().add(textArea);
        final String linkURL = ResourceManager.getMessage("about.home.link");
        Hyperlink link = new Hyperlink(linkURL);
        link.setOnAction(new EventHandler(){

            public void handle(Event event) {
                FXAboutDialog.browserToUrl(linkURL);
            }
        });
        centerPanel.getChildren().add(link);
        ImageView logoImageView = ResourceManager.getIcon("sun.logo.image");
        centerPanel.getChildren().add(logoImageView);
        StackPane buttonBar = new StackPane();
        buttonBar.getStyleClass().add("button-bar");
        buttonBar.setId("about-dialog-button-bar");
        outerVBox.getChildren().add(buttonBar);
        Button closeButton = new Button(ResourceManager.getMessage("about.option.close"));
        closeButton.setDefaultButton(true);
        closeButton.setOnAction(new EventHandler(){

            public void handle(Event event) {
                dialog.close();
            }
        });
        closeButton.setAlignment(Pos.TOP_LEFT);
        buttonBar.getChildren().add(closeButton);
        dialog.setContentPane(outerVBox);
        dialog.show();
        closeButton.requestFocus();
    }

    private static void browserToUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getVersionStr() {
        int dashIdx;
        String javaVersion = System.getProperty("java.version");
        int firstDot = javaVersion.indexOf(".");
        String marketingVersion = javaVersion.substring(firstDot + 1, javaVersion.indexOf(".", firstDot + 1));
        int pos = javaVersion.lastIndexOf("_");
        String updateVersion = null;
        if (pos != -1 && (updateVersion = (dashIdx = javaVersion.indexOf("-")) != -1 ? javaVersion.substring(pos + 1, dashIdx) : javaVersion.substring(pos + 1, javaVersion.length())).startsWith("0")) {
            updateVersion = updateVersion.substring(1);
        }
        String version = null;
        version = updateVersion != null ? MessageFormat.format(ResourceManager.getMessage("about.java.version.update"), marketingVersion, updateVersion) : MessageFormat.format(ResourceManager.getMessage("about.java.version"), marketingVersion);
        String buildInfo = MessageFormat.format(ResourceManager.getMessage("about.java.build"), System.getProperty("java.runtime.version"));
        return version + " " + buildInfo;
    }
}

