/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.StyleConverter;
import javafx.geometry.Insets;
import javafx.scene.text.Font;

public final class InsetsConverter
extends StyleConverter<ParsedValue<?, Size>[], Insets> {
    public static InsetsConverter getInstance() {
        return Holder.INSTANCE;
    }

    private InsetsConverter() {
    }

    @Override
    public Insets convert(ParsedValue<ParsedValue<?, Size>[], Insets> parsedValue, Font font) {
        ParsedValue<?, Size>[] parsedValueArray = parsedValue.getValue();
        double d = parsedValueArray[0].convert(font).pixels(font);
        double d2 = parsedValueArray.length > 1 ? parsedValueArray[1].convert(font).pixels(font) : d;
        double d3 = parsedValueArray.length > 2 ? parsedValueArray[2].convert(font).pixels(font) : d;
        double d4 = parsedValueArray.length > 3 ? parsedValueArray[3].convert(font).pixels(font) : d2;
        return new Insets(d, d2, d3, d4);
    }

    public String toString() {
        return "InsetsConverter";
    }

    private static class Holder {
        static InsetsConverter INSTANCE = new InsetsConverter();
        static SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }

    public static final class SequenceConverter
    extends StyleConverter<ParsedValue<ParsedValue<?, Size>[], Insets>[], Insets[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public Insets[] convert(ParsedValue<ParsedValue<ParsedValue<?, Size>[], Insets>[], Insets[]> parsedValue, Font font) {
            ParsedValue<ParsedValue<?, Size>[], Insets>[] parsedValueArray = parsedValue.getValue();
            Insets[] insetsArray = new Insets[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                insetsArray[i] = InsetsConverter.getInstance().convert((ParsedValue)parsedValueArray[i], font);
            }
            return insetsArray;
        }

        public String toString() {
            return "InsetsSequenceConverter";
        }
    }
}

