/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.AudioClip;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.NativeMediaAudioClipPlayer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicInteger;

public final class NativeMediaAudioClip
extends AudioClip {
    private static final int CACHE_SIZE_LIMIT = 0x3200000;
    private URI sourceURI;
    private Locator mediaLocator;
    private AtomicInteger playCount;

    private NativeMediaAudioClip(URI source) throws URISyntaxException, FileNotFoundException, IOException {
        this.sourceURI = source;
        this.playCount = new AtomicInteger(0);
        if (Logger.canLog(1)) {
            Logger.logMsg(1, "Creating AudioClip for URI " + source);
        }
        this.mediaLocator = new Locator(this.sourceURI);
        this.mediaLocator.init();
        this.mediaLocator.cacheMedia(0x3200000);
    }

    Locator getLocator() {
        return this.mediaLocator;
    }

    public static AudioClip load(URI source) throws URISyntaxException, FileNotFoundException, IOException {
        return new NativeMediaAudioClip(source);
    }

    public static AudioClip create(byte[] data, int dataOffset, int sampleCount, int sampleFormat, int channels, int sampleRate) {
        throw new UnsupportedOperationException("NativeMediaAudioClip does not support creating clips from raw sample data");
    }

    public AudioClip createSegment(double startTime, double stopTime) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AudioClip createSegment(int startSample, int endSample) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AudioClip resample(int startSample, int endSample, int newSampleRate) throws IllegalArgumentException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AudioClip append(AudioClip clip) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AudioClip flatten() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isPlaying() {
        return this.playCount.get() > 0;
    }

    public void play() {
        this.play(this.clipVolume, this.clipBalance, this.clipRate, this.clipPan, this.loopCount, this.clipPriority);
    }

    public void play(double volume) {
        this.play(volume, this.clipBalance, this.clipRate, this.clipPan, this.loopCount, this.clipPriority);
    }

    public void play(double volume, double balance, double rate, double pan, int loopCount, int priority) {
        this.playCount.getAndIncrement();
        NativeMediaAudioClipPlayer.playClip(this, volume, balance, rate, pan, loopCount, priority);
    }

    public void stop() {
        NativeMediaAudioClipPlayer.stopPlayers(this.mediaLocator);
    }

    public static void stopAllClips() {
        NativeMediaAudioClipPlayer.stopPlayers(null);
    }

    void playFinished() {
        this.playCount.decrementAndGet();
    }
}

