/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.prism;

import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.paint.Color;
import com.sun.webpane.platform.graphics.WCGraphicsContext;
import com.sun.webpane.platform.graphics.WCGraphicsManager;
import com.sun.webpane.platform.graphics.WCPageBackBuffer;
import com.sun.webpane.sg.prism.PrismImage;

public class WCPageBackBufferImpl
extends WCPageBackBuffer
implements ResourceFactoryListener {
    private RTTexture texture;
    private boolean listenerAdded = false;

    private RTTexture createTexture(int n, int n2) {
        RTTexture rTTexture = GraphicsPipeline.getDefaultResourceFactory().createRTTexture(n, n2);
        rTTexture.createGraphics().clear(Color.WHITE);
        return rTTexture;
    }

    @Override
    public WCGraphicsContext createGraphics() {
        return WCGraphicsManager.getGraphicsManager().createGraphicsContext(this.texture.createGraphics());
    }

    @Override
    public void disposeGraphics(WCGraphicsContext wCGraphicsContext) {
        wCGraphicsContext.dispose();
    }

    @Override
    public void flush(final WCGraphicsContext wCGraphicsContext, int n, int n2, final int n3, final int n4) {
        PrismImage prismImage = new PrismImage(){

            @Override
            public int getWidth() {
                return n3;
            }

            @Override
            public int getHeight() {
                return n4;
            }

            @Override
            public Graphics getGraphics() {
                return (Graphics)wCGraphicsContext.getPlatformGraphics();
            }

            @Override
            public Image getImage() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void draw(Graphics graphics, int n, int n2, int n32, int n42, int n5, int n6, int n7, int n8) {
                graphics.drawTexture(WCPageBackBufferImpl.this.texture, n, n2, n32, n42, n5, n6, n7, n8);
            }

            @Override
            public void dispose() {
                throw new UnsupportedOperationException();
            }
        };
        wCGraphicsContext.drawImage(prismImage, n, n2, n3, n4, n, n2, n3, n4);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        RTTexture rTTexture = this.createTexture(n3, n4);
        rTTexture.createGraphics().drawTexture(this.texture, 0.0f, 0.0f, n3, n4, n, n2, n + n3, n2 + n4);
        this.texture.createGraphics().drawTexture(rTTexture, n + n5, n2 + n6, n + n3 + n5, n2 + n4 + n6, 0.0f, 0.0f, n3, n4);
        rTTexture.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validate(int n, int n2) {
        if (this.texture == null) {
            this.texture = this.createTexture(n, n2);
            if (this.listenerAdded) return false;
            GraphicsPipeline.getDefaultResourceFactory().addFactoryListener(this);
            this.listenerAdded = true;
            return true;
        } else {
            int n3 = this.texture.getContentWidth();
            int n4 = this.texture.getContentHeight();
            if (n3 == n && n4 == n2) return true;
            RTTexture rTTexture = this.createTexture(n, n2);
            rTTexture.createGraphics().drawTexture(this.texture, 0.0f, 0.0f, Math.min(n, n3), Math.min(n2, n4));
            this.texture.dispose();
            this.texture = rTTexture;
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return this.texture != null || !this.listenerAdded;
    }

    @Override
    public void factoryReset() {
        if (this.texture != null) {
            this.texture.dispose();
            this.texture = null;
        }
    }

    @Override
    public void factoryReleased() {
    }
}

