/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.silentupdate;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class OutputLogger {
    private static final Logger LOGGER = Logger.getLogger(OutputLogger.class.getPackage().getName());
    private static Grain grain;
    private static final String OUTPUT_LOGGER_NAME;
    private static InputOutput io;
    private static final Grain DEFAULT;

    private static Grain grain() {
        if (grain == null) {
            String s = NbBundle.getBundle((String)"org.netbeans.modules.autoupdate.silentupdate.resources.Bundle").getString("OutputLogger.Grain");
            grain = DEFAULT;
            try {
                grain = Grain.valueOf(s);
            }
            catch (IllegalArgumentException x) {
                LOGGER.info(s);
            }
        }
        return grain;
    }

    public static void log(String msg, Throwable ... x) {
        OutputLogger.log(Level.INFO, msg, x);
    }

    public static void log(Level l, String msg, Throwable ... x) {
        switch (OutputLogger.grain()) {
            case VERBOSE: {
                if (x == null) {
                    LOGGER.log(Level.INFO, msg);
                    break;
                }
                LOGGER.log(Level.INFO, msg);
                for (Throwable t : x) {
                    LOGGER.log(Level.INFO, msg, t);
                }
                break;
            }
            case WINDOW: {
                try {
                    InputOutput output = OutputLogger.getIO();
                    if (x == null) {
                        output.getOut().println(msg);
                        output.getOut().close();
                    } else {
                        output.getErr().println(msg);
                        for (Throwable t : x) {
                            output.getErr().println((Object)t);
                        }
                        output.getErr().close();
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
            case LOG: {
                if (!LOGGER.isLoggable(l)) break;
                if (x == null) {
                    LOGGER.log(l, msg);
                    break;
                }
                LOGGER.log(l, msg);
                for (Throwable t : x) {
                    LOGGER.log(l, msg, t);
                }
                break;
            }
            case SILENT: {
                if (x == null) {
                    LOGGER.log(Level.FINEST, msg);
                    break;
                }
                LOGGER.log(Level.FINEST, msg);
                for (Throwable t : x) {
                    LOGGER.log(Level.FINEST, msg, t);
                }
                break;
            }
            default: {
                assert (false) : "Unkown grain " + (Object)((Object)OutputLogger.grain());
                break;
            }
        }
    }

    private static synchronized InputOutput getIO() {
        if (io == null) {
            io = IOProvider.getDefault().getIO(OUTPUT_LOGGER_NAME, true);
        }
        return io;
    }

    static {
        OUTPUT_LOGGER_NAME = NbBundle.getMessage(OutputLogger.class, (String)"OutputLoggerWindow.Name");
        DEFAULT = Grain.LOG;
    }

    private static enum Grain {
        VERBOSE,
        WINDOW,
        LOG,
        SILENT;

    }
}

