/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.invoke.CallSite;
import java.lang.invoke.Invokers;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.sql.DriverManager;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Logger;
import javax.sql.rowset.serial.SerialJavaObject;
import sun.misc.Unsafe;
import sun.reflect.Reflection;

class MethodHandleNatives {
    static final boolean COUNT_GWT;
    private static String[] REFERENCE_KIND_NAME;

    private MethodHandleNatives() {
    }

    static native void init(MemberName var0, Object var1);

    static native void expand(MemberName var0);

    static native MemberName resolve(MemberName var0, Class<?> var1) throws LinkageError;

    static native int getMembers(Class<?> var0, String var1, String var2, int var3, Class<?> var4, int var5, MemberName[] var6);

    static native long objectFieldOffset(MemberName var0);

    static native long staticFieldOffset(MemberName var0);

    static native Object staticFieldBase(MemberName var0);

    static native Object getMemberVMInfo(MemberName var0);

    static native int getConstant(int var0);

    static native void setCallSiteTargetNormal(CallSite var0, MethodHandle var1);

    static native void setCallSiteTargetVolatile(CallSite var0, MethodHandle var1);

    private static native void registerNatives();

    static boolean refKindIsValid(int n) {
        return n > 0 && n < 10;
    }

    static boolean refKindIsField(byte by) {
        assert (MethodHandleNatives.refKindIsValid(by));
        return by <= 4;
    }

    static boolean refKindIsGetter(byte by) {
        assert (MethodHandleNatives.refKindIsValid(by));
        return by <= 2;
    }

    static boolean refKindIsSetter(byte by) {
        return MethodHandleNatives.refKindIsField(by) && !MethodHandleNatives.refKindIsGetter(by);
    }

    static boolean refKindIsMethod(byte by) {
        return !MethodHandleNatives.refKindIsField(by) && by != 8;
    }

    static boolean refKindHasReceiver(byte by) {
        assert (MethodHandleNatives.refKindIsValid(by));
        return (by & 1) != 0;
    }

    static boolean refKindIsStatic(byte by) {
        return !MethodHandleNatives.refKindHasReceiver(by) && by != 8;
    }

    static boolean refKindDoesDispatch(byte by) {
        assert (MethodHandleNatives.refKindIsValid(by));
        return by == 5 || by == 9;
    }

    static String refKindName(byte by) {
        assert (MethodHandleNatives.refKindIsValid(by));
        return REFERENCE_KIND_NAME[by];
    }

    private static native int getNamedCon(int var0, Object[] var1);

    static boolean verifyConstants() {
        Object[] objectArray = new Object[]{null};
        int n = 0;
        while (true) {
            block4: {
                objectArray[0] = null;
                int n2 = MethodHandleNatives.getNamedCon(n, objectArray);
                if (objectArray[0] == null) break;
                String string = (String)objectArray[0];
                try {
                    Field field = Constants.class.getDeclaredField(string);
                    int n3 = field.getInt(null);
                    if (n3 == n2) break block4;
                    String string2 = string + ": JVM has " + n2 + " while Java has " + n3;
                    if (string.equals("CONV_OP_LIMIT")) {
                        System.err.println("warning: " + string2);
                        break block4;
                    }
                    throw new InternalError(string2);
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    String string3 = string + ": JVM has " + n2 + " which Java does not define";
                }
            }
            ++n;
        }
        return true;
    }

    static MemberName linkCallSite(Object object, Object object2, Object object3, Object object4, Object object5, Object[] objectArray) {
        MethodHandle methodHandle = (MethodHandle)object2;
        Class clazz = (Class)object;
        String string = object3.toString().intern();
        MethodType methodType = (MethodType)object4;
        objectArray[0] = CallSite.makeSite(methodHandle, string, methodType, object5, clazz);
        return Invokers.linkToCallSiteMethod(methodType);
    }

    static MethodType findMethodHandleType(Class<?> clazz, Class<?>[] classArray) {
        return MethodType.makeImpl(clazz, classArray, true);
    }

    static MemberName linkMethod(Class<?> clazz, int n, Class<?> clazz2, String string, Object object, Object[] objectArray) {
        if (!MethodHandleStatics.TRACE_METHOD_LINKAGE) {
            return MethodHandleNatives.linkMethodImpl(clazz, n, clazz2, string, object, objectArray);
        }
        return MethodHandleNatives.linkMethodTracing(clazz, n, clazz2, string, object, objectArray);
    }

    static MemberName linkMethodImpl(Class<?> clazz, int n, Class<?> clazz2, String string, Object object, Object[] objectArray) {
        try {
            if (clazz2 == MethodHandle.class && n == 5) {
                switch (string) {
                    case "invoke": {
                        return Invokers.genericInvokerMethod(MethodHandleNatives.fixMethodType(clazz, object), objectArray);
                    }
                    case "invokeExact": {
                        return Invokers.exactInvokerMethod(MethodHandleNatives.fixMethodType(clazz, object), objectArray);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof LinkageError) {
                throw (LinkageError)throwable;
            }
            throw new LinkageError(throwable.getMessage(), throwable);
        }
        throw new LinkageError("no such method " + clazz2.getName() + "." + string + object);
    }

    private static MethodType fixMethodType(Class<?> clazz, Object object) {
        if (object instanceof MethodType) {
            return (MethodType)object;
        }
        return MethodType.fromMethodDescriptorString((String)object, clazz.getClassLoader());
    }

    static MemberName linkMethodTracing(Class<?> clazz, int n, Class<?> clazz2, String string, Object object, Object[] objectArray) {
        System.out.println("linkMethod " + clazz2.getName() + "." + string + object + "/" + Integer.toHexString(n));
        try {
            MemberName memberName = MethodHandleNatives.linkMethodImpl(clazz, n, clazz2, string, object, objectArray);
            System.out.println("linkMethod => " + memberName + " + " + objectArray[0]);
            return memberName;
        }
        catch (Throwable throwable) {
            System.out.println("linkMethod => throw " + throwable);
            throw throwable;
        }
    }

    static MethodHandle linkMethodHandleConstant(Class<?> clazz, int n, Class<?> clazz2, String string, Object object) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP.in(clazz);
            assert (MethodHandleNatives.refKindIsValid(n));
            return lookup.linkMethodHandleConstant((byte)n, clazz2, string, object);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            IncompatibleClassChangeError incompatibleClassChangeError = new IncompatibleClassChangeError();
            incompatibleClassChangeError.initCause(reflectiveOperationException);
            throw incompatibleClassChangeError;
        }
    }

    static boolean isCallerSensitive(MemberName memberName) {
        if (!memberName.isMethod()) {
            return false;
        }
        return MethodHandleNatives.isCallerSensitiveMethod(memberName.getDeclaringClass(), memberName.getName()) || MethodHandleNatives.canBeCalledVirtual(memberName);
    }

    private static boolean isCallerSensitiveMethod(Class<?> clazz, String string) {
        switch (string) {
            case "doPrivileged": 
            case "doPrivilegedWithCombiner": {
                return clazz == AccessController.class;
            }
            case "checkMemberAccess": {
                return clazz == SecurityManager.class;
            }
            case "getUnsafe": {
                return clazz == Unsafe.class;
            }
            case "lookup": {
                return clazz == MethodHandles.class;
            }
            case "invoke": {
                return clazz == Method.class;
            }
            case "get": 
            case "getBoolean": 
            case "getByte": 
            case "getChar": 
            case "getShort": 
            case "getInt": 
            case "getLong": 
            case "getFloat": 
            case "getDouble": 
            case "set": 
            case "setBoolean": 
            case "setByte": 
            case "setChar": 
            case "setShort": 
            case "setInt": 
            case "setLong": 
            case "setFloat": 
            case "setDouble": {
                return clazz == Field.class;
            }
            case "newInstance": {
                if (clazz == Constructor.class) {
                    return true;
                }
                if (clazz != Class.class) break;
                return true;
            }
            case "getFields": {
                return clazz == Class.class || clazz == SerialJavaObject.class;
            }
            case "forName": 
            case "getClassLoader": 
            case "getClasses": 
            case "getMethods": 
            case "getConstructors": 
            case "getDeclaredClasses": 
            case "getDeclaredFields": 
            case "getDeclaredMethods": 
            case "getDeclaredConstructors": 
            case "getField": 
            case "getMethod": 
            case "getConstructor": 
            case "getDeclaredField": 
            case "getDeclaredMethod": 
            case "getDeclaredConstructor": 
            case "getDeclaringClass": 
            case "getEnclosingClass": 
            case "getEnclosingMethod": 
            case "getEnclosingConstructor": {
                return clazz == Class.class;
            }
            case "getConnection": 
            case "getDriver": 
            case "getDrivers": 
            case "deregisterDriver": {
                return clazz == DriverManager.class;
            }
            case "newUpdater": {
                if (clazz == AtomicIntegerFieldUpdater.class) {
                    return true;
                }
                if (clazz == AtomicLongFieldUpdater.class) {
                    return true;
                }
                if (clazz != AtomicReferenceFieldUpdater.class) break;
                return true;
            }
            case "getContextClassLoader": {
                return clazz == Thread.class;
            }
            case "getPackage": 
            case "getPackages": {
                return clazz == Package.class;
            }
            case "getParent": 
            case "getSystemClassLoader": {
                return clazz == ClassLoader.class;
            }
            case "load": 
            case "loadLibrary": {
                if (clazz == Runtime.class) {
                    return true;
                }
                if (clazz != System.class) break;
                return true;
            }
            case "getCallerClass": {
                if (clazz == Reflection.class) {
                    return true;
                }
                if (clazz != System.class) break;
                return true;
            }
            case "getCallerClassLoader": {
                return clazz == ClassLoader.class;
            }
            case "registerAsParallelCapable": {
                return clazz == ClassLoader.class;
            }
            case "getInvocationHandler": 
            case "getProxyClass": 
            case "newProxyInstance": {
                return clazz == Proxy.class;
            }
            case "asInterfaceInstance": {
                return clazz == MethodHandleProxies.class;
            }
            case "getBundle": 
            case "clearCache": {
                return clazz == ResourceBundle.class;
            }
            case "getType": {
                return clazz == ObjectStreamField.class;
            }
            case "forClass": {
                return clazz == ObjectStreamClass.class;
            }
            case "getLogger": {
                return clazz == Logger.class;
            }
            case "getAnonymousLogger": {
                return clazz == Logger.class;
            }
        }
        return false;
    }

    private static boolean canBeCalledVirtual(MemberName memberName) {
        assert (memberName.isInvocable());
        Class<?> clazz = memberName.getDeclaringClass();
        switch (memberName.getName()) {
            case "checkMemberAccess": {
                return MethodHandleNatives.canBeCalledVirtual(memberName, SecurityManager.class);
            }
            case "getContextClassLoader": {
                return MethodHandleNatives.canBeCalledVirtual(memberName, Thread.class);
            }
        }
        return false;
    }

    static boolean canBeCalledVirtual(MemberName memberName, Class<?> clazz) {
        Class<?> clazz2 = memberName.getDeclaringClass();
        if (clazz2 == clazz) {
            return true;
        }
        if (memberName.isStatic() || memberName.isPrivate()) {
            return false;
        }
        return clazz.isAssignableFrom(clazz2) || clazz2.isInterface();
    }

    static {
        MethodHandleNatives.registerNatives();
        COUNT_GWT = MethodHandleNatives.getConstant(4) != 0;
        MethodHandleImpl.initStatics();
        for (byte by = 1; by < 10; by = (byte)(by + 1)) {
            assert (MethodHandleNatives.refKindHasReceiver(by) == ((1 << by & 0x2AA) != 0)) : by;
        }
        REFERENCE_KIND_NAME = new String[]{null, "getField", "getStatic", "putField", "putStatic", "invokeVirtual", "invokeStatic", "invokeSpecial", "newInvokeSpecial", "invokeInterface"};
        assert (MethodHandleNatives.verifyConstants());
    }

    static class Constants {
        static final int GC_COUNT_GWT = 4;
        static final int GC_LAMBDA_SUPPORT = 5;
        static final int MN_IS_METHOD = 65536;
        static final int MN_IS_CONSTRUCTOR = 131072;
        static final int MN_IS_FIELD = 262144;
        static final int MN_IS_TYPE = 524288;
        static final int MN_CALLER_SENSITIVE = 0x100000;
        static final int MN_REFERENCE_KIND_SHIFT = 24;
        static final int MN_REFERENCE_KIND_MASK = 15;
        static final int MN_SEARCH_SUPERCLASSES = 0x100000;
        static final int MN_SEARCH_INTERFACES = 0x200000;
        static final int T_BOOLEAN = 4;
        static final int T_CHAR = 5;
        static final int T_FLOAT = 6;
        static final int T_DOUBLE = 7;
        static final int T_BYTE = 8;
        static final int T_SHORT = 9;
        static final int T_INT = 10;
        static final int T_LONG = 11;
        static final int T_OBJECT = 12;
        static final int T_VOID = 14;
        static final int T_ILLEGAL = 99;
        static final byte CONSTANT_Utf8 = 1;
        static final byte CONSTANT_Integer = 3;
        static final byte CONSTANT_Float = 4;
        static final byte CONSTANT_Long = 5;
        static final byte CONSTANT_Double = 6;
        static final byte CONSTANT_Class = 7;
        static final byte CONSTANT_String = 8;
        static final byte CONSTANT_Fieldref = 9;
        static final byte CONSTANT_Methodref = 10;
        static final byte CONSTANT_InterfaceMethodref = 11;
        static final byte CONSTANT_NameAndType = 12;
        static final byte CONSTANT_MethodHandle = 15;
        static final byte CONSTANT_MethodType = 16;
        static final byte CONSTANT_InvokeDynamic = 18;
        static final byte CONSTANT_LIMIT = 19;
        static final char ACC_PUBLIC = '\u0001';
        static final char ACC_PRIVATE = '\u0002';
        static final char ACC_PROTECTED = '\u0004';
        static final char ACC_STATIC = '\b';
        static final char ACC_FINAL = '\u0010';
        static final char ACC_SYNCHRONIZED = ' ';
        static final char ACC_VOLATILE = '@';
        static final char ACC_TRANSIENT = '\u0080';
        static final char ACC_NATIVE = '\u0100';
        static final char ACC_INTERFACE = '\u0200';
        static final char ACC_ABSTRACT = '\u0400';
        static final char ACC_STRICT = '\u0800';
        static final char ACC_SYNTHETIC = '\u1000';
        static final char ACC_ANNOTATION = '\u2000';
        static final char ACC_ENUM = '\u4000';
        static final char ACC_SUPER = ' ';
        static final char ACC_BRIDGE = '@';
        static final char ACC_VARARGS = '\u0080';
        static final byte REF_NONE = 0;
        static final byte REF_getField = 1;
        static final byte REF_getStatic = 2;
        static final byte REF_putField = 3;
        static final byte REF_putStatic = 4;
        static final byte REF_invokeVirtual = 5;
        static final byte REF_invokeStatic = 6;
        static final byte REF_invokeSpecial = 7;
        static final byte REF_newInvokeSpecial = 8;
        static final byte REF_invokeInterface = 9;
        static final byte REF_LIMIT = 10;

        Constants() {
        }
    }
}

