/*
 * Decompiled with CFR 0.152.
 */
package javafx.geometry;

public class Point2D {
    private double x;
    private double y;
    private int hash = 0;

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public Point2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public double distance(double d, double d2) {
        double d3 = this.getX() - d;
        double d4 = this.getY() - d2;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    public double distance(Point2D point2D) {
        return this.distance(point2D.getX(), point2D.getY());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Point2D) {
            Point2D point2D = (Point2D)object;
            return this.getX() == point2D.getX() && this.getY() == point2D.getY();
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long l = 7L;
            l = 31L * l + Double.doubleToLongBits(this.getX());
            l = 31L * l + Double.doubleToLongBits(this.getY());
            this.hash = (int)(l ^ l >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return "Point2D [x = " + this.getX() + ", y = " + this.getY() + "]";
    }
}

