/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.cdma;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.Bundle;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class ESNCondition {
    private static final String ORG_OSGI_UTIL_CDMA_ESN = "org.osgi.util.cdma.esn";
    private static final String ESN = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            String esn = System.getProperty(ESNCondition.ORG_OSGI_UTIL_CDMA_ESN);
            if (esn == null) {
                return null;
            }
            return esn.toUpperCase();
        }
    });
    private static final int ESN_LENGTH = 8;

    private ESNCondition() {
    }

    public static Condition getCondition(Bundle bundle, ConditionInfo conditionInfo) {
        String esn = conditionInfo.getArgs()[0].toUpperCase();
        int length = esn.length();
        if (length > 8) {
            throw new IllegalArgumentException("ESN too long: " + esn);
        }
        if (esn.endsWith("*")) {
            esn = esn.substring(0, --length);
        } else if (length < 8) {
            throw new IllegalArgumentException("ESN too short: " + esn);
        }
        for (int i = 0; i < length; ++i) {
            char c = esn.charAt(i);
            if ('0' <= c && c <= '9' || 'A' <= c && c <= 'F') continue;
            throw new IllegalArgumentException("not a valid ESN: " + esn);
        }
        if (ESN == null) {
            System.err.println("The OSGi implementation of org.osgi.util.cdma.ESNCondition needs the system property org.osgi.util.cdma.esn set.");
            return Condition.FALSE;
        }
        return ESN.startsWith(esn) ? Condition.TRUE : Condition.FALSE;
    }
}

