/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.netbeans.core.startup.logging.NbFormatter;

final class MessagesHandler
extends StreamHandler {
    private final File dir;
    private final File[] files;
    private final long limit;

    MessagesHandler(File dir) {
        this(dir, -1, 0x100000L);
    }

    MessagesHandler(File dir, int count, long limit) {
        this.dir = dir;
        if (count == -1 && (count = Integer.getInteger("org.netbeans.log.numberOfFiles", 3).intValue()) < 3) {
            count = 3;
        }
        File[] arr = new File[count];
        arr[0] = new File(dir, "messages.log");
        for (int i = 1; i < arr.length; ++i) {
            arr[i] = new File(dir, "messages.log." + i);
        }
        this.files = arr;
        this.limit = limit;
        this.setFormatter(NbFormatter.FORMATTER);
        this.setLevel(Level.ALL);
        this.checkRotate(true);
        this.initStream();
    }

    private boolean checkRotate(boolean always) {
        if (!always && this.files[0].length() < this.limit) {
            return false;
        }
        this.flush();
        this.doRotate();
        return true;
    }

    private void initStream() {
        try {
            this.setOutputStream(new FileOutputStream(this.files[0], false));
        }
        catch (FileNotFoundException ex) {
            this.setOutputStream(System.err);
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        super.publish(record);
        if (this.checkRotate(false)) {
            this.initStream();
        }
    }

    private synchronized void doRotate() {
        this.close();
        int n = this.files.length;
        if (this.files[n - 1].exists()) {
            this.files[n - 1].delete();
        }
        for (int i = n - 2; i >= 0; --i) {
            if (!this.files[i].exists()) continue;
            this.files[i].renameTo(this.files[i + 1]);
        }
    }
}

