/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.PersistenceException;
import javax.persistence.ValidationMode;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.JPAClassLoaderHolder;
import org.eclipse.persistence.internal.helper.JPAConversionManager;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.StaticWeaveInfo;
import org.eclipse.persistence.internal.jpa.deployment.BeanValidationInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAsmFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.weaving.PersistenceWeaver;
import org.eclipse.persistence.internal.jpa.weaving.TransformerFactory;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.jpa.metadata.MetadataSource;
import org.eclipse.persistence.jpa.metadata.XMLMetadataSource;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.database.converters.StructConverter;
import org.eclipse.persistence.platform.database.partitioning.DataPartitioningCallback;
import org.eclipse.persistence.platform.server.CustomServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSPublishingTransportManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSTopicTransportManager;
import org.eclipse.persistence.sessions.coordination.rmi.RMITransportManager;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ExternalConnectionPool;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceMonitor;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;
import org.eclipse.persistence.tools.profiler.QueryMonitor;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerSetupImpl {
    protected String persistenceUnitUniqueName;
    protected String sessionName;
    protected MetadataProcessor processor = null;
    protected PersistenceWeaver weaver = null;
    protected PersistenceUnitInfo persistenceUnitInfo = null;
    protected int factoryCount = 0;
    protected DatabaseSessionImpl session = null;
    protected boolean isInContainerMode = false;
    protected boolean isSessionLoadedFromSessionsXML = false;
    protected Boolean enableWeaving = null;
    protected boolean isWeavingStatic = false;
    protected StaticWeaveInfo staticWeaveInfo;
    protected SecurableObjectHolder securableObjectHolder = new SecurableObjectHolder();
    private Metamodel metaModel;
    protected List<StructConverter> structConverters = null;
    public static final String STATE_INITIAL = "Initial";
    public static final String STATE_PREDEPLOYED = "Predeployed";
    public static final String STATE_DEPLOYED = "Deployed";
    public static final String STATE_PREDEPLOY_FAILED = "PredeployFailed";
    public static final String STATE_DEPLOY_FAILED = "DeployFailed";
    public static final String STATE_UNDEPLOYED = "Undeployed";
    public static final String STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER = "HalfPredeployedCompositeMember";
    protected String state = "Initial";
    public static final String ERROR_LOADING_XML_FILE = "error_loading_xml_file";
    public static final String EXCEPTION_LOADING_ENTITY_CLASS = "exception_loading_entity_class";
    public static String[] connectionPropertyNames = new String[]{"javax.persistence.transactionType", "javax.persistence.jtaDataSource", "javax.persistence.nonJtaDataSource", "javax.persistence.jdbc.url", "javax.persistence.jdbc.user"};
    protected EntityManagerSetupImpl compositeEmSetupImpl;
    protected Set<EntityManagerSetupImpl> compositeMemberEmSetupImpls;
    PersistenceUnitProcessor.Mode mode;
    boolean throwExceptionOnFail;
    boolean weaveChangeTracking;
    boolean weaveLazy;
    boolean weaveEager;
    boolean weaveFetchGroups;
    boolean weaveInternal;
    protected boolean isMetadataExpired = false;

    public EntityManagerSetupImpl(String persistenceUnitUniqueName, String sessionName) {
        this.persistenceUnitUniqueName = persistenceUnitUniqueName;
        this.sessionName = sessionName;
    }

    public EntityManagerSetupImpl() {
        this("", "");
    }

    public static String getOrBuildSessionName(Map properties, PersistenceUnitInfo puInfo, String persistenceUnitUniqueName) {
        String sessionName = (String)properties.get("eclipselink.session-name");
        if (sessionName == null) {
            sessionName = (String)puInfo.getProperties().get("eclipselink.session-name");
        }
        if (sessionName != null && sessionName.length() > 0) {
            return sessionName;
        }
        if (EntityManagerSetupImpl.isComposite(puInfo)) {
            return persistenceUnitUniqueName;
        }
        return persistenceUnitUniqueName + EntityManagerSetupImpl.buildSessionNameSuffixFromConnectionProperties(properties);
    }

    protected static String buildSessionNameSuffixFromConnectionProperties(Map properties) {
        String suffix = "";
        for (int i = 0; i < connectionPropertyNames.length; ++i) {
            String name = connectionPropertyNames[i];
            Object value = properties.get(name);
            if (value == null) continue;
            String strValue = null;
            if (value instanceof String) {
                strValue = (String)value;
            } else if (value instanceof DataSource) {
                strValue = Integer.toString(System.identityHashCode(value));
            } else if (value instanceof PersistenceUnitTransactionType) {
                strValue = value.toString();
            }
            if (strValue.length() <= 0) continue;
            suffix = suffix + "_" + Helper.getShortClassName(name) + "=" + strValue;
        }
        return suffix;
    }

    public void changeSessionName(String newSessionName) {
        if (!this.session.getName().equals(newSessionName)) {
            this.session.log(1, "properties", "session_name_change", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), newSessionName});
            this.sessionName = newSessionName;
            this.session.setName(newSessionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSessionFromGlobalSessionManager() {
        if (this.session != null) {
            try {
                if (this.session.isConnected()) {
                    this.session.logout();
                }
            }
            finally {
                SessionManager.getManager().getSessions().remove(this.session.getName(), this.session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseSessionImpl deploy(ClassLoader realClassLoader, Map additionalProperties) {
        DatabaseSessionImpl e2;
        if (this.state != STATE_PREDEPLOYED && this.state != STATE_DEPLOYED) {
            if (this.mustBeCompositeMember()) {
                throw new PersistenceException((Throwable)EntityManagerSetupException.compositeMemberCannotBeUsedStandalone(this.persistenceUnitInfo.getPersistenceUnitName()));
            }
            throw new PersistenceException((Throwable)EntityManagerSetupException.cannotDeployWithoutPredeploy(this.persistenceUnitInfo.getPersistenceUnitName(), this.state));
        }
        this.session.log(1, "properties", "deploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
        try {
            DatabaseSessionImpl databaseSessionImpl;
            Map deployProperties = EntityManagerFactoryProvider.mergeMaps(additionalProperties, this.persistenceUnitInfo.getProperties());
            EntityManagerFactoryProvider.translateOldProperties(deployProperties, this.session);
            if (this.isComposite()) {
                this.updateCompositeMembersProperties(deployProperties);
            }
            if (this.state == STATE_PREDEPLOYED) {
                databaseSessionImpl = this.session;
                synchronized (databaseSessionImpl) {
                    if (this.state == STATE_PREDEPLOYED) {
                        try {
                            if (!this.isSessionLoadedFromSessionsXML) {
                                if (this.isComposite()) {
                                    this.deployCompositeMembers(deployProperties, realClassLoader);
                                } else {
                                    this.processor.setClassLoader(realClassLoader);
                                    this.processor.createDynamicClasses();
                                    this.session.getProject().convertClassNamesToClasses(realClassLoader);
                                    this.processor.addEntityListeners();
                                    if (!this.isCompositeMember()) {
                                        this.addBeanValidationListeners(deployProperties, realClassLoader);
                                    }
                                    this.processor.addNamedQueries();
                                    this.processor.processCustomizers();
                                    this.structConverters = this.processor.getStructConverters();
                                }
                                this.processor = null;
                            } else {
                                this.session.getProject().convertClassNamesToClasses(realClassLoader);
                            }
                            this.initSession();
                            if (this.session.getIntegrityChecker().hasErrors()) {
                                this.session.handleException(new IntegrityException(this.session.getIntegrityChecker()));
                            }
                            this.session.getDatasourcePlatform().getConversionManager().setLoader(realClassLoader);
                            this.state = STATE_DEPLOYED;
                        }
                        catch (RuntimeException ex) {
                            this.state = STATE_DEPLOY_FAILED;
                            throw new PersistenceException((Throwable)EntityManagerSetupException.deployFailed(this.persistenceUnitInfo.getPersistenceUnitName(), ex));
                        }
                    }
                }
            }
            if (!this.isCompositeMember()) {
                if (!this.session.isConnected()) {
                    databaseSessionImpl = this.session;
                    synchronized (databaseSessionImpl) {
                        if (!this.session.isConnected()) {
                            this.session.setProperties(deployProperties);
                            this.updateSession(deployProperties, realClassLoader);
                            if (this.isValidationOnly(deployProperties, false)) {
                                this.session.initializeDescriptors();
                            } else {
                                if (this.isSessionLoadedFromSessionsXML) {
                                    if (!this.session.isConnected()) {
                                        this.session.login();
                                    }
                                } else {
                                    EntityManagerFactoryProvider.login(this.session, deployProperties);
                                }
                                if (!this.isSessionLoadedFromSessionsXML) {
                                    this.addStructConverters();
                                }
                                this.generateDDL(deployProperties);
                            }
                        }
                    }
                }
                try {
                    this.getMetamodel();
                }
                catch (Exception e2) {
                    this.session.log(1, "jpa_metamodel", "metamodel_init_failed", new Object[]{e2.getMessage()});
                }
            }
            if (this.weaver != null) {
                this.weaver.clear();
                this.weaver = null;
            }
            e2 = this.session;
        }
        catch (Exception exception) {
            try {
                PersistenceException persistenceException = null;
                persistenceException = exception instanceof PersistenceException ? (PersistenceException)exception : new PersistenceException((Throwable)exception);
                this.session.logThrowable(7, "ejb", exception);
                throw persistenceException;
            }
            catch (Throwable throwable) {
                this.session.log(1, "properties", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
                throw throwable;
            }
        }
        this.session.log(1, "properties", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
        return e2;
    }

    protected void addProjectToSession(ServerSession session, Project project) {
        DatasourcePlatform sessionPlatform = (DatasourcePlatform)session.getDatasourceLogin().getDatasourcePlatform();
        DatasourcePlatform projectPlatform = (DatasourcePlatform)project.getDatasourceLogin().getDatasourcePlatform();
        if (!sessionPlatform.hasDefaultSequence() && projectPlatform.hasDefaultSequence()) {
            sessionPlatform.setDefaultSequence(projectPlatform.getDefaultSequence());
        }
        if (sessionPlatform.getSequences() == null || sessionPlatform.getSequences().isEmpty()) {
            if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
                sessionPlatform.setSequences(projectPlatform.getSequences());
            }
        } else if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
            for (Sequence sequence : projectPlatform.getSequences().values()) {
                if (sessionPlatform.getSequences().containsKey(sequence.getName())) continue;
                sessionPlatform.addSequence(sequence);
            }
        }
        session.addDescriptors(project);
    }

    protected void addSessionToGlobalSessionManager() {
        AbstractSession oldSession = (AbstractSession)SessionManager.getManager().getSessions().get(this.session.getName());
        if (oldSession != null) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.attemptedRedeployWithoutClose(this.session.getName()));
        }
        SessionManager.getManager().addSession(this.session);
    }

    public void addStructConverters() {
        if (this.compositeMemberEmSetupImpls == null) {
            for (StructConverter structConverter : this.structConverters) {
                if (this.session.getPlatform().getTypeConverters().get(structConverter.getJavaType()) != null) {
                    throw ValidationException.twoStructConvertersAddedForSameClass(structConverter.getJavaType().getName());
                }
                this.session.getPlatform().addStructConverter(structConverter);
            }
        } else {
            for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
                if (compositeMemberEmSetupImpl.structConverters.isEmpty()) continue;
                String compositeMemberPuName = compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName();
                compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_begin_call", new Object[]{"addStructConverters", compositeMemberPuName, this.state});
                compositeMemberEmSetupImpl.addStructConverters();
                compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_end_call", new Object[]{"addStructConverters", compositeMemberPuName, this.state});
            }
        }
    }

    protected void assignCMP3Policy() {
        Project project = this.session.getProject();
        for (ClassDescriptor descriptor : project.getDescriptors().values()) {
            OptimisticLockingPolicy olp;
            if (descriptor.getCMPPolicy() == null) {
                descriptor.setCMPPolicy(new CMP3Policy());
            }
            if ((olp = descriptor.getOptimisticLockingPolicy()) == null || olp.getLockOnChangeMode() != null) continue;
            olp.setLockOnChangeMode(OptimisticLockingPolicy.LockOnChange.OWNING);
        }
    }

    protected boolean updateServerPlatform(Map m, ClassLoader loader) {
        String serverPlatformClassName = PropertiesHandler.getPropertyValueLogDebug("eclipselink.target-server", m, (AbstractSession)this.session);
        if (serverPlatformClassName == null) {
            return false;
        }
        ServerPlatform originalServerPlatform = this.session.getServerPlatform();
        String originalServerPlatformClassName = originalServerPlatform.getClass().getName();
        if (originalServerPlatformClassName.equals(serverPlatformClassName)) {
            return false;
        }
        ServerPlatform serverPlatform = null;
        Class cls = EntityManagerSetupImpl.findClassForProperty(serverPlatformClassName, "eclipselink.target-server", loader);
        try {
            Constructor constructor = cls.getConstructor(DatabaseSession.class);
            serverPlatform = (ServerPlatform)constructor.newInstance(this.session);
        }
        catch (Exception ex) {
            if (ExternalTransactionController.class.isAssignableFrom(cls)) {
                if (originalServerPlatform.getClass().equals(CustomServerPlatform.class)) {
                    CustomServerPlatform originalCustomServerPlatform = (CustomServerPlatform)originalServerPlatform;
                    if (!cls.equals(originalCustomServerPlatform.getExternalTransactionControllerClass())) {
                        originalCustomServerPlatform.setExternalTransactionControllerClass(cls);
                    }
                } else {
                    CustomServerPlatform customServerPlatform = new CustomServerPlatform(this.session);
                    customServerPlatform.setExternalTransactionControllerClass(cls);
                    serverPlatform = customServerPlatform;
                }
            }
            throw EntityManagerSetupException.failedToInstantiateServerPlatform(serverPlatformClassName, "eclipselink.target-server", ex);
        }
        if (serverPlatform != null) {
            this.session.setServerPlatform(serverPlatform);
            return true;
        }
        return false;
    }

    protected void updatePartitioning(Map m, ClassLoader loader) {
        String callbackClassName;
        String partitioning = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.partitioning", m, this.session);
        if (partitioning != null) {
            PartitioningPolicy partitioningPolicy = this.session.getProject().getPartitioningPolicy(partitioning);
            if (partitioningPolicy == null) {
                throw DescriptorException.missingPartitioningPolicy(partitioning, null, null);
            }
            this.session.setPartitioningPolicy(partitioningPolicy);
        }
        if ((callbackClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.partitioning.callback", m, this.session)) != null) {
            Class cls = EntityManagerSetupImpl.findClassForProperty(callbackClassName, "eclipselink.partitioning.callback", loader);
            DataPartitioningCallback callback = null;
            try {
                Constructor constructor = cls.getConstructor(new Class[0]);
                callback = (DataPartitioningCallback)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw EntityManagerSetupException.failedToInstantiateServerPlatform(callbackClassName, "eclipselink.partitioning.callback", exception);
            }
            this.session.getLogin().setPartitioningCallback(callback);
        }
    }

    protected void updateLoggers(Map persistenceProperties, boolean serverPlatformChanged, ClassLoader loader) {
        block15: {
            String loggerClassName = PropertiesHandler.getPropertyValueLogDebug("eclipselink.logging.logger", persistenceProperties, (AbstractSession)this.session);
            SessionLog singletonLog = null;
            SessionLog sessionLog = null;
            if (loggerClassName != null) {
                SessionLog currentLog = this.session.getSessionLog();
                if (loggerClassName.equals("ServerLogger")) {
                    ServerPlatform serverPlatform = this.session.getServerPlatform();
                    singletonLog = serverPlatform.getServerLog();
                    sessionLog = serverPlatform.getServerLog();
                } else if (!currentLog.getClass().getName().equals(loggerClassName)) {
                    Class sessionLogClass = EntityManagerSetupImpl.findClassForProperty(loggerClassName, "eclipselink.logging.logger", loader);
                    try {
                        singletonLog = (SessionLog)sessionLogClass.newInstance();
                        sessionLog = (SessionLog)sessionLogClass.newInstance();
                    }
                    catch (Exception ex) {
                        throw EntityManagerSetupException.failedToInstantiateLogger(loggerClassName, "eclipselink.logging.logger", ex);
                    }
                }
            } else if (serverPlatformChanged) {
                ServerPlatform serverPlatform = this.session.getServerPlatform();
                singletonLog = serverPlatform.getServerLog();
                sessionLog = serverPlatform.getServerLog();
            }
            if (singletonLog != null && sessionLog != null) {
                AbstractSessionLog.setLog(singletonLog);
                this.session.setSessionLog(sessionLog);
            }
            this.initOrUpdateLogging(persistenceProperties, AbstractSessionLog.getLog());
            this.initOrUpdateLogging(persistenceProperties, this.session.getSessionLog());
            String loggingFileString = (String)persistenceProperties.get("eclipselink.logging.file");
            if (loggingFileString != null) {
                if (!loggingFileString.trim().equals("")) {
                    try {
                        if (sessionLog == null) break block15;
                        if (sessionLog instanceof AbstractSessionLog) {
                            FileOutputStream fos = new FileOutputStream(loggingFileString);
                            ((AbstractSessionLog)sessionLog).setWriter(fos);
                            break block15;
                        }
                        FileWriter fw = new FileWriter(loggingFileString);
                        sessionLog.setWriter(fw);
                    }
                    catch (IOException e) {
                        this.session.handleException(ValidationException.invalidLoggingFile(loggingFileString, e));
                    }
                } else {
                    this.session.handleException(ValidationException.invalidLoggingFile());
                }
            }
        }
    }

    protected void updateProfiler(Map persistenceProperties, ClassLoader loader) {
        String newProfilerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.profiler", persistenceProperties, this.session);
        if (newProfilerClassName == null) {
            ((ServerPlatformBase)this.session.getServerPlatform()).configureProfiler(this.session);
        } else {
            if (newProfilerClassName.equals("NoProfiler")) {
                this.session.setProfiler(null);
                return;
            }
            if (newProfilerClassName.equals("QueryMonitor")) {
                this.session.setProfiler(null);
                QueryMonitor.shouldMonitor = true;
                return;
            }
            if (newProfilerClassName.equals("PerformanceProfiler")) {
                this.session.setProfiler(new PerformanceProfiler());
                return;
            }
            if (newProfilerClassName.equals("PerformanceMonitor")) {
                this.session.setProfiler(new PerformanceMonitor());
                return;
            }
            String originalProfilerClassNamer = null;
            if (this.session.getProfiler() != null && (originalProfilerClassNamer = this.session.getProfiler().getClass().getName()).equals(newProfilerClassName)) {
                return;
            }
            try {
                Class newProfilerClass = EntityManagerSetupImpl.findClassForProperty(newProfilerClassName, "eclipselink.profiler", loader);
                SessionProfiler sessionProfiler = (SessionProfiler)EntityManagerSetupImpl.buildObjectForClass(newProfilerClass, SessionProfiler.class);
                if (sessionProfiler != null) {
                    this.session.setProfiler(sessionProfiler);
                } else {
                    this.session.handleException(ValidationException.invalidProfilerClass(newProfilerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException(ValidationException.cannotInstantiateProfilerClass(newProfilerClassName, e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException(ValidationException.cannotInstantiateProfilerClass(newProfilerClassName, e));
            }
            catch (InstantiationException e) {
                this.session.handleException(ValidationException.cannotInstantiateProfilerClass(newProfilerClassName, e));
            }
        }
    }

    protected static Class findClass(String className, ClassLoader loader) throws ClassNotFoundException, PrivilegedActionException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, loader));
        }
        return PrivilegedAccessHelper.getClassForName(className, true, loader);
    }

    protected static Class findClassForProperty(String className, String propertyName, ClassLoader loader) {
        try {
            return EntityManagerSetupImpl.findClass(className, loader);
        }
        catch (PrivilegedActionException exception1) {
            throw EntityManagerSetupException.classNotFoundForProperty(className, propertyName, exception1.getException());
        }
        catch (ClassNotFoundException exception2) {
            throw EntityManagerSetupException.classNotFoundForProperty(className, propertyName, exception2);
        }
    }

    public DatabaseSessionImpl getSession() {
        return this.session;
    }

    protected static Object buildObjectForClass(Class clazz, Class mustBeImplementedInterface) throws IllegalAccessException, PrivilegedActionException, InstantiationException {
        if (clazz != null && Helper.classImplementsInterface(clazz, mustBeImplementedInterface)) {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
            }
            return PrivilegedAccessHelper.newInstanceFromClass(clazz);
        }
        return null;
    }

    protected void updateDescriptorCacheSettings(Map m, ClassLoader loader) {
        Map typeMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.cache.type.", m, this.session);
        Map sizeMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.cache.size.", m, this.session);
        Map sharedMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.cache.shared.", m, this.session);
        if (typeMap.isEmpty() && sizeMap.isEmpty() && sharedMap.isEmpty()) {
            return;
        }
        String defaultTypeName = (String)typeMap.remove("default");
        if (defaultTypeName != null) {
            Class defaultType = EntityManagerSetupImpl.findClassForProperty(defaultTypeName, "eclipselink.cache.type.default", this.getClass().getClassLoader());
            this.session.getProject().setDefaultIdentityMapClass(defaultType);
        }
        String value = null;
        try {
            String defaultSharedString;
            String defaultSizeString = (String)sizeMap.remove("default");
            if (defaultSizeString != null) {
                value = defaultSizeString;
                int defaultSize = Integer.parseInt(defaultSizeString);
                this.session.getProject().setDefaultIdentityMapSize(defaultSize);
            }
            if ((defaultSharedString = (String)sharedMap.remove("default")) != null) {
                boolean defaultShared = Boolean.parseBoolean(defaultSharedString);
                this.session.getProject().setDefaultIsIsolated(!defaultShared);
            }
            Iterator<ClassDescriptor> it = this.session.getDescriptors().values().iterator();
            while (!(!it.hasNext() || typeMap.isEmpty() && sizeMap.isEmpty() && sharedMap.isEmpty())) {
                String sharedString;
                String sizeString;
                ClassDescriptor descriptor = it.next();
                if (descriptor.isDescriptorTypeAggregate()) continue;
                String entityName = descriptor.getAlias();
                String className = descriptor.getJavaClass().getName();
                String name = entityName;
                String typeName = (String)typeMap.remove(name);
                if (typeName == null) {
                    name = className;
                    typeName = (String)typeMap.remove(name);
                }
                if (typeName != null) {
                    Class type = EntityManagerSetupImpl.findClassForProperty(typeName, "eclipselink.cache.type." + name, this.getClass().getClassLoader());
                    descriptor.setIdentityMapClass(type);
                }
                if ((sizeString = (String)sizeMap.remove(name = entityName)) == null) {
                    name = className;
                    sizeString = (String)sizeMap.remove(name);
                }
                if (sizeString != null) {
                    value = sizeString;
                    int size = Integer.parseInt(sizeString);
                    descriptor.setIdentityMapSize(size);
                }
                if ((sharedString = (String)sharedMap.remove(name = entityName)) == null) {
                    name = className;
                    sharedString = (String)sharedMap.remove(name);
                }
                if (sharedString == null) continue;
                boolean shared = Boolean.parseBoolean(sharedString);
                descriptor.setIsIsolated(!shared);
            }
        }
        catch (NumberFormatException exception) {
            this.session.handleException(ValidationException.invalidValueForProperty(value, "eclipselink.cache.size.", exception));
        }
    }

    protected void updateConnectionSettings(ServerSession serverSession, Map properties) {
        Map connectionsMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.connection-pool.", properties, serverSession);
        if (connectionsMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : connectionsMap.entrySet()) {
            String poolName = "default";
            String attribute = null;
            try {
                boolean shared;
                if (((String)entry.getKey()).indexOf(".") == -1) {
                    attribute = (String)entry.getKey();
                } else {
                    poolName = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("."));
                    attribute = ((String)entry.getKey()).substring(((String)entry.getKey()).indexOf(".") + 1, ((String)entry.getKey()).length());
                }
                ConnectionPool pool = null;
                if (poolName.equals("write")) {
                    poolName = "default";
                }
                if (poolName.equals("read")) {
                    pool = serverSession.getReadConnectionPool();
                    if (pool == null || pool == serverSession.getDefaultConnectionPool()) {
                        pool = this.session.getLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, serverSession.getLogin(), serverSession) : new ConnectionPool(poolName, serverSession.getLogin(), serverSession);
                        serverSession.setReadConnectionPool(pool);
                    }
                } else if (poolName.equals("sequence")) {
                    pool = this.session.getSequencingControl().getConnectionPool();
                    if (pool == null) {
                        pool = this.session.getLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, serverSession.getLogin(), serverSession) : new ConnectionPool(poolName, serverSession.getLogin(), serverSession);
                        this.session.getSequencingControl().setConnectionPool(pool);
                    }
                } else {
                    pool = serverSession.getConnectionPool(poolName);
                    if (pool == null) {
                        pool = this.session.getLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, serverSession.getLogin(), serverSession) : new ConnectionPool(poolName, serverSession.getLogin(), serverSession);
                        serverSession.addConnectionPool(pool);
                    }
                }
                if (attribute.equals("initial")) {
                    pool.setInitialNumberOfConnections(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("min")) {
                    pool.setMinNumberOfConnections(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("max")) {
                    pool.setMaxNumberOfConnections(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("url")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).setURL((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("nonJtaDataSource")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).useDataSource((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("jtaDataSource")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).useDataSource((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("user")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).setUserName((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("password")) {
                    pool.setLogin(pool.getLogin().clone());
                    ((DatabaseLogin)pool.getLogin()).setPassword((String)entry.getValue());
                    continue;
                }
                if (attribute.equals("wait")) {
                    pool.setWaitTimeout(Integer.parseInt((String)entry.getValue()));
                    continue;
                }
                if (attribute.equals("failover")) {
                    String failoverPools = (String)entry.getValue();
                    if (failoverPools.indexOf(44) != -1 || failoverPools.indexOf(32) != -1) {
                        StringTokenizer tokenizer = new StringTokenizer(failoverPools, " ,");
                        while (tokenizer.hasMoreTokens()) {
                            pool.addFailoverConnectionPool(tokenizer.nextToken());
                        }
                        continue;
                    }
                    pool.addFailoverConnectionPool((String)entry.getValue());
                    continue;
                }
                if (!poolName.equals("read") || !attribute.equals("shared") || !(shared = Boolean.parseBoolean((String)entry.getValue()))) continue;
                ReadConnectionPool readPool = new ReadConnectionPool(poolName, serverSession.getLogin(), serverSession);
                readPool.setInitialNumberOfConnections(pool.getInitialNumberOfConnections());
                readPool.setMinNumberOfConnections(pool.getMinNumberOfConnections());
                readPool.setMaxNumberOfConnections(pool.getMaxNumberOfConnections());
                readPool.setWaitTimeout(pool.getWaitTimeout());
                readPool.setLogin(pool.getLogin());
                serverSession.setReadConnectionPool(readPool);
            }
            catch (RuntimeException exception) {
                this.session.handleException(ValidationException.invalidValueForProperty(entry.getValue(), (String)entry.getKey(), exception));
            }
        }
    }

    protected void updateConnectionPolicy(ServerSession serverSession, Map m) {
        ConnectionPolicy.ExclusiveMode exclusiveMode;
        String isLazyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.exclusive-connection.is-lazy", m, this.session);
        if (isLazyString != null) {
            serverSession.getDefaultConnectionPolicy().setIsLazy(Boolean.parseBoolean(isLazyString));
        }
        if ((exclusiveMode = EntityManagerSetupImpl.getConnectionPolicyExclusiveModeFromProperties(m, this.session, true)) != null) {
            serverSession.getDefaultConnectionPolicy().setExclusiveMode(exclusiveMode);
        }
    }

    public static ConnectionPolicy.ExclusiveMode getConnectionPolicyExclusiveModeFromProperties(Map m, AbstractSession abstractSession, boolean useSystemAsDefault) {
        String exclusiveConnectionModeString = PropertiesHandler.getPropertyValueLogDebug("eclipselink.jdbc.exclusive-connection.mode", m, abstractSession, useSystemAsDefault);
        if (exclusiveConnectionModeString != null) {
            if (exclusiveConnectionModeString == "Isolated") {
                return ConnectionPolicy.ExclusiveMode.Isolated;
            }
            if (exclusiveConnectionModeString == "Always") {
                return ConnectionPolicy.ExclusiveMode.Always;
            }
            return ConnectionPolicy.ExclusiveMode.Transactional;
        }
        return null;
    }

    public synchronized ClassTransformer predeploy(PersistenceUnitInfo info, Map extendedProperties) {
        ClassLoader privateClassLoader = null;
        if (this.state == STATE_DEPLOY_FAILED || this.state == STATE_UNDEPLOYED) {
            throw new PersistenceException((Throwable)EntityManagerSetupException.cannotPredeploy(this.persistenceUnitInfo.getPersistenceUnitName(), this.state));
        }
        if (this.state == STATE_PREDEPLOYED || this.state == STATE_DEPLOYED) {
            this.session.log(1, "properties", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            ++this.factoryCount;
            this.session.log(1, "properties", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            return null;
        }
        if (this.state == STATE_INITIAL) {
            this.persistenceUnitInfo = info;
            if (!this.isCompositeMember() && EntityManagerSetupImpl.mustBeCompositeMember(this.persistenceUnitInfo)) {
                if (this.staticWeaveInfo == null) {
                    return null;
                }
                throw new PersistenceException((Throwable)EntityManagerSetupException.compositeMemberCannotBeUsedStandalone(this.persistenceUnitInfo.getPersistenceUnitName()));
            }
        } else if (this.state == STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER) {
            this.session.log(1, "properties", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state + " " + (Object)((Object)this.mode), this.factoryCount});
        }
        try {
            Map predeployProperties = null;
            boolean isComposite = false;
            if (this.state != STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER) {
                predeployProperties = EntityManagerFactoryProvider.mergeMaps(extendedProperties, this.persistenceUnitInfo.getProperties());
                EntityManagerFactoryProvider.translateOldProperties(predeployProperties, null);
                String sessionsXMLStr = (String)predeployProperties.get("eclipselink.sessions-xml");
                if (sessionsXMLStr != null) {
                    this.isSessionLoadedFromSessionsXML = true;
                }
                if (isComposite = EntityManagerSetupImpl.isComposite(this.persistenceUnitInfo)) {
                    if (this.isSessionLoadedFromSessionsXML) {
                        throw new PersistenceException((Throwable)EntityManagerSetupException.compositeIncompatibleWithSessionsXml(this.persistenceUnitInfo.getPersistenceUnitName()));
                    }
                    this.session = new SessionBroker();
                    ((SessionBroker)this.session).setShouldUseDescriptorAliases(true);
                } else {
                    this.session = new ServerSession(new Project(new DatabaseLogin()));
                }
                this.session.setName(this.sessionName);
                if (this.compositeEmSetupImpl == null) {
                    ClassLoader realClassLoader = this.persistenceUnitInfo.getClassLoader();
                    if (this.staticWeaveInfo == null) {
                        this.updateServerPlatform(predeployProperties, realClassLoader);
                        this.updateLoggers(predeployProperties, true, realClassLoader);
                        JPAClassLoaderHolder privateClassLoaderHolder = this.session.getServerPlatform().getNewTempClassLoader(this.persistenceUnitInfo);
                        privateClassLoader = privateClassLoaderHolder.getClassLoader();
                        this.updateProfiler(predeployProperties, realClassLoader);
                    } else {
                        Writer writer = this.staticWeaveInfo.getLogWriter();
                        if (writer != null) {
                            ((DefaultSessionLog)this.session.getSessionLog()).setWriter(writer);
                        }
                        this.session.setLogLevel(this.staticWeaveInfo.getLogLevel());
                        privateClassLoader = this.persistenceUnitInfo.getNewTempClassLoader();
                    }
                } else {
                    this.session.setSessionLog(this.compositeEmSetupImpl.session.getSessionLog());
                    this.session.setProfiler(this.compositeEmSetupImpl.session.getProfiler());
                    privateClassLoader = this.persistenceUnitInfo.getNewTempClassLoader();
                }
                this.session.log(1, "properties", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
                if (this.isSessionLoadedFromSessionsXML) {
                    String tempSessionName = this.sessionName;
                    if (this.isCompositeMember()) {
                        tempSessionName = (String)predeployProperties.get("eclipselink.session-name");
                    }
                    this.session.log(1, "properties", "loading_session_xml", sessionsXMLStr, tempSessionName);
                    if (tempSessionName == null) {
                        throw new PersistenceException((Throwable)EntityManagerSetupException.sessionNameNeedBeSpecified(this.persistenceUnitInfo.getPersistenceUnitName(), sessionsXMLStr));
                    }
                    XMLSessionConfigLoader xmlLoader = new XMLSessionConfigLoader(sessionsXMLStr);
                    AbstractSession tempSession = new SessionManager().getSession(xmlLoader, tempSessionName, privateClassLoader, false, false);
                    this.session.log(1, "properties", "sessions_xml_path_where_session_load_from", xmlLoader.getSessionName(), xmlLoader.getResourcePath());
                    if (tempSession == null) {
                        throw new PersistenceException((Throwable)ValidationException.noSessionFound(this.sessionName, sessionsXMLStr));
                    }
                    if (tempSession.isServerSession() || tempSession.isSessionBroker()) {
                        this.session = (DatabaseSessionImpl)tempSession;
                        if (tempSessionName != this.sessionName) {
                            this.session.setName(this.sessionName);
                        }
                    } else {
                        throw new PersistenceException((Throwable)EntityManagerSetupException.sessionLoadedFromSessionsXMLMustBeServerSession(this.persistenceUnitInfo.getPersistenceUnitName(), (String)predeployProperties.get("eclipselink.sessions-xml"), tempSession));
                    }
                    if (this.staticWeaveInfo == null) {
                        this.updateServerPlatform(predeployProperties, privateClassLoader);
                        this.updateLoggers(predeployProperties, true, privateClassLoader);
                    }
                }
                EntityManagerFactoryProvider.warnOldProperties(predeployProperties, this.session);
                this.session.getPlatform().setConversionManager(new JPAConversionManager());
                if (this.staticWeaveInfo == null) {
                    if (!isComposite) {
                        PersistenceUnitTransactionType transactionType = null;
                        String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", predeployProperties, this.session);
                        if (transTypeString != null) {
                            transactionType = PersistenceUnitTransactionType.valueOf((String)transTypeString);
                        } else if (this.persistenceUnitInfo != null) {
                            transactionType = this.persistenceUnitInfo.getTransactionType();
                        }
                        if (!this.isValidationOnly(predeployProperties, false) && this.persistenceUnitInfo != null && transactionType == PersistenceUnitTransactionType.JTA && predeployProperties.get("javax.persistence.jtaDataSource") == null && this.persistenceUnitInfo.getJtaDataSource() == null) {
                            throw new PersistenceException((Throwable)EntityManagerSetupException.jtaPersistenceUnitInfoMissingJtaDataSource(this.persistenceUnitInfo.getPersistenceUnitName()));
                        }
                    }
                    if (this.state == STATE_INITIAL) {
                        String weaving;
                        if (this.compositeEmSetupImpl == null) {
                            if (null == this.enableWeaving) {
                                this.enableWeaving = Boolean.TRUE;
                            }
                            this.isWeavingStatic = false;
                            weaving = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.weaving", predeployProperties);
                            if (weaving != null && weaving.equalsIgnoreCase("false")) {
                                this.enableWeaving = Boolean.FALSE;
                            } else if (weaving != null && weaving.equalsIgnoreCase("static")) {
                                this.isWeavingStatic = true;
                            }
                        } else {
                            if (!this.compositeEmSetupImpl.enableWeaving.booleanValue()) {
                                this.enableWeaving = Boolean.FALSE;
                            } else {
                                if (null == this.enableWeaving) {
                                    this.enableWeaving = Boolean.TRUE;
                                }
                                if ((weaving = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.weaving", predeployProperties)) != null && weaving.equalsIgnoreCase("false")) {
                                    this.enableWeaving = Boolean.FALSE;
                                }
                            }
                            this.isWeavingStatic = this.compositeEmSetupImpl.isWeavingStatic;
                        }
                    }
                    this.throwExceptionOnFail = this.compositeEmSetupImpl == null ? "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.orm.throw.exceptions", predeployProperties, "true", this.session)) : this.compositeEmSetupImpl.throwExceptionOnFail;
                } else {
                    this.enableWeaving = Boolean.TRUE;
                }
                this.weaveChangeTracking = false;
                this.weaveLazy = false;
                this.weaveEager = false;
                this.weaveFetchGroups = false;
                this.weaveInternal = false;
                if (this.enableWeaving.booleanValue()) {
                    this.weaveChangeTracking = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.changetracking", predeployProperties, "true", this.session));
                    this.weaveLazy = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.lazy", predeployProperties, "true", this.session));
                    this.weaveEager = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.eager", predeployProperties, "false", this.session));
                    this.weaveFetchGroups = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.fetchgroups", predeployProperties, "true", this.session));
                    this.weaveInternal = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.weaving.internal", predeployProperties, "true", this.session));
                }
            }
            if (!this.isSessionLoadedFromSessionsXML) {
                if (isComposite) {
                    this.predeployCompositeMembers(predeployProperties, privateClassLoader);
                } else {
                    MetadataProcessor compositeProcessor = null;
                    if (this.compositeEmSetupImpl == null) {
                        this.mode = PersistenceUnitProcessor.Mode.ALL;
                    } else {
                        if (this.state != STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER) {
                            this.state = STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER;
                            this.mode = PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL;
                        }
                        compositeProcessor = this.compositeEmSetupImpl.processor;
                    }
                    if (this.mode == PersistenceUnitProcessor.Mode.ALL || this.mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL) {
                        boolean usesMultitenantSharedEmf = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.multitenant.tenants-share-cache", predeployProperties, "false", this.session));
                        this.processor = new MetadataProcessor(this.persistenceUnitInfo, this.session, privateClassLoader, this.weaveLazy, this.weaveEager, this.weaveFetchGroups, usesMultitenantSharedEmf, predeployProperties, compositeProcessor);
                        this.updateMetadataRepository(predeployProperties, this.persistenceUnitInfo.getClassLoader());
                        EntityManagerSetupImpl.updateCaseSensitivitySettings(predeployProperties, this.processor.getProject(), this.session);
                    }
                    PersistenceUnitProcessor.processORMetadata(this.processor, this.throwExceptionOnFail, this.mode);
                    if (this.mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL) {
                        this.mode = PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_MIDDLE;
                        this.session.log(1, "properties", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state + " " + (Object)((Object)this.mode), this.factoryCount});
                        return null;
                    }
                    if (this.mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_MIDDLE) {
                        this.mode = PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_FINAL;
                        this.session.log(1, "properties", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state + " " + (Object)((Object)this.mode), this.factoryCount});
                        return null;
                    }
                    this.mode = null;
                    if (this.session.getIntegrityChecker().hasErrors()) {
                        this.session.handleException(new IntegrityException(this.session.getIntegrityChecker()));
                    }
                    if (this.enableWeaving.booleanValue()) {
                        Collection<MetadataClass> entities = PersistenceUnitProcessor.buildEntityList(this.processor, privateClassLoader);
                        this.weaver = TransformerFactory.createTransformerAndModifyProject(this.session, entities, privateClassLoader, this.weaveLazy, this.weaveChangeTracking, this.weaveFetchGroups, this.weaveInternal);
                    }
                }
            } else if (this.enableWeaving.booleanValue()) {
                ArrayList<MetadataClass> persistenceClasses = new ArrayList<MetadataClass>();
                MetadataAsmFactory factory = new MetadataAsmFactory(new MetadataLogger(this.session), privateClassLoader);
                Iterator<Class> iterator = this.session.getProject().getDescriptors().keySet().iterator();
                while (iterator.hasNext()) {
                    persistenceClasses.add(factory.getMetadataClass(iterator.next().getName()));
                }
                this.weaver = TransformerFactory.createTransformerAndModifyProject(this.session, persistenceClasses, privateClassLoader, this.weaveLazy, this.weaveChangeTracking, this.weaveFetchGroups, this.weaveInternal);
            }
            if (!this.isCompositeMember() && (this.state != STATE_INITIAL || this.isInContainerMode())) {
                ++this.factoryCount;
            }
            this.state = STATE_PREDEPLOYED;
            this.session.log(1, "properties", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            if (this.isWeavingStatic) {
                return null;
            }
            return this.weaver;
        }
        catch (RuntimeException ex) {
            this.state = STATE_PREDEPLOY_FAILED;
            this.session.log(1, "properties", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            this.session = null;
            this.mode = null;
            throw new PersistenceException((Throwable)EntityManagerSetupException.predeployFailed(this.persistenceUnitInfo.getPersistenceUnitName(), ex));
        }
    }

    public String getDeployedSessionName() {
        return this.session != null ? this.session.getName() : null;
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.persistenceUnitInfo;
    }

    public boolean isValidationOnly(Map m) {
        return this.isValidationOnly(m, true);
    }

    protected boolean isValidationOnly(Map m, boolean shouldMergeMap) {
        String validationOnlyString;
        if (shouldMergeMap) {
            m = this.mergeWithExistingMap(m);
        }
        if ((validationOnlyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.validation-only", m, this.session)) != null) {
            return Boolean.parseBoolean(validationOnlyString);
        }
        return false;
    }

    public boolean shouldGetSessionOnCreateFactory(Map m) {
        if (this.isValidationOnly(m = this.mergeWithExistingMap(m), false)) {
            return true;
        }
        String deployString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.deploy-on-startup", m, this.session);
        if (deployString != null) {
            return Boolean.parseBoolean(deployString);
        }
        return false;
    }

    protected Map mergeWithExistingMap(Map m) {
        if (this.persistenceUnitInfo != null) {
            return EntityManagerFactoryProvider.mergeMaps(m, this.persistenceUnitInfo.getProperties());
        }
        return m;
    }

    public boolean isInContainerMode() {
        return this.isInContainerMode;
    }

    protected void updateCacheCoordination(Map m, ClassLoader loader) {
        String protocol = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.protocol", m, this.session);
        if (protocol != null) {
            String channel;
            String asynch;
            String removeOnError;
            String context;
            String password;
            String user;
            RemoteCommandManager rcm = new RemoteCommandManager(this.session);
            if (protocol.equalsIgnoreCase("jms") || protocol.equalsIgnoreCase("jms-publishing")) {
                String reuse_publisher;
                String factory;
                String topic;
                JMSPublishingTransportManager transport = null;
                transport = protocol.equalsIgnoreCase("jms") ? new JMSTopicTransportManager(rcm) : new JMSPublishingTransportManager(rcm);
                rcm.setTransportManager(transport);
                String host = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.host", m, this.session);
                if (host != null) {
                    transport.setTopicHostUrl(host);
                }
                if ((topic = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.topic", m, this.session)) != null) {
                    transport.setTopicName(topic);
                }
                if ((factory = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.factory", m, this.session)) != null) {
                    transport.setTopicConnectionFactoryName(factory);
                }
                if ((reuse_publisher = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jms.reuse-topic-publisher", m, this.session)) != null) {
                    transport.setShouldReuseJMSTopicPublisher(reuse_publisher.equalsIgnoreCase("true"));
                }
            } else if (protocol.equalsIgnoreCase("rmi") || protocol.equalsIgnoreCase("rmi-iiop")) {
                String url;
                String timeToLive;
                String port;
                String multicast;
                String delay;
                if (protocol.equalsIgnoreCase("rmi-iiop")) {
                    ((RMITransportManager)rcm.getTransportManager()).setIsRMIOverIIOP(true);
                }
                if ((delay = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.announcement-delay", m, this.session)) != null) {
                    rcm.getDiscoveryManager().setAnnouncementDelay(Integer.parseInt(delay));
                }
                if ((multicast = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.multicast-group", m, this.session)) != null) {
                    rcm.getDiscoveryManager().setMulticastGroupAddress(multicast);
                }
                if ((port = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.multicast-group.port", m, this.session)) != null) {
                    rcm.getDiscoveryManager().setMulticastPort(Integer.parseInt(port));
                }
                if ((timeToLive = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.packet-time-to-live", m, this.session)) != null) {
                    rcm.getDiscoveryManager().setPacketTimeToLive(Integer.parseInt(timeToLive));
                }
                if ((url = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.rmi.url", m, this.session)) != null) {
                    rcm.setUrl(url);
                }
            } else {
                Class transportClass = EntityManagerSetupImpl.findClassForProperty(protocol, "eclipselink.cache.coordination.protocol", loader);
                try {
                    rcm.setTransportManager((TransportManager)transportClass.newInstance());
                }
                catch (Exception invalid) {
                    throw new RuntimeException(invalid);
                }
            }
            String naming = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.naming-service", m, this.session);
            if (naming != null) {
                if (naming.equalsIgnoreCase("jndi")) {
                    rcm.getTransportManager().setNamingServiceType(0);
                } else if (naming.equalsIgnoreCase("rmi")) {
                    rcm.getTransportManager().setNamingServiceType(1);
                }
            }
            if ((user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.user", m, this.session)) != null) {
                rcm.getTransportManager().setUserName(user);
            }
            if ((password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.password", m, this.session)) != null) {
                rcm.getTransportManager().setPassword(password);
            }
            if ((context = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.jndi.initial-context-factory", m, this.session)) != null) {
                rcm.getTransportManager().setInitialContextFactoryName(context);
            }
            if ((removeOnError = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.remove-connection-on-error", m, this.session)) != null) {
                rcm.getTransportManager().setShouldRemoveConnectionOnError(removeOnError.equalsIgnoreCase("true"));
            }
            if ((asynch = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.propagate-asynchronously", m, this.session)) != null) {
                rcm.setShouldPropagateAsynchronously(asynch.equalsIgnoreCase("true"));
            }
            if ((channel = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.cache.coordination.channel", m, this.session)) != null) {
                rcm.setChannel(channel);
            }
            this.session.setCommandManager(rcm);
            this.session.setShouldPropagateChanges(true);
        }
    }

    protected void updateLogins(Map m) {
        String eclipselinkPlatform;
        DatabaseLogin login = this.session.getLogin();
        String user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.user", m, this.session);
        String password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.password", m, this.session);
        if (user != null) {
            login.setUserName(user);
        }
        if (password != null) {
            login.setPassword(this.securableObjectHolder.getSecurableObject().decryptPassword(password));
        }
        if ((eclipselinkPlatform = PropertiesHandler.getPropertyValueLogDebug("eclipselink.target-database", m, (AbstractSession)this.session)) != null) {
            login.setPlatformClassName(eclipselinkPlatform, this.persistenceUnitInfo.getClassLoader());
        }
        PersistenceUnitTransactionType transactionType = this.persistenceUnitInfo.getTransactionType();
        String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", m, this.session);
        if (transTypeString != null) {
            transactionType = PersistenceUnitTransactionType.valueOf((String)transTypeString);
        }
        DataSource jtaDatasource = this.getDatasourceFromProperties(m, "javax.persistence.jtaDataSource", this.persistenceUnitInfo.getJtaDataSource());
        DataSource nonjtaDatasource = this.getDatasourceFromProperties(m, "javax.persistence.nonJtaDataSource", this.persistenceUnitInfo.getNonJtaDataSource());
        if (this.isValidationOnly(m, false) && transactionType == PersistenceUnitTransactionType.JTA && jtaDatasource == null) {
            this.updateLoginDefaultConnector(login, m);
            return;
        }
        login.setUsesExternalTransactionController(transactionType == PersistenceUnitTransactionType.JTA);
        DataSource mainDatasource = null;
        DataSource readDatasource = null;
        if (login.shouldUseExternalTransactionController()) {
            mainDatasource = jtaDatasource;
            readDatasource = nonjtaDatasource;
        } else {
            if (jtaDatasource != null) {
                this.session.log(6, "transaction", "resource_local_persistence_init_info_ignores_jta_data_source", this.persistenceUnitInfo.getPersistenceUnitName());
            }
            if (nonjtaDatasource != null) {
                mainDatasource = nonjtaDatasource;
            } else {
                this.updateLoginDefaultConnector(login, m);
                return;
            }
        }
        if (!(login.getConnector() instanceof JNDIConnector)) {
            JNDIConnector jndiConnector = mainDatasource instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)mainDatasource).getName()) : new JNDIConnector(mainDatasource);
            login.setConnector(jndiConnector);
            login.setUsesExternalConnectionPooling(true);
        }
        if (this.session.isServerSession() && readDatasource != null) {
            DatasourceLogin readLogin = login.clone();
            readLogin.dontUseExternalTransactionController();
            JNDIConnector jndiConnector = readDatasource instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)readDatasource).getName()) : new JNDIConnector(readDatasource);
            readLogin.setConnector(jndiConnector);
            ((ServerSession)this.session).setReadConnectionPool(readLogin);
        }
    }

    protected DataSource getDatasourceFromProperties(Map m, String property, DataSource defaultDataSource) {
        Object datasource = EntityManagerFactoryProvider.getConfigPropertyLogDebug(property, m, this.session);
        if (datasource == null) {
            return defaultDataSource;
        }
        if (datasource instanceof String) {
            if (((String)datasource).length() > 0) {
                return new DataSourceImpl((String)datasource, null, null, null);
            }
            return null;
        }
        if (!(datasource instanceof DataSource)) {
            this.session.log(6, "properties", "invalid_datasource_property_value", property, datasource);
            return defaultDataSource;
        }
        return (DataSource)datasource;
    }

    protected void updateLoginDefaultConnector(DatasourceLogin login, Map m) {
        if (login.getConnector() instanceof DefaultConnector) {
            DatabaseLogin dbLogin = (DatabaseLogin)login;
            String jdbcDriver = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.driver", m, this.session);
            String connectionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.jdbc.url", m, this.session);
            if (connectionString != null) {
                dbLogin.setConnectionString(connectionString);
            }
            if (jdbcDriver != null) {
                dbLogin.setDriverClassName(jdbcDriver);
            }
        }
    }

    protected void updatePools(ServerSession serverSession, Map m) {
        String value = null;
        String property = null;
        try {
            String sequenceDataSource;
            String sequence;
            if (!serverSession.getDefaultConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
                property = "eclipselink.jdbc.connections.min";
                value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property, m, serverSession);
                if (value != null) {
                    serverSession.getDefaultConnectionPool().setMinNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.connections.max", m, serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setMaxNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.connections.initial", m, serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setInitialNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.write-connections.min", m, serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setMinNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.write-connections.max", m, serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setMaxNumberOfConnections(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(property = "eclipselink.jdbc.write-connections.initial", m, serverSession)) != null) {
                    serverSession.getDefaultConnectionPool().setInitialNumberOfConnections(Integer.parseInt(value));
                }
            }
            if (!serverSession.getReadConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
                String wait;
                String initial;
                String max;
                String shared = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.shared", m, serverSession);
                boolean isShared = false;
                if (shared != null) {
                    isShared = Boolean.parseBoolean(shared);
                }
                ConnectionPool pool = null;
                pool = isShared ? new ReadConnectionPool("read", serverSession.getReadConnectionPool().getLogin(), serverSession) : new ConnectionPool("read", serverSession.getReadConnectionPool().getLogin(), serverSession);
                String min = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.min", m, serverSession);
                if (min != null) {
                    value = min;
                    property = "eclipselink.jdbc.read-connections.min";
                    pool.setMinNumberOfConnections(Integer.parseInt(min));
                }
                if ((max = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.max", m, serverSession)) != null) {
                    value = max;
                    property = "eclipselink.jdbc.read-connections.max";
                    pool.setMaxNumberOfConnections(Integer.parseInt(max));
                }
                if ((initial = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.read-connections.initial", m, serverSession)) != null) {
                    value = initial;
                    property = "eclipselink.jdbc.read-connections.initial";
                    pool.setInitialNumberOfConnections(Integer.parseInt(initial));
                }
                if (isShared || min != null || max != null || initial != null) {
                    serverSession.setReadConnectionPool(pool);
                }
                if ((wait = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.connections.wait-timeout", m, serverSession)) != null) {
                    value = wait;
                    property = "eclipselink.jdbc.connections.wait-timeout";
                    serverSession.getDefaultConnectionPool().setWaitTimeout(Integer.parseInt(wait));
                    pool.setWaitTimeout(Integer.parseInt(wait));
                }
            }
            if ((sequence = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool", m, serverSession)) != null) {
                serverSession.getSequencingControl().setShouldUseSeparateConnection(Boolean.parseBoolean(sequence));
            }
            if ((sequenceDataSource = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.non-jta-data-source", m, serverSession)) != null) {
                DatasourceLogin login = this.session.getLogin().clone();
                login.dontUseExternalTransactionController();
                JNDIConnector jndiConnector = new JNDIConnector(sequenceDataSource);
                login.setConnector(jndiConnector);
                serverSession.getSequencingControl().setLogin(login);
            }
            if (!serverSession.getReadConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
                value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.min", m, serverSession);
                if (value != null) {
                    property = "eclipselink.jdbc.sequence-connection-pool.min";
                    serverSession.getSequencingControl().setMinPoolSize(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.max", m, serverSession)) != null) {
                    property = "eclipselink.jdbc.sequence-connection-pool.max";
                    serverSession.getSequencingControl().setMaxPoolSize(Integer.parseInt(value));
                }
                if ((value = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sequence-connection-pool.initial", m, serverSession)) != null) {
                    property = "eclipselink.jdbc.sequence-connection-pool.initial";
                    serverSession.getSequencingControl().setInitialPoolSize(Integer.parseInt(value));
                }
            }
        }
        catch (NumberFormatException exception) {
            serverSession.handleException(ValidationException.invalidValueForProperty(value, property, exception));
        }
    }

    protected void initSession() {
        this.assignCMP3Policy();
        if (!this.isCompositeMember()) {
            this.addSessionToGlobalSessionManager();
        }
    }

    protected void updateSession(Map m, ClassLoader loader) {
        if (this.session == null || this.session.isConnected()) {
            return;
        }
        boolean serverPlatformChanged = this.updateServerPlatform(m, loader);
        if (!this.session.hasBroker()) {
            this.updateLoggers(m, serverPlatformChanged, loader);
            this.updateProfiler(m, loader);
        }
        if (this.session.isBroker()) {
            PersistenceUnitTransactionType transactionType = this.persistenceUnitInfo.getTransactionType();
            String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", m, this.session);
            if (transTypeString != null) {
                transactionType = PersistenceUnitTransactionType.valueOf((String)transTypeString);
            }
            this.session.getLogin().setUsesExternalTransactionController(transactionType == PersistenceUnitTransactionType.JTA);
        } else {
            String shouldBindString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.bind-parameters", m, this.session);
            if (shouldBindString != null) {
                this.session.getPlatform().setShouldBindAllParameters(Boolean.parseBoolean(shouldBindString));
            }
            this.updateLogins(m);
        }
        if (!this.session.getLogin().shouldUseExternalTransactionController()) {
            this.session.getServerPlatform().disableJTA();
        }
        if (this.session.isServerSession()) {
            this.updatePools((ServerSession)this.session, m);
            this.updateConnectionSettings((ServerSession)this.session, m);
            if (!this.isSessionLoadedFromSessionsXML) {
                this.updateDescriptorCacheSettings(m, loader);
            }
            this.updateConnectionPolicy((ServerSession)this.session, m);
        }
        if (this.session.isBroker()) {
            if (this.compositeMemberEmSetupImpls != null) {
                Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", m);
                for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
                    String compositeMemberPuName = compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName();
                    Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(compositeMemberPuName);
                    compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_begin_call", new Object[]{"updateSession", compositeMemberPuName, this.state});
                    compositeMemberEmSetupImpl.updateSession(compositeMemberProperties, loader);
                    compositeMemberEmSetupImpl.session.log(1, "properties", "composite_member_end_call", new Object[]{"updateSession", compositeMemberPuName, this.state});
                }
            }
            this.setSessionEventListener(m, loader);
            this.setExceptionHandler(m, loader);
            this.updateAllowZeroIdSetting(m);
            this.updateCacheCoordination(m, loader);
            this.processSessionCustomizer(m, loader);
        } else {
            this.setSessionEventListener(m, loader);
            this.setExceptionHandler(m, loader);
            this.updateBatchWritingSetting(m);
            this.updateNativeSQLSetting(m);
            this.updateSQLCastSetting(m);
            this.updateUppercaseSetting(m);
            this.updateCacheStatementSettings(m);
            this.updateTemporalMutableSetting(m);
            this.updateTableCreationSettings(m);
            if (!this.session.hasBroker()) {
                this.updateAllowZeroIdSetting(m);
            }
            this.updateIdValidation(m);
            this.updatePessimisticLockTimeout(m);
            this.updateQueryTimeout(m);
            if (!this.session.hasBroker()) {
                this.updateCacheCoordination(m, loader);
            }
            this.updatePartitioning(m, loader);
            this.processDescriptorCustomizers(m, loader);
            this.processSessionCustomizer(m, loader);
            this.setDescriptorNamedQueries(m);
        }
    }

    public void setIsInContainerMode(boolean isInContainerMode) {
        this.isInContainerMode = isInContainerMode;
    }

    public void setIsMetadataExpired(boolean hasExpiredMetadata) {
        this.isMetadataExpired = hasExpiredMetadata;
    }

    protected void processSessionCustomizer(Map m, ClassLoader loader) {
        String sessionCustomizerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session.customizer", m, this.session);
        if (sessionCustomizerClassName == null) {
            return;
        }
        Class sessionCustomizerClass = EntityManagerSetupImpl.findClassForProperty(sessionCustomizerClassName, "eclipselink.session.customizer", loader);
        try {
            SessionCustomizer sessionCustomizer = (SessionCustomizer)sessionCustomizerClass.newInstance();
            sessionCustomizer.customize(this.session);
        }
        catch (Exception ex) {
            throw EntityManagerSetupException.failedWhileProcessingProperty("eclipselink.session.customizer", sessionCustomizerClassName, ex);
        }
    }

    protected void initOrUpdateLogging(Map m, SessionLog log) {
        String shouldDisplayData;
        String exString;
        String connectionString;
        String sessionString;
        String threadString;
        String tsString;
        Map categoryLogLevelMap;
        String logLevelString = PropertiesHandler.getPropertyValueLogDebug("eclipselink.logging.level", m, (AbstractSession)this.session);
        if (logLevelString != null) {
            log.setLevel(AbstractSessionLog.translateStringToLoggingLevel(logLevelString));
        }
        if (!(categoryLogLevelMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.logging.level.", m, this.session)).isEmpty()) {
            for (Map.Entry entry : categoryLogLevelMap.entrySet()) {
                String category = (String)entry.getKey();
                String value = (String)entry.getValue();
                log.setLevel(AbstractSessionLog.translateStringToLoggingLevel(value), category);
            }
        }
        if ((tsString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.timestamp", m, this.session)) != null) {
            log.setShouldPrintDate(Boolean.parseBoolean(tsString));
        }
        if ((threadString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.thread", m, this.session)) != null) {
            log.setShouldPrintThread(Boolean.parseBoolean(threadString));
        }
        if ((sessionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.session", m, this.session)) != null) {
            log.setShouldPrintSession(Boolean.parseBoolean(sessionString));
        }
        if ((connectionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.connection", m, this.session)) != null) {
            log.setShouldPrintConnection(Boolean.parseBoolean(sessionString));
        }
        if ((exString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.exceptions", m, this.session)) != null) {
            log.setShouldLogExceptionStackTrace(Boolean.parseBoolean(exString));
        }
        if ((shouldDisplayData = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.logging.parameters", m, this.session)) != null) {
            log.setShouldDisplayData(Boolean.parseBoolean(shouldDisplayData));
        }
    }

    protected void processDescriptorCustomizers(Map m, ClassLoader loader) {
        Map customizerMap = PropertiesHandler.getPrefixValuesLogDebug("eclipselink.descriptor.customizer.", m, this.session);
        if (customizerMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : customizerMap.entrySet()) {
            String name = (String)entry.getKey();
            String customizerClassName = (String)entry.getValue();
            ClassDescriptor descriptor = this.session.getDescriptorForAlias(name);
            if (descriptor == null) {
                try {
                    Class javaClass = EntityManagerSetupImpl.findClass(name, loader);
                    descriptor = this.session.getDescriptor(javaClass);
                }
                catch (Exception ex) {
                    throw EntityManagerSetupException.failedWhileProcessingProperty("eclipselink.descriptor.customizer." + name, customizerClassName, ex);
                }
            }
            if (descriptor != null) {
                Class customizerClass = EntityManagerSetupImpl.findClassForProperty(customizerClassName, "eclipselink.descriptor.customizer." + name, loader);
                try {
                    DescriptorCustomizer customizer = (DescriptorCustomizer)customizerClass.newInstance();
                    customizer.customize(descriptor);
                    continue;
                }
                catch (Exception ex) {
                    throw EntityManagerSetupException.failedWhileProcessingProperty("eclipselink.descriptor.customizer." + name, customizerClassName, ex);
                }
            }
            throw EntityManagerSetupException.failedWhileProcessingProperty("eclipselink.descriptor.customizer." + name, customizerClassName, null);
        }
    }

    public boolean isInitial() {
        return this.state == STATE_INITIAL;
    }

    public boolean isMetadataExpired() {
        return this.isMetadataExpired;
    }

    public boolean isPredeployed() {
        return this.state == STATE_PREDEPLOYED;
    }

    public boolean isDeployed() {
        return this.state == STATE_DEPLOYED;
    }

    public boolean isUndeployed() {
        return this.state == STATE_UNDEPLOYED;
    }

    public boolean isPredeployFailed() {
        return this.state == STATE_PREDEPLOY_FAILED;
    }

    public boolean isDeployFailed() {
        return this.state == STATE_DEPLOY_FAILED;
    }

    public boolean isHalfPredeployedCompositeMember() {
        return this.state == STATE_HALF_PREDEPLOYED_COMPOSITE_MEMBER;
    }

    public String getPersistenceUnitUniqueName() {
        return this.persistenceUnitUniqueName;
    }

    public int getFactoryCount() {
        return this.factoryCount;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public boolean shouldRedeploy() {
        return this.state == STATE_UNDEPLOYED || this.state == STATE_PREDEPLOY_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undeploy() {
        block11: {
            if (this.state == STATE_INITIAL || this.state == STATE_PREDEPLOY_FAILED || this.state == STATE_UNDEPLOYED) {
                return;
            }
            this.session.log(1, "properties", "undeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            try {
                --this.factoryCount;
                if (this.factoryCount <= 0) break block11;
            }
            catch (Throwable throwable) {
                this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
                if (this.state == STATE_UNDEPLOYED) {
                    this.session = null;
                }
                throw throwable;
            }
            this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
            if (this.state == STATE_UNDEPLOYED) {
                this.session = null;
            }
            return;
        }
        HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
        synchronized (hashMap) {
            this.state = STATE_UNDEPLOYED;
            this.removeSessionFromGlobalSessionManager();
            if (EntityManagerFactoryProvider.emSetupImpls.get(this.sessionName).equals(this)) {
                EntityManagerFactoryProvider.emSetupImpls.remove(this.sessionName);
            }
        }
        this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.session.getName(), this.state, this.factoryCount});
        if (this.state == STATE_UNDEPLOYED) {
            this.session = null;
        }
    }

    protected void setSessionEventListener(Map m, ClassLoader loader) {
        String sessionEventListenerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session-event-listener", m, this.session);
        if (sessionEventListenerClassName != null) {
            Class sessionEventListenerClass = EntityManagerSetupImpl.findClassForProperty(sessionEventListenerClassName, "eclipselink.session-event-listener", loader);
            try {
                SessionEventListener sessionEventListener = (SessionEventListener)EntityManagerSetupImpl.buildObjectForClass(sessionEventListenerClass, SessionEventListener.class);
                if (sessionEventListener != null) {
                    this.session.getEventManager().addListener(sessionEventListener);
                } else {
                    this.session.handleException(ValidationException.invalidSessionEventListenerClass(sessionEventListenerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException(ValidationException.cannotInstantiateSessionEventListenerClass(sessionEventListenerClassName, e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException(ValidationException.cannotInstantiateSessionEventListenerClass(sessionEventListenerClassName, e));
            }
            catch (InstantiationException e) {
                this.session.handleException(ValidationException.cannotInstantiateSessionEventListenerClass(sessionEventListenerClassName, e));
            }
        }
    }

    protected void setExceptionHandler(Map m, ClassLoader loader) {
        String exceptionHandlerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.exception-handler", m, this.session);
        if (exceptionHandlerClassName != null) {
            Class exceptionHandlerClass = EntityManagerSetupImpl.findClassForProperty(exceptionHandlerClassName, "eclipselink.exception-handler", loader);
            try {
                ExceptionHandler exceptionHandler = (ExceptionHandler)EntityManagerSetupImpl.buildObjectForClass(exceptionHandlerClass, ExceptionHandler.class);
                if (exceptionHandler != null) {
                    this.session.setExceptionHandler(exceptionHandler);
                } else {
                    this.session.handleException(ValidationException.invalidExceptionHandlerClass(exceptionHandlerClassName));
                }
            }
            catch (IllegalAccessException e) {
                this.session.handleException(ValidationException.cannotInstantiateExceptionHandlerClass(exceptionHandlerClassName, e));
            }
            catch (PrivilegedActionException e) {
                this.session.handleException(ValidationException.cannotInstantiateExceptionHandlerClass(exceptionHandlerClassName, e));
            }
            catch (InstantiationException e) {
                this.session.handleException(ValidationException.cannotInstantiateExceptionHandlerClass(exceptionHandlerClassName, e));
            }
        }
    }

    protected void updateBatchWritingSetting(Map persistenceProperties) {
        String sizeString;
        String batchWritingSettingString = PropertiesHandler.getPropertyValueLogDebug("eclipselink.jdbc.batch-writing", persistenceProperties, (AbstractSession)this.session);
        if (batchWritingSettingString != null) {
            this.session.getPlatform().setUsesBatchWriting(batchWritingSettingString != "None");
            if (batchWritingSettingString == "JDBC") {
                this.session.getPlatform().setUsesJDBCBatchWriting(true);
                this.session.getPlatform().setUsesNativeBatchWriting(false);
            } else if (batchWritingSettingString == "Buffered") {
                this.session.getPlatform().setUsesJDBCBatchWriting(false);
                this.session.getPlatform().setUsesNativeBatchWriting(false);
            } else if (batchWritingSettingString == "Oracle-JDBC") {
                this.session.getPlatform().setUsesNativeBatchWriting(true);
                this.session.getPlatform().setUsesJDBCBatchWriting(true);
            }
        }
        if ((sizeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.batch-writing.size", persistenceProperties, this.session)) != null) {
            try {
                this.session.getPlatform().setMaxBatchWritingSize(Integer.parseInt(sizeString));
            }
            catch (NumberFormatException invalid) {
                this.session.handleException(ValidationException.invalidValueForProperty(sizeString, "eclipselink.jdbc.batch-writing.size", invalid));
            }
        }
    }

    protected void updateMetadataRepository(Map m, ClassLoader loader) {
        String repository = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.metadata-source", m, null, this.session);
        if (repository != null) {
            if (repository.equalsIgnoreCase("XML")) {
                this.processor.setMetadataSource(new XMLMetadataSource());
            } else {
                Class transportClass = EntityManagerSetupImpl.findClassForProperty(repository, "eclipselink.metadata-source", loader);
                try {
                    this.processor.setMetadataSource((MetadataSource)transportClass.newInstance());
                }
                catch (Exception invalid) {
                    this.session.handleException(EntityManagerSetupException.failedToInstantiateProperty(repository, "eclipselink.metadata-source", invalid));
                }
            }
        }
    }

    protected void updateNativeSQLSetting(Map m) {
        String nativeSQLString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.native-sql", m, this.session);
        if (nativeSQLString != null) {
            if (nativeSQLString.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().useNativeSQL();
            } else if (nativeSQLString.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().dontUseNativeSQL();
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForSettingNativeSQL(nativeSQLString));
            }
        }
    }

    protected void updateSQLCastSetting(Map m) {
        String sqlCastString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.sql-cast", m, this.session);
        if (sqlCastString != null) {
            if (sqlCastString.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().getPlatform().setIsCastRequired(true);
            } else if (sqlCastString.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().getPlatform().setIsCastRequired(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(sqlCastString, "eclipselink.jdbc.sql-cast"));
            }
        }
    }

    protected void updateUppercaseSetting(Map m) {
        String uppercaseString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.uppercase-columns", m, this.session);
        if (uppercaseString != null) {
            if (uppercaseString.equalsIgnoreCase("true")) {
                this.session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(true);
            } else if (uppercaseString.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(uppercaseString, "eclipselink.jdbc.uppercase-columns"));
            }
        }
    }

    public static void updateCaseSensitivitySettings(Map m, MetadataProject project, AbstractSession session) {
        String insensitiveString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jpa.uppercase-column-names", m, "false", session);
        if (insensitiveString != null) {
            if (insensitiveString.equalsIgnoreCase("true")) {
                project.setShouldForceFieldNamesToUpperCase(true);
                session.getProject().getLogin().setShouldForceFieldNamesToUpperCase(true);
            } else if (insensitiveString.equalsIgnoreCase("false")) {
                project.setShouldForceFieldNamesToUpperCase(false);
            } else {
                session.handleException(ValidationException.invalidBooleanValueForProperty(insensitiveString, "eclipselink.jpa.uppercase-column-names"));
            }
        }
    }

    protected void updatePessimisticLockTimeout(Map persistenceProperties) {
        String pessimisticLockTimeout = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.lock.timeout", persistenceProperties, this.session);
        if (pessimisticLockTimeout != null) {
            try {
                this.session.setPessimisticLockTimeoutDefault(Integer.parseInt(pessimisticLockTimeout));
            }
            catch (NumberFormatException invalid) {
                this.session.handleException(ValidationException.invalidValueForProperty(pessimisticLockTimeout, "javax.persistence.lock.timeout", invalid));
            }
        }
    }

    protected void updateCacheStatementSettings(Map m) {
        String cacheStatementsSize;
        String statmentsNeedBeCached = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.cache-statements", m, this.session);
        if (statmentsNeedBeCached != null) {
            if (statmentsNeedBeCached.equalsIgnoreCase("true")) {
                if (this.session.isServerSession() && ((ServerSession)this.session).getConnectionPools().isEmpty()) {
                    this.session.log(6, "properties", "persistence_unit_ignores_statments_cache_setting", new Object[]{null});
                } else {
                    this.session.getProject().getLogin().setShouldCacheAllStatements(true);
                }
            } else if (statmentsNeedBeCached.equalsIgnoreCase("false")) {
                this.session.getProject().getLogin().setShouldCacheAllStatements(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForEnableStatmentsCached(statmentsNeedBeCached));
            }
        }
        if ((cacheStatementsSize = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.jdbc.cache-statements.size", m, this.session)) != null) {
            try {
                this.session.getProject().getLogin().setStatementCacheSize(Integer.parseInt(cacheStatementsSize));
            }
            catch (NumberFormatException e) {
                this.session.handleException(ValidationException.invalidCacheStatementsSize(cacheStatementsSize, e.getMessage()));
            }
        }
    }

    protected void updateAllowZeroIdSetting(Map m) {
        String allowZero = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.allow-zero-id", m, this.session);
        if (allowZero != null) {
            if (allowZero.equalsIgnoreCase("true")) {
                Helper.isZeroValidPrimaryKey = true;
            } else if (allowZero.equalsIgnoreCase("false")) {
                Helper.isZeroValidPrimaryKey = false;
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(allowZero, "eclipselink.allow-zero-id"));
            }
        }
    }

    protected void updateIdValidation(Map m) {
        String idValidationString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.id-validation", m, this.session);
        if (idValidationString != null) {
            this.session.getProject().setDefaultIdValidation(IdValidation.valueOf(idValidationString));
        }
    }

    protected void updateTableCreationSettings(Map m) {
        String tableCreationSuffix = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.ddl-generation.table-creation-suffix", m, this.session);
        if (tableCreationSuffix != null && tableCreationSuffix.length() > 0) {
            this.session.getPlatform().setTableCreationSuffix(tableCreationSuffix);
        }
    }

    protected void updateTemporalMutableSetting(Map m) {
        String temporalMutable = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.temporal.mutable", m, this.session);
        if (temporalMutable != null) {
            if (temporalMutable.equalsIgnoreCase("true")) {
                this.session.getProject().setDefaultTemporalMutable(true);
            } else if (temporalMutable.equalsIgnoreCase("false")) {
                this.session.getProject().setDefaultTemporalMutable(false);
            } else {
                this.session.handleException(ValidationException.invalidBooleanValueForProperty(temporalMutable, "eclipselink.temporal.mutable"));
            }
        }
    }

    protected void setDescriptorNamedQueries(Map m) {
        String addNamedQueriesString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("eclipselink.session.include.descriptor.queries", m, this.session);
        if (addNamedQueriesString != null) {
            if (addNamedQueriesString.equalsIgnoreCase("true")) {
                this.session.copyDescriptorNamedQueries(false);
            } else if (!addNamedQueriesString.equalsIgnoreCase("false")) {
                this.session.handleException(ValidationException.invalidBooleanValueForAddingNamedQueries(addNamedQueriesString));
            }
        }
    }

    private void updateQueryTimeout(Map persistenceProperties) {
        String timeout = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.query.timeout", persistenceProperties, this.session);
        try {
            if (timeout != null) {
                this.session.setQueryTimeoutDefault(Integer.parseInt(timeout));
            }
        }
        catch (NumberFormatException exception) {
            this.session.handleException(ValidationException.invalidValueForProperty(timeout, "javax.persistence.query.timeout", exception));
        }
    }

    private void addBeanValidationListeners(Map puProperties, ClassLoader appClassLoader) {
        ValidationMode validationMode = EntityManagerSetupImpl.getValidationMode(this.persistenceUnitInfo, puProperties);
        if (validationMode == ValidationMode.AUTO || validationMode == ValidationMode.CALLBACK) {
            String helperClassName = "org.eclipse.persistence.internal.jpa.deployment.BeanValidationInitializationHelper$BeanValidationInitializationHelperImpl";
            ClassLoader eclipseLinkClassLoader = EntityManagerSetupImpl.class.getClassLoader();
            try {
                Class helperClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (Class)AccessController.doPrivileged(new PrivilegedClassForName(helperClassName, true, eclipseLinkClassLoader)) : PrivilegedAccessHelper.getClassForName(helperClassName, true, eclipseLinkClassLoader);
                BeanValidationInitializationHelper beanValidationInitializationHelper = (BeanValidationInitializationHelper)helperClass.newInstance();
                beanValidationInitializationHelper.bootstrapBeanValidation(puProperties, this.session, this.processor.getProject(), appClassLoader);
            }
            catch (Throwable e) {
                if (validationMode == ValidationMode.CALLBACK) {
                    throw PersistenceUnitLoadingException.exceptionObtainingRequiredBeanValidatorFactory(e);
                }
                this.session.logMessage("Could not initialize Validation Factory. Encountered following exception: " + e);
            }
        }
    }

    private static ValidationMode getValidationMode(PersistenceUnitInfo persitenceUnitInfo, Map puProperties) {
        String validationModeAtEMFCreation;
        ValidationMode validationMode = null;
        try {
            Method method = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                method = (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(PersistenceUnitInfo.class, "getValidationMode", null));
                validationMode = (ValidationMode)((Object)AccessController.doPrivileged(new PrivilegedMethodInvoker(method, persitenceUnitInfo)));
            } else {
                method = PrivilegedAccessHelper.getDeclaredMethod(PersistenceUnitInfo.class, "getValidationMode", null);
                validationMode = (ValidationMode)((Object)PrivilegedAccessHelper.invokeMethod(method, persitenceUnitInfo, null));
            }
        }
        catch (Throwable exception) {
            // empty catch block
        }
        if (validationMode == null) {
            validationMode = ValidationMode.AUTO;
        }
        if ((validationModeAtEMFCreation = (String)puProperties.get("javax.persistence.validation.mode")) != null) {
            validationMode = ValidationMode.valueOf(validationModeAtEMFCreation);
        }
        return validationMode;
    }

    public Metamodel getMetamodel() {
        MetamodelImpl tempMetaModel = null;
        if (null == this.metaModel) {
            tempMetaModel = new MetamodelImpl(this);
            this.initializeCanonicalMetamodel(tempMetaModel);
            this.metaModel = tempMetaModel;
        }
        return this.metaModel;
    }

    /*
     * Exception decompiling
     */
    protected void initializeCanonicalMetamodel(Metamodel model) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setMetamodel(Metamodel aMetamodel) {
        this.metaModel = aMetamodel;
    }

    public boolean mustBeCompositeMember() {
        return EntityManagerSetupImpl.mustBeCompositeMember(this.persistenceUnitInfo);
    }

    public boolean isCompositeMember() {
        return this.compositeEmSetupImpl != null;
    }

    public boolean isComposite() {
        return this.compositeMemberEmSetupImpls != null;
    }

    public static boolean mustBeCompositeMember(PersistenceUnitInfo puInfo) {
        String mustBeCompositeMemberStr = PropertiesHandler.getPropertyValue("eclipselink.composite-unit.member", puInfo.getProperties(), false);
        if (mustBeCompositeMemberStr != null) {
            return mustBeCompositeMemberStr.equals("true");
        }
        return false;
    }

    public static boolean isComposite(PersistenceUnitInfo puInfo) {
        String isCompositeString = PropertiesHandler.getPropertyValue("eclipselink.composite-unit", puInfo.getProperties(), false);
        if (isCompositeString != null) {
            return isCompositeString.equals("true");
        }
        return false;
    }

    public void setCompositeEmSetupImpl(EntityManagerSetupImpl compositeEmSetupImpl) {
        this.compositeEmSetupImpl = compositeEmSetupImpl;
    }

    public EntityManagerSetupImpl getCompositeEmSetupImpl() {
        return this.compositeEmSetupImpl;
    }

    public void setStaticWeaveInfo(StaticWeaveInfo staticWeaveInfo) {
        this.staticWeaveInfo = staticWeaveInfo;
    }

    protected void predeployCompositeMembers(Map predeployProperties, ClassLoader tempClassLoader) {
        Set<SEPersistenceUnitInfo> compositeMemberPuInfos = EntityManagerSetupImpl.getCompositeMemberPuInfoSet(this.persistenceUnitInfo, predeployProperties);
        this.updateCompositeMembersProperties(compositeMemberPuInfos, predeployProperties);
        Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", predeployProperties);
        this.compositeMemberEmSetupImpls = new HashSet<EntityManagerSetupImpl>(compositeMemberPuInfos.size());
        this.processor = new MetadataProcessor();
        if (this.enableWeaving.booleanValue()) {
            this.weaver = new PersistenceWeaver(this.session, new HashMap());
        }
        for (SEPersistenceUnitInfo compositeMemberPuInfo : compositeMemberPuInfos) {
            compositeMemberPuInfo.setNewTempClassLoader(tempClassLoader);
            String containedPuName = compositeMemberPuInfo.getPersistenceUnitName();
            EntityManagerSetupImpl containedEmSetupImpl = new EntityManagerSetupImpl(containedPuName, containedPuName);
            containedEmSetupImpl.setCompositeEmSetupImpl(this);
            containedEmSetupImpl.setStaticWeaveInfo(this.staticWeaveInfo);
            Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(containedPuName);
            containedEmSetupImpl.predeploy(compositeMemberPuInfo, compositeMemberProperties);
            compositeMemberPuInfo.setNewTempClassLoader(compositeMemberPuInfo.getClassLoader());
            this.compositeMemberEmSetupImpls.add(containedEmSetupImpl);
        }
        for (EntityManagerSetupImpl containedEmSetupImpl : this.compositeMemberEmSetupImpls) {
            containedEmSetupImpl.predeploy(null, null);
        }
        for (EntityManagerSetupImpl containedEmSetupImpl : this.compositeMemberEmSetupImpls) {
            PersistenceWeaver containedWeaver = (PersistenceWeaver)containedEmSetupImpl.predeploy(null, null);
            if (!this.enableWeaving.booleanValue() || containedWeaver == null) continue;
            this.weaver.getClassDetailsMap().putAll(containedWeaver.getClassDetailsMap());
        }
        if (this.enableWeaving.booleanValue() && this.weaver.getClassDetailsMap().isEmpty()) {
            this.weaver = null;
        }
    }

    protected void deployCompositeMembers(Map deployProperties, ClassLoader realClassLoader) {
        Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", deployProperties);
        for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
            Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName());
            compositeMemberEmSetupImpl.deploy(realClassLoader, compositeMemberProperties);
            DatabaseSessionImpl containedSession = compositeMemberEmSetupImpl.getSession();
            ((SessionBroker)this.session).registerSession(containedSession.getName(), containedSession);
        }
    }

    protected void updateCompositeMembersProperties(Map compositeProperties) {
        HashSet<SEPersistenceUnitInfo> compositePuInfos = new HashSet<SEPersistenceUnitInfo>(this.compositeMemberEmSetupImpls.size());
        for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
            compositePuInfos.add((SEPersistenceUnitInfo)compositeMemberEmSetupImpl.persistenceUnitInfo);
        }
        this.updateCompositeMembersProperties(compositePuInfos, compositeProperties);
    }

    protected void updateCompositeMembersProperties(Set<SEPersistenceUnitInfo> compositePuInfos, Map compositeProperties) {
        Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", compositeProperties);
        HashMap newCompositeMemberMapOfProperties = compositeMemberMapOfProperties == null ? new HashMap(compositePuInfos.size()) : new HashMap(compositeMemberMapOfProperties);
        for (SEPersistenceUnitInfo compositePuInfo : compositePuInfos) {
            String compositeMemberPuName = compositePuInfo.getPersistenceUnitName();
            Map compositeMemberProperties = (Map)newCompositeMemberMapOfProperties.get(compositeMemberPuName);
            Map newCompositeMemberProperties = compositeMemberProperties == null ? new HashMap() : new HashMap(compositeMemberProperties);
            EntityManagerSetupImpl.overrideMemberProperties(newCompositeMemberProperties, compositeProperties);
            newCompositeMemberProperties = EntityManagerFactoryProvider.mergeMaps(newCompositeMemberProperties, compositePuInfo.getProperties());
            EntityManagerFactoryProvider.translateOldProperties(newCompositeMemberProperties, this.session);
            newCompositeMemberMapOfProperties.put(compositeMemberPuName, newCompositeMemberProperties);
        }
        compositeProperties.put("eclipselink.composite-unit.properties", newCompositeMemberMapOfProperties);
    }

    protected void generateDDL(Map props) {
        block9: {
            block8: {
                if (this.compositeMemberEmSetupImpls != null) break block8;
                boolean createTables = false;
                boolean shouldDropFirst = false;
                String ddlGeneration = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.ddl-generation", props, "none");
                if ((ddlGeneration = ddlGeneration.toLowerCase()).equals("none")) {
                    return;
                }
                if (ddlGeneration.equals("create-tables") || ddlGeneration.equals("drop-and-create-tables")) {
                    createTables = true;
                    if (ddlGeneration.equals("drop-and-create-tables")) {
                        shouldDropFirst = true;
                    }
                }
                if (!createTables) break block9;
                String ddlGenerationMode = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.ddl-generation.output-mode", props, "database");
                if (ddlGenerationMode.equals("none")) {
                    return;
                }
                if (this.isCompositeMember()) {
                    this.session.log(1, "properties", "composite_member_begin_call", new Object[]{"generateDDL", this.persistenceUnitInfo.getPersistenceUnitName(), this.state});
                }
                SchemaManager mgr = new SchemaManager(this.session);
                if (ddlGenerationMode.equals("database") || ddlGenerationMode.equals("both")) {
                    EntityManagerFactoryProvider.writeDDLToDatabase(mgr, shouldDropFirst);
                }
                if (ddlGenerationMode.equals("sql-script") || ddlGenerationMode.equals("both")) {
                    String appLocation = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.application-location", props, PersistenceUnitProperties.DEFAULT_APP_LOCATION);
                    String createDDLJdbc = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.create-ddl-jdbc-file-name", props, "createDDL.jdbc");
                    String dropDDLJdbc = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.drop-ddl-jdbc-file-name", props, "dropDDL.jdbc");
                    EntityManagerFactoryProvider.writeDDLsToFiles(mgr, appLocation, createDDLJdbc, dropDDLJdbc);
                }
                if (!this.isCompositeMember()) break block9;
                this.session.log(1, "properties", "composite_member_end_call", new Object[]{"generateDDL", this.persistenceUnitInfo.getPersistenceUnitName(), this.state});
                break block9;
            }
            Map compositeMemberMapOfProperties = (Map)EntityManagerFactoryProvider.getConfigProperty("eclipselink.composite-unit.properties", props);
            for (EntityManagerSetupImpl compositeMemberEmSetupImpl : this.compositeMemberEmSetupImpls) {
                Map compositeMemberProperties = (Map)compositeMemberMapOfProperties.get(compositeMemberEmSetupImpl.getPersistenceUnitInfo().getPersistenceUnitName());
                compositeMemberEmSetupImpl.generateDDL(compositeMemberProperties);
            }
        }
    }

    protected static void overrideMemberProperties(Map memberProperties, Map compositeProperties) {
        String transactionTypeProp = (String)compositeProperties.get("javax.persistence.transactionType");
        if (transactionTypeProp != null) {
            memberProperties.put("javax.persistence.transactionType", transactionTypeProp);
        } else {
            memberProperties.remove("javax.persistence.transactionType");
        }
        String serverPlatformProp = (String)compositeProperties.get("eclipselink.target-server");
        if (serverPlatformProp != null) {
            memberProperties.put("eclipselink.target-server", serverPlatformProp);
        } else {
            memberProperties.remove("eclipselink.target-server");
        }
    }

    protected static Map<String, SEPersistenceUnitInfo> getCompositeMemberPuInfoMap(PersistenceUnitInfo puInfo, Map predeployProperties) {
        Set<SEPersistenceUnitInfo> memeberPuInfoSet = PersistenceUnitProcessor.getPersistenceUnits(puInfo.getClassLoader(), predeployProperties, puInfo.getJarFileUrls());
        HashMap<String, SEPersistenceUnitInfo> memberPuInfoMap = new HashMap<String, SEPersistenceUnitInfo>(memeberPuInfoSet.size());
        for (SEPersistenceUnitInfo memberPuInfo : memeberPuInfoSet) {
            memberPuInfo.setTransactionType(puInfo.getTransactionType());
            EntityManagerSetupImpl.overrideMemberProperties(memberPuInfo.getProperties(), puInfo.getProperties());
            if (EntityManagerSetupImpl.isComposite(memberPuInfo)) {
                Map<String, SEPersistenceUnitInfo> containedMemberPuInfoMap = EntityManagerSetupImpl.getCompositeMemberPuInfoMap(memberPuInfo, memberPuInfo.getProperties());
                for (Map.Entry<String, SEPersistenceUnitInfo> entry : containedMemberPuInfoMap.entrySet()) {
                    String containedMemberPuName = entry.getKey();
                    SEPersistenceUnitInfo containedMemberPuInfo = entry.getValue();
                    SEPersistenceUnitInfo anotherMemeberPuInfo = memberPuInfoMap.get(containedMemberPuName);
                    if (anotherMemeberPuInfo == null) {
                        memberPuInfoMap.put(containedMemberPuName, containedMemberPuInfo);
                        continue;
                    }
                    EntityManagerSetupImpl.throwPersistenceUnitNameAlreadyInUseException(containedMemberPuName, containedMemberPuInfo, anotherMemeberPuInfo);
                }
                continue;
            }
            String memberPuName = memberPuInfo.getPersistenceUnitName();
            SEPersistenceUnitInfo anotherMemeberPuInfo = memberPuInfoMap.get(memberPuName);
            if (anotherMemeberPuInfo == null) {
                memberPuInfoMap.put(memberPuName, memberPuInfo);
                continue;
            }
            EntityManagerSetupImpl.throwPersistenceUnitNameAlreadyInUseException(memberPuName, memberPuInfo, anotherMemeberPuInfo);
        }
        return memberPuInfoMap;
    }

    protected static Set<SEPersistenceUnitInfo> getCompositeMemberPuInfoSet(PersistenceUnitInfo puInfo, Map predeployProperties) {
        return new HashSet<SEPersistenceUnitInfo>(EntityManagerSetupImpl.getCompositeMemberPuInfoMap(puInfo, predeployProperties).values());
    }

    public static void throwPersistenceUnitNameAlreadyInUseException(String puName, PersistenceUnitInfo newPuInfo, PersistenceUnitInfo exsitingPuInfo) {
        String anotherPuUrl;
        String puUrl;
        try {
            puUrl = URLDecoder.decode(newPuInfo.getPersistenceUnitRootUrl().toString(), "UTF8");
            anotherPuUrl = URLDecoder.decode(exsitingPuInfo.getPersistenceUnitRootUrl().toString(), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            puUrl = newPuInfo.getPersistenceUnitRootUrl().toString();
            anotherPuUrl = exsitingPuInfo.getPersistenceUnitRootUrl().toString();
        }
        throw PersistenceUnitLoadingException.persistenceUnitNameAlreadyInUse(puName, puUrl, anotherPuUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerSetupImpl refreshMetadata(Map properties) {
        String sessionName = this.getSessionName();
        String uniqueName = this.getPersistenceUnitUniqueName();
        EntityManagerSetupImpl newSetupImpl = new EntityManagerSetupImpl(uniqueName, sessionName);
        newSetupImpl.setIsInContainerMode(this.isInContainerMode);
        newSetupImpl.enableWeaving = this.enableWeaving;
        HashMap refreshProperties = new HashMap();
        refreshProperties.putAll(this.getSession().getProperties());
        if (properties != null) {
            refreshProperties.putAll(properties);
        }
        newSetupImpl.predeploy(this.getPersistenceUnitInfo(), refreshProperties);
        if (!this.isInContainerMode) {
            newSetupImpl.predeploy(this.getPersistenceUnitInfo(), refreshProperties);
        }
        HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
        synchronized (hashMap) {
            SessionManager.getManager().getSessions().remove(sessionName, this.getSession());
            if (EntityManagerFactoryProvider.emSetupImpls.get(sessionName).equals(this)) {
                EntityManagerFactoryProvider.emSetupImpls.remove(sessionName);
            }
            this.setIsMetadataExpired(true);
            EntityManagerFactoryProvider.addEntityManagerSetupImpl(sessionName, newSetupImpl);
        }
        return newSetupImpl;
    }
}

