/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.core.ProxyAutoConfig;
import org.netbeans.core.ProxySettings;

public final class NbProxySelector
extends ProxySelector {
    private final ProxySelector original;
    private static final Logger LOG = Logger.getLogger(NbProxySelector.class.getName());
    private static Object useSystemProxies;

    private NbProxySelector(ProxySelector delegate) {
        this.original = delegate;
        LOG.fine("java.net.useSystemProxies has been set to " + NbProxySelector.useSystemProxies());
        LOG.fine("In launcher was detected netbeans.system_http_proxy: " + System.getProperty("netbeans.system_http_proxy", "N/A"));
        LOG.fine("In launcher was detected netbeans.system_socks_proxy: " + System.getProperty("netbeans.system_socks_proxy", "N/A"));
        ProxySettings.addPreferenceChangeListener(new ProxySettingsListener());
        this.copySettingsToSystem();
    }

    static ProxySelector create(ProxySelector delegate) {
        return new NbProxySelector(delegate);
    }

    static void register() {
        ProxySelector prev = ProxySelector.getDefault();
        if (prev == null) {
            LOG.warning("No default system ProxySelector was found thus NetBeans ProxySelector won't delegate on it");
        } else {
            LOG.log(Level.FINE, "Override the original ProxySelector: {0}", prev);
        }
        ProxySelector.setDefault(NbProxySelector.create(prev));
    }

    @Override
    public List<Proxy> select(URI uri) {
        List<Object> res = new ArrayList();
        int proxyType = ProxySettings.getProxyType();
        switch (proxyType) {
            case 0: {
                res = Collections.singletonList(Proxy.NO_PROXY);
                break;
            }
            case 1: {
                if (NbProxySelector.useSystemProxies()) {
                    if (this.original == null) break;
                    res = this.original.select(uri);
                    break;
                }
                String protocol = uri.getScheme();
                assert (protocol != null) : "Invalid scheme of uri " + uri + ". Scheme cannot be null!";
                if (NbProxySelector.dontUseProxy(ProxySettings.SystemProxySettings.getNonProxyHosts(), uri.getHost())) {
                    res.add(Proxy.NO_PROXY);
                    break;
                }
                if (protocol.toLowerCase(Locale.US).startsWith("http")) {
                    String ports = ProxySettings.SystemProxySettings.getHttpPort();
                    if (ports != null && ports.length() > 0 && ProxySettings.SystemProxySettings.getHttpHost().length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxySettings.SystemProxySettings.getHttpHost(), porti));
                        res.add(p);
                    }
                } else {
                    String ports = ProxySettings.SystemProxySettings.getSocksPort();
                    String hosts = ProxySettings.SystemProxySettings.getSocksHost();
                    if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(hosts, porti));
                        res.add(p);
                    }
                }
                if (this.original == null) break;
                res.addAll(this.original.select(uri));
                break;
            }
            case 2: {
                String protocol = uri.getScheme();
                assert (protocol != null) : "Invalid scheme of uri " + uri + ". Scheme cannot be null!";
                if (NbProxySelector.dontUseProxy(ProxySettings.getNonProxyHosts(), uri.getHost())) {
                    res.add(Proxy.NO_PROXY);
                    break;
                }
                if (protocol.toLowerCase(Locale.US).startsWith("http")) {
                    String hosts = ProxySettings.getHttpHost();
                    String ports = ProxySettings.getHttpPort();
                    if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hosts, porti));
                        res.add(p);
                    } else {
                        LOG.fine("Incomplete HTTP Proxy [" + hosts + "/" + ports + "] found in ProxySelector[Type: " + ProxySettings.getProxyType() + "] for uri " + uri + ". ");
                        if (this.original != null) {
                            LOG.finest("Fallback to the default ProxySelector which returns " + this.original.select(uri));
                            res.addAll(this.original.select(uri));
                        }
                    }
                } else {
                    String ports = ProxySettings.getSocksPort();
                    String hosts = ProxySettings.getSocksHost();
                    if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(hosts, porti));
                        res.add(p);
                    } else {
                        LOG.fine("Incomplete SOCKS Server [" + hosts + "/" + ports + "] found in ProxySelector[Type: " + ProxySettings.getProxyType() + "] for uri " + uri + ". ");
                        if (this.original != null) {
                            LOG.finest("Fallback to the default ProxySelector which returns " + this.original.select(uri));
                            res.addAll(this.original.select(uri));
                        }
                    }
                }
                res.add(Proxy.NO_PROXY);
                break;
            }
            case 3: {
                if (NbProxySelector.useSystemProxies()) {
                    if (this.original != null) {
                        res = this.original.select(uri);
                    }
                } else {
                    if (NbProxySelector.dontUseProxy(ProxySettings.getNonProxyHosts(), uri.getHost())) {
                        res.add(Proxy.NO_PROXY);
                        break;
                    }
                    ProxyAutoConfig pac = ProxyAutoConfig.get(NbProxySelector.getPacFile());
                    assert (pac != null) : "Instance of ProxyAutoConfig found for " + NbProxySelector.getPacFile();
                    if (pac == null) {
                        LOG.finest("No instance of ProxyAutoConfig(" + NbProxySelector.getPacFile() + ") for URI " + uri);
                        res.add(Proxy.NO_PROXY);
                    }
                    if (pac.getPacURI().getHost() == null) {
                        LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC LOCAL URI: {2}", new Object[]{uri.toString(), uri.getHost(), pac.getPacURI().toString()});
                        res.addAll(pac.findProxyForURL(uri));
                    } else if (pac.getPacURI().getHost().equals(uri.getHost())) {
                        res.add(Proxy.NO_PROXY);
                    } else {
                        LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC URI: {2}---{3}", new Object[]{uri.toString(), uri.getHost(), pac.getPacURI().toString(), pac.getPacURI().getHost()});
                        res.addAll(pac.findProxyForURL(uri));
                    }
                }
                res.add(Proxy.NO_PROXY);
                break;
            }
            case 4: {
                if (NbProxySelector.dontUseProxy(ProxySettings.getNonProxyHosts(), uri.getHost())) {
                    res.add(Proxy.NO_PROXY);
                    break;
                }
                ProxyAutoConfig pac = ProxyAutoConfig.get(NbProxySelector.getPacFile());
                assert (pac != null) : "Instance of ProxyAutoConfig found for " + NbProxySelector.getPacFile();
                if (pac == null) {
                    LOG.finest("No instance of ProxyAutoConfig(" + NbProxySelector.getPacFile() + ") for URI " + uri);
                    res.add(Proxy.NO_PROXY);
                }
                if (pac.getPacURI().getHost() == null) {
                    LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC LOCAL URI: {2}", new Object[]{uri.toString(), uri.getHost(), pac.getPacURI().toString()});
                    res.addAll(pac.findProxyForURL(uri));
                } else if (pac.getPacURI().getHost().equals(uri.getHost())) {
                    res.add(Proxy.NO_PROXY);
                } else {
                    LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC URI: {2}---{3}", new Object[]{uri.toString(), uri.getHost(), pac.getPacURI().toString(), pac.getPacURI().getHost()});
                    res.addAll(pac.findProxyForURL(uri));
                }
                res.add(Proxy.NO_PROXY);
                break;
            }
            default: {
                assert (false) : "Invalid proxy type: " + proxyType;
                break;
            }
        }
        LOG.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + ", Use HTTP for all protocols: " + ProxySettings.useProxyAllProtocols() + "] returns " + res + " for URI " + uri);
        return res;
    }

    @Override
    public void connectFailed(URI arg0, SocketAddress arg1, IOException arg2) {
        LOG.log(Level.INFO, "connectionFailed(" + arg0 + ", " + arg1 + ")", arg2);
    }

    private void copySettingsToSystem() {
        String host = null;
        String port = null;
        String nonProxyHosts = null;
        String sHost = null;
        String sPort = null;
        String httpsHost = null;
        String httpsPort = null;
        int proxyType = ProxySettings.getProxyType();
        switch (proxyType) {
            case 0: {
                host = null;
                port = null;
                httpsHost = null;
                httpsPort = null;
                nonProxyHosts = null;
                sHost = null;
                sPort = null;
                break;
            }
            case 1: {
                host = ProxySettings.SystemProxySettings.getHttpHost();
                port = ProxySettings.SystemProxySettings.getHttpPort();
                httpsHost = ProxySettings.SystemProxySettings.getHttpsHost();
                httpsPort = ProxySettings.SystemProxySettings.getHttpsPort();
                sHost = ProxySettings.SystemProxySettings.getSocksHost();
                sPort = ProxySettings.SystemProxySettings.getSocksPort();
                ProxySettings.SystemProxySettings.getNonProxyHosts();
                break;
            }
            case 2: {
                host = ProxySettings.getHttpHost();
                port = ProxySettings.getHttpPort();
                httpsHost = ProxySettings.getHttpsHost();
                httpsPort = ProxySettings.getHttpsPort();
                nonProxyHosts = ProxySettings.getNonProxyHosts();
                sHost = ProxySettings.getSocksHost();
                sPort = ProxySettings.getSocksPort();
                break;
            }
            case 3: {
                host = null;
                port = null;
                httpsHost = null;
                httpsPort = null;
                ProxySettings.SystemProxySettings.getNonProxyHosts();
                sHost = null;
                sPort = null;
                break;
            }
            case 4: {
                host = null;
                port = null;
                httpsHost = null;
                httpsPort = null;
                ProxySettings.getNonProxyHosts();
                sHost = null;
                sPort = null;
                break;
            }
            default: {
                assert (false) : "Invalid proxy type: " + proxyType;
                break;
            }
        }
        this.setOrClearProperty("http.proxyHost", host, false);
        this.setOrClearProperty("http.proxyPort", port, true);
        this.setOrClearProperty("http.nonProxyHosts", nonProxyHosts, false);
        this.setOrClearProperty("https.proxyHost", httpsHost, false);
        this.setOrClearProperty("https.proxyPort", httpsPort, true);
        this.setOrClearProperty("https.nonProxyHosts", nonProxyHosts, false);
        this.setOrClearProperty("socksProxyHost", sHost, false);
        this.setOrClearProperty("socksProxyPort", sPort, true);
        LOG.fine("Set System's http.proxyHost/Port/NonProxyHost to " + host + "/" + port + "/" + nonProxyHosts);
        LOG.fine("Set System's https.proxyHost/Port to " + httpsHost + "/" + httpsPort);
        LOG.fine("Set System's socksProxyHost/Port to " + sHost + "/" + sPort);
    }

    private void setOrClearProperty(String key, String value, boolean isInteger) {
        assert (key != null);
        if (value == null || value.length() == 0) {
            System.clearProperty(key);
        } else {
            if (isInteger) {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.INFO, nfe.getMessage(), nfe);
                }
            }
            System.setProperty(key, value);
        }
    }

    static boolean dontUseProxy(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        if (NbProxySelector.dontUseIp(nonProxyHosts, host)) {
            return true;
        }
        return NbProxySelector.dontUseHostName(nonProxyHosts, host);
    }

    private static boolean dontUseHostName(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        boolean dontUseProxy = false;
        StringTokenizer st = new StringTokenizer(nonProxyHosts, "|", false);
        while (st.hasMoreTokens() && !dontUseProxy) {
            String token = st.nextToken().trim();
            int star = token.indexOf("*");
            if (star == -1) {
                dontUseProxy = token.equals(host);
                if (!dontUseProxy) continue;
                LOG.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host " + host + " found in nonProxyHosts: " + nonProxyHosts);
                continue;
            }
            String start = token.substring(0, star - 1 < 0 ? 0 : star - 1);
            String end = token.substring(star + 1 > token.length() ? token.length() : star + 1);
            boolean compareStart = star > 0;
            boolean compareEnd = star < token.length() - 1;
            dontUseProxy = compareStart && host.startsWith(start) || compareEnd && host.endsWith(end);
            if (!dontUseProxy) continue;
            LOG.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host " + host + " found in nonProxyHosts: " + nonProxyHosts);
        }
        return dontUseProxy;
    }

    private static boolean dontUseIp(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        String ip = null;
        try {
            ip = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException ex) {
            LOG.log(Level.FINE, ex.getLocalizedMessage(), ex);
        }
        if (ip == null) {
            return false;
        }
        boolean dontUseProxy = false;
        StringTokenizer st = new StringTokenizer(nonProxyHosts, "|", false);
        while (st.hasMoreTokens() && !dontUseProxy) {
            String nonProxyHost = st.nextToken().trim();
            int star = nonProxyHost.indexOf("*");
            if (star == -1) {
                dontUseProxy = nonProxyHost.equals(ip);
                if (!dontUseProxy) continue;
                LOG.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host's IP " + ip + " found in nonProxyHosts: " + nonProxyHosts);
                continue;
            }
            try {
                dontUseProxy = Pattern.matches(nonProxyHost, ip);
                if (!dontUseProxy) continue;
                LOG.finest("NbProxySelector[Type: " + ProxySettings.getProxyType() + "]. Host's IP" + ip + " found in nonProxyHosts: " + nonProxyHosts);
            }
            catch (PatternSyntaxException pse) {}
        }
        return dontUseProxy;
    }

    static boolean useSystemProxies() {
        if (useSystemProxies == null) {
            try {
                Class<?> clazz = Class.forName("sun.net.NetProperties");
                Method getBoolean = clazz.getMethod("getBoolean", String.class);
                useSystemProxies = getBoolean.invoke(null, "java.net.useSystemProxies");
            }
            catch (Exception x) {
                LOG.log(Level.FINEST, "Cannot get value of java.net.useSystemProxies bacause " + x.getMessage(), x);
            }
        }
        return useSystemProxies != null && "true".equalsIgnoreCase(useSystemProxies.toString());
    }

    static boolean usePAC() {
        String s = System.getProperty("netbeans.system_http_proxy");
        boolean usePAC = s != null && s.startsWith("PAC");
        return usePAC;
    }

    private static String getPacFile() {
        String init = System.getProperty("netbeans.system_http_proxy");
        return init.substring(4).trim();
    }

    private class ProxySettingsListener
    implements PreferenceChangeListener {
        private ProxySettingsListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if (evt.getKey().startsWith("proxy") || evt.getKey().startsWith("useProxy")) {
                NbProxySelector.this.copySettingsToSystem();
            }
        }
    }
}

