/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Stamps;

final class PackageAttrsCache
implements Stamps.Updater {
    private static final String CACHE = "package-attrs.dat";
    private static final String[] EMPTY = new String[7];
    private static final Logger LOG = Logger.getLogger(PackageAttrsCache.class.getName());
    private static PackageAttrsCache packages;
    private final Map<String, String[]> cache;

    static void initialize() {
        packages = new PackageAttrsCache();
    }

    PackageAttrsCache() {
        InputStream is = Stamps.getModulesJARs().asStream(CACHE);
        HashMap<String, String[]> tmp = null;
        if (is != null) {
            try {
                String key;
                tmp = new HashMap<String, String[]>();
                DataInputStream dis = new DataInputStream(is);
                while (!(key = Stamps.readRelativePath(dis)).isEmpty()) {
                    String[] arr = new String[7];
                    for (int i = 0; i < 7; ++i) {
                        arr[i] = dis.readUTF();
                    }
                    tmp.put(key, arr);
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Cannot read package-attrs.dat", ex);
                tmp = null;
            }
        }
        if (tmp == null) {
            this.cache = new HashMap<String, String[]>();
            Stamps.getModulesJARs().scheduleSave(this, CACHE, false);
        } else {
            this.cache = Collections.unmodifiableMap(tmp);
        }
    }

    static String[] findPackageAttrs(URL src, Manifest man, String path) {
        PackageAttrsCache p = packages;
        return p == null ? PackageAttrsCache.extractFromManifest(man, path) : p.findImpl(src, man, path);
    }

    final String[] findImpl(URL src, Manifest man, String path) {
        String[] arr;
        String key = src.toExternalForm() + "!/" + path;
        if (this.cache instanceof HashSet) {
            arr = PackageAttrsCache.extractFromManifest(man, path);
            if (PackageAttrsCache.isEmpty(arr)) {
                arr = EMPTY;
            } else {
                this.cache.put(key, arr);
            }
        } else {
            arr = this.cache.get(key);
            if (arr == null) {
                arr = EMPTY;
            }
        }
        return arr;
    }

    @Override
    public void flushCaches(DataOutputStream os) throws IOException {
        for (Map.Entry<String, String[]> entry : this.cache.entrySet()) {
            Stamps.writeRelativePath(entry.getKey(), os);
            for (String s : entry.getValue()) {
                os.writeUTF(s);
            }
        }
        Stamps.writeRelativePath("", os);
    }

    @Override
    public void cacheReady() {
    }

    private static String getAttr(Attributes spec, Attributes main, Attributes.Name name) {
        String val = null;
        if (spec != null) {
            val = spec.getValue(name);
        }
        if (val == null && main != null) {
            val = main.getValue(name);
        }
        return val;
    }

    private static String[] extractFromManifest(Manifest man, String path) {
        Attributes spec = man.getAttributes(path);
        Attributes main = man.getMainAttributes();
        String[] arr = new String[]{PackageAttrsCache.getAttr(spec, main, Attributes.Name.SPECIFICATION_TITLE), PackageAttrsCache.getAttr(spec, main, Attributes.Name.SPECIFICATION_VERSION), PackageAttrsCache.getAttr(spec, main, Attributes.Name.SPECIFICATION_VENDOR), PackageAttrsCache.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_TITLE), PackageAttrsCache.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_VERSION), PackageAttrsCache.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_VENDOR), PackageAttrsCache.getAttr(spec, main, Attributes.Name.SEALED)};
        return arr;
    }

    private static boolean isEmpty(String[] arr) {
        if (arr == EMPTY) {
            return true;
        }
        for (String s : arr) {
            if (s == null) continue;
            return false;
        }
        return true;
    }
}

