/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.applemenu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ShowInFinder
implements ActionListener {
    private static final String APPLE_SCRIPT = "AppleScriptEngine";
    private static final String SCRIPT = "org/netbeans/modules/applemenu/resources/select_file.scpt";
    private static final Logger LOG = Logger.getLogger(ShowInFinder.class.getName());
    private static volatile String script;
    private final DataObject context;

    public ShowInFinder(DataObject context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        FileObject fobj = this.context.getPrimaryFile();
        if (fobj == null) {
            return;
        }
        LOG.log(Level.FINE, "Selected file: {0}", FileUtil.getFileDisplayName((FileObject)fobj));
        if (FileUtil.getArchiveFile((FileObject)fobj) != null) {
            fobj = FileUtil.getArchiveFile((FileObject)fobj);
        }
        LOG.log(Level.FINE, "File to select in Finder: {0}", FileUtil.getFileDisplayName((FileObject)fobj));
        File file = FileUtil.toFile((FileObject)fobj);
        if (file == null) {
            LOG.log(Level.INFO, "Ignoring non local file: {0}", FileUtil.getFileDisplayName((FileObject)fobj));
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ShowInFinder.class, (String)"TXT_NoLocalFile"));
            return;
        }
        File folder = file.getParentFile();
        if (folder == null) {
            LOG.log(Level.INFO, "Ignoring file with no parent: {0}", FileUtil.getFileDisplayName((FileObject)fobj));
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ShowInFinder.class, (String)"TXT_NoLocalFile"));
            return;
        }
        String _script = ShowInFinder.getScript();
        if (_script == null) {
            LOG.log(Level.INFO, "Cannot load apple scipt program");
            return;
        }
        ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (cl == null) {
            LOG.log(Level.INFO, "No ClassLoader to load AppleScriptEngine");
            return;
        }
        ScriptEngineManager scriptEngineFactory = new ScriptEngineManager(cl);
        ScriptEngine appleScriptEngine = scriptEngineFactory.getEngineByName(APPLE_SCRIPT);
        if (appleScriptEngine == null) {
            LOG.log(Level.INFO, "No AppleScriptEngine found");
            return;
        }
        try {
            appleScriptEngine.eval(MessageFormat.format(_script, folder.getAbsolutePath(), file.getAbsolutePath()));
        }
        catch (ScriptException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getScript() {
        String _script = script;
        if (_script != null) {
            return _script;
        }
        try {
            ClassLoader cl = ShowInFinder.class.getClassLoader();
            BufferedReader in = new BufferedReader(new InputStreamReader(cl.getResourceAsStream(SCRIPT), "UTF-8"));
            try {
                int len;
                StringBuilder builder = new StringBuilder();
                char[] buffer = new char[512];
                while ((len = in.read(buffer, 0, buffer.length)) > 0) {
                    builder.append(buffer, 0, len);
                }
                _script = builder.toString();
            }
            finally {
                in.close();
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        script = _script;
        return _script;
    }
}

