/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.MediaDisposer;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class LocatorCache {
    private final Map<URI, WeakReference<CacheReference>> uriCache = new HashMap<URI, WeakReference<CacheReference>>();
    private final CacheDisposer cacheDisposer = new CacheDisposer();

    public static LocatorCache locatorCache() {
        return CacheInitializer.globalInstance;
    }

    private LocatorCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheReference registerURICache(URI sourceURI, ByteBuffer data, String mimeType) {
        if (Logger.canLog(1)) {
            Logger.logMsg(1, "New cache entry: URI " + sourceURI + ", buffer " + data + ", MIME type " + mimeType);
        }
        if (!data.isDirect()) {
            data.rewind();
            ByteBuffer newData = ByteBuffer.allocateDirect(data.capacity());
            newData.put(data);
            data = newData;
        }
        CacheReference ref = new CacheReference(data, mimeType);
        Map<URI, WeakReference<CacheReference>> map = this.uriCache;
        synchronized (map) {
            this.uriCache.put(sourceURI, new WeakReference<CacheReference>(ref));
        }
        MediaDisposer.addResourceDisposer(ref, sourceURI, this.cacheDisposer);
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheReference fetchURICache(URI sourceURI) {
        Map<URI, WeakReference<CacheReference>> map = this.uriCache;
        synchronized (map) {
            WeakReference<CacheReference> ref = this.uriCache.get(sourceURI);
            if (null == ref) {
                return null;
            }
            CacheReference cacheData = (CacheReference)ref.get();
            if (null != cacheData) {
                if (Logger.canLog(1)) {
                    Logger.logMsg(1, "Fetched cache entry: URI " + sourceURI + ", buffer " + cacheData.getBuffer() + ", MIME type " + cacheData.getMIMEType());
                }
                return cacheData;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(URI sourceURI) {
        Map<URI, WeakReference<CacheReference>> map = this.uriCache;
        synchronized (map) {
            return this.uriCache.containsKey(sourceURI);
        }
    }

    private class CacheDisposer
    implements MediaDisposer.ResourceDisposer {
        private CacheDisposer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disposeResource(Object resource) {
            if (resource instanceof URI) {
                Map map = LocatorCache.this.uriCache;
                synchronized (map) {
                    LocatorCache.this.uriCache.remove((URI)resource);
                }
            }
        }
    }

    private static class CacheInitializer {
        private static final LocatorCache globalInstance = new LocatorCache();

        private CacheInitializer() {
        }
    }

    public static class CacheReference {
        private final ByteBuffer buffer;
        private String mimeType;

        public CacheReference(ByteBuffer buf, String mimeType) {
            this.buffer = buf;
            this.mimeType = mimeType;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public String getMIMEType() {
            return this.mimeType;
        }
    }
}

