/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.impl.BaseGraphics;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.shape.TesselatorImpl;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;

class TessShapeRepState {
    private static final TesselatorImpl tess = new TesselatorImpl();
    private boolean valid;
    private VertexBuffer vb;
    private int numVerts;
    private Paint lastPaint;
    private float lastExtraAlpha = -1.0f;

    TessShapeRepState() {
    }

    void invalidate() {
        this.valid = false;
        this.lastPaint = null;
        this.lastExtraAlpha = -1.0f;
    }

    void render(Graphics graphics, Shape shape, BasicStroke basicStroke, float f, float f2) {
        BaseGraphics baseGraphics = (BaseGraphics)graphics;
        Paint paint = baseGraphics.getPaint();
        float f3 = baseGraphics.getExtraAlpha();
        if (this.vb == null) {
            this.vb = graphics.getResourceFactory().createVertexBuffer(16);
        }
        boolean bl = false;
        if (!this.valid) {
            this.numVerts = this.generate(shape, basicStroke, this.vb);
            this.valid = true;
            bl = true;
        }
        if (bl || paint != this.lastPaint || f3 != this.lastExtraAlpha) {
            if (paint.getType() == Paint.Type.COLOR) {
                this.vb.setPerVertexColor((Color)paint, f3);
                this.vb.updateVertexColors(this.numVerts);
            } else {
                this.vb.setPerVertexColor(f3);
                this.vb.updateVertexColors(this.numVerts);
            }
            this.lastPaint = paint;
            this.lastExtraAlpha = f3;
        }
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (paint.isProportional()) {
            RectBounds rectBounds = shape.getBounds();
            f4 = rectBounds.getMinX();
            f5 = rectBounds.getMinY();
            f6 = rectBounds.getWidth();
            f7 = rectBounds.getHeight();
        }
        baseGraphics.translate(f, f2);
        baseGraphics.fillTriangles(this.vb, this.numVerts, f4, f5, f6, f7);
        baseGraphics.translate(-f, -f2);
    }

    private int generate(Shape shape, BasicStroke basicStroke, VertexBuffer vertexBuffer) {
        if (basicStroke != null) {
            shape = basicStroke.createStrokedShape(shape);
        }
        vertexBuffer.rewind();
        return tess.generate(shape, vertexBuffer);
    }
}

