/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class AnchorPane
extends Pane {
    private static final String TOP_ANCHOR = "pane-top-anchor";
    private static final String LEFT_ANCHOR = "pane-left-anchor";
    private static final String BOTTOM_ANCHOR = "pane-bottom-anchor";
    private static final String RIGHT_ANCHOR = "pane-right-anchor";

    public static void setTopAnchor(Node node, Double d) {
        AnchorPane.setConstraint(node, TOP_ANCHOR, d);
    }

    public static Double getTopAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, TOP_ANCHOR);
    }

    public static void setLeftAnchor(Node node, Double d) {
        AnchorPane.setConstraint(node, LEFT_ANCHOR, d);
    }

    public static Double getLeftAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, LEFT_ANCHOR);
    }

    public static void setBottomAnchor(Node node, Double d) {
        AnchorPane.setConstraint(node, BOTTOM_ANCHOR, d);
    }

    public static Double getBottomAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, BOTTOM_ANCHOR);
    }

    public static void setRightAnchor(Node node, Double d) {
        AnchorPane.setConstraint(node, RIGHT_ANCHOR, d);
    }

    public static Double getRightAnchor(Node node) {
        return (Double)AnchorPane.getConstraint(node, RIGHT_ANCHOR);
    }

    public static void clearConstraints(Node node) {
        AnchorPane.setTopAnchor(node, null);
        AnchorPane.setRightAnchor(node, null);
        AnchorPane.setBottomAnchor(node, null);
        AnchorPane.setLeftAnchor(node, null);
    }

    @Override
    protected double computeMinWidth(double d) {
        return this.computeWidth(true, d);
    }

    @Override
    protected double computeMinHeight(double d) {
        return this.computeHeight(true, d);
    }

    @Override
    protected double computePrefWidth(double d) {
        return this.computeWidth(false, d);
    }

    @Override
    protected double computePrefHeight(double d) {
        return this.computeHeight(false, d);
    }

    private double computeWidth(boolean bl, double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.getChildren().size(); ++i) {
            double d3;
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged()) continue;
            Double d4 = AnchorPane.getLeftAnchor(node);
            Double d5 = AnchorPane.getRightAnchor(node);
            double d6 = d4 != null ? d4 : (d5 != null ? 0.0 : node.getLayoutBounds().getMinX() + node.getLayoutX());
            double d7 = d3 = d5 != null ? d5 : 0.0;
            if (node.getContentBias() == Orientation.VERTICAL) {
                d = bl ? node.minHeight(-1.0) : node.prefHeight(-1.0);
            }
            d2 = Math.max(d2, d6 + (bl ? node.minWidth(d) : node.prefWidth(d)) + d3);
        }
        return this.getInsets().getLeft() + d2 + this.getInsets().getRight();
    }

    private double computeHeight(boolean bl, double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.getChildren().size(); ++i) {
            double d3;
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged()) continue;
            Double d4 = AnchorPane.getTopAnchor(node);
            Double d5 = AnchorPane.getBottomAnchor(node);
            double d6 = d4 != null ? d4 : (d5 != null ? 0.0 : node.getLayoutBounds().getMinY() + node.getLayoutY());
            double d7 = d3 = d5 != null ? d5 : 0.0;
            if (node.getContentBias() == Orientation.HORIZONTAL) {
                d = bl ? node.minWidth(-1.0) : node.prefWidth(-1.0);
            }
            d2 = Math.max(d2, d6 + (bl ? node.minHeight(d) : node.prefHeight(d)) + d3);
        }
        return this.getInsets().getTop() + d2 + this.getInsets().getBottom();
    }

    private double computeChildWidth(Node node, Double d, Double d2, double d3) {
        if (d != null && d2 != null && node.isResizable()) {
            return this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight() - d - d2;
        }
        return this.computeChildPrefAreaWidth(node, Insets.EMPTY, d3);
    }

    private double computeChildHeight(Node node, Double d, Double d2, double d3) {
        if (d != null && d2 != null && node.isResizable()) {
            return this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom() - d - d2;
        }
        return this.computeChildPrefAreaHeight(node, Insets.EMPTY, d3);
    }

    @Override
    protected void layoutChildren() {
        Insets insets = this.getInsets();
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged()) continue;
            Double d = AnchorPane.getTopAnchor(node);
            Double d2 = AnchorPane.getBottomAnchor(node);
            Double d3 = AnchorPane.getLeftAnchor(node);
            Double d4 = AnchorPane.getRightAnchor(node);
            double d5 = node.getLayoutX() + node.getLayoutBounds().getMinX();
            double d6 = node.getLayoutY() + node.getLayoutBounds().getMinY();
            double d7 = -1.0;
            double d8 = -1.0;
            Orientation orientation = node.getContentBias();
            if (orientation == Orientation.VERTICAL) {
                d8 = this.computeChildHeight(node, d, d2, -1.0);
                d7 = this.computeChildWidth(node, d3, d4, d8);
            } else if (orientation == Orientation.HORIZONTAL) {
                d7 = this.computeChildWidth(node, d3, d4, -1.0);
                d8 = this.computeChildHeight(node, d, d2, d7);
            } else {
                d7 = this.computeChildWidth(node, d3, d4, -1.0);
                d8 = this.computeChildHeight(node, d, d2, -1.0);
            }
            if (d3 != null) {
                d5 = insets.getLeft() + d3;
            } else if (d4 != null) {
                d5 = this.getWidth() - insets.getRight() - d4 - d7;
            }
            if (d != null) {
                d6 = insets.getTop() + d;
            } else if (d2 != null) {
                d6 = this.getHeight() - insets.getBottom() - d2 - d8;
            }
            node.resizeRelocate(d5, d6, d7, d8);
        }
    }
}

