/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObjectLines;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.ListenerList;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.RecursiveListener;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;

public abstract class FileObject
implements Serializable {
    public static final String DEFAULT_LINE_SEPARATOR_ATTR = "default-line-separator";
    static final long serialVersionUID = 85305031923497718L;
    static final String REMOVE_WRITABLES_ATTR = "removeWritables";

    public abstract String getName();

    public abstract String getExt();

    public abstract void rename(FileLock var1, String var2, String var3) throws IOException;

    public FileObject copy(FileObject target, String name, String ext) throws IOException {
        if (this.isFolder()) {
            FileObject peer = target.createFolder(name);
            FileUtil.copyAttributes(this, peer);
            for (FileObject fo : this.getChildren()) {
                fo.copy(peer, fo.getName(), fo.getExt());
            }
            return peer;
        }
        FileObject dest = FileUtil.copyFileImpl(this, target, name, ext);
        return dest;
    }

    public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
        if (this.getParent().equals(target)) {
            this.rename(lock, name, ext);
            return this;
        }
        FileObject dest = this.copy(target, name, ext);
        this.delete(lock);
        return dest;
    }

    public String toString() {
        String cname = this.getClass().getName();
        String cnameShort = cname.substring(cname.lastIndexOf(46) + 1);
        try {
            return cnameShort + '@' + Integer.toHexString(System.identityHashCode(this)) + '[' + (this.isRoot() ? "root of " + this.getFileSystem() : this.getPath()) + ']';
        }
        catch (FileStateInvalidException x) {
            return cnameShort + '@' + Integer.toHexString(System.identityHashCode(this)) + "[???]";
        }
    }

    public String getPath() {
        StringBuilder[] buf = new StringBuilder[]{null};
        this.constructName(buf, '/', 0);
        return buf[0].toString();
    }

    @Deprecated
    public String getPackageNameExt(char separatorChar, char extSepChar) {
        assert (false) : "Deprecated.";
        if (this.isRoot() || this.getParent().isRoot()) {
            return this.getNameExt();
        }
        StringBuilder[] arr = new StringBuilder[1];
        this.getParent().constructName(arr, separatorChar, 50);
        String ext = this.getExt();
        if (ext == null || ext.equals("")) {
            arr[0].append(separatorChar).append(this.getNameExt());
        } else {
            arr[0].append(separatorChar).append(this.getName()).append(extSepChar).append(this.getExt());
        }
        return arr[0].toString();
    }

    @Deprecated
    public String getPackageName(char separatorChar) {
        assert (false) : "Deprecated.";
        if (this.isRoot() || this.getParent().isRoot()) {
            return this.isFolder() ? this.getNameExt() : this.getName();
        }
        StringBuilder[] arr = new StringBuilder[1];
        String name = this.getName();
        this.getParent().constructName(arr, separatorChar, name.length());
        arr[0].append(separatorChar).append(name);
        return arr[0].toString();
    }

    public String getNameExt() {
        String n = this.getName();
        String e = this.getExt();
        return e == null || e.length() == 0 ? n : n + '.' + e;
    }

    private void constructName(StringBuilder[] arr, char sepChar, int lengthSoFar) {
        String myName = this.getNameExt();
        int myLen = lengthSoFar + myName.length();
        FileObject parent = this.getParent();
        if (parent != null && !parent.isRoot()) {
            parent.constructName(arr, sepChar, myLen + 1);
            arr[0].append(sepChar);
        } else {
            assert (arr[0] == null);
            arr[0] = new StringBuilder(myLen);
        }
        arr[0].append(this.getNameExt());
    }

    public abstract FileSystem getFileSystem() throws FileStateInvalidException;

    public abstract FileObject getParent();

    public abstract boolean isFolder();

    public abstract Date lastModified();

    public abstract boolean isRoot();

    public abstract boolean isData();

    public abstract boolean isValid();

    public boolean existsExt(String ext) {
        FileObject parent = this.getParent();
        return parent != null && parent.getFileObject(this.getName(), ext) != null;
    }

    public abstract void delete(FileLock var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete() throws IOException {
        FileLock lock = this.lock();
        try {
            this.delete(lock);
        }
        finally {
            lock.releaseLock();
        }
    }

    public abstract Object getAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2) throws IOException;

    public abstract Enumeration<String> getAttributes();

    public final boolean hasExt(String ext) {
        if (this.isHasExtOverride()) {
            return this.hasExtOverride(ext);
        }
        return this.getExt().equals(ext);
    }

    boolean isHasExtOverride() {
        return false;
    }

    boolean hasExtOverride(String ext) {
        return false;
    }

    public abstract void addFileChangeListener(FileChangeListener var1);

    public abstract void removeFileChangeListener(FileChangeListener var1);

    public void addRecursiveListener(FileChangeListener fcl) {
        if (!this.isFolder()) {
            this.addFileChangeListener(fcl);
            return;
        }
        try {
            boolean allowsExternalChanges = this.getFileSystem() instanceof LocalFileSystem;
            this.getFileSystem().addFileChangeListener(new RecursiveListener(this, fcl, allowsExternalChanges));
        }
        catch (FileStateInvalidException ex) {
            ExternalUtil.LOG.log(Level.FINE, "Cannot remove listener from " + this, ex);
        }
    }

    public void removeRecursiveListener(FileChangeListener fcl) {
        if (!this.isFolder()) {
            this.removeFileChangeListener(fcl);
            return;
        }
        try {
            this.getFileSystem().removeFileChangeListener(new RecursiveListener(this, fcl, false));
        }
        catch (FileStateInvalidException ex) {
            ExternalUtil.LOG.log(Level.FINE, "Cannot remove listener from " + this, ex);
        }
    }

    protected void fireFileDataCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.dispatchEvent(FCLSupport.Op.DATA_CREATED, en, fe);
    }

    protected void fireFileFolderCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.dispatchEvent(FCLSupport.Op.FOLDER_CREATED, en, fe);
    }

    protected void fireFileChangedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.dispatchEvent(FCLSupport.Op.FILE_CHANGED, en, fe);
    }

    protected void fireFileDeletedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        this.dispatchEvent(FCLSupport.Op.FILE_DELETED, en, fe);
    }

    protected void fireFileAttributeChangedEvent(Enumeration<FileChangeListener> en, FileAttributeEvent fe) {
        this.dispatchEvent(FCLSupport.Op.ATTR_CHANGED, en, fe);
    }

    protected void fireFileRenamedEvent(Enumeration<FileChangeListener> en, FileRenameEvent fe) {
        this.dispatchEvent(FCLSupport.Op.FILE_RENAMED, en, fe);
    }

    private void dispatchEvent(FCLSupport.Op op, Enumeration<FileChangeListener> en, FileEvent fe) {
        try {
            FileSystem fs = this.getFileSystem();
            fs.dispatchEvent(new ED(op, en, fe));
        }
        catch (FileStateInvalidException ex) {
            // empty catch block
        }
    }

    final void dispatchEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
        try {
            this.getFileSystem().dispatchEvent(new ED(en, fe));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public String getMIMEType() {
        String mimeType = FileUtil.getMIMEType(this);
        return mimeType == null ? "content/unknown" : mimeType;
    }

    public String getMIMEType(String ... withinMIMETypes) {
        return FileUtil.getMIMEType(this, withinMIMETypes);
    }

    public abstract long getSize();

    public abstract InputStream getInputStream() throws FileNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] asBytes() throws IOException {
        long len = this.getSize();
        if (len > Integer.MAX_VALUE) {
            throw new IOException("Too big file " + this.getPath());
        }
        InputStream is = this.getInputStream();
        try {
            int pos;
            int read;
            byte[] arr = new byte[(int)len];
            for (pos = 0; pos < arr.length && (read = is.read(arr, pos, arr.length - pos)) != -1; pos += read) {
            }
            if (pos != arr.length) {
                throw new IOException("Just " + pos + " bytes read from " + this.getPath());
            }
            byte[] byArray = arr;
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public String asText(String encoding) throws IOException {
        return new String(this.asBytes(), encoding);
    }

    public String asText() throws IOException {
        return this.asText(Charset.defaultCharset().name());
    }

    public List<String> asLines() throws IOException {
        return this.asLines(Charset.defaultCharset().name());
    }

    public List<String> asLines(String encoding) throws IOException {
        return new FileObjectLines(encoding, this);
    }

    public abstract OutputStream getOutputStream(FileLock var1) throws IOException;

    public final OutputStream getOutputStream() throws FileAlreadyLockedException, IOException {
        final FileLock lock = this.lock();
        try {
            final OutputStream os = this.getOutputStream(lock);
            return new FilterOutputStream(os){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    os.write(b, off, len);
                }

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                        lock.releaseLock();
                    }
                    catch (IOException iex) {
                        if (lock.isValid()) {
                            lock.releaseLock();
                        }
                        throw iex;
                    }
                }
            };
        }
        catch (IOException iex) {
            if (lock.isValid()) {
                lock.releaseLock();
            }
            throw iex;
        }
    }

    public abstract FileLock lock() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        FileLock fLock = null;
        try {
            fLock = this.lock();
        }
        catch (FileAlreadyLockedException fax) {
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fLock != null) {
                fLock.releaseLock();
            }
        }
        return fLock == null;
    }

    @Deprecated
    public abstract void setImportant(boolean var1);

    public abstract FileObject[] getChildren();

    public Enumeration<? extends FileObject> getChildren(final boolean rec) {
        class WithChildren
        implements Enumerations.Processor<FileObject, FileObject> {
            WithChildren() {
            }

            public FileObject process(FileObject fo, Collection<FileObject> toAdd) {
                if (rec && fo.isFolder()) {
                    toAdd.addAll(Arrays.asList(fo.getChildren()));
                }
                return fo;
            }
        }
        return Enumerations.queue((Enumeration)Enumerations.array((Object[])this.getChildren()), (Enumerations.Processor)new WithChildren());
    }

    public Enumeration<? extends FileObject> getFolders(boolean rec) {
        return Enumerations.filter(this.getChildren(rec), (Enumerations.Processor)new OnlyFolders(true));
    }

    public Enumeration<? extends FileObject> getData(boolean rec) {
        return Enumerations.filter(this.getChildren(rec), (Enumerations.Processor)new OnlyFolders(false));
    }

    public abstract FileObject getFileObject(String var1, String var2);

    public FileObject getFileObject(String relativePath) {
        if (relativePath.startsWith("/") && !relativePath.startsWith("//")) {
            relativePath = relativePath.substring(1);
        }
        FileObject myObj = this;
        StringTokenizer st = new StringTokenizer(relativePath, "/");
        if (relativePath.startsWith("//")) {
            myObj = myObj.getFileObject("//" + st.nextToken() + "/" + st.nextToken(), null);
        }
        while (myObj != null && st.hasMoreTokens()) {
            String nameExt = st.nextToken();
            if (nameExt.equals("..")) {
                myObj = myObj.getParent();
                continue;
            }
            if (nameExt.equals(".")) continue;
            myObj = myObj.getFileObject(nameExt, null);
        }
        return myObj;
    }

    public abstract FileObject createFolder(String var1) throws IOException;

    public abstract FileObject createData(String var1, String var2) throws IOException;

    public FileObject createData(String name) throws IOException {
        return this.createData(name, "");
    }

    public OutputStream createAndOpen(final String name) throws IOException {
        class R
        implements FileSystem.AsyncAtomicAction {
            OutputStream os;

            R() {
            }

            @Override
            public void run() throws IOException {
                FileObject fo = FileObject.this.createData(name);
                this.os = fo.getOutputStream();
            }

            @Override
            public boolean isAsynchronous() {
                return true;
            }
        }
        R r = new R();
        this.getFileSystem().runAtomicAction(r);
        return r.os;
    }

    @Deprecated
    public abstract boolean isReadOnly();

    public boolean canWrite() {
        File f = FileUtil.toFile(this);
        if (f != null) {
            return f.canWrite();
        }
        return !this.isReadOnly();
    }

    public boolean canRead() {
        File f = FileUtil.toFile(this);
        if (f != null) {
            return f.canRead();
        }
        return true;
    }

    public final boolean canRevert() {
        return this.getAttribute(REMOVE_WRITABLES_ATTR) instanceof Callable;
    }

    public final void revert() throws IOException {
        Object v = this.getAttribute(REMOVE_WRITABLES_ATTR);
        if (v instanceof Callable) {
            try {
                ((Callable)v).call();
            }
            catch (IOException x) {
                throw x;
            }
            catch (Exception x) {
                throw new IOException(x);
            }
        }
    }

    public void refresh(boolean expected) {
    }

    public void refresh() {
        this.refresh(false);
    }

    @Deprecated
    public final URL getURL() throws FileStateInvalidException {
        return this.toURL();
    }

    public final URL toURL() {
        return URLMapper.findURL(this, 0);
    }

    public final URI toURI() {
        try {
            URI uri = this.toURL().toURI();
            assert (uri.isAbsolute()) : uri;
            assert (uri.equals(uri.normalize())) : uri + " from " + this;
            return uri;
        }
        catch (URISyntaxException x) {
            throw new IllegalStateException(x);
        }
    }

    public boolean isVirtual() {
        return false;
    }

    static boolean isPriorityListener(FileChangeListener fcl) {
        return fcl instanceof PriorityFileChangeListener;
    }

    private static class ED
    extends FileSystem.EventDispatcher {
        private FCLSupport.Op op;
        private Enumeration<FileChangeListener> en;
        private final List<FileChangeListener> fsList;
        private final List<FileChangeListener> repList;
        private FileEvent fe;

        public ED(FCLSupport.Op op, Enumeration<FileChangeListener> en, FileEvent fe) {
            this.op = op;
            this.en = en;
            this.fe = fe;
            FileSystem fs = null;
            try {
                fs = this.fe.getFile().getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                ExternalUtil.exception(ex);
            }
            ListenerList<FileChangeListener> fsll = fs != null ? fs.getFCLSupport().listeners : null;
            ListenerList<FileChangeListener> repll = fs != null && fs.getRepository() != null ? fs.getRepository().getFCLSupport().listeners : null;
            this.fsList = ListenerList.allListeners(fsll);
            this.repList = ListenerList.allListeners(repll);
        }

        public ED(Enumeration<FileChangeListener> en, FileEvent fe) {
            this(null, en, fe);
        }

        @Override
        protected void dispatch(boolean onlyPriority, Collection<Runnable> postNotify) {
            if (this.op == null) {
                this.op = this.fe.getFile().isFolder() ? FCLSupport.Op.FOLDER_CREATED : FCLSupport.Op.DATA_CREATED;
            }
            LinkedList<FileChangeListener> newEnum = new LinkedList<FileChangeListener>();
            while (this.en.hasMoreElements()) {
                FileChangeListener fcl = this.en.nextElement();
                if (onlyPriority && !FileObject.isPriorityListener(fcl)) {
                    newEnum.add(fcl);
                    continue;
                }
                FCLSupport.dispatchEvent(fcl, this.fe, this.op, postNotify);
            }
            if (onlyPriority) {
                this.en = Collections.enumeration(newEnum);
            }
            FileObject fo = this.fe.getFile();
            boolean transmit = false;
            if (fo != null) {
                switch (this.op) {
                    case FILE_CHANGED: {
                        transmit = fo.equals(this.fe.getSource());
                        break;
                    }
                    default: {
                        boolean bl = transmit = !fo.equals(this.fe.getSource());
                        if (transmit || !(this.fe instanceof Enumeration) || ((Enumeration)((Object)this.fe)).hasMoreElements()) break;
                        transmit = true;
                    }
                }
            }
            if (!this.en.hasMoreElements() && transmit && !onlyPriority) {
                FileSystem fs = null;
                Repository rep = null;
                try {
                    fs = this.fe.getFile().getFileSystem();
                    rep = fs.getRepository();
                }
                catch (FileStateInvalidException fsix) {
                    return;
                }
                if (fs != null && this.fsList != null) {
                    for (FileChangeListener fcl : this.fsList) {
                        FCLSupport.dispatchEvent(fcl, this.fe, this.op, postNotify);
                    }
                }
                if (rep != null && this.repList != null) {
                    for (FileChangeListener fcl : this.repList) {
                        FCLSupport.dispatchEvent(fcl, this.fe, this.op, postNotify);
                    }
                }
            }
        }

        @Override
        protected void setAtomicActionLink(EventControl.AtomicActionLink propID) {
            this.fe.setAtomicActionLink(propID);
        }
    }

    private static final class OnlyFolders
    implements Enumerations.Processor<FileObject, FileObject> {
        private boolean folders;

        public OnlyFolders(boolean folders) {
            this.folders = folders;
        }

        public FileObject process(FileObject obj, Collection<FileObject> coll) {
            FileObject fo = obj;
            if (this.folders) {
                return fo.isFolder() ? fo : null;
            }
            return fo.isData() ? fo : null;
        }
    }

    static interface PriorityFileChangeListener
    extends FileChangeListener {
    }
}

