/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

final class IntListSimple {
    private int[] array;
    private int used = 0;

    IntListSimple(int capacity) {
        this.array = new int[capacity];
    }

    public synchronized void add(int value) {
        if (this.used >= this.array.length) {
            this.growArray();
        }
        this.array[this.used++] = value;
    }

    public synchronized int get(int index) {
        if (index >= this.used) {
            throw new ArrayIndexOutOfBoundsException("List contains " + this.used + " items, but tried to fetch item " + index);
        }
        return this.array[index];
    }

    public synchronized int size() {
        return this.used;
    }

    private void growArray() {
        int[] old = this.array;
        this.array = new int[Math.round((float)this.array.length * 1.5f)];
        System.arraycopy(old, 0, this.array, 0, old.length);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("IntListSimple [");
        for (int i = 0; i < this.used; ++i) {
            result.append(i);
            result.append(':');
            result.append(this.array[i]);
            if (i == this.used - 1) continue;
            result.append(',');
        }
        result.append(']');
        return result.toString();
    }
}

