/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import sun.security.jca.GetInstance;

public abstract class TransformService
implements Transform {
    private String algorithm;
    private String mechanism;
    private Provider provider;

    protected TransformService() {
    }

    public static TransformService getInstance(String string, String string2) throws NoSuchAlgorithmException {
        if (string2 == null || string == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        if (string2.equals("DOM")) {
            bl = true;
        }
        List<Provider.Service> list = GetInstance.getServices("TransformService", string);
        for (Provider.Service service : list) {
            String string3 = service.getAttribute("MechanismType");
            if ((string3 != null || !bl) && (string3 == null || !string3.equals(string2))) continue;
            GetInstance.Instance instance = GetInstance.getInstance(service, null);
            TransformService transformService = (TransformService)instance.impl;
            transformService.algorithm = string;
            transformService.mechanism = string2;
            transformService.provider = instance.provider;
            return transformService;
        }
        throw new NoSuchAlgorithmException(string + " algorithm and " + string2 + " mechanism not available");
    }

    public static TransformService getInstance(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        Provider.Service service;
        String string3;
        if (string2 == null || string == null || provider == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        if (string2.equals("DOM")) {
            bl = true;
        }
        if ((string3 = (service = GetInstance.getService("TransformService", string, provider)).getAttribute("MechanismType")) == null && bl || string3 != null && string3.equals(string2)) {
            GetInstance.Instance instance = GetInstance.getInstance(service, null);
            TransformService transformService = (TransformService)instance.impl;
            transformService.algorithm = string;
            transformService.mechanism = string2;
            transformService.provider = instance.provider;
            return transformService;
        }
        throw new NoSuchAlgorithmException(string + " algorithm and " + string2 + " mechanism not available");
    }

    public static TransformService getInstance(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider.Service service;
        String string4;
        if (string2 == null || string == null || string3 == null) {
            throw new NullPointerException();
        }
        if (string3.length() == 0) {
            throw new NoSuchProviderException();
        }
        boolean bl = false;
        if (string2.equals("DOM")) {
            bl = true;
        }
        if ((string4 = (service = GetInstance.getService("TransformService", string, string3)).getAttribute("MechanismType")) == null && bl || string4 != null && string4.equals(string2)) {
            GetInstance.Instance instance = GetInstance.getInstance(service, null);
            TransformService transformService = (TransformService)instance.impl;
            transformService.algorithm = string;
            transformService.mechanism = string2;
            transformService.provider = instance.provider;
            return transformService;
        }
        throw new NoSuchAlgorithmException(string + " algorithm and " + string2 + " mechanism not available");
    }

    public final String getMechanismType() {
        return this.mechanism;
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract void init(TransformParameterSpec var1) throws InvalidAlgorithmParameterException;

    public abstract void marshalParams(XMLStructure var1, XMLCryptoContext var2) throws MarshalException;

    public abstract void init(XMLStructure var1, XMLCryptoContext var2) throws InvalidAlgorithmParameterException;

    private static class MechanismMapEntry
    implements Map.Entry {
        private final String mechanism;
        private final String algorithm;
        private final String key;

        MechanismMapEntry(String string, String string2) {
            this.algorithm = string;
            this.mechanism = string2;
            this.key = "TransformService." + string + " MechanismType";
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.mechanism;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

