/*
 * Decompiled with CFR 0.152.
 */
package org.shop.tools;

import demo.Exposure;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.shop.tools.CustomerRootNode;
import org.shop.tools.EntityService;
import org.shop.tools.ExposureChildFactory;

public class Transfer
extends JFrame
implements ExplorerManager.Provider,
PropertyChangeListener {
    private static ExplorerManager em = new ExplorerManager();
    private static String RootName = "Root";
    Integer client;
    Integer polnum;
    List<Exposure> resultList;
    String PU;
    String[] prop3 = new String[]{"policynumber", "clientname", "pdata2", "pdata1", "underwriter"};
    Integer[] proptarget = new Integer[]{1, 3, 2, 14, 15};
    JTable table;
    Integer selectedRow = 0;
    Integer index = 0;
    public JComboBox Record;
    JButton bClose;
    JButton bReset;
    JButton bTarget;
    JButton bTransfer;
    private JLabel jLabel15;
    private JLabel jLabel17;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JPanel jp;
    public JLabel lbRecord;
    private JTable tab;

    public Transfer(String pu, Integer clnt, JTable tab) {
        this.initComponents();
        this.setTitle("Transfer Tool");
        this.table = tab;
        this.PU = pu;
        this.client = clnt;
        this.bClose.addActionListener(new ExposureListener());
        this.bTransfer.addActionListener(new ExposureListener());
        this.bReset.addActionListener(new ExposureListener());
        this.bReset.setVisible(false);
        this.bTarget.setVisible(false);
        this.bTransfer.setEnabled(false);
        this.Record.setVisible(false);
        OutlineView ov = new OutlineView("Index");
        ov.setPropertyColumns(new String[]{"usersgroup", "Version", "policynumber", "<html>Quote<br>Number</html>", "clientname", "<html>Client<br>Name</html>", "pdata2", "<html>Received<br>Date</html>", "pdata1", "<html>Effective<br>Date</html>", "underwriter", "<html>Fleet<br>Premium</html>"});
        ov.getOutline().removeColumn(ov.getOutline().getColumnModel().getColumn(0));
        Integer cnt = ov.getOutline().getColumnCount();
        TableColumnModel mc = ov.getOutline().getColumnModel();
        for (int i = 0; i < cnt; ++i) {
            mc.getColumn(i).setHeaderRenderer(new HeaderRenderer(new JTable(), 0));
            mc.getColumn(i).setCellRenderer(new numRenderer2((Integer)4));
        }
        ov.getOutline().setRootVisible(false);
        ov.getOutline().setFullyNonEditable(true);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.add((Component)ov, "Center");
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        this.resultList = entityManager.createNamedQuery("Exposure").setParameter("client", (Object)this.client).getResultList();
        SimpleDateFormat formatter = new SimpleDateFormat("MMMM d, yyyy");
        SimpleDateFormat formatter2 = new SimpleDateFormat("d-MMM-yyyy");
        NumberFormat formatnum = NumberFormat.getNumberInstance();
        formatnum.setMaximumFractionDigits(0);
        formatnum.setMinimumFractionDigits(0);
        for (Exposure expo : this.resultList) {
            Float flt = this.getFloat(expo, "Ttfprm");
            String steff = this.getString(expo, "Pdata1");
            String strec = this.getString(expo, "Pdata2");
            try {
                Date dteff = formatter2.parse(steff);
                steff = formatter.format(dteff);
            }
            catch (ParseException ex) {
                System.out.print("Erroneous Date Effective: " + steff + "\n");
            }
            try {
                Date dtrec = formatter2.parse(strec);
                strec = formatter.format(dtrec);
            }
            catch (ParseException ex) {
                System.out.print("Erroneous Date Effective: " + strec + "\n");
            }
            expo.setPdata1(steff);
            expo.setPdata2(strec);
            expo.setUnderwriter(formatnum.format(flt));
            expo.setUsersgroup(this.getInteger(expo, "Version").toString());
        }
        this.initRecord(tab);
        this.refreshNode(this.resultList);
        this.jPanel2.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                double cp2gen = Transfer.this.jPanel2.getSize().getHeight();
                double cp3gen = Transfer.this.jp.getSize().getHeight();
                double room = cp2gen + cp3gen - 150.0;
                Double horiz = Transfer.this.jp.getSize().getWidth();
                int cp2ht = (int)Math.round(room > 40.0 ? room / 2.0 : 20.0);
                int cp3ht = cp2ht + 150;
                Transfer.this.jPanel2.setPreferredSize(new Dimension(horiz.intValue(), cp2ht));
                Transfer.this.jp.setPreferredSize(new Dimension(horiz.intValue(), cp3ht));
                String str = "cp2=" + Transfer.this.jPanel2.getSize().getHeight() + "/cp3=" + Transfer.this.jp.getSize().getHeight() + "/cp2ht=" + cp2ht + "/cp3ht=" + cp3ht;
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    public void initRecord(JTable table) {
        int i;
        this.Record.removeAllItems();
        System.out.println("initRecord: ");
        TableModel mod = table.getModel();
        for (int j = 0; j < mod.getRowCount(); ++j) {
            this.Record.addItem(mod.getValueAt(j, 0));
        }
        this.tab.setModel(mod);
        this.tab.setAutoCreateRowSorter(true);
        this.tab.setSelectionMode(0);
        this.tab.setRowSelectionInterval(0, 0);
        this.tab.setShowGrid(false);
        this.tab.setIntercellSpacing(new Dimension(1, 1));
        this.tab.setRowHeight(20);
        Integer[] proptargettable = new Integer[]{0, 1, 3, 2, 14, 15};
        Integer cnt = this.tab.getColumnCount();
        for (i = cnt - 1; i > -1; --i) {
            if (this.findGroup(proptargettable, i).booleanValue()) continue;
            this.tab.removeColumn(this.tab.getColumnModel().getColumn(i));
        }
        for (i = 0; i < this.tab.getColumnCount(); ++i) {
            this.tab.getTableHeader().getColumnModel().getColumn(i).setHeaderRenderer(new HeaderRenderer(new JTable(), 0));
            this.tab.getColumnModel().getColumn(i).setCellRenderer(new numRenderer3());
        }
        this.setColumnOrder(new int[]{0, 1, 3, 2, 4, 5}, this.tab.getColumnModel());
    }

    public void initRecordOld(JTable table) {
        int i;
        Object[] header = new Object[]{"<html>Record<br>Number</html>", "<html>Quote<br>Number</html>", "<html>Client<br>Name</html>", "<html>Received<br>Date</html>", "<html>Effective<br>Date</html>", "<html>Fleet<br>Premium</html>"};
        Integer[] proptargettable = new Integer[]{0, 17, 3, 2, 14, 15};
        this.Record.removeAllItems();
        System.out.println("initRecord: ");
        TableModel mod = table.getModel();
        Object[][] data = new Object[mod.getRowCount()][header.length];
        for (int j = 0; j < mod.getRowCount(); ++j) {
            this.Record.addItem(mod.getValueAt(j, 0));
            for (i = 0; i < header.length; ++i) {
                data[j][i] = mod.getValueAt(j, proptargettable[i]);
            }
        }
        DefaultTableModel tab1 = new DefaultTableModel(data, header){

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }
        };
        this.tab.removeAll();
        this.tab.setModel(tab1);
        this.tab.setAutoCreateRowSorter(true);
        for (i = 0; i < this.tab.getColumnCount(); ++i) {
            this.tab.getTableHeader().getColumnModel().getColumn(i).setHeaderRenderer(new HeaderRenderer(new JTable(), 0));
            this.tab.getColumnModel().getColumn(i).setCellRenderer(new numRenderer3());
        }
    }

    public Boolean findGroup(Integer[] arr, Integer in) {
        Boolean found = false;
        for (int i = 0; i < arr.length; ++i) {
            if (!in.equals(arr[i])) continue;
            found = true;
            break;
        }
        return found;
    }

    public void setColumnOrder(int[] indices, TableColumnModel columnModel) {
        int i;
        TableColumn[] column = new TableColumn[indices.length];
        for (i = 0; i < column.length; ++i) {
            column[i] = columnModel.getColumn(indices[i]);
        }
        while (columnModel.getColumnCount() > 0) {
            columnModel.removeColumn(columnModel.getColumn(0));
        }
        for (i = 0; i < column.length; ++i) {
            columnModel.addColumn(column[i]);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        System.out.println("getPropertyName:" + evt.getPropertyName());
        if (evt.getPropertyName().equals("selectedNodes")) {
            this.bTransfer.setEnabled(true);
            this.forceSingleSelection();
        }
    }

    public void refreshNode(List<Exposure> rl) {
        em.removePropertyChangeListener((PropertyChangeListener)this);
        CustomerRootNode crn = new CustomerRootNode(Children.create((ChildFactory)new ExposureChildFactory(rl), (boolean)true), RootName);
        em.setRootContext((Node)crn);
        em.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public ExplorerManager getExplorerManager() {
        return em;
    }

    public List<Exposure> getExposureSelectedList() {
        ArrayList<Exposure> list = new ArrayList<Exposure>();
        ArrayList<Node> selected = new ArrayList<Node>(Arrays.asList(this.getExplorerManager().getSelectedNodes()));
        for (Node node : selected) {
            Exposure b = (Exposure)((ExposureChildFactory.ExposureBeanNode)node).getmyBean();
            list.add(b);
        }
        return list;
    }

    public void forceSingleSelection() {
        Node[] nd = this.getExplorerManager().getSelectedNodes();
        if (nd.length < 2) {
            return;
        }
        final Node[] ndd = new Node[]{nd[0]};
        Timer timer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.out.println("Initializing, Firing inside timer Init");
                Transfer.this.fireAction(Transfer.this.bReset, "");
                Timer timer = new Timer(10, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        System.out.println("Initializing, Firing inside timer Init");
                        try {
                            Node[] ndarr = Transfer.this.findNode(ndd[0]);
                            Transfer.this.getExplorerManager().setSelectedNodes(ndarr);
                        }
                        catch (PropertyVetoException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public Node[] findNode(Node ndorig) {
        Node[] ndnew = new Node[1];
        this.index = 0;
        Exposure exporig = (Exposure)((ExposureChildFactory.ExposureBeanNode)ndorig).getmyBean();
        Node[] nd = em.getRootContext().getChildren().getNodes();
        for (int i = 0; i < nd.length; ++i) {
            Exposure exp;
            Node node = nd[i];
            if (!(node instanceof ExposureChildFactory.ExposureBeanNode) || !exporig.equals((Object)(exp = (Exposure)((ExposureChildFactory.ExposureBeanNode)node).getmyBean()))) continue;
            System.out.println("found node at " + i);
            ndnew[0] = nd[i];
            this.index = i;
            break;
        }
        return ndnew;
    }

    void fireAction(JButton cb, String str) {
        str = str.length() == 0 ? cb.getActionCommand() : str;
        ActionListener[] cbActions = cb.getActionListeners();
        for (int i = 0; i < cbActions.length; ++i) {
            cb.getActionListeners()[i].actionPerformed(new ActionEvent(cb, 0, str));
        }
    }

    Float getFloat(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Float in = Float.valueOf(0.0f);
        try {
            in = (Float)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Float.valueOf(in == null ? 0.0f : in.floatValue());
    }

    Integer getInteger(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Integer in = 0;
        try {
            in = (Integer)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? 0 : in;
    }

    String getString(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        String in = "";
        try {
            in = (String)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? "" : in;
    }

    void setInteger(Object obj, String name, Integer in) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        try {
            obj.getClass().getMethod("set" + p1 + p2, Integer.class).invoke(obj, in);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void setString(Object obj, String name, String in) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        try {
            obj.getClass().getMethod("set" + p1 + p2, String.class).invoke(obj, in);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    String getDate(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Date in = null;
        DateFormat df = DateFormat.getDateInstance(2, this.getLocale());
        try {
            in = (Date)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? "" : df.format(in);
    }

    Integer oi(Object obj) {
        return obj == null ? 0 : (Integer)obj;
    }

    String os(Object obj) {
        return obj == null ? "" : (String)obj;
    }

    Integer b2i(Boolean b) {
        return b != false ? 1 : 0;
    }

    Boolean i2b(Integer i) {
        return i == null ? false : i == 1;
    }

    private void initComponents() {
        this.jp = new JPanel();
        this.jLabel15 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel9 = new JLabel();
        this.bReset = new JButton();
        this.bClose = new JButton();
        this.bTransfer = new JButton();
        this.bTarget = new JButton();
        this.jLabel17 = new JLabel();
        this.lbRecord = new JLabel();
        this.Record = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.tab = new JTable();
        this.jPanel2 = new JPanel();
        this.setDefaultCloseOperation(2);
        this.jLabel15.setFont(new Font("Tahoma", 1, 14));
        this.jLabel15.setText(NbBundle.getMessage(Transfer.class, (String)"Transfer.jLabel15.text"));
        this.jLabel15.setToolTipText(NbBundle.getMessage(Transfer.class, (String)"Transfer.jLabel15.toolTipText"));
        this.jLabel9.setFont(new Font("Tahoma", 0, 18));
        this.jLabel9.setText(NbBundle.getMessage(Transfer.class, (String)"Transfer.jLabel9.text"));
        this.bReset.setText(NbBundle.getMessage(Transfer.class, (String)"Transfer.bReset.text"));
        this.bReset.setActionCommand(NbBundle.getMessage(Transfer.class, (String)"Transfer.bReset.actionCommand"));
        this.bReset.setName("bReset");
        this.bClose.setText(NbBundle.getMessage(Transfer.class, (String)"Transfer.bClose.text"));
        this.bClose.setActionCommand(NbBundle.getMessage(Transfer.class, (String)"Transfer.bClose.actionCommand"));
        this.bClose.setName("bReset");
        this.bTransfer.setText(NbBundle.getMessage(Transfer.class, (String)"Transfer.bTransfer.text"));
        this.bTransfer.setToolTipText(NbBundle.getMessage(Transfer.class, (String)"Transfer.bTransfer.toolTipText"));
        this.bTransfer.setActionCommand(NbBundle.getMessage(Transfer.class, (String)"Transfer.bTransfer.actionCommand"));
        this.bTransfer.setName("bReset");
        this.bTarget.setText(NbBundle.getMessage(Transfer.class, (String)"Transfer.bTarget.text"));
        this.bTarget.setToolTipText(NbBundle.getMessage(Transfer.class, (String)"Transfer.bTarget.toolTipText"));
        this.bTarget.setActionCommand(NbBundle.getMessage(Transfer.class, (String)"Transfer.bTarget.actionCommand"));
        this.bTarget.setName("bReset");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9, -2, 136, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 107, Short.MAX_VALUE).addComponent(this.bTransfer, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bTarget, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bReset, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bClose, -2, 109, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.bClose).addComponent(this.bReset).addComponent(this.bTransfer, -2, 23, -2).addComponent(this.bTarget, -2, 23, -2)).addGap(0, 11, Short.MAX_VALUE)));
        this.jLabel17.setFont(new Font("Tahoma", 3, 12));
        this.jLabel17.setText(NbBundle.getMessage(Transfer.class, (String)"Transfer.jLabel17.text"));
        this.jLabel17.setToolTipText(NbBundle.getMessage(Transfer.class, (String)"Transfer.jLabel17.toolTipText"));
        this.lbRecord.setFont(new Font("Tahoma", 3, 12));
        this.lbRecord.setText(NbBundle.getMessage(Transfer.class, (String)"Transfer.lbRecord.text"));
        this.lbRecord.setToolTipText(NbBundle.getMessage(Transfer.class, (String)"Transfer.lbRecord.toolTipText"));
        this.lbRecord.setName("lbRecord");
        this.Record.setModel(new DefaultComboBoxModel<String>(new String[]{"Record"}));
        this.Record.setActionCommand(NbBundle.getMessage(Transfer.class, (String)"Transfer.Record.actionCommand"));
        this.Record.setName("Record");
        this.tab.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}));
        this.jScrollPane1.setViewportView(this.tab);
        GroupLayout jpLayout = new GroupLayout(this.jp);
        this.jp.setLayout(jpLayout);
        jpLayout.setHorizontalGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpLayout.createSequentialGroup().addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpLayout.createSequentialGroup().addContainerGap().addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(jpLayout.createSequentialGroup().addComponent(this.jLabel15, -2, 204, -2).addGap(0, 0, Short.MAX_VALUE)))).addGroup(jpLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1)).addGroup(jpLayout.createSequentialGroup().addGap(50, 50, 50).addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17, -2, 217, -2).addGroup(jpLayout.createSequentialGroup().addComponent(this.lbRecord, -2, 226, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Record, -2, 73, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jpLayout.setVerticalGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.Record, -2, -1, -2).addComponent(this.lbRecord, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 118, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel17, -2, 26, -2)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 179, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jp, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jp, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Transfer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Transfer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Transfer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Transfer.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Transfer("FleetDB", 1, null).setVisible(true);
            }
        });
    }

    void creatForm() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Transfer.this.setVisible(true);
            }
        });
    }

    String entry(String str, String srch) {
        String spt = "";
        String Sep = ":";
        String[] lineSplit = (" " + str).substring(1).split(Sep, -99);
        for (int i = 0; i < lineSplit.length; ++i) {
            if (!srch.equals(lineSplit[i])) continue;
            spt = lineSplit[i + 1].trim();
            break;
        }
        return spt;
    }

    class ExposureListener
    implements ActionListener {
        ExposureListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("Reset")) {
                Transfer.this.refreshNode(Transfer.this.resultList);
            } else if (cmd.equals("Close")) {
                Transfer.this.dispose();
            } else if (cmd.equals("Transfer")) {
                Node[] nd = Transfer.this.getExplorerManager().getSelectedNodes();
                Node[] ndarr = Transfer.this.findNode(nd[0]);
                Exposure sch = Transfer.this.resultList.get(Transfer.this.index);
                int targetrow = Transfer.this.tab.convertRowIndexToModel(Transfer.this.tab.getSelectedRow());
                for (int i = 0; i < Transfer.this.prop3.length; ++i) {
                    String store = Transfer.this.getString(sch, Transfer.this.prop3[i]);
                    Transfer.this.table.setValueAt(store, targetrow, Transfer.this.proptarget[i]);
                }
            }
        }
    }

    private class HeaderRenderer
    implements TableCellRenderer {
        DefaultTableCellRenderer renderer;
        int horAlignment;

        public HeaderRenderer(JTable table, int horizontalAlignment) {
            this.horAlignment = horizontalAlignment;
            this.renderer = (DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            JLabel label = (JLabel)c;
            label.setHorizontalAlignment(this.horAlignment);
            Font fnt = label.getFont();
            label.setFont(new Font(fnt.getFontName(), 1, fnt.getSize()));
            label.setBackground(Color.darkGray);
            label.setForeground(Color.white);
            label.setToolTipText("Click to Sort Column");
            return label;
        }
    }

    public class numRenderer
    extends JLabel
    implements TableCellRenderer {
        Font fnt = this.getFont();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String val = (String)value;
            this.setText(val == null ? "" : val);
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    public class numRenderer1
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            this.setHorizontalAlignment(0);
            if (isSelected) {
                this.setBackground(Color.cyan);
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    public class numRenderer2
    extends DefaultTableCellRenderer {
        NumberFormat formatnum1;
        NumberFormat formatnum2;
        NumberFormat formatnum3;
        Integer in;
        Font fnt = this.getFont();

        public numRenderer2(Integer in) {
            this.in = in;
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                if (this.formatnum1 == null) {
                    this.formatnum1 = NumberFormat.getNumberInstance();
                    this.formatnum1.setMaximumFractionDigits(0);
                    this.formatnum1.setMinimumFractionDigits(0);
                    this.formatnum2 = NumberFormat.getNumberInstance();
                    this.formatnum2.setMaximumFractionDigits(3);
                    this.formatnum2.setMinimumFractionDigits(3);
                    this.formatnum3 = NumberFormat.getNumberInstance();
                    this.formatnum3.setMaximumFractionDigits(1);
                    this.formatnum3.setMinimumFractionDigits(1);
                }
                try {
                    if (this.in == 1) {
                        Object obj = ((PropertySupport.Reflection)value).getValue();
                        if (obj instanceof Float) {
                            Float val = (Float)((PropertySupport.Reflection)value).getValue();
                            this.setText(val == null ? "" : this.formatnum1.format(val));
                        } else {
                            String val = (String)obj;
                            this.setText(val == null ? "" : val);
                        }
                    } else if (this.in == 2) {
                        Float val = (Float)((PropertySupport.Reflection)value).getValue();
                        this.setText(val == null ? "" : this.formatnum2.format(val));
                    } else if (this.in == 3) {
                        Integer val = (Integer)((PropertySupport.Reflection)value).getValue();
                        this.setText(val == null ? "" : val.toString());
                        this.setHorizontalAlignment(2);
                    } else if (this.in == 4) {
                        String val = (String)((PropertySupport.Reflection)value).getValue();
                        this.setText(val == null ? "" : val);
                        this.setHorizontalAlignment(0);
                        this.setBorder(BorderFactory.createLineBorder(Color.black));
                    } else if (this.in == 5) {
                        Float val = (Float)((PropertySupport.Reflection)value).getValue();
                        this.setText(val == null ? "" : this.formatnum3.format(val));
                        this.setHorizontalAlignment(2);
                    }
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public class numRenderer3
    extends JTextArea
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            if (isSelected) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(Transfer.this.table.getBackground());
            }
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            return this;
        }
    }
}

