/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.ContextView;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.ui.BasicAbstractResultsPanel;
import org.netbeans.modules.search.ui.IssuesPanel;
import org.netbeans.modules.search.ui.ResultsOutlineSupport;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class BasicReplaceResultsPanel
extends BasicAbstractResultsPanel {
    private JButton replaceButton;

    public BasicReplaceResultsPanel(ResultModel resultModel, BasicComposition composition, List<FileObject> rootFiles, Node infoNode) {
        super(resultModel, composition, true, rootFiles, new ResultsOutlineSupport(true, true, resultModel, rootFiles, infoNode));
        this.init();
    }

    private void init() {
        JPanel leftPanel = new JPanel();
        this.replaceButton = new JButton();
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicReplaceResultsPanel.this.replace();
            }
        });
        this.setButtonText();
        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(3, 2, 1));
        buttonPanel.add(this.replaceButton);
        this.replaceButton.setMaximumSize(this.replaceButton.getPreferredSize());
        leftPanel.add((Component)this.resultsOutlineSupport.getOutlineView());
        leftPanel.add(buttonPanel);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setLeftComponent(leftPanel);
        splitPane.setRightComponent(new ContextView(this.resultModel, this.getExplorerManager()));
        this.getContentPanel().add(splitPane);
        this.initResultModelListener();
        this.replaceButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultView.class, (String)"ACS_TEXT_BUTTON_REPLACE"));
    }

    private void replace() {
        ReplaceTask taskReplace = new ReplaceTask(this.resultModel.getMatchingObjects(), this);
        this.resultsOutlineSupport.clean();
        this.replaceButton.setEnabled(false);
        Manager.getInstance().scheduleReplaceTask(taskReplace);
    }

    private void initResultModelListener() {
        this.resultModel.addPropertyChangeListener(new ModelListener());
    }

    private void setButtonText() {
        int matches = this.resultModel.getSelectedMatchesCount();
        this.replaceButton.setText(NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_REPLACE", (Object)matches));
        this.replaceButton.setEnabled(matches > 0);
    }

    public void displayIssuesToUser(ReplaceTask task, final String title, final String[] problems, final boolean reqAtt) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                IssuesPanel issuesPanel = new IssuesPanel(title, problems);
                if (BasicAbstractResultsPanel.isMacLaf) {
                    issuesPanel.setBackground(BasicAbstractResultsPanel.macBackground);
                }
                BasicReplaceResultsPanel.this.displayIssues(issuesPanel);
                if (!ResultView.getInstance().isOpened()) {
                    ResultView.getInstance().open();
                }
                if (reqAtt) {
                    ResultView.getInstance().requestAttention(true);
                }
            }
        });
    }

    public void displayIssues(IssuesPanel issuesPanel) {
        if (issuesPanel != null) {
            this.showRefreshButton();
            this.removeButtons(this.btnNext, this.btnPrev, this.btnFlatView, this.btnTreeView, this.btnExpand, this.showDetailsButton);
            JPanel p = this.getContentPanel();
            p.removeAll();
            p.add(issuesPanel);
            this.validate();
            this.repaint();
        }
    }

    private void removeButtons(AbstractButton ... abstractButtons) {
        for (AbstractButton ab : abstractButtons) {
            if (ab == null) continue;
            Container c = ab.getParent();
            c.remove(ab);
        }
    }

    public void rescan() {
        BasicComposition bc = new BasicComposition(this.composition.getSearchInfo(), this.composition.getMatcher(), this.composition.getBasicSearchCriteria(), this.composition.getScopeDisplayName());
        Manager.getInstance().scheduleSearchTask(bc, true);
    }

    public void showFinishedInfo() {
        final AbstractNode an = new AbstractNode(Children.LEAF);
        an.setIconBaseWithExtension("org/netbeans/modules/search/res/info.png");
        an.setDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_INFO_REPLACE_FINISHED", (Object)this.resultModel.getSelectedMatchesCount()));
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                BasicReplaceResultsPanel.this.getOutlineView().getOutline().setRootVisible(true);
                BasicReplaceResultsPanel.this.getExplorerManager().setRootContext((Node)an);
                BasicReplaceResultsPanel.this.getOutlineView().validate();
                BasicReplaceResultsPanel.this.getOutlineView().repaint();
                BasicReplaceResultsPanel.this.btnNext.setEnabled(false);
                BasicReplaceResultsPanel.this.btnPrev.setEnabled(false);
                BasicReplaceResultsPanel.this.btnTreeView.setEnabled(false);
                BasicReplaceResultsPanel.this.btnFlatView.setEnabled(false);
                BasicReplaceResultsPanel.this.btnExpand.setEnabled(false);
            }
        });
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("valid")) {
                BasicReplaceResultsPanel.this.replaceButton.setText(NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_REPLACE_INVALID"));
                BasicReplaceResultsPanel.this.replaceButton.setEnabled(false);
            } else if (evt.getPropertyName().equals("selection") && BasicReplaceResultsPanel.this.resultModel.isValid()) {
                BasicReplaceResultsPanel.this.setButtonText();
            }
        }
    }
}

