/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.startup.preferences.NbPreferences;
import org.netbeans.core.startup.preferences.Statistics;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;

class PropertiesStorage
implements NbPreferences.FileStorage {
    private static final String USERROOT_PREFIX = "/Preferences";
    private static final String SYSTEMROOT_PREFIX = "/SystemPreferences";
    private static final FileObject SFS_ROOT = FileUtil.getConfigRoot();
    private final String folderPath;
    private String filePath;
    private boolean isModified;
    private FileChangeAdapter fileChangeAdapter;

    static NbPreferences.FileStorage instance(String absolutePath) {
        return new PropertiesStorage(absolutePath, true);
    }

    FileObject preferencesRoot() throws IOException {
        return FileUtil.createFolder((FileObject)SFS_ROOT, (String)USERROOT_PREFIX);
    }

    static NbPreferences.FileStorage instanceReadOnly(String absolutePath) {
        return new PropertiesStorage(absolutePath, false){

            @Override
            public boolean isReadOnly() {
                return true;
            }

            @Override
            public final String[] childrenNames() {
                return new String[0];
            }

            @Override
            public final EditableProperties load() throws IOException {
                return new EditableProperties(true);
            }

            @Override
            protected FileObject toPropertiesFile(boolean create) throws IOException {
                if (create) {
                    throw new IOException();
                }
                return null;
            }

            @Override
            protected FileObject toFolder(boolean create) throws IOException {
                if (create) {
                    throw new IOException();
                }
                return null;
            }

            @Override
            protected FileObject toPropertiesFile() {
                return null;
            }

            @Override
            protected FileObject toFolder() {
                return null;
            }

            @Override
            FileObject preferencesRoot() throws IOException {
                return FileUtil.createFolder((FileObject)SFS_ROOT, (String)PropertiesStorage.SYSTEMROOT_PREFIX);
            }
        };
    }

    private PropertiesStorage(String absolutePath, boolean userRoot) {
        StringBuilder sb = new StringBuilder();
        String prefix = userRoot ? USERROOT_PREFIX : SYSTEMROOT_PREFIX;
        sb.append(prefix).append(absolutePath);
        this.folderPath = sb.toString();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void markModified() {
        this.isModified = true;
    }

    @Override
    public final boolean existsNode() {
        return this.toPropertiesFile() != null || this.toFolder() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] childrenNames() {
        Statistics.StopWatch sw = Statistics.getStopWatch(Statistics.CHILDREN_NAMES, true);
        try {
            FileObject folder = this.toFolder();
            ArrayList<String> folderNames = new ArrayList<String>();
            if (folder != null) {
                block3: for (FileObject fo : Collections.list(folder.getFolders(false))) {
                    Enumeration en = fo.getChildren(true);
                    while (en.hasMoreElements()) {
                        FileObject ffo = (FileObject)en.nextElement();
                        if (!ffo.hasExt("properties")) continue;
                        folderNames.add(fo.getNameExt());
                        continue block3;
                    }
                }
                for (FileObject fo : Collections.list(folder.getData(false))) {
                    if (!fo.hasExt("properties")) continue;
                    folderNames.add(fo.getName());
                }
            }
            String[] stringArray = folderNames.toArray(new String[folderNames.size()]);
            return stringArray;
        }
        finally {
            sw.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeNode() throws IOException {
        Statistics.StopWatch sw = Statistics.getStopWatch(Statistics.REMOVE_NODE, true);
        try {
            FileObject propertiesFile = this.toPropertiesFile();
            if (propertiesFile != null && propertiesFile.isValid()) {
                propertiesFile.delete();
                for (FileObject folder = propertiesFile.getParent(); folder != null && folder != this.preferencesRoot() && folder.getChildren().length == 0; folder = folder.getParent()) {
                    folder.delete();
                }
            }
        }
        finally {
            sw.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EditableProperties load() throws IOException {
        Statistics.StopWatch sw = Statistics.getStopWatch(Statistics.LOAD, true);
        try {
            EditableProperties retval = new EditableProperties(true);
            FileObject file = this.toPropertiesFile(false);
            if (file != null) {
                try {
                    InputStream is = file.getInputStream();
                    try {
                        retval.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IllegalArgumentException x) {
                    Logger.getLogger(PropertiesStorage.class.getName()).log(Level.INFO, "While loading " + file, x);
                    file.delete();
                }
            }
            EditableProperties editableProperties = retval;
            return editableProperties;
        }
        finally {
            sw.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(EditableProperties properties) throws IOException {
        block11: {
            if (this.isModified) {
                Statistics.StopWatch sw = Statistics.getStopWatch(Statistics.FLUSH, true);
                try {
                    this.isModified = false;
                    if (!properties.isEmpty()) {
                        OutputStream os = null;
                        try {
                            os = this.outputStream();
                            properties.store(os);
                            break block11;
                        }
                        finally {
                            if (os != null) {
                                os.close();
                            }
                        }
                    }
                    FileObject file = this.toPropertiesFile();
                    if (file != null) {
                        file.delete();
                    }
                    for (FileObject folder = this.toFolder(); folder != null && folder != this.preferencesRoot() && folder.getChildren().length == 0; folder = folder.getParent()) {
                        folder.delete();
                    }
                }
                finally {
                    sw.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream outputStream() throws IOException {
        FileObject fo = this.toPropertiesFile(true);
        final FileLock lock = fo.lock();
        OutputStream os = null;
        try {
            os = fo.getOutputStream(lock);
        }
        finally {
            if (os == null && lock != null) {
                lock.releaseLock();
            }
        }
        return new FilterOutputStream(os){

            @Override
            public void close() throws IOException {
                super.close();
                lock.releaseLock();
            }
        };
    }

    private String folderPath() {
        return this.folderPath;
    }

    private String filePath() {
        if (this.filePath == null) {
            String[] all = this.folderPath().split("/");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < all.length - 1; ++i) {
                sb.append(all[i]).append("/");
            }
            if (all.length > 0) {
                sb.append(all[all.length - 1]).append(".properties");
            } else {
                sb.append("root.properties");
            }
            this.filePath = sb.toString();
        }
        return this.filePath;
    }

    protected FileObject toFolder() {
        return SFS_ROOT.getFileObject(this.folderPath());
    }

    protected FileObject toPropertiesFile() {
        return SFS_ROOT.getFileObject(this.filePath());
    }

    protected FileObject toFolder(boolean create) throws IOException {
        FileObject retval = this.toFolder();
        if (retval == null && create) {
            retval = FileUtil.createFolder((FileObject)SFS_ROOT, (String)this.folderPath);
        }
        assert (retval == null && !create || retval != null && retval.isFolder());
        return retval;
    }

    protected FileObject toPropertiesFile(boolean create) throws IOException {
        FileObject retval = this.toPropertiesFile();
        if (retval == null && create) {
            retval = FileUtil.createData((FileObject)SFS_ROOT, (String)this.filePath());
        }
        assert (retval == null && !create || retval != null && retval.isData());
        return retval;
    }

    @Override
    public void runAtomic(final Runnable run) {
        try {
            SFS_ROOT.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    run.run();
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void attachChangeListener(final ChangeListener changeListener) {
        try {
            this.fileChangeAdapter = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    if (fe.getFile().equals(PropertiesStorage.this.toPropertiesFile())) {
                        changeListener.stateChanged(new ChangeEvent(PropertiesStorage.this));
                    }
                }

                public void fileFolderCreated(FileEvent fe) {
                    if (fe.getFile().equals(PropertiesStorage.this.toPropertiesFile())) {
                        changeListener.stateChanged(new ChangeEvent(PropertiesStorage.this));
                    }
                }

                public void fileChanged(FileEvent fe) {
                    if (fe.getFile().equals(PropertiesStorage.this.toPropertiesFile())) {
                        changeListener.stateChanged(new ChangeEvent(PropertiesStorage.this));
                    }
                }

                public void fileDeleted(FileEvent fe) {
                    if (fe.getFile().equals(PropertiesStorage.this.toPropertiesFile())) {
                        changeListener.stateChanged(new ChangeEvent(PropertiesStorage.this));
                    }
                }

                public void fileRenamed(FileRenameEvent fe) {
                    if (fe.getFile().equals(PropertiesStorage.this.toPropertiesFile())) {
                        changeListener.stateChanged(new ChangeEvent(PropertiesStorage.this));
                    }
                }
            };
            SFS_ROOT.getFileSystem().addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeAdapter, (Object)SFS_ROOT.getFileSystem()));
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

