/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import org.netbeans.updater.Localization;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterDispatcher;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;

public class UpdaterFrame
extends JPanel
implements UpdatingContext {
    private static final boolean enabledConsole = Boolean.getBoolean("netbeans.logger.console");
    public static final int OS_WIN = 1;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_OS2 = 1024;
    public static final int OS_OTHER = 65536;
    private static final String SPLASH_PATH = "org/netbeans/updater/resources/updatersplash";
    private boolean bigBounds = false;
    private Window splashWindow;
    private boolean noSplash = false;
    private JLabel jLabel3;
    private JTextArea jTextArea1;
    private JProgressBar progressBar;
    private JLabel textLabel;

    public UpdaterFrame() {
        this((String[])null);
    }

    private UpdaterFrame(String[] args) {
        if (args != null && args.length > 0) {
            this.cli(args);
        }
        this.initComponents();
        if (UpdaterFrame.addBorder()) {
            this.setBorder(new LineBorder(UpdaterFrame.stringToColor("UpdaterFrame.LineBorder.Color", new Color(0, 0, 0))));
        }
        this.loadSplash();
    }

    static void center(Window c) {
        c.pack();
        GraphicsConfiguration gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Rectangle bounds = gconf.getBounds();
        Dimension dialogSize = c.getSize();
        c.setLocation(bounds.x + (bounds.width - dialogSize.width) / 2, bounds.y + (bounds.height - dialogSize.height) / 2);
    }

    static String getMainWindowTitle() {
        return Localization.getBrandedString("UpdaterFrame.Form.title");
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.textLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.setBackground(UpdaterFrame.stringToColor("UpdaterFrame.Background", new Color(6, 4, 100)));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextArea1.setBackground(UpdaterFrame.stringToColor("UpdaterFrame.TextBackground", new Color(213, 204, 187)));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setForeground(UpdaterFrame.stringToColor("UpdaterFrame.TextForeground", Color.white));
        this.jTextArea1.setText(Localization.getBrandedString("UpdaterFrame.jTextArea1.text"));
        this.jTextArea1.setDisabledTextColor(UpdaterFrame.stringToColor("UpdaterFrame.DisabledTextColor", Color.white));
        this.jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 14, 0, 14);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.textLabel.setFont(new Font(Localization.getBrandedString("UpdaterFrame.textLabel.fontName"), 1, 11));
        this.textLabel.setForeground(UpdaterFrame.stringToColor("UpdaterFrame.TextForeground", Color.white));
        this.textLabel.setText(Localization.getBrandedString("UpdaterFrame.textLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 14, 8, 14);
        this.add((Component)this.textLabel, gridBagConstraints);
        this.progressBar.setMinimumSize(UpdaterFrame.stringToDimension("UpdaterFrame.ProgressBar.PreferredSize", new Dimension(300, 20)));
        this.progressBar.setPreferredSize(UpdaterFrame.stringToDimension("UpdaterFrame.ProgressBar.PreferredSize", new Dimension(300, 20)));
        this.progressBar.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 14, 10, 14);
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (UpdaterFrame.isGradient()) {
            Color outerColor = UpdaterFrame.stringToColor("UpdaterFrame.outerColor", new Color(230, 242, 234));
            Color centerColor = UpdaterFrame.stringToColor("UpdaterFrame.centerColor", Color.WHITE);
            int w = this.getWidth();
            int h = this.getHeight();
            Graphics2D g2d = (Graphics2D)g;
            if (UpdaterFrame.isGradientVertical()) {
                Icon splashIcon = this.jLabel3.getIcon();
                int splashH = splashIcon != null ? splashIcon.getIconHeight() : 0;
                g2d.setPaint(new GradientPaint(0.0f, splashH, centerColor, 0.0f, h, outerColor));
                g2d.fillRect(0, splashH, w, h - splashH);
            } else {
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, outerColor, w / 2, 0.0f, centerColor, true));
                g2d.fillRect(0, 0, w, h);
            }
        } else {
            super.paintComponent(g);
        }
    }

    private void showSplash() {
        this.splashWindow = UpdaterFrame.getOperatingSystem() == 1 || UpdaterFrame.getOperatingSystem() == 8 || UpdaterFrame.getOperatingSystem() == 1024 || UpdaterFrame.getOperatingSystem() == 16 ? new SplashWindow(this) : new SplashFrame(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdaterFrame.this.splashWindow.setVisible(true);
                UpdaterFrame.this.splashWindow.toFront();
            }
        });
    }

    @Override
    public void disposeSplash() {
        if (this.splashWindow != null) {
            this.splashWindow.dispose();
        }
    }

    public static void main(String ... args) {
        UpdaterFrame panel = new UpdaterFrame(args);
        if (!panel.noSplash) {
            panel.showSplash();
        }
        new UpdaterDispatcher(panel).run();
        XMLUtil.LOG.info("-------------------------- exiting updater.jar");
    }

    @Override
    public Collection<File> forInstall() {
        return null;
    }

    @Override
    public void unpackingIsRunning() {
    }

    @Override
    public void unpackingFinished() {
        this.runningFinished();
    }

    @Override
    public void runningFinished() {
        System.exit(0);
    }

    @Override
    public void setLabel(final String text) {
        if (this.noSplash) {
            return;
        }
        final JLabel label = this.textLabel;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                label.setText(text);
            }
        });
    }

    @Override
    public void setProgressRange(final long min, final long max) {
        if (this.noSplash) {
            return;
        }
        this.bigBounds = max > 65535L;
        final JProgressBar pb = this.progressBar;
        final boolean bb = this.bigBounds;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                pb.setMinimum(bb ? (int)(min / 1024L) : (int)min);
                pb.setMaximum(bb ? (int)(max / 1024L) : (int)max);
            }
        });
    }

    @Override
    public void setProgressValue(final long value) {
        if (this.noSplash) {
            return;
        }
        final boolean bb = this.bigBounds;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdaterFrame.this.progressBar.setValue(bb ? (int)(value / 1024L) : (int)value);
            }
        });
    }

    private static int getOperatingSystem() {
        String osName = System.getProperty("os.name");
        int operatingSystem = osName != null && osName.startsWith("Windows") ? 1 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : ("Linux".equals(osName) ? 16 : ("OS/2".equals(osName) ? 1024 : 65536))));
        return operatingSystem;
    }

    @Override
    public boolean isFromIDE() {
        return false;
    }

    private static Color stringToColor(String key, Color defcolor) {
        try {
            String str = Localization.getBrandedString(key + "_R");
            int re = Integer.parseInt(str);
            str = Localization.getBrandedString(key + "_G");
            int gr = Integer.parseInt(str);
            str = Localization.getBrandedString(key + "_B");
            int bl = Integer.parseInt(str);
            return new Color(re, gr, bl);
        }
        catch (Exception e) {
            return defcolor;
        }
    }

    private static Dimension stringToDimension(String key, Dimension defaultSize) {
        try {
            String str = Localization.getBrandedString(key + "_X");
            int x = Integer.parseInt(str);
            str = Localization.getBrandedString(key + "_Y");
            int y = Integer.parseInt(str);
            return new Dimension(x, y);
        }
        catch (Exception e) {
            return defaultSize;
        }
    }

    private static boolean addBorder() {
        return "true".equals(Localization.getBrandedString("UpdaterFrame.hasBorder"));
    }

    private static boolean isGradient() {
        return "true".equals(Localization.getBrandedString("UpdaterFrame.isGradient"));
    }

    private static boolean isGradientVertical() {
        return "true".equals(Localization.getBrandedString("UpdaterFrame.isGradientVertical"));
    }

    private void loadSplash() {
        URL lookup = Localization.getBrandedResource(SPLASH_PATH, ".gif");
        if (lookup != null) {
            this.jLabel3.setIcon(new ImageIcon(lookup));
        }
    }

    @Override
    public OutputStream createOS(File bckFile) throws FileNotFoundException {
        return new FileOutputStream(bckFile);
    }

    private static boolean isOption(String value, String optionName) {
        if (value == null) {
            return false;
        }
        if (value.startsWith("--")) {
            return value.substring(2).equals(optionName);
        }
        if (value.startsWith("-")) {
            return value.substring(1).equals(optionName);
        }
        return false;
    }

    private int cli(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (UpdaterFrame.isOption(args[i], "noexit")) {
                throw new IllegalStateException();
            }
            if (UpdaterFrame.isOption(args[i], "nosplash")) {
                this.noSplash = true;
                continue;
            }
            if (UpdaterFrame.isOption(args[i], "locale")) {
                String language;
                args[i] = null;
                String localeParam = args[++i];
                String country = "";
                String variant = "";
                int index1 = localeParam.indexOf(":");
                if (index1 == -1) {
                    language = localeParam;
                } else {
                    language = localeParam.substring(0, index1);
                    int index2 = localeParam.indexOf(":", index1 + 1);
                    if (index2 != -1) {
                        country = localeParam.substring(index1 + 1, index2);
                        variant = localeParam.substring(index2 + 1);
                    } else {
                        country = localeParam.substring(index1 + 1);
                    }
                }
                Locale.setDefault(new Locale(language, country, variant));
                continue;
            }
            if (!UpdaterFrame.isOption(args[i], "branding")) continue;
            args[i] = null;
            if (++i == args.length) {
                System.err.println("Option --branding requires one argument.");
                return 2;
            }
            String branding = args[i];
            if (branding.equals("-")) {
                branding = null;
            }
            try {
                Localization.setBranding(branding);
                continue;
            }
            catch (IllegalArgumentException iae) {
                XMLUtil.LOG.log(Level.WARNING, "Cannot change branding", iae);
                return 1;
            }
        }
        return 0;
    }

    static {
        FileHandler fh = null;
        try {
            boolean append = true;
            fh = new FileHandler(UpdateTracking.getUserDir().getPath() + File.separator + "var" + File.separator + "log" + File.separator + "updater.log", 1000000, 3, append);
            fh.setFormatter(new SimpleFormatter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        XMLUtil.LOG.setUseParentHandlers(enabledConsole);
        if (fh != null) {
            XMLUtil.LOG.addHandler(fh);
        }
        XMLUtil.LOG.info("Entering updater.jar .................................................................... ");
    }

    static class SplashWindow
    extends Window {
        public SplashWindow(UpdaterFrame panel) {
            super(new Frame());
            this.setLayout(new BorderLayout());
            this.add((Component)panel, "Center");
            UpdaterFrame.center(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return UpdaterFrame.stringToDimension("UpdaterFrame.Splash.PreferredSize", new Dimension(400, 280));
        }
    }

    static class SplashFrame
    extends JFrame {
        public SplashFrame(UpdaterFrame panel) {
            super(UpdaterFrame.getMainWindowTitle());
            this.setDefaultCloseOperation(0);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.getContentPane().add(panel);
            UpdaterFrame.center(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return UpdaterFrame.stringToDimension("UpdaterFrame.Splash.PreferredSize", new Dimension(400, 280));
        }
    }
}

