/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public class SQLInsertStatement
extends SQLModifyStatement {
    protected SQLCall buildCallWithoutReturning(AbstractSession session) {
        SQLCall call = new SQLCall();
        call.returnNothing();
        CharArrayWriter writer = new CharArrayWriter(200);
        try {
            int i;
            DatabaseField field;
            writer.write("INSERT ");
            if (this.getHintString() != null) {
                writer.write(this.getHintString());
                writer.write(" ");
            }
            writer.write("INTO ");
            writer.write(this.getTable().getQualifiedNameDelimited(session.getPlatform()));
            writer.write(" (");
            Vector<DatabaseField> fieldsForTable = new Vector<DatabaseField>();
            Enumeration fieldsEnum = this.getModifyRow().keys();
            while (fieldsEnum.hasMoreElements()) {
                field = (DatabaseField)fieldsEnum.nextElement();
                if (!field.getTable().equals(this.getTable()) && field.hasTableName()) continue;
                fieldsForTable.addElement(field);
            }
            if (fieldsForTable.isEmpty()) {
                throw QueryException.objectToInsertIsEmpty(this.getTable());
            }
            for (i = 0; i < fieldsForTable.size(); ++i) {
                writer.write(((DatabaseField)fieldsForTable.elementAt(i)).getNameDelimited(session.getPlatform()));
                if (i + 1 >= fieldsForTable.size()) continue;
                writer.write(", ");
            }
            writer.write(") VALUES (");
            for (i = 0; i < fieldsForTable.size(); ++i) {
                field = (DatabaseField)fieldsForTable.elementAt(i);
                call.appendModify(writer, field);
                if (i + 1 >= fieldsForTable.size()) continue;
                writer.write(", ");
            }
            writer.write(")");
            call.setSQLString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return call;
    }
}

