/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.sunas;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.JavaLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.JMXEnabledPlatform;
import org.eclipse.persistence.platform.server.JMXServerPlatformBase;
import org.eclipse.persistence.services.glassfish.MBeanGlassfishRuntimeServices;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.transaction.sunas.SunAS9TransactionController;

public class SunAS9ServerPlatform
extends JMXServerPlatformBase
implements JMXEnabledPlatform {
    public SunAS9ServerPlatform(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
        this.enableRuntimeServices();
        this.prepareServerSpecificServicesMBean();
    }

    public Class getExternalTransactionControllerClass() {
        if (this.externalTransactionControllerClass == null) {
            this.externalTransactionControllerClass = SunAS9TransactionController.class;
        }
        return this.externalTransactionControllerClass;
    }

    public Connection unwrapConnection(final Connection connection) {
        Connection unwrappedConnection = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedAction<Connection>(){

            @Override
            public Connection run() {
                return SunAS9ServerPlatform.this.unwrapGlassFishConnectionHelper(connection);
            }
        }) : this.unwrapGlassFishConnectionHelper(connection);
        if (unwrappedConnection == null) {
            unwrappedConnection = super.unwrapConnection(connection);
        }
        return unwrappedConnection;
    }

    private Connection unwrapGlassFishConnectionHelper(Connection connection) {
        Connection unwrappedConnection = null;
        try {
            Class<?> connectionWrapperClass = connection.getClass().getClassLoader().loadClass("com.sun.gjc.spi.base.ConnectionHolder");
            if (connectionWrapperClass.isInstance(connection)) {
                Method unwrapMethod = connectionWrapperClass.getDeclaredMethod("getConnection", new Class[0]);
                unwrappedConnection = (Connection)unwrapMethod.invoke((Object)connection, new Object[0]);
            }
        }
        catch (Exception e) {
            this.getDatabaseSession().getSessionLog().logThrowable(6, e);
        }
        return unwrappedConnection;
    }

    public SessionLog getServerLog() {
        return new JavaLog();
    }

    public boolean isRuntimeServicesEnabledDefault() {
        return true;
    }

    public void prepareServerSpecificServicesMBean() {
        if (this.shouldRegisterRuntimeBean) {
            this.setRuntimeServicesMBean(new MBeanGlassfishRuntimeServices(this.getDatabaseSession()));
        }
    }

    public void serverSpecificRegisterMBean() {
        super.serverSpecificRegisterMBean();
        this.initializeApplicationNameAndModuleName();
    }

    static {
        APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX = "URLEntry : file:/";
        APP_SERVER_CLASSLOADER_MODULE_EJB_SEARCH_STRING_PREFIX = "_jar/";
        APP_SERVER_CLASSLOADER_MODULE_WAR_SEARCH_STRING_PREFIX = "_war/";
        APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_POSTFIX = "]";
        APP_SERVER_CLASSLOADER_MODULE_EJB_WAR_SEARCH_STRING_POSTFIX = "postfix,match~not;required^";
    }
}

