/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;

public class OptimisticLockException
extends EclipseLinkException {
    protected transient ObjectLevelModifyQuery query;
    public static final int NO_VERSION_NUMBER_WHEN_DELETING = 5001;
    public static final int OBJECT_CHANGED_SINCE_LAST_READ_WHEN_DELETING = 5003;
    public static final int NO_VERSION_NUMBER_WHEN_UPDATING = 5004;
    public static final int OBJECT_CHANGED_SINCE_LAST_READ_WHEN_UPDATING = 5006;
    public static final int MUST_HAVE_MAPPING_WHEN_IN_OBJECT = 5007;
    public static final int NEED_TO_MAP_JAVA_SQL_TIMESTAMP = 5008;
    public static final int UNWRAPPING_OBJECT_DELETED_SINCE_LAST_READ = 5009;
    public static final int OBJECT_CHANGED_SINCE_LAST_MERGE = 5010;
    public static final int STATEMENT_NOT_EXECUTED_IN_BATCH = 5011;

    protected OptimisticLockException(String theMessage) {
        super(theMessage);
    }

    protected OptimisticLockException(String theMessage, ObjectLevelModifyQuery query) {
        super(theMessage);
        this.query = query;
        query.getSession().incrementProfile("Counter:OptimisticLocks");
    }

    public Object getObject() {
        return this.getQuery().getObject();
    }

    public ObjectLevelModifyQuery getQuery() {
        return this.query;
    }

    public static OptimisticLockException batchStatementExecutionFailure() {
        Object[] args = new Object[]{};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5011, args));
        optimisticLockException.setErrorCode(5011);
        return optimisticLockException;
    }

    public static OptimisticLockException mustHaveMappingWhenStoredInObject(Class aClass) {
        Object[] args = new Object[]{aClass};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5007, args));
        optimisticLockException.setErrorCode(5007);
        return optimisticLockException;
    }

    public static OptimisticLockException noVersionNumberWhenDeleting(Object object, ObjectLevelModifyQuery query) {
        Object key = null;
        if (query.getSession() != null) {
            key = query.getSession().getId(object);
        }
        Object[] args = new Object[]{object, object.getClass().getName(), key, CR};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5001, args), query);
        optimisticLockException.setErrorCode(5001);
        return optimisticLockException;
    }

    public static OptimisticLockException noVersionNumberWhenUpdating(Object object, ObjectLevelModifyQuery query) {
        Object key = null;
        if (query.getSession() != null) {
            key = query.getSession().getId(object);
        }
        Object[] args = new Object[]{object, object.getClass().getName(), key, CR};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5004, args), query);
        optimisticLockException.setErrorCode(5004);
        return optimisticLockException;
    }

    public static OptimisticLockException objectChangedSinceLastReadWhenDeleting(Object object, ObjectLevelModifyQuery query) {
        Object key = null;
        if (query.getSession() != null) {
            key = query.getSession().getId(object);
        }
        Object[] args = new Object[]{object, object.getClass().getName(), key, CR};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5003, args), query);
        optimisticLockException.setErrorCode(5003);
        return optimisticLockException;
    }

    public static OptimisticLockException objectChangedSinceLastReadWhenUpdating(Object object, ObjectLevelModifyQuery query) {
        Object key = null;
        if (query.getSession() != null) {
            key = query.getSession().getId(object);
        }
        Object[] args = new Object[]{object, object.getClass().getName(), key, CR};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5006, args), query);
        optimisticLockException.setErrorCode(5006);
        return optimisticLockException;
    }

    public static OptimisticLockException objectChangedSinceLastMerge(Object object) {
        Object[] args = new Object[]{object, object.getClass().getName(), CR};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5010, args));
        optimisticLockException.setErrorCode(5010);
        return optimisticLockException;
    }

    public static OptimisticLockException unwrappingObjectDeletedSinceLastRead(Vector pkVector, String className) {
        Object[] args = new Object[]{pkVector, className};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5009, args));
        optimisticLockException.setErrorCode(5009);
        return optimisticLockException;
    }

    public static OptimisticLockException needToMapJavaSqlTimestampWhenStoredInObject() {
        Object[] args = new Object[]{};
        OptimisticLockException optimisticLockException = new OptimisticLockException(ExceptionMessageGenerator.buildMessage(OptimisticLockException.class, 5008, args));
        optimisticLockException.setErrorCode(5008);
        return optimisticLockException;
    }

    public void setQuery(ObjectLevelModifyQuery query) {
        this.query = query;
    }
}

