/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ClassTypeExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ManualQueryKeyExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectExpression
extends DataExpression {
    public transient ClassDescriptor descriptor;
    public Vector derivedExpressions;
    protected boolean shouldUseOuterJoinForMultitableInheritance;
    protected boolean shouldUseOuterJoin = false;
    protected Class castClass = null;

    @Override
    public Expression as(Class castClass) {
        this.setCastClass(castClass);
        return this;
    }

    @Override
    public boolean equals(Object expression) {
        if (this == expression) {
            return true;
        }
        return super.equals(expression) && this.shouldUseOuterJoin() == ((ObjectExpression)expression).shouldUseOuterJoin();
    }

    public void addDerivedExpression(Expression addThis) {
        if (this.derivedExpressions == null) {
            this.derivedExpressions = NonSynchronizedVector.newInstance();
        }
        this.derivedExpressions.addElement(addThis);
    }

    public Expression additionalExpressionCriteria() {
        if (this.getDescriptor() == null) {
            return null;
        }
        Expression criteria = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
        if (this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() && this.isUsingOuterJoinForMultitableInheritance()) {
            Expression childrenCriteria = this.getDescriptor().getInheritancePolicy().getChildrenJoinExpression();
            childrenCriteria = this.getBaseExpression().twist(childrenCriteria, this);
            childrenCriteria.convertToUseOuterJoin();
            criteria = criteria == null ? childrenCriteria : criteria.and(childrenCriteria);
        }
        return criteria;
    }

    public Map additionalExpressionCriteriaMap() {
        if (this.getDescriptor() == null) {
            return null;
        }
        HashMap<DatabaseTable, Expression> tablesJoinExpressions = null;
        if (this.isUsingOuterJoinForMultitableInheritance()) {
            tablesJoinExpressions = new HashMap<DatabaseTable, Expression>();
            List<DatabaseTable> childrenTables = this.getDescriptor().getInheritancePolicy().getChildrenTables();
            for (int i = 0; i < childrenTables.size(); ++i) {
                DatabaseTable table = childrenTables.get(i);
                Expression joinExpression = this.getDescriptor().getInheritancePolicy().getChildrenTablesJoinExpressions().get(table);
                joinExpression = this.getBaseExpression() != null ? this.getBaseExpression().twist(joinExpression, this) : this.twist(joinExpression, this);
                tablesJoinExpressions.put(table, joinExpression);
            }
        }
        return tablesJoinExpressions;
    }

    @Override
    public Expression anyOf(String attributeName) {
        QueryKeyExpression queryKey = this.newDerivedExpressionNamed(attributeName);
        queryKey.doQueryToManyRelationship();
        return queryKey;
    }

    @Override
    public Expression anyOfAllowingNone(String attributeName) {
        QueryKeyExpression queryKey = this.newDerivedExpressionNamed(attributeName);
        queryKey.doUseOuterJoin();
        queryKey.doQueryToManyRelationship();
        return queryKey;
    }

    public ClassDescriptor convertToCastDescriptor(ClassDescriptor rootDescriptor, AbstractSession session) {
        if (this.castClass == null) {
            return rootDescriptor;
        }
        if (rootDescriptor.getJavaClass() == this.castClass) {
            this.descriptor = rootDescriptor;
            return rootDescriptor;
        }
        ClassDescriptor castDescriptor = session.getClassDescriptor(this.castClass);
        if (castDescriptor == null) {
            throw QueryException.couldNotFindCastDescriptor(this.castClass, this.getBaseExpression());
        }
        if (castDescriptor.getInheritancePolicy() == null) {
            throw QueryException.castMustUseInheritance(this.getBaseExpression());
        }
        ClassDescriptor parentDescriptor = castDescriptor.getInheritancePolicy().getParentDescriptor();
        while (parentDescriptor != null) {
            if (parentDescriptor == rootDescriptor) {
                this.descriptor = castDescriptor;
                return castDescriptor;
            }
            parentDescriptor = parentDescriptor.getInheritancePolicy().getParentDescriptor();
        }
        ClassDescriptor childDescriptor = rootDescriptor;
        while (childDescriptor != null) {
            if (childDescriptor == castDescriptor) {
                this.descriptor = rootDescriptor;
                return this.descriptor;
            }
            childDescriptor = childDescriptor.getInheritancePolicy().getParentDescriptor();
        }
        throw QueryException.couldNotFindCastDescriptor(this.castClass, this.getBaseExpression());
    }

    public QueryKeyExpression derivedExpressionNamed(String attributeName) {
        QueryKeyExpression existing = this.existingDerivedExpressionNamed(attributeName);
        if (existing != null) {
            return existing;
        }
        return this.newDerivedExpressionNamed(attributeName);
    }

    public Expression derivedManualExpressionNamed(String attributeName, ClassDescriptor aDescriptor) {
        QueryKeyExpression existing = this.existingDerivedExpressionNamed(attributeName);
        if (existing != null) {
            return existing;
        }
        return this.newManualDerivedExpressionNamed(attributeName, aDescriptor);
    }

    protected void doNotUseOuterJoin() {
        this.shouldUseOuterJoin = false;
    }

    protected void doUseOuterJoin() {
        this.shouldUseOuterJoin = true;
    }

    public QueryKeyExpression existingDerivedExpressionNamed(String attributeName) {
        if (this.derivedExpressions == null) {
            return null;
        }
        Enumeration e = this.derivedExpressions.elements();
        while (e.hasMoreElements()) {
            QueryKeyExpression exp = (QueryKeyExpression)e.nextElement();
            if (!exp.getName().equals(attributeName)) continue;
            return exp;
        }
        return null;
    }

    @Override
    public Expression get(String attributeName, Vector arguments) {
        Expression operatorExpression = super.get(attributeName, arguments);
        if (operatorExpression != null) {
            return operatorExpression;
        }
        QueryKeyExpression result = this.derivedExpressionNamed(attributeName);
        result.doNotUseOuterJoin();
        return result;
    }

    @Override
    public Expression getAllowingNull(String attributeName, Vector arguments) {
        QueryKeyExpression exp = this.existingDerivedExpressionNamed(attributeName);
        if (exp != null) {
            return exp;
        }
        exp = this.derivedExpressionNamed(attributeName);
        exp.doUseOuterJoin();
        return exp;
    }

    public Class getCastClass() {
        return this.castClass;
    }

    @Override
    public Expression type() {
        return new ClassTypeExpression(this);
    }

    @Override
    public ClassDescriptor getDescriptor() {
        if (this.isAttribute()) {
            return null;
        }
        if (this.descriptor == null) {
            ForeignReferenceQueryKey queryKey = (ForeignReferenceQueryKey)this.getQueryKeyOrNull();
            if (queryKey != null) {
                this.descriptor = this.getSession().getDescriptor(queryKey.getReferenceClass());
                return this.convertToCastDescriptor(this.descriptor, this.getSession());
            }
            if (this.getMapping() == null) {
                throw QueryException.invalidQueryKeyInExpression(this);
            }
            this.descriptor = this.getMapping().getReferenceDescriptor();
            if (this.getMapping().isVariableOneToOneMapping()) {
                throw QueryException.cannotQueryAcrossAVariableOneToOneMapping(this.getMapping(), this.descriptor);
            }
            this.convertToCastDescriptor(this.descriptor, this.getSession());
        }
        return this.descriptor;
    }

    @Override
    public Vector getFields() {
        if (this.getDescriptor() == null) {
            DatabaseMapping mapping = this.getMapping();
            if (mapping != null) {
                return mapping.getSelectFields();
            }
            return new NonSynchronizedVector(0);
        }
        if (this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().shouldReadSubclasses() && !this.descriptor.getInheritancePolicy().hasMultipleTableChild() || this.shouldUseOuterJoinForMultitableInheritance()) {
            return this.descriptor.getAllFields();
        }
        return this.descriptor.getFields();
    }

    protected Vector getForUpdateOfFields() {
        Vector allFields = this.getFields();
        int expected = this.getTableAliases().size();
        Vector<DatabaseField> firstFields = new Vector<DatabaseField>(expected);
        DatabaseTable lastTable = null;
        DatabaseField field = null;
        int i = 0;
        while (i < allFields.size() && firstFields.size() < expected) {
            int j;
            field = (DatabaseField)allFields.elementAt(i++);
            if (lastTable != null && field.getTable().equals(lastTable)) continue;
            lastTable = field.getTable();
            for (j = 0; j < firstFields.size() && !lastTable.equals(((DatabaseField)firstFields.elementAt(j)).getTable()); ++j) {
            }
            if (j != firstFields.size()) continue;
            firstFields.addElement(field);
        }
        return firstFields;
    }

    public Expression getManualQueryKey(String attributeName, ClassDescriptor aDescriptor) {
        return this.derivedManualExpressionNamed(attributeName, aDescriptor);
    }

    public List<DatabaseTable> getAdditionalTables() {
        return null;
    }

    @Override
    public Vector getOwnedTables() {
        ClassDescriptor descriptor = this.getDescriptor();
        Vector tables = null;
        if (descriptor == null) {
            List<DatabaseTable> additionalTables = this.getAdditionalTables();
            if (additionalTables == null) {
                return null;
            }
            return new Vector<DatabaseTable>(additionalTables);
        }
        if (descriptor.isAggregateDescriptor()) {
            return null;
        }
        tables = descriptor.getHistoryPolicy() != null && this.getAsOfClause().getValue() != null ? descriptor.getHistoryPolicy().getHistoricalTables() : (this.isUsingOuterJoinForMultitableInheritance() ? descriptor.getInheritancePolicy().getAllTables() : descriptor.getTables());
        List<DatabaseTable> additionalTables = this.getAdditionalTables();
        if (additionalTables != null) {
            tables = new Vector(tables);
            Helper.addAllUniqueToVector(tables, additionalTables);
            return tables;
        }
        return tables;
    }

    protected boolean hasDerivedExpressions() {
        return this.derivedExpressions != null;
    }

    @Override
    public boolean isObjectExpression() {
        return true;
    }

    public boolean isUsingOuterJoinForMultitableInheritance() {
        return this.shouldUseOuterJoinForMultitableInheritance() && this.getDescriptor() != null && this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasMultipleTableChild() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses();
    }

    public QueryKeyExpression newDerivedExpressionNamed(String attributeName) {
        QueryKeyExpression result = new QueryKeyExpression(attributeName, this);
        this.addDerivedExpression(result);
        return result;
    }

    public Expression newManualDerivedExpressionNamed(String attributeName, ClassDescriptor aDescriptor) {
        ManualQueryKeyExpression result = new ManualQueryKeyExpression(attributeName, this, aDescriptor);
        this.addDerivedExpression(result);
        return result;
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.derivedExpressions = this.copyCollection(this.derivedExpressions, alreadyDone);
    }

    public void postCopyIn(Map alreadyDone, Vector oldDerivedFields, Vector oldDerivedTables) {
        if (oldDerivedFields != null) {
            if (this.derivedFields == null) {
                this.derivedFields = this.copyCollection(oldDerivedFields, alreadyDone);
            } else {
                this.derivedFields.addAll(this.copyCollection(oldDerivedFields, alreadyDone));
            }
        }
        if (oldDerivedTables != null) {
            if (this.derivedTables == null) {
                this.derivedTables = this.copyCollection(oldDerivedTables, alreadyDone);
            } else {
                this.derivedTables.addAll(this.copyCollection(oldDerivedTables, alreadyDone));
            }
        }
    }

    public void setCastClass(Class castClass) {
        this.castClass = castClass;
    }

    public void setShouldUseOuterJoinForMultitableInheritance(boolean shouldUseOuterJoinForMultitableInheritance) {
        this.shouldUseOuterJoinForMultitableInheritance = shouldUseOuterJoinForMultitableInheritance;
    }

    public boolean shouldUseOuterJoin() {
        return this.shouldUseOuterJoin;
    }

    public boolean shouldUseOuterJoinForMultitableInheritance() {
        return this.shouldUseOuterJoinForMultitableInheritance;
    }

    protected void writeForUpdateOfFields(ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        for (DatabaseField field : this.getForUpdateOfFields()) {
            if (printer.getPlatform().shouldPrintAliasForUpdate()) {
                this.writeAlias(printer, field, statement);
                continue;
            }
            this.writeField(printer, field, statement);
        }
    }
}

