/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.multitenant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.MultitenantType;
import org.eclipse.persistence.annotations.TenantDiscriminatorColumn;
import org.eclipse.persistence.annotations.TenantDiscriminatorColumns;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.TenantDiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultitenantMetadata
extends ORMetadata {
    private List<TenantDiscriminatorColumnMetadata> m_tenantDiscriminatorColumns = new ArrayList<TenantDiscriminatorColumnMetadata>();
    private String m_type;

    public MultitenantMetadata() {
        super("<multitenant>");
    }

    public MultitenantMetadata(MetadataAnnotation multitenant, MetadataAccessor accessor) {
        super(multitenant, accessor);
        this.m_type = (String)multitenant.getAttribute("value");
        if (accessor.isAnnotationPresent(TenantDiscriminatorColumns.class)) {
            for (Object tenantDiscriminatorColumn : (Object[])accessor.getAnnotation(TenantDiscriminatorColumns.class).getAttributeArray("value")) {
                this.m_tenantDiscriminatorColumns.add(new TenantDiscriminatorColumnMetadata((MetadataAnnotation)tenantDiscriminatorColumn, accessor));
            }
        }
        if (accessor.isAnnotationPresent(TenantDiscriminatorColumn.class)) {
            this.m_tenantDiscriminatorColumns.add(new TenantDiscriminatorColumnMetadata(accessor.getAnnotation(TenantDiscriminatorColumn.class), accessor));
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof MultitenantMetadata) {
            MultitenantMetadata multitenant = (MultitenantMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_type, multitenant.getType())) {
                return false;
            }
            return this.valuesMatch(this.m_tenantDiscriminatorColumns, multitenant.getTenantDiscriminatorColumns());
        }
        return false;
    }

    public List<TenantDiscriminatorColumnMetadata> getTenantDiscriminatorColumns() {
        return this.m_tenantDiscriminatorColumns;
    }

    public String getType() {
        return this.m_type;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_tenantDiscriminatorColumns, accessibleObject);
    }

    public void process(MetadataDescriptor descriptor) {
        if (this.m_type != null && !this.m_type.equals(MultitenantType.SINGLE_TABLE.name())) {
            throw new RuntimeException("Unsupported multitenant type: " + this.m_type);
        }
        this.processTenantDiscriminators(descriptor);
        if (this.getProject().usesMultitenantSharedEmf()) {
            descriptor.getClassDescriptor().setCacheIsolation(CacheIsolationType.PROTECTED);
        }
    }

    protected void processTenantDiscriminators(MetadataDescriptor descriptor) {
        EntityAccessor parentAccessor;
        if (descriptor.isInheritanceSubclass() && !(parentAccessor = descriptor.getInheritanceRootDescriptor().getEntityAccessor()).getInheritance().usesTablePerClassStrategy()) {
            if (!this.m_tenantDiscriminatorColumns.isEmpty()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_inheritance_tenant_discriminator_column", descriptor.getJavaClass());
            }
            return;
        }
        if (this.m_tenantDiscriminatorColumns.isEmpty()) {
            this.m_tenantDiscriminatorColumns = descriptor.getDefaultTenantDiscriminatorColumns();
            if (this.m_tenantDiscriminatorColumns.isEmpty()) {
                this.m_tenantDiscriminatorColumns.add(new TenantDiscriminatorColumnMetadata(descriptor.getClassAccessor()));
            } else {
                for (TenantDiscriminatorColumnMetadata tenantDiscriminator : this.m_tenantDiscriminatorColumns) {
                    tenantDiscriminator.setAccessibleObject(this.getAccessibleObject());
                    tenantDiscriminator.setProject(this.getProject());
                }
            }
        }
        for (TenantDiscriminatorColumnMetadata tenantDiscriminator : this.m_tenantDiscriminatorColumns) {
            tenantDiscriminator.process(descriptor);
        }
    }

    public void setTenantDiscriminatorColumns(List<TenantDiscriminatorColumnMetadata> tenantDiscriminatorColumns) {
        this.m_tenantDiscriminatorColumns = tenantDiscriminatorColumns;
    }

    public void setType(String type) {
        this.m_type = type;
    }
}

