/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.xjc;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMods;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaConstructorImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaFieldImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaMethodImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaPackageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJCJavaClassImpl
implements JavaClass {
    private JDefinedClass xjcClass;
    private JCodeModel jCodeModel;
    private JavaModel javaModel;
    private boolean isArray;
    private boolean isPrimitive;
    private DynamicClassLoader dynamicClassLoader;
    private static Field JDEFINEDCLASS_ANNOTATIONS = null;
    private static Field JDEFINEDCLASS_MODS = null;
    private static Field JDEFINEDCLASS_SUPERCLASS = null;
    private static Field JTYPEVAR_BOUND = null;
    private static final Map<String, JPrimitiveType> jPrimitiveTypes = new HashMap<String, JPrimitiveType>();

    public XJCJavaClassImpl(JDefinedClass jDefinedClass, JCodeModel codeModel, DynamicClassLoader loader) {
        this(jDefinedClass, codeModel, loader, false, false);
    }

    public XJCJavaClassImpl(JDefinedClass jDefinedClass, JCodeModel codeModel, DynamicClassLoader loader, boolean isArray, boolean isPrimitive) {
        this.xjcClass = jDefinedClass;
        this.jCodeModel = codeModel;
        this.dynamicClassLoader = loader;
        this.isArray = isArray;
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Collection<JavaClass> getActualTypeArguments() {
        JTypeVar[] typeParams = this.xjcClass.typeParams();
        if (null == typeParams || 0 == typeParams.length) {
            return null;
        }
        try {
            ArrayList<JavaClass> typeArguments = new ArrayList<JavaClass>(1);
            JTypeVar var = typeParams[typeParams.length - 1];
            JClass xjcBoundClass = (JClass)PrivilegedAccessHelper.getValueFromField(JTYPEVAR_BOUND, var);
            JClass basis = null;
            try {
                Field basisField = PrivilegedAccessHelper.getDeclaredField(xjcBoundClass.getClass(), "basis", true);
                basis = (JClass)PrivilegedAccessHelper.getValueFromField(basisField, xjcBoundClass);
            }
            catch (Exception e) {
                // empty catch block
            }
            JavaClass boundClass = basis != null ? this.javaModel.getClass(basis.fullName()) : (this.javaModel != null ? this.javaModel.getClass(xjcBoundClass.fullName()) : new XJCJavaClassImpl((JDefinedClass)xjcBoundClass, this.jCodeModel, this.dynamicClassLoader));
            typeArguments.add(boundClass);
            return typeArguments;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public JavaClass getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return this.javaModel.getClass(this.xjcClass.fullName());
    }

    @Override
    public JavaConstructor getConstructor(JavaClass[] parameterTypes) {
        JType[] xjcParameterTypes = new JType[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            JavaClass pType = parameterTypes[i];
            String className = pType.getQualifiedName();
            Object xjcType = null;
            xjcType = pType.isPrimitive() ? (JType)jPrimitiveTypes.get(className) : this.jCodeModel._getClass(className);
            xjcParameterTypes[i] = xjcType;
        }
        JMethod constructor = this.xjcClass.getConstructor(xjcParameterTypes);
        return new XJCJavaConstructorImpl(constructor, this.jCodeModel, this.dynamicClassLoader, this);
    }

    @Override
    public Collection<JavaConstructor> getConstructors() {
        ArrayList<JavaConstructor> constructors = new ArrayList<JavaConstructor>();
        Iterator it = this.xjcClass.constructors();
        while (it.hasNext()) {
            constructors.add(new XJCJavaConstructorImpl((JMethod)it.next(), this.jCodeModel, this.dynamicClassLoader, this));
        }
        return constructors;
    }

    @Override
    public Collection<JavaClass> getDeclaredClasses() {
        ArrayList<JavaClass> declaredClasses = new ArrayList<JavaClass>();
        Iterator it = this.xjcClass.classes();
        while (it.hasNext()) {
            XJCJavaClassImpl dc = this.javaModel != null ? (XJCJavaClassImpl)this.javaModel.getClass(((JDefinedClass)it.next()).fullName()) : new XJCJavaClassImpl((JDefinedClass)it.next(), this.jCodeModel, this.dynamicClassLoader);
            declaredClasses.add(dc);
        }
        return declaredClasses;
    }

    @Override
    public JavaConstructor getDeclaredConstructor(JavaClass[] parameterTypes) {
        return this.getConstructor(parameterTypes);
    }

    @Override
    public Collection<JavaConstructor> getDeclaredConstructors() {
        return this.getConstructors();
    }

    @Override
    public JavaField getDeclaredField(String fieldName) {
        JFieldVar xjcField = (JFieldVar)this.xjcClass.fields().get(fieldName);
        return new XJCJavaFieldImpl(xjcField, this.jCodeModel, this.dynamicClassLoader, this);
    }

    @Override
    public Collection<JavaField> getDeclaredFields() {
        Collection xjcFields = this.xjcClass.fields().values();
        ArrayList<JavaField> fields = new ArrayList<JavaField>(xjcFields.size());
        for (JFieldVar jField : xjcFields) {
            fields.add(new XJCJavaFieldImpl(jField, this.jCodeModel, this.dynamicClassLoader, this));
        }
        return fields;
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaClass[] args) {
        return this.getMethod(name, args);
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods() {
        return this.getMethods();
    }

    @Override
    public JavaMethod getMethod(String name, JavaClass[] args) {
        Collection xjcMethods = this.xjcClass.methods();
        for (JMethod xjcMethod : xjcMethods) {
            JType[] params = xjcMethod.listParamTypes();
            boolean argsAreEqual = this.argsAreEqual(args, params);
            if (!xjcMethod.name().equals(name) || !argsAreEqual) continue;
            return new XJCJavaMethodImpl(xjcMethod, this.jCodeModel, this.dynamicClassLoader, this);
        }
        return null;
    }

    private boolean argsAreEqual(JavaClass[] elinkArgs, JType[] xjcArgs) {
        if (elinkArgs == null && xjcArgs == null) {
            return true;
        }
        if (elinkArgs != null && xjcArgs == null) {
            return false;
        }
        if (elinkArgs == null && xjcArgs != null) {
            return false;
        }
        if (elinkArgs.length != xjcArgs.length) {
            return false;
        }
        for (int i = 0; i < elinkArgs.length; ++i) {
            JavaClass elinkClass = elinkArgs[i];
            JType xjcClass = xjcArgs[i];
            if (elinkClass.getQualifiedName().equals(xjcClass.fullName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<JavaMethod> getMethods() {
        Collection xjcMethods = this.xjcClass.methods();
        ArrayList<JavaMethod> elinkMethods = new ArrayList<JavaMethod>(xjcMethods.size());
        for (JMethod xjcMethod : xjcMethods) {
            elinkMethods.add(new XJCJavaMethodImpl(xjcMethod, this.jCodeModel, this.dynamicClassLoader, this));
        }
        return elinkMethods;
    }

    @Override
    public int getModifiers() {
        JMods xjcMods = null;
        try {
            xjcMods = (JMods)PrivilegedAccessHelper.getValueFromField(JDEFINEDCLASS_MODS, this.xjcClass);
        }
        catch (Exception e) {
            return 0;
        }
        return xjcMods.getValue();
    }

    @Override
    public String getName() {
        return this.getQualifiedName();
    }

    @Override
    public JavaPackage getPackage() {
        return new XJCJavaPackageImpl(this.xjcClass.getPackage(), this.dynamicClassLoader);
    }

    @Override
    public String getPackageName() {
        return this.xjcClass._package().name();
    }

    @Override
    public String getQualifiedName() {
        if (this.isArray) {
            if (this.isPrimitive) {
                return this.getPrimitiveArrayNameFor(this.xjcClass.fullName());
            }
            return "[L" + this.xjcClass.fullName();
        }
        return this.xjcClass.fullName();
    }

    private String getPrimitiveArrayNameFor(String fullName) {
        Class componentClass = ConversionManager.getPrimitiveClass(fullName);
        if (componentClass != null) {
            if (componentClass == ClassConstants.PBYTE) {
                return ClassConstants.APBYTE.getName();
            }
            if (componentClass == ClassConstants.PCHAR) {
                return ClassConstants.APCHAR.getName();
            }
            if (componentClass == ClassConstants.PBOOLEAN) {
                return boolean[].class.getName();
            }
            if (componentClass == ClassConstants.PDOUBLE) {
                return double[].class.getName();
            }
            if (componentClass == ClassConstants.PFLOAT) {
                return float[].class.getName();
            }
            if (componentClass == ClassConstants.PINT) {
                return int[].class.getName();
            }
            if (componentClass == ClassConstants.PLONG) {
                return long[].class.getName();
            }
            if (componentClass == ClassConstants.PSHORT) {
                return short[].class.getName();
            }
        }
        return fullName;
    }

    @Override
    public String getRawName() {
        if (this.isArray) {
            return this.xjcClass.fullName() + "[]";
        }
        return this.xjcClass.fullName();
    }

    @Override
    public JavaClass getSuperclass() {
        try {
            JClass superClass = (JClass)PrivilegedAccessHelper.getValueFromField(JDEFINEDCLASS_SUPERCLASS, this.xjcClass);
            if (superClass instanceof JDefinedClass) {
                if (this.javaModel != null) {
                    return this.javaModel.getClass(superClass.fullName());
                }
                return new XJCJavaClassImpl((JDefinedClass)superClass, this.jCodeModel, this.dynamicClassLoader);
            }
            if (this.javaModel != null) {
                return this.javaModel.getClass(superClass.fullName());
            }
            return new XJCJavaClassImpl((JDefinedClass)superClass, this.jCodeModel, this.dynamicClassLoader);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean hasActualTypeArguments() {
        return this.xjcClass.typeParams().length > 0;
    }

    @Override
    public boolean isAbstract() {
        return this.xjcClass.isAbstract();
    }

    @Override
    public boolean isAnnotation() {
        return this.xjcClass.isAnnotationTypeDeclaration();
    }

    @Override
    public boolean isArray() {
        if (this.isArray) {
            return true;
        }
        return this.xjcClass.isArray();
    }

    @Override
    public boolean isAssignableFrom(JavaClass javaClass) {
        if (javaClass == null) {
            return false;
        }
        XJCJavaClassImpl javaClassImpl = (XJCJavaClassImpl)javaClass;
        JDefinedClass someClass = javaClassImpl.xjcClass;
        return this.xjcClass.isAssignableFrom((JClass)someClass);
    }

    @Override
    public boolean isEnum() {
        return this.xjcClass.getClassType().equals(ClassType.ENUM);
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public boolean isInterface() {
        return this.xjcClass.isInterface();
    }

    @Override
    public boolean isMemberClass() {
        return this.xjcClass.outer() != null;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        throw new UnsupportedOperationException("isSynthetic");
    }

    @Override
    public JavaAnnotation getAnnotation(JavaClass aClass) {
        if (aClass != null) {
            Collection annotations = null;
            try {
                annotations = (Collection)PrivilegedAccessHelper.getValueFromField(JDEFINEDCLASS_ANNOTATIONS, this.xjcClass);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (annotations == null) {
                return null;
            }
            for (JAnnotationUse annotationUse : annotations) {
                String annotationClass;
                XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
                String myAnnotationClass = xjcAnnotation.getJavaAnnotationClass().getCanonicalName();
                if (!myAnnotationClass.equals(annotationClass = aClass.getQualifiedName())) continue;
                return xjcAnnotation;
            }
            return null;
        }
        return null;
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>();
        Collection annotations = null;
        try {
            annotations = (Collection)PrivilegedAccessHelper.getValueFromField(JDEFINEDCLASS_ANNOTATIONS, this.xjcClass);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (annotations == null) {
            return annotationsList;
        }
        for (JAnnotationUse annotationUse : annotations) {
            XJCJavaAnnotationImpl xjcAnnotation = new XJCJavaAnnotationImpl(annotationUse, this.dynamicClassLoader);
            annotationsList.add(xjcAnnotation);
        }
        return annotationsList;
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        throw new UnsupportedOperationException("getDeclaredAnnotation");
    }

    @Override
    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        throw new UnsupportedOperationException("getDeclaredAnnotations");
    }

    public JavaModel getJavaModel() {
        return this.javaModel;
    }

    public void setJavaModel(JavaModel javaModel) {
        this.javaModel = javaModel;
    }

    static {
        JCodeModel tempCodeModel = new JCodeModel();
        jPrimitiveTypes.put("java.lang.Boolean", tempCodeModel.BOOLEAN);
        jPrimitiveTypes.put("java.lang.Byte", tempCodeModel.BYTE);
        jPrimitiveTypes.put("java.lang.Character", tempCodeModel.CHAR);
        jPrimitiveTypes.put("java.lang.Double", tempCodeModel.DOUBLE);
        jPrimitiveTypes.put("java.lang.Float", tempCodeModel.FLOAT);
        jPrimitiveTypes.put("java.lang.Integer", tempCodeModel.INT);
        jPrimitiveTypes.put("java.lang.Long", tempCodeModel.LONG);
        jPrimitiveTypes.put("java.lang.Short", tempCodeModel.SHORT);
        try {
            JDEFINEDCLASS_ANNOTATIONS = PrivilegedAccessHelper.getDeclaredField(JDefinedClass.class, "annotations", true);
            JDEFINEDCLASS_MODS = PrivilegedAccessHelper.getDeclaredField(JDefinedClass.class, "mods", true);
            JDEFINEDCLASS_SUPERCLASS = PrivilegedAccessHelper.getDeclaredField(JDefinedClass.class, "superClass", true);
            JTYPEVAR_BOUND = PrivilegedAccessHelper.getDeclaredField(JTypeVar.class, "bound", true);
        }
        catch (Exception e) {
            throw JAXBException.errorCreatingDynamicJAXBContext(e);
        }
    }
}

