/*
 * Decompiled with CFR 0.152.
 */
package org.shop.editor;

import com.google.common.base.Function;
import demo.Components;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.persistence.EntityManager;
import javax.swing.JOptionPane;
import org.openide.util.Lookup;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Wait;
import org.shop.editor.EntityService;

public class VehicleGroup {
    WebDriver driver;
    Wait<WebDriver> wait;
    private AtomicLong lastActivityTime;
    private ScheduledExecutorService scheduler;
    private static final long INACTIVITY_TIMEOUT = 300000L;

    public void VehicleGroup() {
        this.lastActivityTime = new AtomicLong(System.currentTimeMillis());
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.cleanupTempChromeDriverFiles();
    }

    private void startInactivityCheck() {
        try {
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    long currentTime = System.currentTimeMillis();
                    long lastActivity = VehicleGroup.this.lastActivityTime.get();
                    System.out.println("INACTIVITY_TIMEOUT: 300000 startInactivityCheck: " + currentTime + " lastActivity: " + lastActivity + " lapse: " + (currentTime - lastActivity));
                    if (currentTime - lastActivity > 300000L || !VehicleGroup.this.isBrowserOpen()) {
                        System.out.println("No activity detected for 1 minute. Quitting browser...");
                        VehicleGroup.this.quit();
                    }
                }
            }, 0L, 10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            System.err.println("Error at startInactivityCheck: " + e.getMessage());
        }
    }

    private void resetInactivityTimer() {
        this.lastActivityTime.set(System.currentTimeMillis());
        System.out.println("resetInactivityTimer: " + System.currentTimeMillis());
    }

    public boolean isBrowserOpen() {
        try {
            this.driver.getCurrentUrl();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void quit() {
        try {
            if (this.driver != null) {
                if (this.isBrowserOpen()) {
                    try {
                        this.driver.quit();
                    }
                    catch (NoClassDefFoundError e) {
                        System.err.println("Warning: Could not properly quit browser using Selenium. Attempting alternative cleanup...");
                        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                            Runtime.getRuntime().exec("taskkill /F /IM chrome.exe");
                            Runtime.getRuntime().exec("taskkill /F /IM chromedriver.exe");
                        }
                        Runtime.getRuntime().exec("pkill -f chrome");
                        Runtime.getRuntime().exec("pkill -f chromedriver");
                    }
                }
                this.driver = null;
            }
            if (!this.scheduler.isShutdown()) {
                this.scheduler.shutdown();
            }
            this.cleanupTempChromeDriverFiles();
        }
        catch (Exception e) {
            System.err.println("Error closing browser: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.quit();
            this.cleanupTempChromeDriverFiles();
        }
        finally {
            super.finalize();
        }
    }

    private void cleanupTempChromeDriverFiles() {
        try {
            String tempDir = System.getProperty("java.io.tmpdir");
            File tempFolder = new File(tempDir);
            File[] files = tempFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().startsWith("chrome");
                }
            });
            if (files != null) {
                for (File file : files) {
                    try {
                        boolean deleted;
                        if (!file.exists() || (deleted = file.delete())) continue;
                        System.out.println("Could not delete file: " + file.getAbsolutePath());
                    }
                    catch (Exception e) {
                        System.err.println("Error deleting file " + file.getAbsolutePath() + ": " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error cleaning up temp files: " + e.getMessage());
        }
    }

    private String getChromeVersion() {
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder("reg", "query", "HKEY_CURRENT_USER\\Software\\Google\\Chrome\\BLBeacon", "/v", "version");
            Process p = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("version")) continue;
                String[] parts = line.split("\\s+");
                return parts[parts.length - 1];
            }
        }
        catch (Exception e) {
            System.err.println("Error getting Chrome version: " + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String downloadChromeDriver(String version) {
        try {
            System.setProperty("https.protocols", "TLSv1.2");
            System.setProperty("jdk.tls.client.protocols", "TLSv1.2");
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            System.out.println("Starting ChromeDriver download for version: " + version);
            String majorVersion = version.split("\\.")[0];
            String downloadUrl = "https://edgedl.me.gvt1.com/edgedl/chrome/chrome-for-testing/" + version + "/win32/chromedriver-win32.zip";
            System.out.println("Download URL: " + downloadUrl);
            URL url = new URL(downloadUrl);
            System.out.println("Opening connection to URL...");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            System.out.println("Connection response code: " + connection.getResponseCode());
            if (connection.getResponseCode() != 200) {
                System.err.println("Failed to download ChromeDriver. Response code: " + connection.getResponseCode());
                return null;
            }
            File zipFile = File.createTempFile("chromedriver", ".zip");
            System.out.println("Created temporary zip file: " + zipFile.getAbsolutePath());
            zipFile.deleteOnExit();
            System.out.println("Downloading zip file...");
            try (InputStream in = connection.getInputStream();
                 FileOutputStream out = new FileOutputStream(zipFile);){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            System.out.println("Zip file downloaded successfully");
            System.out.println("Extracting zip file...");
            String extractPath = zipFile.getParent();
            System.out.println("Extraction path: " + extractPath);
            try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFile));){
                ZipEntry entry;
                while ((entry = zipIn.getNextEntry()) != null) {
                    if (!entry.getName().endsWith("chromedriver.exe")) continue;
                    System.out.println("Found chromedriver.exe in zip");
                    File outFile = File.createTempFile("chromedriver", ".exe");
                    outFile.deleteOnExit();
                    System.out.println("Extracting to: " + outFile.getAbsolutePath());
                    File parentDir = outFile.getParentFile();
                    if (parentDir != null && !parentDir.exists()) {
                        System.out.println("Creating directory: " + parentDir.getAbsolutePath());
                        parentDir.mkdirs();
                    }
                    try (FileOutputStream out = new FileOutputStream(outFile);){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = zipIn.read(buffer)) != -1) {
                            out.write(buffer, 0, len);
                        }
                    }
                    System.out.println("ChromeDriver extracted successfully");
                    String string = outFile.getAbsolutePath();
                    return string;
                }
            }
            System.err.println("Could not find chromedriver.exe in the zip file");
            return null;
        }
        catch (Exception e) {
            System.err.println("Error downloading ChromeDriver: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, String> scrapeVehicleGroup(Integer series, Integer client, Integer subversion, Integer province, Integer vehicle) throws Exception {
        if (this.driver == null || !this.isBrowserOpen()) {
            this.quit();
            this.VehicleGroup();
            try {
                String chromeVersion = this.getChromeVersion();
                if (chromeVersion == null) {
                    throw new RuntimeException("Could not determine Chrome version");
                }
                String driverPath = this.downloadChromeDriver(chromeVersion);
                if (driverPath == null) {
                    throw new RuntimeException("Could not download ChromeDriver");
                }
                System.setProperty("webdriver.chrome.driver", driverPath);
                ChromeOptions options = new ChromeOptions();
                options.addArguments(new String[]{"--no-sandbox"});
                options.addArguments(new String[]{"--disable-dev-shm-usage"});
                options.addArguments(new String[]{"--remote-debugging-port=9222"});
                options.addArguments(new String[]{"--disable-gpu"});
                options.addArguments(new String[]{"--disable-extensions"});
                options.addArguments(new String[]{"--disable-software-rasterizer"});
                options.addArguments(new String[]{"--ignore-certificate-errors"});
                this.driver = new ChromeDriver(options);
                this.wait = new FluentWait((Object)this.driver).withTimeout(10L, TimeUnit.SECONDS).pollingEvery(2L, TimeUnit.SECONDS);
                this.startInactivityCheck();
            }
            catch (Exception e) {
                System.err.println("Cannot load Chrome driver: \n" + e.getMessage());
                JOptionPane.showMessageDialog(null, "Error starting Chrome. Please ensure Chrome is installed, all chrome browsers closed, internet is accessible", "Chrome Error", 0);
            }
            return new HashMap<String, String>();
        }
        this.resetInactivityTimer();
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList3 = series == 1 ? entityManager.createNamedQuery("Components.series.province.vehicle.name.all").setParameter("client", (Object)client).setParameter("version", (Object)subversion).setParameter("province", (Object)0).setParameter("vehicle", (Object)0).setParameter("series", (Object)1).setParameter("name", (Object)"Labels").getResultList() : entityManager.createNamedQuery("Components.series.province.vehicle.name.all").setParameter("client", (Object)client).setParameter("version", (Object)subversion).setParameter("province", (Object)province).setParameter("vehicle", (Object)vehicle).setParameter("series", (Object)2).setParameter("name", (Object)"Labels").getResultList();
        System.out.println("VehicleGroup1: Loaded maps");
        HashMap<String, String> vehicleGroupDict = new HashMap<String, String>();
        try {
            for (Components c3 : resultList3) {
                String[] pair = c3.getDisplay().split(":", -99);
                if (pair.length != 2) continue;
                try {
                    final String elementId = pair[0];
                    WebElement element = (WebElement)this.wait.until((Function)new Function<WebDriver, WebElement>(){

                        public WebElement apply(WebDriver driver) {
                            return driver.findElement(By.id((String)elementId));
                        }
                    });
                    vehicleGroupDict.put(pair[1], element.getText());
                }
                catch (Exception e) {}
            }
            System.out.println("VehicleGroup1 - Number of data points transfered: " + vehicleGroupDict.size());
            JOptionPane.showMessageDialog(null, "Number of data points transfered: " + vehicleGroupDict.size(), "Data Transfer", 1);
        }
        catch (Exception e) {
            System.err.println("An error occurred: " + e.getMessage());
            e.printStackTrace();
        }
        return vehicleGroupDict;
    }
}

