/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.log;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.openqa.selenium.remote.server.log.DefaultPerSessionLogHandler;
import org.openqa.selenium.remote.server.log.LoggingOptions;
import org.openqa.selenium.remote.server.log.MaxLevelFilter;
import org.openqa.selenium.remote.server.log.NoOpSessionLogHandler;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;
import org.openqa.selenium.remote.server.log.ShortTermMemoryHandler;
import org.openqa.selenium.remote.server.log.StdOutHandler;
import org.openqa.selenium.remote.server.log.TerseFormatter;

public class LoggingManager {
    private static Handler[] originalHandlers;
    private static Map<Handler, Formatter> originalFormatters;
    private static Map<Handler, Level> originalLogLevels;
    private static Map<File, FileHandler> seleniumFileHandlers;
    private static ShortTermMemoryHandler shortTermMemoryHandler;
    private static PerSessionLogHandler perSessionLogHandler;

    static {
        seleniumFileHandlers = new HashMap<File, FileHandler>();
        perSessionLogHandler = new NoOpSessionLogHandler();
    }

    public static synchronized void configureLogging(LoggingOptions options, boolean debugMode) {
        if (options.dontTouchLogging()) {
            return;
        }
        Logger currentLogger = Logger.getLogger("");
        LoggingManager.resetLoggerToOriginalState();
        LoggingManager.overrideSimpleFormatterWithTerseOneForConsoleHandler(currentLogger, debugMode);
        LoggingManager.addInMemoryLogger(currentLogger, options);
        if (debugMode) {
            currentLogger.setLevel(Level.FINE);
        }
    }

    public static synchronized ShortTermMemoryHandler shortTermMemoryHandler() {
        return shortTermMemoryHandler;
    }

    public static synchronized PerSessionLogHandler perSessionLogHandler() {
        return perSessionLogHandler;
    }

    private static void addInMemoryLogger(Logger logger, LoggingOptions options) {
        shortTermMemoryHandler = new ShortTermMemoryHandler(options.shortTermMemoryLoggerCapacity(), Level.INFO, new TerseFormatter(true));
        logger.addHandler(shortTermMemoryHandler);
    }

    private static void addPerSessionLogger(Logger logger, LoggingOptions options, boolean debugMode) {
        perSessionLogHandler = debugMode ? new DefaultPerSessionLogHandler(options.shortTermMemoryLoggerCapacity(), Level.FINE, new TerseFormatter(true), options.isCaptureOfLogsOnQuitEnabled()) : new DefaultPerSessionLogHandler(options.shortTermMemoryLoggerCapacity(), Level.INFO, new TerseFormatter(true), options.isCaptureOfLogsOnQuitEnabled());
        logger.addHandler(perSessionLogHandler);
    }

    private static File addNewSeleniumFileHandler(Logger currentLogger, LoggingOptions options) {
        try {
            File logFile = options.getLogOutFile();
            FileHandler fileHandler = seleniumFileHandlers.get(logFile);
            if (fileHandler == null) {
                fileHandler = LoggingManager.registerNewSeleniumFileHandler(logFile);
            }
            fileHandler.setFormatter(new TerseFormatter(true));
            currentLogger.setLevel(Level.FINE);
            fileHandler.setLevel(Level.FINE);
            currentLogger.addHandler(fileHandler);
            return logFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static FileHandler registerNewSeleniumFileHandler(File logFile) throws IOException {
        FileHandler fileHandler = new FileHandler(logFile.getAbsolutePath());
        seleniumFileHandlers.put(logFile, fileHandler);
        return fileHandler;
    }

    public static void overrideSimpleFormatterWithTerseOneForConsoleHandler(Logger logger, boolean debugMode) {
        Handler[] handlerArray = logger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Formatter formatter;
            Handler handler = handlerArray[n2];
            if (handler instanceof ConsoleHandler && (formatter = handler.getFormatter()) instanceof SimpleFormatter) {
                Level originalLevel = handler.getLevel();
                handler.setFormatter(new TerseFormatter(false));
                handler.setLevel(Level.WARNING);
                StdOutHandler stdOutHandler = new StdOutHandler();
                stdOutHandler.setFormatter(new TerseFormatter(false));
                stdOutHandler.setFilter(new MaxLevelFilter(Level.INFO));
                stdOutHandler.setLevel(originalLevel);
                logger.addHandler(stdOutHandler);
                if (debugMode && originalLevel.intValue() > Level.FINE.intValue()) {
                    stdOutHandler.setLevel(Level.FINE);
                }
            }
            ++n2;
        }
    }

    protected static void resetLoggerToOriginalState() {
        Logger logger = Logger.getLogger("");
        if (originalHandlers == null) {
            LoggingManager.saveOriginalHandlersFormattersAndLevels(logger);
        } else {
            LoggingManager.restoreOriginalHandlersFormattersAndLevels(logger);
        }
    }

    protected static void restoreOriginalHandlersFormattersAndLevels(Logger logger) {
        Handler handler;
        Handler[] handlerArray = logger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            handler = handlerArray[n2];
            logger.removeHandler(handler);
            ++n2;
        }
        handlerArray = originalHandlers;
        n = originalHandlers.length;
        n2 = 0;
        while (n2 < n) {
            handler = handlerArray[n2];
            logger.addHandler(handler);
            if (originalFormatters.get(handler) != null) {
                handler.setFormatter(originalFormatters.get(handler));
            }
            handler.setLevel(originalLogLevels.get(handler));
            ++n2;
        }
    }

    protected static void saveOriginalHandlersFormattersAndLevels(Logger logger) {
        originalHandlers = logger.getHandlers();
        originalFormatters = new HashMap<Handler, Formatter>();
        originalLogLevels = new HashMap<Handler, Level>();
        Handler[] handlerArray = originalHandlers;
        int n = originalHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            originalFormatters.put(handler, handler.getFormatter());
            originalLogLevels.put(handler, handler.getLevel());
            ++n2;
        }
    }
}

