/*
 * Decompiled with CFR 0.152.
 */
package org.shop.tools;

import demo.Claims;
import demo.Components;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.bind.DatatypeConverter;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.shop.tools.InsuredLog;
import org.shop.tools.Jersey;
import org.shop.tools.Password;
import org.shop.tools.ToolsTopComponent;

public class UserSelf
extends JFrame {
    PasswordValidator checker = new PasswordValidator();
    Integer client;
    String PU;
    UserSelf ins = this;
    String username = "";
    int passwordPeriod = 30;
    int passwordHistory = 365;
    Password pwd;
    ToolsTopComponent my;
    String passwordcurrent = "";
    Components comp = null;
    Jersey jersey = new Jersey();
    List<String> previousPasswords = new ArrayList<String>();
    public JButton bCancel;
    public JButton bSubmit;
    private JLabel jLabel14;
    private JLabel jLabel16;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    public JLabel lbCurrent;
    public JLabel lbNew;
    public JLabel lbResponse;
    JTextArea lbRules;
    public JTextField txtCurrent;
    public JTextField txtNew;

    public UserSelf(String pu, Integer clnt, String name, String pswd, int pswdPeriod, int pswdHistory, ToolsTopComponent obj) {
        this.initComponents();
        this.setTitle("Change Password");
        this.PU = pu;
        this.passwordPeriod = pswdPeriod;
        this.passwordHistory = pswdHistory;
        this.my = obj;
        this.client = clnt;
        this.username = name;
        this.passwordcurrent = pswd;
        this.txtNew.addKeyListener(new myKeyAdapter2(this.txtNew));
        this.bCancel.addActionListener(new ExposureListener());
        this.bSubmit.addActionListener(new ExposureListener());
        this.bSubmit.setEnabled(false);
        this.load();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UserSelf.this.close();
            }
        });
    }

    Boolean CheckExpiry() {
        String code = this.encrypt(this.username, this.passwordcurrent);
        List<Components> resultList1 = this.jersey.getQuery(Components.class, "Components.findByDescription", "description", code);
        Boolean boo = false;
        this.comp = null;
        Iterator<Components> it = resultList1.iterator();
        if (it.hasNext()) {
            this.comp = it.next();
        }
        if (this.comp != null) {
            int highInt = this.oi(this.comp.getPosx());
            int lowInt = this.oi(this.comp.getPosy());
            long millis = (long)highInt << 32 | (long)lowInt & 0xFFFFFFFFL;
            String date_to_string = this.getDateString(millis);
            long diff = 86400000L * (long)this.passwordPeriod;
            if (System.currentTimeMillis() - millis > diff) {
                boo = true;
            }
        }
        return boo;
    }

    String getDateString(long millis) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MMMdd");
        Date DateNow = new Date(millis);
        String date_to_string = sdf.format(DateNow);
        Date parsedDate = null;
        long millis2 = 0L;
        try {
            parsedDate = sdf.parse(date_to_string);
            millis2 = parsedDate.getTime();
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        System.out.println("Date String : " + date_to_string);
        System.out.println("Milliseconds: " + millis);
        System.out.println("Milliseconds: " + millis2);
        return date_to_string;
    }

    String encrypt(String name, String password) {
        try {
            PasswordEncryptionService service = new PasswordEncryptionService();
            byte[] salt = UserSelf.toByteArray("C2F3838FDE87197B");
            byte[] encodedPassword = service.getEncryptedPassword(name + password, salt);
            password = UserSelf.toHexString(encodedPassword);
            name = "";
        }
        catch (NoSuchAlgorithmException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvalidKeySpecException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return password;
    }

    List<Object[]> pswdList(String name, String password) {
        password = this.encrypt(name, password);
        name = "";
        if (password.isEmpty()) {
            return new ArrayList<Object[]>();
        }
        List<Object[]> arr = this.jersey.getVector("Components.check", "initvalue", name, "description", password);
        return arr;
    }

    Integer oi(Object obj) {
        return obj == null ? 0 : (Integer)obj;
    }

    Integer b2i(Boolean b) {
        return b != false ? 1 : 0;
    }

    Boolean i2b(Integer i) {
        return i == null ? false : i == 1;
    }

    void Save() {
        this.comp.setInitindex(Integer.valueOf(-1));
        this.comp.setCoverage("");
        this.comp.setInitvalue(this.username);
        this.comp.setDescription(this.txtNew.getText());
        long millis = System.currentTimeMillis();
        int highInt = (int)(millis >> 32);
        int lowInt = (int)(millis & 0xFFFFFFFFL);
        this.comp.setPosx(Integer.valueOf(highInt));
        this.comp.setPosy(Integer.valueOf(lowInt));
        String date_to_string = this.getDateString(millis);
        if (date_to_string.length() >= 5) {
            this.comp.setSuffix(date_to_string.substring(date_to_string.length() - 5));
        }
        this.jersey.merge(Components.class, this.comp);
    }

    void log() {
        String pswd = this.encrypt(this.comp.getInitvalue(), this.comp.getDescription());
        Claims clm = new Claims();
        clm.setClient(this.client);
        clm.setUsersgroup(pswd);
        clm.setVersion(this.comp.getPosx());
        clm.setRecordnumber(this.comp.getPosy());
        clm.setPolnum(Integer.valueOf(-2));
        this.jersey.merge(Claims.class, this.comp);
    }

    void load() {
        this.previousPasswords = new ArrayList<String>();
        List<Claims> rl = this.jersey.getQuery(Claims.class, "Claims.polnum", "client", this.client, "polnum", -2);
        for (Claims clm : rl) {
            int highInt = this.oi(clm.getVersion());
            int lowInt = this.oi(clm.getRecordnumber());
            long millis = (long)highInt << 32 | (long)lowInt & 0xFFFFFFFFL;
            long diff = 86400000L * (long)this.passwordHistory;
            if (System.currentTimeMillis() - millis < diff) {
                this.previousPasswords.add(clm.getUsersgroup());
                continue;
            }
            this.jersey.remove(Claims.class, clm.getNumber());
        }
    }

    public void updateFleetdb() {
        List<Components> resultList1 = this.jersey.getQuery(Components.class, "Components.findByNamed", "named", "Logon");
        List<Components> resultList2 = this.jersey.getQuery(Components.class, "Components.findByNamed", "named", "Setup");
        try {
            String holdClient = FileUtil.getConfigFile((String)"Menu").getAttribute("jersey_client").toString();
            FileUtil.getConfigFile((String)"Menu").setAttribute("jersey_client", (Object)"db");
            System.out.println("Connecting to Fleetdb before deleting table:");
            this.emptyTable("Components");
            for (Components c : resultList1) {
                this.jersey.merge(Components.class, c);
            }
            for (Components c : resultList2) {
                this.jersey.merge(Components.class, c);
            }
            FileUtil.getConfigFile((String)"Menu").setAttribute("jersey_client", (Object)holdClient);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void emptyTable(String table) {
        System.out.println("Delete all records from table " + table);
        String str = "";
        Components c2 = null;
        List<Components> resultList = this.jersey.getQuery(Components.class, table + ".findAll");
        for (Components c2 : resultList) {
            str = str + ":" + c2.getNumber();
        }
        System.out.println("UpdateTable:emptyTable: Records to delete " + resultList.size());
        if (!str.isEmpty()) {
            str = str.substring(1);
            this.jersey.processDelete(c2.getClient(), "fleet." + table, str);
        }
    }

    public void encryptLogin(String criteria) {
        this.jersey.clearHashmap();
        List<Components> resultList = this.jersey.getQuery(Components.class, "Components.findByNamed", "named", "Logon");
        PasswordEncryptionService service = new PasswordEncryptionService();
        byte[] salt = UserSelf.toByteArray("C2F3838FDE87197B");
        for (Components c : resultList) {
            if (!c.getCoverage().isEmpty() || c.getInitvalue().isEmpty() || c.getDescription().isEmpty() || !criteria.isEmpty() && !c.getInitvalue().equals(criteria)) continue;
            try {
                String password = c.getInitvalue() + c.getDescription();
                System.out.println("client: " + c.getClient().toString() + "; search: " + password + "; length: " + password.length());
                String encodedpasswordString = password;
                byte[] encodedPassword = service.getEncryptedPassword(password, salt);
                encodedpasswordString = UserSelf.toHexString(encodedPassword);
                System.out.println("encodedpasswordString: " + encodedpasswordString + "; length: " + encodedpasswordString.length());
                c.setCoverage(c.getInitvalue());
                c.setInitvalue("");
                c.setDescription(encodedpasswordString);
            }
            catch (InvalidKeySpecException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (NoSuchAlgorithmException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.jersey.merge(Components.class, c);
        }
    }

    public static String toHexString(byte[] array) {
        return DatatypeConverter.printHexBinary((byte[])array);
    }

    public static byte[] toByteArray(String s) {
        return DatatypeConverter.parseHexBinary((String)s);
    }

    void close() {
        this.dispose();
    }

    private void initComponents() {
        this.jLabel9 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel14 = new JLabel();
        this.bCancel = new JButton();
        this.lbNew = new JLabel();
        this.txtCurrent = new JTextField();
        this.lbCurrent = new JLabel();
        this.bSubmit = new JButton();
        this.jLabel16 = new JLabel();
        this.lbResponse = new JLabel();
        this.txtNew = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.lbRules = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.jLabel9.setFont(new Font("Tahoma", 0, 18));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(UserSelf.class, (String)"UserSelf.jLabel9.text"));
        this.jLabel14.setFont(new Font("Tahoma", 1, 14));
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(UserSelf.class, (String)"UserSelf.jLabel14.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bCancel, (String)NbBundle.getMessage(UserSelf.class, (String)"UserSelf.bCancel.text"));
        this.bCancel.setActionCommand(NbBundle.getMessage(UserSelf.class, (String)"UserSelf.bCancel.actionCommand"));
        this.lbNew.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lbNew, (String)NbBundle.getMessage(UserSelf.class, (String)"UserSelf.lbNew.text"));
        this.txtCurrent.setText(NbBundle.getMessage(UserSelf.class, (String)"UserSelf.txtCurrent.text"));
        this.lbCurrent.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lbCurrent, (String)NbBundle.getMessage(UserSelf.class, (String)"UserSelf.lbCurrent.text"));
        this.lbCurrent.setToolTipText(NbBundle.getMessage(UserSelf.class, (String)"UserSelf.lbCurrent.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.bSubmit, (String)NbBundle.getMessage(UserSelf.class, (String)"UserSelf.bSubmit.text"));
        this.bSubmit.setActionCommand(NbBundle.getMessage(UserSelf.class, (String)"UserSelf.bSubmit.actionCommand"));
        this.jLabel16.setFont(new Font("Tahoma", 1, 14));
        Mnemonics.setLocalizedText((JLabel)this.jLabel16, (String)NbBundle.getMessage(UserSelf.class, (String)"UserSelf.jLabel16.text"));
        this.lbResponse.setForeground(new Color(153, 51, 0));
        this.lbResponse.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lbResponse, (String)NbBundle.getMessage(UserSelf.class, (String)"UserSelf.lbResponse.text"));
        this.lbResponse.setToolTipText(NbBundle.getMessage(UserSelf.class, (String)"UserSelf.lbResponse.toolTipText"));
        this.txtNew.setText(NbBundle.getMessage(UserSelf.class, (String)"UserSelf.txtNew.text"));
        this.txtNew.setToolTipText(NbBundle.getMessage(UserSelf.class, (String)"UserSelf.txtNew.toolTipText"));
        this.lbRules.setColumns(20);
        this.lbRules.setRows(5);
        this.jScrollPane1.setViewportView(this.lbRules);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addGap(44, 44, 44).addComponent(this.lbNew, -2, 53, -2)).addComponent(this.lbCurrent, -2, 97, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bSubmit, -1, 378, Short.MAX_VALUE).addComponent(this.bCancel, -1, -1, Short.MAX_VALUE).addComponent(this.txtCurrent).addComponent(this.txtNew))).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel16, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.lbResponse, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtCurrent, -2, -1, -2).addComponent(this.lbCurrent)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbNew).addComponent(this.txtNew, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bSubmit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bCancel).addGap(47, 47, 47).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 124, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbResponse, -2, 31, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel9, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(InsuredLog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(InsuredLog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(InsuredLog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(InsuredLog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new UserSelf("fleet30", 30, "", "", 0, 0, null).setVisible(true);
            }
        });
    }

    void creatForm() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserSelf.this.setVisible(true);
            }
        });
    }

    public class PasswordValidator {
        StringBuilder errors = new StringBuilder();

        public boolean validatePassword(String password, String userName) {
            this.errors = new StringBuilder();
            boolean isValid = true;
            String passwordencrypted = UserSelf.this.encrypt(userName, password);
            if (password.length() < 10 || password.length() > 30) {
                this.errors.append("- Password must be between 10 and 30 characters.\n");
                isValid = false;
            }
            if (!Pattern.compile("[a-z]").matcher(password).find()) {
                this.errors.append("- Must contain at least one lowercase letter (a-z).\n");
                isValid = false;
            }
            if (!Pattern.compile("[A-Z]").matcher(password).find()) {
                this.errors.append("- Must contain at least one uppercase letter (A-Z).\n");
                isValid = false;
            }
            if (!Pattern.compile("[0-9]").matcher(password).find()) {
                this.errors.append("- Must contain at least one number (0-9).\n");
                isValid = false;
            }
            if (!Pattern.compile("[@#$%&*()_+|~=`{}\\[\\]:\"';/<>]").matcher(password).find()) {
                this.errors.append("- Must contain at least one special character (@#$%&*()_+|~=`{}[]:\"';/<>).\n");
                isValid = false;
            }
            if (userName != null && !userName.isEmpty() && password.toLowerCase().contains(userName.toLowerCase())) {
                this.errors.append("- Password must not contain your name.\n");
                isValid = false;
            }
            if (UserSelf.this.previousPasswords.contains(passwordencrypted)) {
                this.errors.append("- Password has been used before. Please choose a new one.\n");
                isValid = false;
            }
            if (UserSelf.this.passwordcurrent != null && !UserSelf.this.passwordcurrent.isEmpty() && password.equals(UserSelf.this.passwordcurrent)) {
                this.errors.append("- Password must not be the same as your current password.\n");
                isValid = false;
            }
            if (!isValid) {
                System.out.println("Password is INVALID:\n" + this.errors);
            } else {
                System.out.println("Password is STRONG and VALID.");
            }
            return isValid;
        }
    }

    class PasswordEncryptionService {
        PasswordEncryptionService() {
        }

        public boolean authenticate(String attemptedPassword, byte[] encryptedPassword, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
            byte[] encryptedAttemptedPassword = this.getEncryptedPassword(attemptedPassword, salt);
            return Arrays.equals(encryptedPassword, encryptedAttemptedPassword);
        }

        public byte[] getEncryptedPassword(String password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
            String algorithm = "PBKDF2WithHmacSHA1";
            int derivedKeyLength = 160;
            int iterations = 20000;
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterations, derivedKeyLength);
            SecretKeyFactory f = SecretKeyFactory.getInstance(algorithm);
            return f.generateSecret(spec).getEncoded();
        }

        public byte[] generateSalt() throws NoSuchAlgorithmException {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] salt = new byte[8];
            random.nextBytes(salt);
            return salt;
        }
    }

    class ExposureListener
    implements ActionListener {
        ExposureListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("Cancel")) {
                UserSelf.this.close();
            } else if (cmd.equals("Submit")) {
                if (!UserSelf.this.txtCurrent.getText().equals(UserSelf.this.passwordcurrent)) {
                    UserSelf.this.lbResponse.setText("Current Password is incorrect. Retry or contact administrator for assistance.");
                } else {
                    UserSelf.this.Save();
                    UserSelf.this.log();
                    UserSelf.this.encryptLogin("");
                    UserSelf.this.updateFleetdb();
                    UserSelf.this.pwd = new Password(UserSelf.this.PU, (Object)UserSelf.this.my);
                    UserSelf.this.pwd.creatForm();
                    UserSelf.this.pwd.Password.setText(UserSelf.this.txtNew.getText());
                    UserSelf.this.close();
                }
            }
        }
    }

    class myKeyAdapter2
    extends KeyAdapter {
        JTextField tf;

        myKeyAdapter2(JTextField st) {
            this.tf = st;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            UserSelf.this.bSubmit.setEnabled(UserSelf.this.checker.validatePassword(UserSelf.this.txtNew.getText(), UserSelf.this.username) && UserSelf.this.txtCurrent.getText().length() > 0);
            UserSelf.this.lbRules.setText(UserSelf.this.checker.errors.toString());
        }
    }
}

