/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.util.DerValue;

public final class KerberosPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = -7374788026156829911L;
    public static final int KRB_NT_UNKNOWN = 0;
    public static final int KRB_NT_PRINCIPAL = 1;
    public static final int KRB_NT_SRV_INST = 2;
    public static final int KRB_NT_SRV_HST = 3;
    public static final int KRB_NT_SRV_XHST = 4;
    public static final int KRB_NT_UID = 5;
    private transient String fullName;
    private transient String realm;
    private transient int nameType;
    private static final char NAME_REALM_SEPARATOR = '@';

    public KerberosPrincipal(String string) {
        PrincipalName principalName = null;
        try {
            principalName = new PrincipalName(string, 1);
        }
        catch (KrbException krbException) {
            throw new IllegalArgumentException(krbException.getMessage());
        }
        this.nameType = 1;
        this.fullName = principalName.toString();
        this.realm = principalName.getRealmString();
    }

    public KerberosPrincipal(String string, int n) {
        PrincipalName principalName = null;
        try {
            principalName = new PrincipalName(string, n);
        }
        catch (KrbException krbException) {
            throw new IllegalArgumentException(krbException.getMessage());
        }
        this.nameType = n;
        this.fullName = principalName.toString();
        this.realm = principalName.getRealmString();
    }

    public String getRealm() {
        return this.realm;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KerberosPrincipal)) {
            return false;
        }
        String string = this.getName();
        String string2 = ((KerberosPrincipal)object).getName();
        return this.nameType == ((KerberosPrincipal)object).nameType && string.equals(string2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        PrincipalName principalName = null;
        try {
            principalName = new PrincipalName(this.fullName, this.nameType);
            objectOutputStream.writeObject(principalName.asn1Encode());
            objectOutputStream.writeObject(principalName.getRealm().asn1Encode());
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInputStream.readObject();
        byte[] byArray2 = (byte[])objectInputStream.readObject();
        try {
            PrincipalName principalName = new PrincipalName(new DerValue(byArray));
            this.realm = new Realm(new DerValue(byArray2)).toString();
            this.fullName = principalName.toString() + '@' + this.realm.toString();
            this.nameType = principalName.getNameType();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    @Override
    public String getName() {
        return this.fullName;
    }

    public int getNameType() {
        return this.nameType;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

