/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.general;

import java.util.prefs.Preferences;
import org.netbeans.core.ProxySettings;
import org.openide.util.NbPreferences;

class GeneralOptionsModel {
    GeneralOptionsModel() {
    }

    private static Preferences getProxyPreferences() {
        return NbPreferences.root().node("org/netbeans/core");
    }

    boolean getUsageStatistics() {
        String key = System.getProperty("nb.show.statistics.ui");
        if (key != null) {
            return GeneralOptionsModel.getProxyPreferences().getBoolean(key, Boolean.FALSE);
        }
        return false;
    }

    void setUsageStatistics(boolean use) {
        String key = System.getProperty("nb.show.statistics.ui");
        if (key != null && use != this.getUsageStatistics()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean(key, use);
        }
    }

    int getProxyType() {
        return GeneralOptionsModel.getProxyPreferences().getInt("proxyType", 1);
    }

    void setProxyType(int proxyType) {
        if (proxyType != this.getProxyType()) {
            if (1 == proxyType) {
                GeneralOptionsModel.getProxyPreferences().putInt("proxyType", GeneralOptionsModel.usePAC() ? 3 : 1);
            } else {
                GeneralOptionsModel.getProxyPreferences().putInt("proxyType", proxyType);
            }
        }
    }

    String getHttpProxyHost() {
        return ProxySettings.getHttpHost();
    }

    void setHttpProxyHost(String proxyHost) {
        if (!proxyHost.equals(this.getHttpProxyHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpHost", proxyHost);
        }
    }

    String getHttpProxyPort() {
        return ProxySettings.getHttpPort();
    }

    void setHttpProxyPort(String proxyPort) {
        if (!proxyPort.equals(this.getHttpProxyPort())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpPort", GeneralOptionsModel.validatePort(proxyPort) ? proxyPort : "");
        }
    }

    String getHttpsProxyHost() {
        return ProxySettings.getHttpsHost();
    }

    void setHttpsProxyHost(String proxyHost) {
        if (!proxyHost.equals(this.getHttpsProxyHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpsHost", proxyHost);
        }
    }

    String getHttpsProxyPort() {
        return ProxySettings.getHttpsPort();
    }

    void setHttpsProxyPort(String proxyPort) {
        if (!proxyPort.equals(this.getHttpsProxyPort())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyHttpsPort", GeneralOptionsModel.validatePort(proxyPort) ? proxyPort : "");
        }
    }

    String getSocksHost() {
        return ProxySettings.getSocksHost();
    }

    void setSocksHost(String socksHost) {
        if (!socksHost.equals(this.getSocksHost())) {
            GeneralOptionsModel.getProxyPreferences().put("proxySocksHost", socksHost);
        }
    }

    String getSocksPort() {
        return ProxySettings.getSocksPort();
    }

    void setSocksPort(String socksPort) {
        if (!socksPort.equals(this.getSocksPort())) {
            GeneralOptionsModel.getProxyPreferences().put("proxySocksPort", GeneralOptionsModel.validatePort(socksPort) ? socksPort : "");
        }
    }

    String getOriginalHttpsHost() {
        return GeneralOptionsModel.getProxyPreferences().get("proxyHttpsHost", "");
    }

    String getOriginalHttpsPort() {
        return GeneralOptionsModel.getProxyPreferences().get("proxyHttpsPort", "");
    }

    String getOriginalSocksHost() {
        return GeneralOptionsModel.getProxyPreferences().get("proxySocksHost", "");
    }

    String getOriginalSocksPort() {
        return GeneralOptionsModel.getProxyPreferences().get("proxySocksPort", "");
    }

    String getNonProxyHosts() {
        return GeneralOptionsModel.code2view(ProxySettings.getNonProxyHosts());
    }

    void setNonProxyHosts(String nonProxy) {
        if (!nonProxy.equals(this.getNonProxyHosts())) {
            GeneralOptionsModel.getProxyPreferences().put("proxyNonProxyHosts", GeneralOptionsModel.view2code(nonProxy));
        }
    }

    boolean useProxyAuthentication() {
        return ProxySettings.useAuthentication();
    }

    void setUseProxyAuthentication(boolean use) {
        if (use != this.useProxyAuthentication()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean("useProxyAuthentication", use);
        }
    }

    boolean useProxyAllProtocols() {
        return ProxySettings.useProxyAllProtocols();
    }

    void setUseProxyAllProtocols(boolean use) {
        if (use != this.useProxyAllProtocols()) {
            GeneralOptionsModel.getProxyPreferences().putBoolean("useProxyAllProtocols", use);
        }
    }

    String getProxyAuthenticationUsername() {
        return ProxySettings.getAuthenticationUsername();
    }

    void setAuthenticationUsername(String username) {
        GeneralOptionsModel.getProxyPreferences().put("proxyAuthenticationUsername", username);
    }

    char[] getProxyAuthenticationPassword() {
        return ProxySettings.getAuthenticationPassword();
    }

    void setAuthenticationPassword(char[] password) {
        ProxySettings.setAuthenticationPassword((char[])password);
    }

    static boolean usePAC() {
        String s = System.getProperty("netbeans.system_http_proxy");
        boolean usePAC = s != null && s.startsWith("PAC");
        return usePAC;
    }

    private static boolean validatePort(String port) {
        boolean ok;
        block3: {
            if (port.trim().length() == 0) {
                return true;
            }
            ok = false;
            try {
                Integer.parseInt(port);
                ok = true;
            }
            catch (NumberFormatException nfe) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)nfe);
            }
        }
        return ok;
    }

    private static String code2view(String code) {
        return code == null ? code : code.replace("|", ", ");
    }

    private static String view2code(String view) {
        return view == null ? view : view.replace(", ", "|");
    }
}

