/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateItem
extends AbstractExpression {
    private boolean hasEqualSign;
    private boolean hasSpaceAfterEqualSign;
    private boolean hasSpaceAfterStateFieldPathExpression;
    private AbstractExpression newValue;
    private AbstractExpression stateFieldExpression;

    UpdateItem(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getStateFieldPathExpression().accept(visitor);
        this.getNewValue().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getStateFieldPathExpression());
        children.add(this.getNewValue());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        if (this.stateFieldExpression != null) {
            children.add(this.stateFieldExpression);
        }
        if (this.hasSpaceAfterStateFieldPathExpression) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasEqualSign) {
            children.add(this.buildStringExpression("="));
        }
        if (this.hasSpaceAfterEqualSign) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.newValue != null) {
            children.add(this.newValue);
        }
    }

    public Expression getNewValue() {
        if (this.newValue == null) {
            this.newValue = this.buildNullExpression();
        }
        return this.newValue;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return UpdateItem.queryBNF("update_item");
    }

    public Expression getStateFieldPathExpression() {
        if (this.stateFieldExpression == null) {
            this.stateFieldExpression = this.buildNullExpression();
        }
        return this.stateFieldExpression;
    }

    public boolean hasEqualSign() {
        return this.hasEqualSign;
    }

    public boolean hasNewValue() {
        return this.newValue != null && !this.newValue.isNull();
    }

    public boolean hasSpaceAfterEqualSign() {
        return this.hasSpaceAfterEqualSign;
    }

    public boolean hasSpaceAfterStateFieldPathExpression() {
        return this.hasSpaceAfterStateFieldPathExpression;
    }

    public boolean hasStateFieldPathExpression() {
        return this.stateFieldExpression != null && !this.stateFieldExpression.isNull();
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        if (tolerant) {
            this.stateFieldExpression = this.parse(wordParser, (JPQLQueryBNF)UpdateItem.queryBNF("update_item_state_field_path_expression"), tolerant);
        } else {
            this.stateFieldExpression = new StateFieldPathExpression((AbstractExpression)this, wordParser.word());
            this.stateFieldExpression.parse(wordParser, tolerant);
        }
        this.hasSpaceAfterStateFieldPathExpression = wordParser.skipLeadingWhitespace() > 0;
        this.hasEqualSign = wordParser.startsWith('=');
        if (this.hasEqualSign) {
            wordParser.moveForward(1);
            this.hasSpaceAfterEqualSign = wordParser.skipLeadingWhitespace() > 0;
        }
        this.newValue = this.parse(wordParser, (JPQLQueryBNF)UpdateItem.queryBNF("new_value"), tolerant);
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        if (this.stateFieldExpression != null) {
            this.stateFieldExpression.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterStateFieldPathExpression) {
            writer.append(' ');
        }
        if (this.hasEqualSign) {
            writer.append("=");
        }
        if (this.hasSpaceAfterEqualSign) {
            writer.append(' ');
        }
        if (this.newValue != null) {
            this.newValue.toParsedText(writer, includeVirtual);
        }
    }
}

