/*
 * Decompiled with CFR 0.152.
 */
package org.testng.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.Lists;
import org.testng.collections.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListMultiMap<K, V> {
    private Map<K, List<V>> m_objects = Maps.newHashMap();

    public void put(K key, V method) {
        List<Object> l = this.m_objects.get(key);
        if (l == null) {
            l = Lists.newArrayList();
            this.m_objects.put(key, l);
        }
        l.add(method);
    }

    public List<V> get(K key) {
        return this.m_objects.get(key);
    }

    public List<K> getKeys() {
        return new ArrayList<K>(this.m_objects.keySet());
    }

    public boolean containsKey(K k) {
        return this.m_objects.containsKey(k);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        List<K> indices = this.getKeys();
        for (K i : indices) {
            result.append("\n    ").append(i).append(" <-- ");
            for (V o : this.m_objects.get(i)) {
                result.append(o).append(" ");
            }
        }
        return result.toString();
    }

    public boolean isEmpty() {
        return this.m_objects.size() == 0;
    }

    public int getSize() {
        return this.m_objects.size();
    }

    public List<V> remove(K key) {
        return this.m_objects.remove(key);
    }

    public Set<Map.Entry<K, List<V>>> getEntrySet() {
        return this.m_objects.entrySet();
    }

    public Collection<List<V>> getValues() {
        return this.m_objects.values();
    }

    public void putAll(K k, Collection<V> values) {
        for (V v : values) {
            this.put(k, v);
        }
    }
}

