/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg;

import com.sun.javafx.sg.PGShape;
import java.util.Arrays;

public final class BorderStyle {
    public static final BorderStyle SOLID = new BorderStyle(PGShape.StrokeType.CENTERED, PGShape.StrokeLineCap.BUTT, PGShape.StrokeLineJoin.MITER, 10.0f, new float[0], 0.0f);
    public final PGShape.StrokeType strokeType;
    public final PGShape.StrokeLineCap lineCap;
    public final PGShape.StrokeLineJoin lineJoin;
    public final float strokeMiterLimit;
    public final float[] strokeDashArray;
    public final float strokeDashOffset;

    public BorderStyle(PGShape.StrokeType strokeType, PGShape.StrokeLineCap strokeLineCap, PGShape.StrokeLineJoin strokeLineJoin, float f, float[] fArray, float f2) {
        this.strokeType = strokeType;
        this.lineCap = strokeLineCap;
        this.lineJoin = strokeLineJoin;
        this.strokeMiterLimit = f;
        this.strokeDashArray = fArray;
        this.strokeDashOffset = f2;
    }

    public String toString() {
        return this == SOLID ? "SOLID" : "BorderStyle{strokeType=" + (Object)((Object)this.strokeType) + ", lineCap=" + (Object)((Object)this.lineCap) + ", lineJoin=" + (Object)((Object)this.lineJoin) + ", strokeMiterLimit=" + this.strokeMiterLimit + ", strokeDashArray=" + Arrays.toString(this.strokeDashArray) + ", strokeDashOffset=" + this.strokeDashOffset + "} " + SOLID.equals(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BorderStyle borderStyle = (BorderStyle)object;
        if (Float.compare(borderStyle.strokeDashOffset, this.strokeDashOffset) != 0) {
            return false;
        }
        if (Float.compare(borderStyle.strokeMiterLimit, this.strokeMiterLimit) != 0) {
            return false;
        }
        if (this.lineCap != borderStyle.lineCap) {
            return false;
        }
        if (this.lineJoin != borderStyle.lineJoin) {
            return false;
        }
        if (!Arrays.equals(this.strokeDashArray, borderStyle.strokeDashArray)) {
            return false;
        }
        return this.strokeType == borderStyle.strokeType;
    }

    public int hashCode() {
        int n = this.strokeType != null ? this.strokeType.hashCode() : 0;
        n = 31 * n + (this.lineCap != null ? this.lineCap.hashCode() : 0);
        n = 31 * n + (this.lineJoin != null ? this.lineJoin.hashCode() : 0);
        n = 31 * n + (this.strokeMiterLimit != 0.0f ? Float.floatToIntBits(this.strokeMiterLimit) : 0);
        n = 31 * n + (this.strokeDashArray != null ? Arrays.hashCode(this.strokeDashArray) : 0);
        n = 31 * n + (this.strokeDashOffset != 0.0f ? Float.floatToIntBits(this.strokeDashOffset) : 0);
        return n;
    }
}

