/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;
import sun.org.mozilla.javascript.internal.ast.Scope;
import sun.org.mozilla.javascript.internal.ast.VariableDeclaration;

public class LetNode
extends Scope {
    private VariableDeclaration variables;
    private AstNode body;
    private int lp = -1;
    private int rp = -1;

    public LetNode() {
        this.type = 158;
    }

    public LetNode(int n) {
        super(n);
        this.type = 158;
    }

    public LetNode(int n, int n2) {
        super(n, n2);
        this.type = 158;
    }

    public VariableDeclaration getVariables() {
        return this.variables;
    }

    public void setVariables(VariableDeclaration variableDeclaration) {
        this.assertNotNull(variableDeclaration);
        this.variables = variableDeclaration;
        variableDeclaration.setParent(this);
    }

    public AstNode getBody() {
        return this.body;
    }

    public void setBody(AstNode astNode) {
        this.body = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public int getLp() {
        return this.lp;
    }

    public void setLp(int n) {
        this.lp = n;
    }

    public int getRp() {
        return this.rp;
    }

    public void setRp(int n) {
        this.rp = n;
    }

    public void setParens(int n, int n2) {
        this.lp = n;
        this.rp = n2;
    }

    @Override
    public String toSource(int n) {
        String string = this.makeIndent(n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("let (");
        this.printList(this.variables.getVariables(), stringBuilder);
        stringBuilder.append(") ");
        if (this.body != null) {
            stringBuilder.append(this.body.toSource(n));
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.variables.visit(nodeVisitor);
            if (this.body != null) {
                this.body.visit(nodeVisitor);
            }
        }
    }
}

