/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class Util {
    private Util() {
    }

    static String[] addString(String[] array, String val) {
        if (array == null) {
            return new String[]{val};
        }
        String[] n = new String[array.length + 1];
        System.arraycopy(array, 0, n, 0, array.length);
        n[array.length] = val;
        return n;
    }

    static int indexOf(Object[] where, Object what) {
        if (where == null) {
            return -1;
        }
        for (int i = 0; i < where.length; ++i) {
            if (!where[i].equals(what)) continue;
            return i;
        }
        return -1;
    }

    static int indexOf(String[] where, String what, boolean caseInsensitiv) {
        for (int i = 0; where != null && i < where.length; ++i) {
            boolean isEqual = caseInsensitiv ? where[i].equalsIgnoreCase(what) : where[i].equals(what);
            if (!isEqual) continue;
            return i;
        }
        return -1;
    }

    static boolean contains(Object[] where, Object what) {
        return Util.indexOf(where, what) != -1;
    }

    static boolean contains(String[] where, String what, boolean caseInsensitiv) {
        return Util.indexOf(where, what, caseInsensitiv) != -1;
    }

    static void writeUTF(DataOutput os, String s) throws IOException {
        if (s == null) {
            s = "\u0000";
        }
        os.writeUTF(s);
    }

    static String readUTF(DataInput in) throws IOException {
        String s = in.readUTF();
        if ("\u0000".equals(s)) {
            return null;
        }
        return s;
    }

    static void writeStrings(DataOutput out, String[] arr) throws IOException {
        if (arr == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(arr.length);
        for (String m : arr) {
            Util.writeUTF(out, m);
        }
    }

    static String[] readStrings(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        String[] arr = new String[len];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Util.readUTF(in);
        }
        return arr;
    }

    static void writeBytes(DataOutput out, byte[] arr) throws IOException {
        if (arr == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(arr.length);
            out.write(arr);
        }
    }

    static byte[] readBytes(DataInput is) throws IOException {
        int len = is.readInt();
        if (len == -1) {
            return null;
        }
        byte[] arr = new byte[len];
        is.readFully(arr);
        return arr;
    }
}

