/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.SnmpGenericMetaServer;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class SnmpGenericObjectServer {
    protected final MBeanServer server;

    public SnmpGenericObjectServer(MBeanServer mBeanServer) {
        this.server = mBeanServer;
    }

    public void get(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        int n2 = snmpMibSubRequest.getSize();
        Object object = snmpMibSubRequest.getUserData();
        String[] stringArray = new String[n2];
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        long[] lArray = new long[n2];
        int n3 = 0;
        Object object2 = snmpMibSubRequest.getElements();
        while (object2.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)object2.nextElement();
            try {
                long l = snmpVarBind.oid.getOidArc(n);
                stringArray[n3] = snmpGenericMetaServer.getAttributeName(l);
                snmpVarBindArray[n3] = snmpVarBind;
                lArray[n3] = l;
                snmpGenericMetaServer.checkGetAccess(l, object);
                ++n3;
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerGetException(snmpVarBind, snmpStatusException);
            }
        }
        object2 = null;
        int n4 = 224;
        try {
            object2 = this.server.getAttributes(objectName, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            object2 = new AttributeList();
        }
        catch (ReflectionException reflectionException) {
            object2 = new AttributeList();
        }
        catch (Exception exception) {
            object2 = new AttributeList();
        }
        Iterator iterator = ((ArrayList)object2).iterator();
        for (int i = 0; i < n3; ++i) {
            Serializable serializable;
            if (!iterator.hasNext()) {
                serializable = new SnmpStatusException(n4);
                snmpMibSubRequest.registerGetException(snmpVarBindArray[i], (SnmpStatusException)serializable);
                continue;
            }
            serializable = (Attribute)iterator.next();
            while (i < n3 && !stringArray[i].equals(((Attribute)serializable).getName())) {
                SnmpStatusException snmpStatusException = new SnmpStatusException(n4);
                snmpMibSubRequest.registerGetException(snmpVarBindArray[i], snmpStatusException);
                ++i;
            }
            if (i == n3) break;
            try {
                snmpVarBindArray[i].value = snmpGenericMetaServer.buildSnmpValue(lArray[i], ((Attribute)serializable).getValue());
                continue;
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerGetException(snmpVarBindArray[i], snmpStatusException);
            }
        }
    }

    public SnmpValue get(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, long l, Object object) throws SnmpStatusException {
        String string = snmpGenericMetaServer.getAttributeName(l);
        Object object2 = null;
        try {
            object2 = this.server.getAttribute(objectName, string);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof SnmpStatusException) {
                throw (SnmpStatusException)exception;
            }
            throw new SnmpStatusException(224);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(224);
        }
        return snmpGenericMetaServer.buildSnmpValue(l, object2);
    }

    public void set(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        Object object;
        Object object2;
        int n2 = snmpMibSubRequest.getSize();
        AttributeList attributeList = new AttributeList(n2);
        String[] stringArray = new String[n2];
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        long[] lArray = new long[n2];
        int n3 = 0;
        Object object3 = snmpMibSubRequest.getElements();
        while (object3.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)object3.nextElement();
            try {
                long l = snmpVarBind.oid.getOidArc(n);
                object2 = snmpGenericMetaServer.getAttributeName(l);
                object = snmpGenericMetaServer.buildAttributeValue(l, snmpVarBind.value);
                Attribute attribute = new Attribute((String)object2, object);
                attributeList.add(attribute);
                stringArray[n3] = object2;
                snmpVarBindArray[n3] = snmpVarBind;
                lArray[n3] = l;
                ++n3;
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerSetException(snmpVarBind, snmpStatusException);
            }
        }
        object3 = null;
        int n4 = 6;
        try {
            object3 = this.server.setAttributes(objectName, attributeList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            object3 = new AttributeList();
            n4 = 18;
        }
        catch (ReflectionException reflectionException) {
            n4 = 18;
            object3 = new AttributeList();
        }
        catch (Exception exception) {
            object3 = new AttributeList();
        }
        Iterator iterator = ((ArrayList)object3).iterator();
        for (int i = 0; i < n3; ++i) {
            if (!iterator.hasNext()) {
                object2 = new SnmpStatusException(n4);
                snmpMibSubRequest.registerSetException(snmpVarBindArray[i], (SnmpStatusException)object2);
                continue;
            }
            object2 = (Attribute)iterator.next();
            while (i < n3 && !stringArray[i].equals(((Attribute)object2).getName())) {
                object = new SnmpStatusException(6);
                snmpMibSubRequest.registerSetException(snmpVarBindArray[i], (SnmpStatusException)object);
                ++i;
            }
            if (i == n3) break;
            try {
                snmpVarBindArray[i].value = snmpGenericMetaServer.buildSnmpValue(lArray[i], ((Attribute)object2).getValue());
                continue;
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerSetException(snmpVarBindArray[i], snmpStatusException);
            }
        }
    }

    public SnmpValue set(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpValue snmpValue, long l, Object object) throws SnmpStatusException {
        String string = snmpGenericMetaServer.getAttributeName(l);
        Object object2 = snmpGenericMetaServer.buildAttributeValue(l, snmpValue);
        Attribute attribute = new Attribute(string, object2);
        Object object3 = null;
        try {
            this.server.setAttribute(objectName, attribute);
            object3 = this.server.getAttribute(objectName, string);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new SnmpStatusException(10);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new SnmpStatusException(18);
        }
        catch (ReflectionException reflectionException) {
            throw new SnmpStatusException(18);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof SnmpStatusException) {
                throw (SnmpStatusException)exception;
            }
            throw new SnmpStatusException(6);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(6);
        }
        return snmpGenericMetaServer.buildSnmpValue(l, object3);
    }

    public void check(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpMibSubRequest snmpMibSubRequest, int n) throws SnmpStatusException {
        Object object = snmpMibSubRequest.getUserData();
        Enumeration enumeration = snmpMibSubRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            try {
                long l = snmpVarBind.oid.getOidArc(n);
                this.check(snmpGenericMetaServer, objectName, snmpVarBind.value, l, object);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerCheckException(snmpVarBind, snmpStatusException);
            }
        }
    }

    public void check(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpValue snmpValue, long l, Object object) throws SnmpStatusException {
        snmpGenericMetaServer.checkSetAccess(snmpValue, l, object);
        try {
            String string = snmpGenericMetaServer.getAttributeName(l);
            Object object2 = snmpGenericMetaServer.buildAttributeValue(l, snmpValue);
            Object[] objectArray = new Object[1];
            String[] stringArray = new String[1];
            objectArray[0] = object2;
            stringArray[0] = object2.getClass().getName();
            this.server.invoke(objectName, "check" + string, objectArray, stringArray);
        }
        catch (SnmpStatusException snmpStatusException) {
            throw snmpStatusException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new SnmpStatusException(18);
        }
        catch (ReflectionException reflectionException) {
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof SnmpStatusException) {
                throw (SnmpStatusException)exception;
            }
            throw new SnmpStatusException(6);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(6);
        }
    }

    public void registerTableEntry(SnmpMibTable snmpMibTable, SnmpOid snmpOid, ObjectName objectName, Object object) throws SnmpStatusException {
        if (objectName == null) {
            throw new SnmpStatusException(18);
        }
        try {
            if (object != null && !this.server.isRegistered(objectName)) {
                this.server.registerMBean(object, objectName);
            }
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw new SnmpStatusException(18);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new SnmpStatusException(6);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new SnmpStatusException(5);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new SnmpStatusException(5);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(5);
        }
    }
}

