/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.TreatExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Join
extends AbstractExpression {
    private boolean hasAs;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterJoin;
    private boolean hasSpaceAfterJoinAssociation;
    private AbstractExpression identificationVariable;
    private AbstractExpression joinAssociationPath;

    Join(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getJoinAssociationPath().accept(visitor);
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getJoinAssociationPath());
        children.add(this.getIdentificationVariable());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        String space;
        String join = this.getText();
        if (join.indexOf(space = " ") != -1) {
            StringTokenizer tokenizer = new StringTokenizer(join, space, true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                children.add(this.buildStringExpression(token));
            }
        } else {
            children.add(this.buildStringExpression(join));
        }
        if (this.hasSpaceAfterJoin) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.joinAssociationPath != null) {
            children.add(this.joinAssociationPath);
        }
        if (this.hasSpaceAfterJoinAssociation) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasAs) {
            children.add(this.buildStringExpression("AS"));
            if (this.hasSpaceAfterAs) {
                children.add(this.buildStringExpression(' '));
            }
        }
        if (this.identificationVariable != null) {
            children.add(this.identificationVariable);
        }
    }

    public Expression getIdentificationVariable() {
        if (this.identificationVariable == null) {
            this.identificationVariable = this.buildNullExpression();
        }
        return this.identificationVariable;
    }

    public String getIdentifier() {
        return this.getText();
    }

    public Expression getJoinAssociationPath() {
        if (this.joinAssociationPath == null) {
            this.joinAssociationPath = this.buildNullExpression();
        }
        return this.joinAssociationPath;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return Join.queryBNF("join");
    }

    public boolean hasAs() {
        return this.hasAs;
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable != null && !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public boolean hasJoinAssociationPath() {
        return this.joinAssociationPath != null && !this.joinAssociationPath.isNull();
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasSpaceAfterJoin() {
        return this.hasSpaceAfterJoin;
    }

    public boolean hasSpaceAfterJoinAssociation() {
        return this.hasSpaceAfterJoinAssociation;
    }

    public boolean isLeftJoin() {
        String identifier = this.getIdentifier();
        return identifier == "LEFT JOIN" || identifier == "LEFT OUTER JOIN";
    }

    @Override
    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("AS") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward(this.getText());
        boolean bl = this.hasSpaceAfterJoin = wordParser.skipLeadingWhitespace() > 0;
        if (tolerant) {
            this.joinAssociationPath = this.parse(wordParser, (JPQLQueryBNF)Join.queryBNF("join_association_path_expression*"), tolerant);
        } else if (wordParser.startsWithIdentifier("TREAT")) {
            this.joinAssociationPath = new TreatExpression(this);
            this.joinAssociationPath.parse(wordParser, tolerant);
        } else {
            this.joinAssociationPath = new CollectionValuedPathExpression((AbstractExpression)this, wordParser.word());
            this.joinAssociationPath.parse(wordParser, tolerant);
        }
        this.hasSpaceAfterJoinAssociation = wordParser.skipLeadingWhitespace() > 0;
        this.hasAs = wordParser.startsWithIdentifier("AS");
        if (this.hasAs) {
            wordParser.moveForward("AS");
            boolean bl2 = this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        if (tolerant) {
            this.identificationVariable = this.parse(wordParser, (JPQLQueryBNF)Join.queryBNF("identification_variable"), tolerant);
        } else {
            this.identificationVariable = new IdentificationVariable(this, wordParser.word());
            this.identificationVariable.parse(wordParser, tolerant);
        }
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append(this.getText());
        if (this.hasSpaceAfterJoin) {
            writer.append(' ');
        }
        if (this.joinAssociationPath != null) {
            this.joinAssociationPath.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterJoinAssociation) {
            writer.append(' ');
        }
        if (this.hasAs) {
            writer.append("AS");
            if (this.hasSpaceAfterAs) {
                writer.append(' ');
            }
        }
        if (this.identificationVariable != null) {
            this.identificationVariable.toParsedText(writer, includeVirtual);
        }
    }
}

