/*
 * Decompiled with CFR 0.152.
 */
package org.shop.claims;

import demo.Claims;
import demo.Components;
import demo.Exposure;
import demo.Policy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdatepicker.impl.JDatePanelImpl;
import org.jdatepicker.impl.JDatePickerImpl;
import org.jdatepicker.impl.UtilDateModel;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.shop.claims.ClaimsTopComponent;
import org.shop.claims.Combohelper;
import org.shop.claims.EntityService;
import org.shop.claims.Review;

public class ClaimsCode {
    private final TopComponent viewTC;
    private final ClaimsTopComponent my;
    private String PU = "fleetLibraryPU";
    Policy policy = null;
    Claims claims = null;
    Exposure exposure = null;
    Integer client;
    Integer polnum;
    Integer prov;
    Integer vehicle;
    Integer version;
    Integer users;
    String policynumber;
    String usersgroup;
    Boolean flagExist = false;
    Boolean flagCalc = true;
    List<Component> componentList;
    private final String[][] arrCoverage = new String[][]{{"1", "Unknown", "Unknown"}, {"2", "Mandatory", "Mandatory"}, {"3", "Physical", "Physical"}, {"4", "TP", "Third Party"}, {"5", "BI", "Bodily Injury"}, {"6", "PD", "Property Damage"}, {"7", "DC", "Direct Compensation"}, {"8", "AB", "Accident Benefits"}, {"9", "UA", "Uninsured Auto"}, {"10", "UM", "Underinsured Auto"}, {"11", "CL", "Collision"}, {"12", "CM", "Comprehensive"}, {"13", "SP", "Specified Perils"}, {"14", "AP", "All Perils"}, {"15", "SA", "Section A"}, {"16", "PHPD", "PHPD"}, {"17", "PHBI", "PHBI"}};
    String[] names = new String[]{"UA", "UM", "BI", "PD", "DC", "SA", "TP", "AB", "CL", "CM", "SP", "AP", "PHPD", "PHBI"};
    private final String[][] arrPeriod = new String[][]{{"1", "0.0 - 1.0 Years Prior"}, {"2", "1.0 - 2.0 Years Prior"}, {"3", "2.0 - 3.0 Years Prior"}, {"4", "3.0 - 4.0 Years Prior"}, {"5", "4.0 - 5.0 Years Prior"}};
    private final String[][] arrComponents = new String[][]{{"JComboBox", "Province"}, {"JComboBox", "Vehicle"}, {"JComboBox", "Cov"}, {"JComboBox", "Periods"}, {"JTextField", "Amount"}, {"JTextField", "Msl"}, {"JTextField", "Counts"}, {"JFormattedTextField", "ValuationDate"}, {"JFormattedTextField", "ClaimDate"}, {"JButton", "bValuationDate"}, {"JButton", "bClaimDate"}};
    JFrame frameDate;
    JTextField tfDate;
    Boolean booPeriodDate = true;

    public void setPU(String pu) {
        this.PU = pu;
    }

    public ClaimsCode() {
        this.viewTC = WindowManager.getDefault().findTopComponent("ClaimsTopComponent");
        this.my = (ClaimsTopComponent)this.viewTC;
        if (this.componentList == null) {
            this.componentList = ClaimsCode.getAllComponents((Container)((Object)this.my));
        }
        this.initOpen();
        this.my.bUpdate.addActionListener(new PolicyListener());
        this.my.bNew.addActionListener(new PolicyListener());
        this.my.bDelete.addActionListener(new PolicyListener());
        this.my.bPopulate.addActionListener(new PolicyListener());
        this.my.bRefresh.addActionListener(new PolicyListener());
        this.my.Amount.addKeyListener(new myKeyAdapter(this.my.Amount));
        this.my.Counts.addKeyListener(new myKeyAdapter(this.my.Counts));
        this.my.tfRecord.getDocument().addDocumentListener(new MyDocumentListener());
        this.my.bValuationDate.addActionListener(new PolicyListener());
        this.my.bClaimDate.addActionListener(new PolicyListener());
        this.my.Periods.addActionListener(new ComboListener());
        SimpleDateFormat df = new SimpleDateFormat("d-MMM-yyyy");
        JFormattedTextField ftf2 = new JFormattedTextField(df);
        this.my.ValuationDate.setFormatterFactory(ftf2.getFormatterFactory());
        this.my.ClaimDate.setFormatterFactory(ftf2.getFormatterFactory());
        this.my.ValuationDate.addKeyListener(new myNullKeyAdapter(this.my.ValuationDate));
        this.my.ClaimDate.addKeyListener(new myNullKeyAdapter(this.my.ClaimDate));
    }

    void initOpen() {
        this.my.bNew.setVisible(false);
        this.my.bPopulate.setVisible(false);
        this.my.bUpdate.setVisible(false);
        this.my.bDelete.setVisible(false);
        this.my.bStop.setVisible(false);
        this.my.bSkip.setVisible(false);
        this.my.bRefresh.setVisible(false);
        this.my.Record.setEnabled(false);
        this.my.bNew.setEnabled(false);
        this.my.bPopulate.setEnabled(false);
        this.my.bUpdate.setEnabled(false);
        this.my.bDelete.setEnabled(false);
        this.my.bStop.setEnabled(false);
        this.my.bSkip.setEnabled(false);
        this.my.bRefresh.setEnabled(false);
        this.my.Record.setEnabled(false);
        this.my.tfRecord.setEnabled(false);
        this.my.tfClient.setVisible(false);
        this.my.tfPolicy.setVisible(false);
        this.my.tfRecord.setVisible(false);
        this.my.tfUsers.setVisible(false);
        this.my.lbtfClient.setVisible(false);
        this.my.lbtfPolicy.setVisible(false);
        this.my.lbtfUsers.setVisible(false);
        this.my.bValuationDate.setVisible(false);
        this.my.bClaimDate.setVisible(false);
        this.enableToogle(false);
        this.resetFields();
    }

    void resetFields() {
        this.my.Amount.setText("");
        this.my.Counts.setText("");
        this.my.Msl.setText("");
        this.my.ValuationDate.setText("");
        this.my.ClaimDate.setText("");
        this.initComboListeners(false);
        this.my.Province.setSelectedIndex(-1);
        this.my.Vehicle.setSelectedIndex(-1);
        this.my.Cov.setSelectedIndex(-1);
        this.my.Periods.setSelectedIndex(-1);
        this.initComboListeners(true);
        this.my.Record.setSelectedIndex(-1);
    }

    void initAll0() {
        this.my.bNew.setVisible(true);
        this.my.bPopulate.setVisible(true);
        this.my.bUpdate.setVisible(true);
        this.my.bDelete.setVisible(true);
        this.my.bValuationDate.setVisible(true);
        this.my.bClaimDate.setVisible(true);
        this.enableToogle(true);
        this.my.tfRecord.setEnabled(true);
        this.my.Record.setEnabled(true);
        this.initComboListeners(false);
        this.flagCalc = false;
        this.initPrimary();
        this.initSecondary();
        this.flagCalc = true;
        this.initComboListeners(true);
    }

    void reset() {
        this.initComboListeners(false);
        this.flagCalc = false;
        for (int i = 0; i < this.arrComponents.length; ++i) {
            JComponent cb;
            String type = this.arrComponents[i][0];
            String name = this.arrComponents[i][1];
            if (type.equals("JComboBox")) {
                cb = this.getComboBox(name);
                ((JComboBox)cb).removeAllItems();
                continue;
            }
            if (type.equals("JTextField")) {
                cb = this.getTextField(name);
                ((JTextComponent)cb).setText("");
                continue;
            }
            if (type.equals("JCheckBox")) {
                cb = this.getCheckBox(name);
                ((AbstractButton)cb).setSelected(false);
                continue;
            }
            if (!type.equals("JRadioButton")) continue;
            cb = this.getRadioButton(name);
            ((AbstractButton)cb).setSelected(false);
        }
    }

    static String entry(String str, String srch) {
        String spt = "";
        String Sep = ":";
        String[] lineSplit = (str + " ").substring(1).split(Sep, -99);
        int i = 0;
        while (i + 1 < lineSplit.length) {
            if (srch.equalsIgnoreCase(lineSplit[i])) {
                spt = lineSplit[i + 1].trim();
                break;
            }
            i += 2;
        }
        return spt;
    }

    void setPolicy(Policy pol) {
        this.policy = pol;
        if (this.policy != null) {
            this.client = this.policy.getClient();
            this.users = this.policy.getUsers();
            this.usersgroup = this.policy.getUsersgroup();
            this.polnum = this.policy.getPolnum();
            this.version = this.policy.getVersion();
            this.policynumber = this.policy.getPolicynumber();
            this.my.tfClient.setText(Integer.toString(this.client));
            this.my.tfUsers.setText(Integer.toString(this.users));
            this.my.tfPolicy.setText(Integer.toString(this.polnum));
            this.initClaimRecord(this.my.Record, this.polnum);
        }
    }

    void setExposure(Exposure pol) {
        this.exposure = pol;
        if (this.exposure != null) {
            this.client = this.exposure.getClient();
            this.users = this.exposure.getUsers();
            this.usersgroup = this.exposure.getUsersgroup();
            this.polnum = this.exposure.getPolnum();
            this.version = this.exposure.getVersion();
            this.policynumber = this.exposure.getPolicynumber();
            this.my.tfClient.setText(Integer.toString(this.client));
            this.my.tfUsers.setText(Integer.toString(this.users));
            this.my.tfPolicy.setText(Integer.toString(this.polnum));
            this.initClaimRecord(this.my.Record, this.polnum);
        }
    }

    void frameDatePick(JTextField rep, String title) {
        if (this.frameDate != null) {
            this.frameDate.dispose();
        }
        this.tfDate = rep;
        UtilDateModel model = new UtilDateModel();
        Properties p = new Properties();
        p.put("text.today", "Today");
        p.put("text.month", "Month");
        p.put("text.year", "Year");
        JDatePanelImpl datePanel = new JDatePanelImpl(model, p);
        JDatePickerImpl datePicker = new JDatePickerImpl(datePanel, new DateLabelFormatter());
        SimpleDateFormat df = new SimpleDateFormat("d-MMM-yyyy");
        if (rep.getText().length() > 0) {
            try {
                Date dt = df.parse(rep.getText());
                ((UtilDateModel)datePicker.getModel()).setValue(dt);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.frameDate = new JFrame();
        this.frameDate.setTitle(title);
        this.frameDate.setDefaultCloseOperation(2);
        JButton button = new JButton("Transfer");
        button.addActionListener(new PolicyListener());
        JPanel PanelMain = new JPanel(new BorderLayout());
        PanelMain.add((Component)datePicker, "North");
        PanelMain.add((Component)button, "Center");
        this.frameDate.getContentPane().add(PanelMain);
        this.frameDate.pack();
        this.frameDate.setVisible(true);
        this.frameDate.setAlwaysOnTop(true);
    }

    void refreshMSL(Review rev) {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Claims.polnum").setParameter("client", (Object)this.client).setParameter("polnum", (Object)this.polnum).getResultList();
        System.out.println("ClaimsTC: refreshMSL: ");
        entityManager.getTransaction().begin();
        for (Claims clm : resultList) {
            Integer Province = clm.getProvince();
            Integer Vehicle = clm.getVehicle();
            Integer Cov = clm.getCov();
            Integer Periods = clm.getPeriods();
            Float msl = Float.valueOf(rev.getMsl(Province, Vehicle, Cov, Periods));
            clm.setMsl(msl);
            entityManager.merge((Object)clm);
        }
        entityManager.getTransaction().commit();
        this.refreshNode();
    }

    void refreshMSL2() {
        Review rev = new Review(this.client, this.polnum, this.version, this.PU);
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Claims.polnum").setParameter("client", (Object)this.client).setParameter("polnum", (Object)this.polnum).getResultList();
        System.out.println("refreshMSL2: ");
        entityManager.getTransaction().begin();
        for (Claims clm : resultList) {
            String desc = clm.getDescription();
            Integer Province = clm.getProvince();
            Integer Vehicle = clm.getVehicle();
            Integer Cov = clm.getCov();
            Integer Periods = clm.getPeriods();
            Float count = clm.getCounts();
            String[] desc2 = desc.split(":", -99);
            String loss = "0";
            for (int i = 0; i < desc2.length; ++i) {
                if (!desc2[i].equals("Loss") || i + 1 >= desc2.length) continue;
                loss = desc2[i + 1];
                break;
            }
            Float actual = Float.valueOf(Float.parseFloat(loss));
            Float msl = Float.valueOf(rev.getMsl(Province, Vehicle, Cov, Periods));
            if (actual.floatValue() > msl.floatValue() * count.floatValue()) {
                actual = Float.valueOf(msl.floatValue() * count.floatValue());
            }
            clm.setAmount(actual);
            clm.setMsl(msl);
            entityManager.merge((Object)clm);
            entityManager.getTransaction().commit();
        }
    }

    public void initClaimRecord(JComboBox cb, Integer in) {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        this.toggleListeners(false);
        List resultList = entityManager.createNamedQuery("Claims.polnum").setParameter("client", (Object)this.client).setParameter("polnum", (Object)in).getResultList();
        cb.removeAllItems();
        System.out.println("initRecord: " + cb.getActionCommand());
        for (Claims c : resultList) {
            if (!this.checkNotNull(c, entityManager).booleanValue()) continue;
            Combohelper ch = new Combohelper(c.getRecordnumber(), c.getRecordnumber().toString(), false);
            ch.addlink("Version", c.getVersion().toString());
            ch.addlink("Policynumber", c.getPolicynumber());
            ch.addlink("Polnum", c.getPolnum().toString());
            cb.addItem(ch);
        }
        this.toggleListeners(true);
        cb.setSelectedIndex(-1);
    }

    Boolean checkNotNull(Claims obj, EntityManager entityManager) {
        Boolean boo = true;
        for (Field field : obj.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                if (field.get(obj) != null || field.getName() == "dateVal") continue;
                entityManager.getTransaction().begin();
                System.out.println("initRecord: Claims: Delete Null Claim with Name= " + field.getName() + " and Number= " + this.getInteger(obj, "number"));
                entityManager.merge((Object)obj);
                entityManager.remove((Object)obj);
                entityManager.getTransaction().commit();
                boo = false;
                break;
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return boo;
    }

    void applytfRecord() {
        if (this.my.tfRecord.getText().length() > 0) {
            for (int i = 0; i < this.my.Record.getItemCount(); ++i) {
                if (!this.my.Record.getItemAt(i).toString().equals(this.my.tfRecord.getText())) continue;
                this.my.Record.setSelectedIndex(i);
                break;
            }
        }
    }

    public Claims getClaimRecord(EntityManager entityManager, Integer in) {
        Claims pol = null;
        List resultList = entityManager.createNamedQuery("Claims.record").setParameter("client", (Object)this.client).setParameter("polnum", (Object)this.polnum).setParameter("record", (Object)in).getResultList();
        Iterator it = resultList.iterator();
        if (it.hasNext()) {
            pol = (Claims)it.next();
        }
        return pol;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public void setClaims(Claims pol) {
        this.claims = pol;
    }

    void resetClaimCount(Integer in) {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        entityManager.getTransaction().begin();
        List resultList3 = entityManager.createNamedQuery("Claims.polnum").setParameter("client", (Object)this.client).setParameter("polnum", (Object)in).getResultList();
        Integer counter = 1;
        for (Claims clm : resultList3) {
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            clm.setRecordnumber(n);
            entityManager.merge((Object)clm);
        }
        entityManager.getTransaction().commit();
    }

    void toggleListeners(Boolean flag) {
        this.removeActionlisteners(this.my.Record, flag);
    }

    void removeActionlisteners(JComboBox cb, Boolean boo) {
        if (boo.booleanValue()) {
            cb.addActionListener(new ComboListener());
        } else {
            ActionListener[] cbActions = cb.getActionListeners();
            for (int i = 0; i < cbActions.length; ++i) {
                cb.removeActionListener(cbActions[i]);
            }
        }
    }

    void save() {
        this.claims.setProvince(((Combohelper)this.my.Province.getSelectedItem()).getCode());
        this.claims.setVehicle(((Combohelper)this.my.Vehicle.getSelectedItem()).getCode());
        this.claims.setCov(((Combohelper)this.my.Cov.getSelectedItem()).getCode());
        this.claims.setPeriods(((Combohelper)this.my.Periods.getSelectedItem()).getCode());
        String str = ":Province:" + this.my.Province.getSelectedItem().toString();
        str = str + ":Vehicle:" + this.my.Vehicle.getSelectedItem().toString();
        str = str + ":Cov:" + this.my.Cov.getSelectedItem().toString();
        str = str + ":Periods:" + this.my.Periods.getSelectedItem().toString();
        str = str + ":ValuationDate:" + this.my.ValuationDate.getText();
        str = str + ":ClaimDate:" + this.my.ClaimDate.getText();
        str = str + ":Loss:" + this.my.Amount.getText();
        str = str + ":Count:" + this.my.Counts.getText();
        str = str + ":MSL:" + this.my.Msl.getText();
        Integer in = str.length() > 250 ? 250 : str.length();
        this.claims.setDescription(str.substring(0, in));
        Float amount = Float.valueOf(Float.parseFloat(this.my.Amount.getText()));
        Float count = Float.valueOf(Float.parseFloat(this.my.Counts.getText()));
        Float msl = Float.valueOf(Float.parseFloat(this.my.Msl.getText()));
        amount = Float.valueOf(this.client == 2 && this.arrCoverage[this.claims.getCov() - 1][1].equals("AB") && this.claims.getProvince() != 5 ? 0.0f : amount.floatValue());
        this.claims.setAmount(amount);
        this.claims.setCounts(count);
        this.claims.setMsl(msl);
    }

    void populatePrimary() {
        for (int i = 0; i < this.arrComponents.length; ++i) {
            String type = this.arrComponents[i][0];
            String name = this.arrComponents[i][1];
            if (type.equals("JComboBox")) {
                Combohelper obj = new Combohelper(this.getInteger(name), "");
                this.populateComboBox(name, obj);
                continue;
            }
            if (type.equals("JFormattedTextField")) {
                if (name.equals("ValuationDate")) {
                    this.my.ValuationDate.setText(ClaimsCode.entry(this.claims.getDescription(), "ValuationDate"));
                    continue;
                }
                if (!name.equals("ClaimDate")) continue;
                this.my.ClaimDate.setText(ClaimsCode.entry(this.claims.getDescription(), "ClaimDate"));
                continue;
            }
            if (type.equals("JTextField")) {
                this.populateTextField(name);
                continue;
            }
            if (type.equals("JCheckBox")) {
                this.populateCheckBox(name);
                continue;
            }
            if (!type.equals("JRadioButton")) continue;
            this.populateRadioButton(name);
        }
    }

    void enableToogle(Boolean boo) {
        for (int i = 0; i < this.arrComponents.length; ++i) {
            String type = this.arrComponents[i][0];
            String name = this.arrComponents[i][1];
            for (Component object : this.componentList) {
                JComponent cb;
                if (object instanceof JTextField) {
                    cb = (JTextField)object;
                    if (cb.getName() == null || !cb.getName().equals(name)) continue;
                    cb.setEnabled(boo);
                    continue;
                }
                if (object instanceof JFormattedTextField) {
                    cb = (JFormattedTextField)object;
                    if (cb.getName() == null || !cb.getName().equals(name)) continue;
                    cb.setEnabled(boo);
                    continue;
                }
                if (object instanceof JComboBox) {
                    cb = (JComboBox)object;
                    if (cb.getName() == null || !cb.getName().equals(name)) continue;
                    ((JComboBox)cb).setEnabled(boo);
                    continue;
                }
                if (!(object instanceof JButton) || (cb = (JButton)object).getName() == null || !cb.getName().equals(name)) continue;
                ((AbstractButton)cb).setEnabled(boo);
            }
        }
    }

    void enableAll(Boolean flag) {
        for (Component components : this.componentList) {
            components.setEnabled(flag);
        }
    }

    Integer getInteger(String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Integer in = 0;
        try {
            in = (Integer)this.claims.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke((Object)this.claims, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? 0 : in;
    }

    void populateComboBox(String name, Object search) {
        Boolean flag = false;
        for (Component object : this.componentList) {
            JComboBox cb;
            if (!(object instanceof JComboBox) || (cb = (JComboBox)object).getName() == null || !cb.getName().equals(name)) continue;
            for (int i = 0; i < cb.getItemCount(); ++i) {
                if (!search.equals(cb.getItemAt(i))) continue;
                cb.setSelectedIndex(i);
                flag = true;
                break;
            }
            if (!flag.booleanValue()) continue;
            break;
        }
    }

    Double getFloat(String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Double in = 0.0;
        try {
            in = (Double)this.claims.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke((Object)this.claims, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in;
    }

    Integer getInteger(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Integer in = 0;
        try {
            in = (Integer)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return in == null ? 0 : in;
    }

    Float getFloat(Object obj, String name) {
        String p1 = name.substring(0, 1).toUpperCase();
        String p2 = name.substring(1).toLowerCase();
        Float in = Float.valueOf(0.0f);
        try {
            in = (Float)obj.getClass().getMethod("get" + p1 + p2, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Float.valueOf(in == null ? 0.0f : in.floatValue());
    }

    void populateTextField(String name) {
        Float code = this.getFloat(this.claims, name);
        for (Component object : this.componentList) {
            JTextField cb;
            if (!(object instanceof JTextField) || (cb = (JTextField)object).getName() == null || !cb.getName().equals(name)) continue;
            cb.setText(String.valueOf(code));
        }
    }

    void populateCheckBox(String name) {
        Integer codeInteger = this.getInteger(this.claims, name);
        Boolean code = this.i2b(codeInteger);
        for (Component object : this.componentList) {
            JCheckBox cb;
            if (!(object instanceof JCheckBox) || (cb = (JCheckBox)object).getName() == null || !cb.getName().equals(name)) continue;
            cb.setSelected(code);
        }
    }

    void populateRadioButton(String name) {
        Integer codeInteger = this.getInteger(this.claims, name);
        Boolean code = this.i2b(codeInteger);
        for (Component object : this.componentList) {
            JRadioButton cb;
            if (!(object instanceof JRadioButton) || (cb = (JRadioButton)object).getName() == null) continue;
            if (cb.getName().equals(name)) {
                cb.setSelected(code);
                continue;
            }
            cb.setSelected(code == false);
        }
    }

    void initPrimary() {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        this.initComboListeners(false);
        List resultList2 = entityManager.createNamedQuery("Components.groupname2").setParameter("client", (Object)this.client).setParameter("version", (Object)this.version).getResultList();
        for (String c2 : resultList2) {
            String name = c2;
            if (name.equals("Limitall")) continue;
            List resultList3 = entityManager.createNamedQuery("Components.series.province.vehicle.name.all").setParameter("client", (Object)this.client).setParameter("version", (Object)this.version).setParameter("province", (Object)0).setParameter("vehicle", (Object)0).setParameter("series", (Object)1).setParameter("name", (Object)name).getResultList();
            String type = "";
            JComboBox cb = null;
            Integer index = -1;
            Components c32 = null;
            for (Components c32 : resultList3) {
                type = c32.getTyped();
                index = c32.getInitindex();
                if (!type.equals("JComboBox")) continue;
                cb = this.getComboBox(name);
                break;
            }
            if (!type.equals("JComboBox")) continue;
            System.out.println("ClaimsCode:initPrimary " + name);
            cb.removeAllItems();
            for (Components c32 : resultList3) {
                if (!this.i2b(c32.getInitread()).booleanValue() || !c32.getCoverage().equals("Display")) continue;
                cb.addItem(new Combohelper(c32.getCode() - 1, c32.getDisplay()));
            }
            for (Components c32 : resultList3) {
                Combohelper ch;
                if (this.i2b(c32.getInitread()).booleanValue() && c32.getCoverage().equals("Code")) {
                    ch = (Combohelper)cb.getItemAt(c32.getCode() - 1);
                    ch.setCode(c32.getFactor().intValue());
                    continue;
                }
                if (!this.i2b(c32.getInitread()).booleanValue() || !c32.getCoverage().equals("Info")) continue;
                ch = (Combohelper)cb.getItemAt(c32.getCode() - 1);
                ch.setDesc(c32.getDisplay());
            }
            if (cb.getItemCount() == 2) {
                cb.removeItemAt(0);
                cb.setSelectedIndex(0);
                continue;
            }
            Combohelper ch = (Combohelper)cb.getItemAt(0);
            ch.setCode(0);
            ch.setDisplay("Unknown");
            ch.setDesc("UNK");
            cb.setSelectedIndex(index);
        }
    }

    void initSecondary() {
        int i;
        this.my.Cov.removeAllItems();
        for (i = 0; i < this.arrCoverage.length; ++i) {
            this.my.Cov.addItem(new Combohelper(Integer.parseInt(this.arrCoverage[i][0]), this.arrCoverage[i][2]));
        }
        this.my.Cov.setSelectedIndex(-1);
        this.my.Periods.removeAllItems();
        for (i = 0; i < this.arrPeriod.length; ++i) {
            this.my.Periods.addItem(new Combohelper(Integer.parseInt(this.arrPeriod[i][0]), this.arrPeriod[i][1]));
        }
        this.my.Periods.setSelectedIndex(-1);
    }

    public JComboBox getComboBox(String name) {
        for (Component object : this.componentList) {
            JComboBox cb;
            if (!(object instanceof JComboBox) || (cb = (JComboBox)object).getName() == null || !cb.getName().equals(name)) continue;
            return cb;
        }
        return null;
    }

    public JCheckBox getCheckBox(String name) {
        for (Component object : this.componentList) {
            JCheckBox cb;
            if (!(object instanceof JCheckBox) || (cb = (JCheckBox)object).getName() == null || !cb.getName().equals(name)) continue;
            return cb;
        }
        return null;
    }

    public JRadioButton getRadioButton(String name) {
        for (Component object : this.componentList) {
            JRadioButton cb;
            if (!(object instanceof JRadioButton) || (cb = (JRadioButton)object).getName() == null || !cb.getName().equals(name)) continue;
            return cb;
        }
        return null;
    }

    public JTextField getTextField(String name) {
        for (Component object : this.componentList) {
            JTextField cb;
            if (!(object instanceof JTextField) || (cb = (JTextField)object).getName() == null || !cb.getName().equals(name)) continue;
            return cb;
        }
        return null;
    }

    public static List<Component> getAllComponents(Container c) {
        Component[] comps = c.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        for (Component comp : comps) {
            compList.add(comp);
            if (!(comp instanceof Container)) continue;
            compList.addAll(ClaimsCode.getAllComponents((Container)comp));
        }
        return compList;
    }

    public JTextField getTextFieldTest(String name, Container my) {
        for (Component object : ClaimsCode.getAllComponents(my)) {
            JTextField temp;
            if (object instanceof JTextField) {
                JTextField cb = (JTextField)object;
                System.out.println("ClaimsCode: getTextField " + cb.getName());
                if (cb.getName() == null || !cb.getName().equals(name)) continue;
                return cb;
            }
            if (((Container)object).getComponents().length <= 1 || (temp = this.getTextFieldTest(name, (Container)object)) == null) continue;
            return temp;
        }
        return null;
    }

    public JFormattedTextField getFormattedTextField(String name) {
        for (Component object : this.componentList) {
            JFormattedTextField cb;
            if (!(object instanceof JFormattedTextField) || (cb = (JFormattedTextField)object).getName() == null || !cb.getName().equals(name)) continue;
            return cb;
        }
        return null;
    }

    public JLabel getLabel(String name) {
        for (Component object : this.componentList) {
            JLabel cb;
            if (!(object instanceof JLabel) || (cb = (JLabel)object).getName() == null || !cb.getName().equals(name)) continue;
            return cb;
        }
        return null;
    }

    void initComboListeners(Boolean boo) {
        for (Component object : this.componentList) {
            if (!(object instanceof JComboBox)) continue;
            JComboBox cb = (JComboBox)object;
            if (boo.booleanValue()) {
                cb.addActionListener(new ComboListener());
                continue;
            }
            ActionListener[] cbActions = cb.getActionListeners();
            for (int i = 0; i < cbActions.length; ++i) {
                System.out.println("ClaimsCode: initComboListeners " + cb.getName());
                if (cbActions[i] == null) continue;
                cb.removeActionListener(cbActions[i]);
            }
        }
    }

    void refreshNode() {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Claims.polnum").setParameter("client", (Object)this.client).setParameter("polnum", (Object)this.polnum).getResultList();
        this.my.refreshNode(resultList);
    }

    public boolean checkComboBoxes() {
        boolean flag = true;
        for (int i = 0; i < this.arrComponents.length; ++i) {
            String name = this.arrComponents[i][1];
            for (Component object : this.componentList) {
                JComboBox cb;
                if (!(object instanceof JComboBox) || (cb = (JComboBox)object).getName() == null || !cb.isVisible() || !name.equals(cb.getName()) || cb.getSelectedIndex() != -1) continue;
                return false;
            }
        }
        return flag;
    }

    public boolean checkTextBoxes() {
        boolean flag = true;
        for (int i = 0; i < this.arrComponents.length; ++i) {
            String name = this.arrComponents[i][1];
            for (Component object : this.componentList) {
                JTextField tf;
                if (!(object instanceof JTextField) || (tf = (JTextField)object).getName() == null || !tf.isVisible() || tf.getName() == null || !tf.isVisible() || !name.equals(tf.getName()) || tf.getText().length() != 0) continue;
                flag = false;
            }
        }
        return flag;
    }

    void fireAction(JButton cb, String str) {
        str = str.length() == 0 ? cb.getActionCommand() : str;
        ActionListener[] cbActions = cb.getActionListeners();
        for (int i = 0; i < cbActions.length; ++i) {
            cb.getActionListeners()[i].actionPerformed(new ActionEvent(cb, 0, str));
        }
    }

    void setPeriodDate(String widget) {
        SimpleDateFormat df = new SimpleDateFormat("d-MMM-yyyy");
        Object NewDateHi = null;
        Object NewDateLo = null;
        Date ValuationDate = null;
        Date ClaimDate = null;
        Integer periods = null;
        if (this.my.ValuationDate.getText().length() > 0) {
            try {
                ValuationDate = df.parse(this.my.ValuationDate.getText());
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        if (this.my.ClaimDate.getText().length() > 0) {
            try {
                ClaimDate = df.parse(this.my.ClaimDate.getText());
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        if (this.my.Periods.getSelectedIndex() > -1) {
            periods = ((Combohelper)this.my.Periods.getSelectedItem()).getCode();
        }
        Calendar cal = Calendar.getInstance();
        if (widget.equals("Periods")) {
            if (ValuationDate == null && ClaimDate == null) {
                ValuationDate = new Date();
                cal.setTime(ValuationDate);
                cal.add(1, -periods.intValue());
                cal.add(2, 6);
                ClaimDate = cal.getTime();
            } else if (ValuationDate != null && ClaimDate == null) {
                cal.setTime(ValuationDate);
                cal.add(1, -periods.intValue());
                cal.add(2, 6);
                ClaimDate = cal.getTime();
            } else if (ValuationDate == null && ClaimDate != null) {
                cal.setTime(ClaimDate);
                cal.add(1, periods);
                cal.add(2, -6);
                ValuationDate = cal.getTime();
            }
            this.my.ValuationDate.setText(df.format(ValuationDate));
            this.my.ClaimDate.setText(df.format(ClaimDate));
        } else if (widget.equals("ValuationDate") && ValuationDate != null) {
            if (periods == null && ClaimDate == null) {
                periods = 1;
                cal.setTime(ValuationDate);
                cal.add(1, -periods.intValue());
                cal.add(2, 6);
                ClaimDate = cal.getTime();
            } else if (periods != null && ClaimDate == null) {
                cal.setTime(ValuationDate);
                cal.add(1, -periods.intValue());
                cal.add(2, 6);
                ClaimDate = cal.getTime();
            } else if (ClaimDate != null) {
                Long elapse = (ValuationDate.getTime() - ClaimDate.getTime()) / 31536000000L;
                Integer prd = Math.max(0, elapse.intValue());
                periods = 1 + Math.min(4, prd);
            }
            this.booPeriodDate = false;
            this.my.Periods.setSelectedIndex(periods - 1);
            this.my.ClaimDate.setText(df.format(ClaimDate));
            this.booPeriodDate = true;
        } else if (widget.equals("ClaimDate") && ClaimDate != null) {
            if (periods == null && ValuationDate == null) {
                periods = 1;
                cal.setTime(ClaimDate);
                cal.add(1, periods);
                cal.add(2, -6);
                ValuationDate = cal.getTime();
            } else if (periods != null && ValuationDate == null) {
                cal.setTime(ClaimDate);
                cal.add(1, periods);
                cal.add(2, -6);
                ValuationDate = cal.getTime();
            } else if (ValuationDate != null) {
                Long elapse = (ValuationDate.getTime() - ClaimDate.getTime()) / 31536000000L;
                Integer prd = Math.max(0, elapse.intValue());
                periods = 1 + Math.min(4, prd);
            }
            this.booPeriodDate = false;
            this.my.Periods.setSelectedIndex(periods - 1);
            this.my.ValuationDate.setText(df.format(ValuationDate));
            this.booPeriodDate = true;
        }
    }

    void setButtons(Boolean flag) {
        this.my.bNew.setEnabled(flag);
        this.my.bUpdate.setEnabled(flag != false && this.my.Record.getItemCount() > 0 && this.my.Record.getSelectedIndex() > -1);
    }

    void selectNode(Boolean flag) {
        EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
        List resultList = entityManager.createNamedQuery("Claims.polnum").setParameter("client", (Object)this.client).setParameter("polnum", (Object)this.polnum).getResultList();
        Claims p = null;
        if (flag.booleanValue()) {
            p = this.claims;
        } else {
            Iterator it = resultList.iterator();
            if (it.hasNext()) {
                this.claims = p = (Claims)it.next();
            }
        }
        if (p != null) {
            this.my.refreshNode(resultList);
            this.my.addBeanToSelection(p);
        }
    }

    Float msl() {
        Review rev = new Review(this.client, this.polnum, this.version, this.PU);
        Integer Province = ((Combohelper)this.my.Province.getSelectedItem()).getCode();
        Integer Vehicle = ((Combohelper)this.my.Vehicle.getSelectedItem()).getCode();
        Integer Cov = ((Combohelper)this.my.Cov.getSelectedItem()).getCode();
        Integer Periods = ((Combohelper)this.my.Periods.getSelectedItem()).getCode();
        return Float.valueOf(rev.getMsl(Province, Vehicle, Cov, Periods));
    }

    void truncateTable() {
        if (this.polnum != null) {
            Review rev = new Review(this.client, this.polnum, this.version, this.PU);
            rev.truncateTable();
        }
    }

    Integer b2i(Boolean b) {
        return b != false ? 1 : 0;
    }

    Boolean i2b(Integer i) {
        return i == 1;
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JComboBox) {
                JComboBox cb = (JComboBox)e.getSource();
                System.out.println("ClaimsCode:ComboListener " + cb.getName());
                if (cb.getName().equals("Record")) {
                    if (((ClaimsCode)ClaimsCode.this).my.Record.getItemCount() > 0 && ((ClaimsCode)ClaimsCode.this).my.Record.getSelectedIndex() > -1) {
                        Combohelper ch = (Combohelper)((ClaimsCode)ClaimsCode.this).my.Record.getSelectedItem();
                        Integer in = ch.getCode();
                        ((ClaimsCode)ClaimsCode.this).my.tfRecord.setText(in.toString());
                        ((ClaimsCode)ClaimsCode.this).my.bPopulate.setEnabled(true);
                        ((ClaimsCode)ClaimsCode.this).my.bDelete.setEnabled(true);
                        ((ClaimsCode)ClaimsCode.this).my.bUpdate.setEnabled(((ClaimsCode)ClaimsCode.this).my.bNew.isEnabled());
                    } else {
                        ((ClaimsCode)ClaimsCode.this).my.bPopulate.setEnabled(false);
                        ((ClaimsCode)ClaimsCode.this).my.bDelete.setEnabled(false);
                    }
                } else if (cb.getName().equals("Periods") && ClaimsCode.this.booPeriodDate.booleanValue()) {
                    ClaimsCode.this.setPeriodDate("Periods");
                }
                if (ClaimsCode.this.checkComboBoxes()) {
                    ((ClaimsCode)ClaimsCode.this).my.Msl.setText(ClaimsCode.this.msl().toString());
                    if (ClaimsCode.this.checkTextBoxes()) {
                        ClaimsCode.this.setButtons(true);
                    } else {
                        ClaimsCode.this.setButtons(false);
                    }
                } else {
                    ClaimsCode.this.setButtons(false);
                }
            }
        }
    }

    public class DateLabelFormatter
    extends JFormattedTextField.AbstractFormatter {
        private String datePattern = "d-MMM-yyyy";
        private SimpleDateFormat dateFormatter = new SimpleDateFormat(this.datePattern);

        @Override
        public Object stringToValue(String text) throws ParseException {
            return this.dateFormatter.parseObject(text);
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value != null) {
                Calendar cal = (Calendar)value;
                return this.dateFormatter.format(cal.getTime());
            }
            return "";
        }
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            this.anychange(de);
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            System.out.println("Combo:MyDocumentListener:removeUpdate " + de.toString());
            this.anychange(de);
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
            System.out.println("Combo:MyDocumentListener:changedUpdate " + de.toString());
        }

        void anychange(DocumentEvent de) {
            System.out.println("Combo:MyDocumentListener:insertUpdate " + de.toString());
            Document doc = de.getDocument();
            Integer in = doc.getLength();
            Boolean flag = ((ClaimsCode)ClaimsCode.this).my.tfRecord.getText().length() > 0;
            ((ClaimsCode)ClaimsCode.this).my.bPopulate.setEnabled(flag);
            ((ClaimsCode)ClaimsCode.this).my.bDelete.setEnabled(flag);
            if (ClaimsCode.this.checkComboBoxes()) {
                if (ClaimsCode.this.checkTextBoxes()) {
                    ClaimsCode.this.setButtons(true);
                } else {
                    ClaimsCode.this.setButtons(false);
                }
            }
        }
    }

    class PolicyListener
    implements ActionListener {
        PolicyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Integer in;
            Boolean usePolicy = true;
            String cmd = e.getActionCommand();
            EntityManager entityManager = ((EntityService)Lookup.getDefault().lookup(EntityService.class)).getEntityManager();
            entityManager.getTransaction().begin();
            if (cmd.equals("Update")) {
                ClaimsCode.this.claims = ClaimsCode.this.getClaimRecord(entityManager, Integer.parseInt(((ClaimsCode)ClaimsCode.this).my.tfRecord.getText()));
                if (ClaimsCode.this.claims != null) {
                    ClaimsCode.this.save();
                    entityManager.getTransaction().commit();
                    ClaimsCode.this.my.setflagReviewFleet(true);
                    ClaimsCode.this.resetFields();
                } else {
                    usePolicy = false;
                }
            } else if (cmd.equals("Valuation Date")) {
                ClaimsCode.this.frameDatePick(((ClaimsCode)ClaimsCode.this).my.ValuationDate, cmd);
            } else if (cmd.equals("Claim Date")) {
                ClaimsCode.this.frameDatePick(((ClaimsCode)ClaimsCode.this).my.ClaimDate, cmd);
            } else if (cmd.equals("Transfer")) {
                JDatePickerImpl dp = (JDatePickerImpl)ClaimsCode.this.frameDate.getContentPane().getComponent(0).getComponentAt(0, 0);
                Date selectedDate = (Date)dp.getModel().getValue();
                String transfer = "";
                if (selectedDate != null) {
                    SimpleDateFormat df = new SimpleDateFormat("d-MMM-yyyy");
                    transfer = df.format(selectedDate);
                }
                if (!transfer.equals(ClaimsCode.this.tfDate.getText())) {
                    ClaimsCode.this.tfDate.setText(transfer);
                }
                ClaimsCode.this.frameDate.dispose();
                ClaimsCode.this.setPeriodDate(ClaimsCode.this.tfDate.getName());
            } else if (cmd.equals("New")) {
                ClaimsCode.this.claims = new Claims();
                ClaimsCode.this.claims.setClient(Integer.valueOf(Integer.parseInt(((ClaimsCode)ClaimsCode.this).my.tfClient.getText())));
                ClaimsCode.this.claims.setPolnum(Integer.valueOf(Integer.parseInt(((ClaimsCode)ClaimsCode.this).my.tfPolicy.getText())));
                ClaimsCode.this.claims.setVersion(ClaimsCode.this.version);
                ClaimsCode.this.claims.setPolicynumber(ClaimsCode.this.policynumber);
                ClaimsCode.this.claims.setUsers(ClaimsCode.this.users);
                ClaimsCode.this.claims.setUsersgroup(ClaimsCode.this.usersgroup);
                ClaimsCode.this.save();
                entityManager.merge((Object)ClaimsCode.this.claims);
                entityManager.persist((Object)ClaimsCode.this.claims);
                entityManager.getTransaction().commit();
                ClaimsCode.this.my.setflagReviewFleet(true);
                ClaimsCode.this.resetClaimCount(ClaimsCode.this.polnum);
                ClaimsCode.this.initClaimRecord(((ClaimsCode)ClaimsCode.this).my.Record, ClaimsCode.this.polnum);
                ClaimsCode.this.resetFields();
            } else if (cmd.equals("Delete")) {
                ClaimsCode.this.claims = ClaimsCode.this.getClaimRecord(entityManager, Integer.parseInt(((ClaimsCode)ClaimsCode.this).my.tfRecord.getText()));
                if (ClaimsCode.this.claims != null) {
                    entityManager.merge((Object)ClaimsCode.this.claims);
                    entityManager.remove((Object)ClaimsCode.this.claims);
                    entityManager.getTransaction().commit();
                    ClaimsCode.this.my.setflagReviewFleet(true);
                    ClaimsCode.this.resetClaimCount(ClaimsCode.this.polnum);
                    ClaimsCode.this.initClaimRecord(((ClaimsCode)ClaimsCode.this).my.Record, ClaimsCode.this.polnum);
                } else {
                    usePolicy = false;
                }
            } else if (cmd.equals("Refresh")) {
                ClaimsCode.this.refreshMSL2();
                usePolicy = false;
            } else if (cmd.equals("Populate")) {
                ClaimsCode.this.claims = ClaimsCode.this.getClaimRecord(entityManager, Integer.parseInt(((ClaimsCode)ClaimsCode.this).my.tfRecord.getText()));
                if (ClaimsCode.this.claims != null) {
                    ClaimsCode.this.initComboListeners(false);
                    ClaimsCode.this.flagCalc = false;
                    ClaimsCode.this.populatePrimary();
                    ClaimsCode.this.initComboListeners(true);
                    ClaimsCode.this.flagCalc = true;
                } else {
                    usePolicy = false;
                }
                if (ClaimsCode.this.checkTextBoxes() && ClaimsCode.this.checkComboBoxes()) {
                    ClaimsCode.this.setButtons(true);
                } else {
                    ClaimsCode.this.setButtons(false);
                }
            } else if (cmd.equals("PopulateHidden")) {
                ClaimsCode.this.claims = (Claims)entityManager.find(Claims.class, (Object)Integer.parseInt(((ClaimsCode)ClaimsCode.this).my.tfRecord.getText()));
                if (ClaimsCode.this.claims != null) {
                    ClaimsCode.this.initComboListeners(false);
                    ClaimsCode.this.flagCalc = false;
                    System.out.println("populatePrimary");
                    ClaimsCode.this.populatePrimary();
                    usePolicy = false;
                    ClaimsCode.this.initComboListeners(true);
                    ClaimsCode.this.flagCalc = true;
                    in = ((ClaimsCode)ClaimsCode.this).my.bPopulate.getIconTextGap();
                    ((ClaimsCode)ClaimsCode.this).my.bPopulate.setIconTextGap(0);
                    Integer idx = ((ClaimsCode)ClaimsCode.this).my.Periods.getSelectedIndex();
                    idx = idx + in;
                    if (idx > 4) {
                        ((ClaimsCode)ClaimsCode.this).my.Periods.setSelectedIndex(-1);
                    } else {
                        ((ClaimsCode)ClaimsCode.this).my.Periods.setSelectedIndex(idx);
                    }
                } else {
                    usePolicy = false;
                }
                if (ClaimsCode.this.checkTextBoxes() && ClaimsCode.this.checkComboBoxes()) {
                    ClaimsCode.this.setButtons(true);
                } else {
                    ClaimsCode.this.setButtons(false);
                }
            } else if (cmd.equals("PopulateOutput")) {
                ClaimsCode.this.claims = (Claims)entityManager.find(Claims.class, (Object)Integer.parseInt(((ClaimsCode)ClaimsCode.this).my.tfRecord.getText()));
                if (ClaimsCode.this.claims != null) {
                    ClaimsCode.this.initComboListeners(false);
                    ClaimsCode.this.flagCalc = false;
                    System.out.println("populatePrimary");
                    ClaimsCode.this.populatePrimary();
                    usePolicy = false;
                    ClaimsCode.this.initComboListeners(true);
                    ClaimsCode.this.flagCalc = true;
                } else {
                    usePolicy = false;
                }
                if (ClaimsCode.this.checkTextBoxes() && ClaimsCode.this.checkComboBoxes()) {
                    ClaimsCode.this.setButtons(true);
                } else {
                    ClaimsCode.this.setButtons(false);
                }
                System.out.println("Claims PopulateOutput Finished");
                ClaimsCode.this.fireAction(((ClaimsCode)ClaimsCode.this).my.bNew, "OutputLoopClaims");
            } else if (cmd.equals("PopulateXml")) {
                ClaimsCode.this.claims = ClaimsCode.this.getClaims();
                if (ClaimsCode.this.claims != null) {
                    ClaimsCode.this.initComboListeners(false);
                    ClaimsCode.this.flagCalc = false;
                    System.out.println("populatePrimary");
                    ClaimsCode.this.populatePrimary();
                    usePolicy = false;
                    ClaimsCode.this.initComboListeners(true);
                    ClaimsCode.this.flagCalc = true;
                    in = ((ClaimsCode)ClaimsCode.this).my.bPopulate.getIconTextGap();
                    ((ClaimsCode)ClaimsCode.this).my.bPopulate.setIconTextGap(0);
                    Integer idx = ((ClaimsCode)ClaimsCode.this).my.Periods.getSelectedIndex();
                    idx = idx + in;
                    if (idx > 4) {
                        ((ClaimsCode)ClaimsCode.this).my.Periods.setSelectedIndex(-1);
                    } else {
                        ((ClaimsCode)ClaimsCode.this).my.Periods.setSelectedIndex(idx);
                    }
                } else {
                    usePolicy = false;
                }
                if (ClaimsCode.this.checkTextBoxes() && ClaimsCode.this.checkComboBoxes()) {
                    ClaimsCode.this.setButtons(true);
                } else {
                    ClaimsCode.this.setButtons(false);
                }
            }
            List resultList = entityManager.createNamedQuery("Claims.polnum").setParameter("client", (Object)ClaimsCode.this.client).setParameter("polnum", (Object)ClaimsCode.this.polnum).getResultList();
            ClaimsCode.this.my.refreshNode(resultList);
            ClaimsCode.this.selectNode(usePolicy);
        }
    }

    class TextListener
    implements ActionListener {
        TextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String tf2 = ((ClaimsCode)ClaimsCode.this).my.tfRecord.getText();
            try {
                if (tf2.length() > 0) {
                    Integer tf1 = Integer.parseInt(tf2);
                }
            }
            catch (NumberFormatException e1) {
                Toolkit.getDefaultToolkit().beep();
                ((ClaimsCode)ClaimsCode.this).my.tfRecord.setText(tf2.substring(0, tf2.length() - 1));
            }
            Boolean flag = ((ClaimsCode)ClaimsCode.this).my.tfRecord.getText().length() > 0;
            ((ClaimsCode)ClaimsCode.this).my.bPopulate.setVisible(flag);
            ((ClaimsCode)ClaimsCode.this).my.bDelete.setVisible(flag);
            if (ClaimsCode.this.checkTextBoxes()) {
                ClaimsCode.this.setButtons(true);
            } else {
                ClaimsCode.this.setButtons(false);
            }
        }
    }

    class myKeyAdapter
    extends KeyAdapter {
        JTextField tf;

        myKeyAdapter(JTextField st) {
            this.tf = st;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            String tf2 = this.tf.getText();
            try {
                if (tf2.length() > 0) {
                    Double tf1 = Double.parseDouble(tf2);
                }
            }
            catch (NumberFormatException e1) {
                Toolkit.getDefaultToolkit().beep();
                this.tf.setText(tf2.substring(0, tf2.length() - 1));
            }
            if (ClaimsCode.this.checkComboBoxes() && ClaimsCode.this.checkTextBoxes()) {
                ClaimsCode.this.setButtons(true);
            } else {
                ClaimsCode.this.setButtons(false);
            }
        }
    }

    class myNullKeyAdapter
    extends KeyAdapter {
        JFormattedTextField tf;

        myNullKeyAdapter(JFormattedTextField st) {
            this.tf = st;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.tf.getText().length() == 0) {
                this.tf.setValue(null);
            }
            switch (e.getKeyCode()) {
                case 9: {
                    ClaimsCode.this.setPeriodDate(this.tf.getName());
                    e.consume();
                    break;
                }
                case 10: {
                    ClaimsCode.this.setPeriodDate(this.tf.getName());
                    e.consume();
                    break;
                }
                default: {
                    e.consume();
                }
            }
            if (ClaimsCode.this.frameDate != null && this.tf.getText().length() > 0) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("d-MMM-yyyy");
                    Date dt = df.parse(this.tf.getText());
                    JDatePickerImpl dp = (JDatePickerImpl)ClaimsCode.this.frameDate.getContentPane().getComponent(0).getComponentAt(0, 0);
                    ((UtilDateModel)dp.getModel()).setValue(dt);
                }
                catch (ParseException ex) {
                    System.out.println("ParseException: on JDatePickerImpl");
                }
            }
        }
    }
}

