/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.CLIHandler;
import org.netbeans.Module;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ModuleSystem;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class CLICoreBridge
extends CLIHandler {
    public CLICoreBridge() {
        super(2);
    }

    protected int cli(CLIHandler.Args arguments) {
        Lookup clis = Lookup.getDefault();
        Collection handlers = clis.lookupAll(CLIHandler.class);
        int h = CLICoreBridge.notifyHandlers((CLIHandler.Args)arguments, (Collection)handlers, (int)3, (boolean)true, (boolean)true);
        if (h == 0) {
            h = CoreBridge.getDefault().cli(arguments.getArguments(), arguments.getInputStream(), arguments.getOutputStream(), arguments.getErrorStream(), arguments.getCurrentDirectory());
        }
        return h;
    }

    protected void usage(PrintWriter w) {
        ModuleSystem moduleSystem;
        if (MainLookup.isStarted()) {
            Lookup clis = Lookup.getDefault();
            Collection handlers = clis.lookupAll(CLIHandler.class);
            CLICoreBridge.showHelp((PrintWriter)w, (Collection)handlers, (int)3);
            w.flush();
            return;
        }
        CLIOptions.fallbackToMemory();
        try {
            moduleSystem = new ModuleSystem(FileUtil.getConfigRoot().getFileSystem());
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Module system cannot be created", ioe);
        }
        moduleSystem.readList();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Module m : moduleSystem.getManager().getModules()) {
            for (File f : m.getAllJars()) {
                try {
                    urls.add(Utilities.toURI((File)f).toURL());
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        MainLookup.systemClassLoaderChanged(loader);
        try {
            List<URL> layers = ModuleLayeredFileSystem.collectLayers(loader);
            XMLFileSystem xfs = new XMLFileSystem();
            xfs.setXmlUrls(layers.toArray(new URL[layers.size()]));
            MainLookup.register(xfs);
            MainLookup.modulesClassPathInitialized(Lookups.forPath((String)"Services/OptionProcessors"));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Lookup clis = Lookup.getDefault();
        Collection handlers = clis.lookupAll(CLIHandler.class);
        CLICoreBridge.showHelp((PrintWriter)w, (Collection)handlers, (int)3);
        w.flush();
    }
}

