/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.ui.UiUtils;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SearchScopeBrowse {
    private static FileObject[] roots = null;
    private SearchScopeDefinition browseScope = new BrowseScope();
    private SearchScopeDefinition getLastScope = new GetLastScope();

    private FileObject[] chooseRoots() {
        FileChooserBuilder chooserBuilder = new FileChooserBuilder(SearchScopeBrowse.class);
        chooserBuilder.setTitle(UiUtils.getText("LBL_ScopeBrowseFileChooserTitle"));
        chooserBuilder.setApproveText(UiUtils.getText("LBL_ScopeBrowseFileChooserApprove"));
        File[] files = chooserBuilder.showMultiOpenDialog();
        if (files == null) {
            files = new File[]{};
        }
        FileObject[] fileObjects = new FileObject[files.length];
        for (int i = 0; i < files.length; ++i) {
            fileObjects[i] = FileUtil.toFileObject((File)files[i]);
        }
        if (fileObjects.length > 0) {
            roots = fileObjects;
        }
        return fileObjects;
    }

    public SearchScopeDefinition getBrowseScope() {
        return this.browseScope;
    }

    public SearchScopeDefinition getGetLastScope() {
        return this.getLastScope;
    }

    private class BrowseScope
    extends SearchScopeDefinition {
        private SearchInfo searchInfo;

        private BrowseScope() {
            this.searchInfo = SearchInfoUtils.createForDefinition(new BrowseSearchInfo());
        }

        @Override
        public String getTypeId() {
            return "browse";
        }

        @Override
        public String getDisplayName() {
            return UiUtils.getText("LBL_ScopeBrowseName");
        }

        @Override
        public boolean isApplicable() {
            return true;
        }

        @Override
        public SearchInfo getSearchInfo() {
            return this.searchInfo;
        }

        @Override
        public int getPriority() {
            return 501;
        }

        @Override
        public void clean() {
        }

        @Override
        public void selected() {
            SearchScopeBrowse.this.chooseRoots();
            this.notifyListeners();
        }
    }

    private class BrowseSearchInfo
    extends SearchInfoDefinition {
        private SearchInfo delegate;

        private BrowseSearchInfo() {
        }

        @Override
        public boolean canSearch() {
            return true;
        }

        @Override
        public Iterator<FileObject> filesToSearch(SearchScopeOptions options, SearchListener listener, AtomicBoolean terminated) {
            return this.getDelegate().getFilesToSearch(options, listener, terminated).iterator();
        }

        @Override
        public List<SearchRoot> getSearchRoots() {
            return this.getDelegate().getSearchRoots();
        }

        private synchronized SearchInfo getDelegate() {
            if (this.delegate == null) {
                this.delegate = this.createDelegate();
            }
            return this.delegate;
        }

        private SearchInfo createDelegate() {
            FileObject[] fileObjects = SearchScopeBrowse.this.chooseRoots();
            return SearchInfoUtils.createSearchInfoForRoots(fileObjects);
        }
    }

    private class GetLastScope
    extends SearchScopeDefinition {
        private GetLastScope() {
        }

        @Override
        public String getTypeId() {
            return "browse";
        }

        @Override
        public String getDisplayName() {
            if (roots != null && roots.length > 0) {
                return UiUtils.getText("LBL_ScopeBrowseName") + " [" + roots[0].getName() + (roots.length > 1 ? "..." : "") + "]";
            }
            return "no files selected";
        }

        @Override
        public boolean isApplicable() {
            return roots != null && roots.length > 0;
        }

        @Override
        public SearchInfo getSearchInfo() {
            return SearchInfoUtils.createSearchInfoForRoots(roots);
        }

        @Override
        public int getPriority() {
            return 500;
        }

        @Override
        public void clean() {
        }
    }
}

