/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.CSSPrimitiveValueImpl;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Rect;

public class RectImpl
implements Rect {
    protected final long peer;

    RectImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static Rect create(long peer) {
        if (peer == 0L) {
            return null;
        }
        return new RectImpl(peer);
    }

    public boolean equals(Object that) {
        return that instanceof RectImpl && this.peer == ((RectImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(Rect arg) {
        return arg == null ? 0L : ((RectImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    static Rect getImpl(long peer) {
        return RectImpl.create(peer);
    }

    @Override
    public CSSPrimitiveValue getTop() {
        return CSSPrimitiveValueImpl.getImpl(RectImpl.getTopImpl(this.getPeer()));
    }

    static native long getTopImpl(long var0);

    @Override
    public CSSPrimitiveValue getRight() {
        return CSSPrimitiveValueImpl.getImpl(RectImpl.getRightImpl(this.getPeer()));
    }

    static native long getRightImpl(long var0);

    @Override
    public CSSPrimitiveValue getBottom() {
        return CSSPrimitiveValueImpl.getImpl(RectImpl.getBottomImpl(this.getPeer()));
    }

    static native long getBottomImpl(long var0);

    @Override
    public CSSPrimitiveValue getLeft() {
        return CSSPrimitiveValueImpl.getImpl(RectImpl.getLeftImpl(this.getPeer()));
    }

    static native long getLeftImpl(long var0);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            RectImpl.dispose(this.peer);
        }
    }
}

