/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ThemeReader {
    private static final HashMap<String, Long> widgetToTheme = new HashMap();
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final Lock readLock = readWriteLock.readLock();
    private static final Lock writeLock = readWriteLock.writeLock();
    private static volatile boolean valid = false;

    static void flush() {
        valid = false;
    }

    public static native boolean isThemed();

    private static Long getThemeImpl(String string) {
        Long l = widgetToTheme.get(string);
        if (l == null) {
            int n = string.indexOf("::");
            if (n > 0) {
                ThemeReader.setWindowTheme(string.substring(0, n));
                l = ThemeReader.openTheme(string.substring(n + 2));
                ThemeReader.setWindowTheme(null);
            } else {
                l = ThemeReader.openTheme(string);
            }
            widgetToTheme.put(string, l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long getTheme(String string) {
        Object object;
        if (!valid) {
            readLock.unlock();
            writeLock.lock();
            try {
                if (!valid) {
                    object = widgetToTheme.values().iterator();
                    while (object.hasNext()) {
                        Long l = (Long)object.next();
                        ThemeReader.closeTheme(l);
                    }
                    widgetToTheme.clear();
                    valid = true;
                }
            }
            finally {
                readLock.lock();
                writeLock.unlock();
            }
        }
        if ((object = widgetToTheme.get(string)) == null) {
            readLock.unlock();
            writeLock.lock();
            try {
                object = ThemeReader.getThemeImpl(string);
            }
            finally {
                readLock.lock();
                writeLock.unlock();
            }
        }
        return object;
    }

    public static native void paintBackground(int[] var0, long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintBackground(int[] nArray, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        readLock.lock();
        try {
            ThemeReader.paintBackground(nArray, ThemeReader.getTheme(string), n, n2, n3, n4, n5, n6, n7);
        }
        finally {
            readLock.unlock();
        }
    }

    public static native Insets getThemeMargins(long var0, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Insets getThemeMargins(String string, int n, int n2, int n3) {
        readLock.lock();
        try {
            Insets insets = ThemeReader.getThemeMargins(ThemeReader.getTheme(string), n, n2, n3);
            return insets;
        }
        finally {
            readLock.unlock();
        }
    }

    private static native boolean isThemePartDefined(long var0, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isThemePartDefined(String string, int n, int n2) {
        readLock.lock();
        try {
            boolean bl = ThemeReader.isThemePartDefined(ThemeReader.getTheme(string), n, n2);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public static native Color getColor(long var0, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color getColor(String string, int n, int n2, int n3) {
        readLock.lock();
        try {
            Color color = ThemeReader.getColor(ThemeReader.getTheme(string), n, n2, n3);
            return color;
        }
        finally {
            readLock.unlock();
        }
    }

    public static native int getInt(long var0, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInt(String string, int n, int n2, int n3) {
        readLock.lock();
        try {
            int n4 = ThemeReader.getInt(ThemeReader.getTheme(string), n, n2, n3);
            return n4;
        }
        finally {
            readLock.unlock();
        }
    }

    public static native int getEnum(long var0, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEnum(String string, int n, int n2, int n3) {
        readLock.lock();
        try {
            int n4 = ThemeReader.getEnum(ThemeReader.getTheme(string), n, n2, n3);
            return n4;
        }
        finally {
            readLock.unlock();
        }
    }

    public static native boolean getBoolean(long var0, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBoolean(String string, int n, int n2, int n3) {
        readLock.lock();
        try {
            boolean bl = ThemeReader.getBoolean(ThemeReader.getTheme(string), n, n2, n3);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public static native boolean getSysBoolean(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getSysBoolean(String string, int n) {
        readLock.lock();
        try {
            boolean bl = ThemeReader.getSysBoolean(ThemeReader.getTheme(string), n);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public static native Point getPoint(long var0, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point getPoint(String string, int n, int n2, int n3) {
        readLock.lock();
        try {
            Point point = ThemeReader.getPoint(ThemeReader.getTheme(string), n, n2, n3);
            return point;
        }
        finally {
            readLock.unlock();
        }
    }

    public static native Dimension getPosition(long var0, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getPosition(String string, int n, int n2, int n3) {
        readLock.lock();
        try {
            Dimension dimension = ThemeReader.getPosition(ThemeReader.getTheme(string), n, n2, n3);
            return dimension;
        }
        finally {
            readLock.unlock();
        }
    }

    public static native Dimension getPartSize(long var0, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getPartSize(String string, int n, int n2) {
        readLock.lock();
        try {
            Dimension dimension = ThemeReader.getPartSize(ThemeReader.getTheme(string), n, n2);
            return dimension;
        }
        finally {
            readLock.unlock();
        }
    }

    public static native long openTheme(String var0);

    public static native void closeTheme(long var0);

    public static native void setWindowTheme(String var0);

    private static native long getThemeTransitionDuration(long var0, int var2, int var3, int var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getThemeTransitionDuration(String string, int n, int n2, int n3, int n4) {
        readLock.lock();
        try {
            long l = ThemeReader.getThemeTransitionDuration(ThemeReader.getTheme(string), n, n2, n3, n4);
            return l;
        }
        finally {
            readLock.unlock();
        }
    }

    public static native boolean isGetThemeTransitionDurationDefined();

    private static native Insets getThemeBackgroundContentMargins(long var0, int var2, int var3, int var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Insets getThemeBackgroundContentMargins(String string, int n, int n2, int n3, int n4) {
        readLock.lock();
        try {
            Insets insets = ThemeReader.getThemeBackgroundContentMargins(ThemeReader.getTheme(string), n, n2, n3, n4);
            return insets;
        }
        finally {
            readLock.unlock();
        }
    }
}

