/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.InsetsConverter;
import com.sun.javafx.scene.layout.region.Border;
import com.sun.javafx.scene.layout.region.BorderStyle;
import com.sun.javafx.scene.layout.region.Margins;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;

public class StrokeBorder
extends Border {
    private final double topLeftCornerRadius;
    private final double topRightCornerRadius;
    private final double bottomLeftCornerRadius;
    private final double bottomRightCornerRadius;
    private final Paint leftFill;
    private final Paint topFill;
    private final Paint rightFill;
    private final Paint bottomFill;
    private final BorderStyle topStyle;
    private final BorderStyle rightStyle;
    private final BorderStyle bottomStyle;
    private final BorderStyle leftStyle;

    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return StrokeBorder.impl_CSS_STYLEABLES();
    }

    public double getTopLeftCornerRadius() {
        return this.topLeftCornerRadius;
    }

    public double getTopRightCornerRadius() {
        return this.topRightCornerRadius;
    }

    public double getBottomLeftCornerRadius() {
        return this.bottomLeftCornerRadius;
    }

    public double getBottomRightCornerRadius() {
        return this.bottomRightCornerRadius;
    }

    public Paint getLeftFill() {
        return this.leftFill;
    }

    public Paint getTopFill() {
        return this.topFill;
    }

    public Paint getRightFill() {
        return this.rightFill;
    }

    public Paint getBottomFill() {
        return this.bottomFill;
    }

    public BorderStyle getTopStyle() {
        return this.topStyle;
    }

    public BorderStyle getRightStyle() {
        return this.rightStyle;
    }

    public BorderStyle getBottomStyle() {
        return this.bottomStyle;
    }

    public BorderStyle getLeftStyle() {
        return this.leftStyle;
    }

    StrokeBorder(double d, double d2, double d3, double d4, boolean bl, Insets insets, double d5, double d6, double d7, double d8, Paint paint, Paint paint2, Paint paint3, Paint paint4, BorderStyle borderStyle, BorderStyle borderStyle2, BorderStyle borderStyle3, BorderStyle borderStyle4) {
        super(d, d2, d3, d4, bl, insets);
        this.topLeftCornerRadius = d5;
        this.topRightCornerRadius = d6;
        this.bottomLeftCornerRadius = d7;
        this.bottomRightCornerRadius = d8;
        this.topFill = paint;
        this.rightFill = paint2;
        this.bottomFill = paint3;
        this.leftFill = paint4;
        this.topStyle = borderStyle;
        this.rightStyle = borderStyle2;
        this.bottomStyle = borderStyle3;
        this.leftStyle = borderStyle4;
    }

    public static final class BorderPaintConverter
    extends StyleConverter<ParsedValue<?, Paint>[], Paint[]> {
        public static BorderPaintConverter getInstance() {
            return Holder.BORDER_PAINT_CONVERTER;
        }

        private BorderPaintConverter() {
        }

        @Override
        public Paint[] convert(ParsedValue<ParsedValue<?, Paint>[], Paint[]> parsedValue, Font font) {
            Paint[] paintArray;
            ParsedValue<?, Paint>[] parsedValueArray = parsedValue.getValue();
            paintArray = new Paint[]{parsedValueArray.length > 0 ? parsedValueArray[0].convert(font) : Color.BLACK, parsedValueArray.length > 1 ? parsedValueArray[1].convert(font) : paintArray[0], parsedValueArray.length > 2 ? parsedValueArray[2].convert(font) : paintArray[0], parsedValueArray.length > 3 ? parsedValueArray[3].convert(font) : paintArray[1]};
            return paintArray;
        }

        public String toString() {
            return "BorderPaintType";
        }
    }

    public static final class BorderStyleConverter
    extends StyleConverter<ParsedValue[], BorderStyle> {
        public static BorderStyleConverter getInstance() {
            return Holder.BORDER_STYLE_CONVERTER;
        }

        private BorderStyleConverter() {
        }

        @Override
        public BorderStyle convert(ParsedValue<ParsedValue[], BorderStyle> parsedValue, Font font) {
            Double d;
            StrokeLineCap strokeLineCap;
            StrokeLineJoin strokeLineJoin;
            Object object;
            ParsedValue[] parsedValueArray = parsedValue.getValue();
            if (parsedValueArray.length == 1 && BorderStyle.NONE == parsedValueArray[0].getValue()) {
                return BorderStyle.NONE;
            }
            ParsedValue[] parsedValueArray2 = (ParsedValue[])parsedValueArray[0].getValue();
            if (parsedValueArray2 == null) {
                return BorderStyle.NONE;
            }
            double[] dArray = new double[parsedValueArray2.length];
            for (int i = 0; i < parsedValueArray2.length; ++i) {
                object = (Size)parsedValueArray2[i].convert(font);
                dArray[i] = object.pixels(font);
            }
            Double d2 = parsedValueArray[1] != null ? (Double)parsedValueArray[1].convert(font) : 0.0;
            object = parsedValueArray[2] != null ? (StrokeType)((Object)parsedValueArray[2].convert(font)) : StrokeType.CENTERED;
            BorderStyle borderStyle = new BorderStyle((StrokeType)((Object)object), strokeLineJoin = parsedValueArray[3] != null ? (StrokeLineJoin)((Object)parsedValueArray[3].convert(font)) : StrokeLineJoin.MITER, strokeLineCap = parsedValueArray[5] != null ? (StrokeLineCap)((Object)parsedValueArray[5].convert(font)) : StrokeLineCap.BUTT, d = Double.valueOf(parsedValueArray[4] != null ? (Double)parsedValueArray[4].convert(font) : 10.0), d2, dArray);
            if (BorderStyle.SOLID.equals(borderStyle)) {
                return BorderStyle.SOLID;
            }
            return borderStyle;
        }

        public String toString() {
            return "StyleType";
        }
    }

    public static final class BorderStyleSequenceConverter
    extends StyleConverter<ParsedValue<ParsedValue[], BorderStyle>[], BorderStyle[]> {
        public static BorderStyleSequenceConverter getInstance() {
            return Holder.BORDER_STYLE_SEQUENCE_CONVERTER;
        }

        private BorderStyleSequenceConverter() {
        }

        @Override
        public BorderStyle[] convert(ParsedValue<ParsedValue<ParsedValue[], BorderStyle>[], BorderStyle[]> parsedValue, Font font) {
            BorderStyle[] borderStyleArray;
            ParsedValue<ParsedValue[], BorderStyle>[] parsedValueArray = parsedValue.getValue();
            borderStyleArray = new BorderStyle[]{parsedValueArray.length > 0 ? parsedValueArray[0].convert(font) : BorderStyle.SOLID, parsedValueArray.length > 1 ? parsedValueArray[1].convert(font) : borderStyleArray[0], parsedValueArray.length > 2 ? parsedValueArray[2].convert(font) : borderStyleArray[0], parsedValueArray.length > 3 ? parsedValueArray[3].convert(font) : borderStyleArray[1]};
            return borderStyleArray;
        }

        public String toString() {
            return "BorderStyleType";
        }
    }

    public static class Builder
    extends Border.Builder {
        private double topLeftCornerRadius = 0.0;
        private double topRightCornerRadius = 0.0;
        private double bottomLeftCornerRadius = 0.0;
        private double bottomRightCornerRadius = 0.0;
        private Paint topFill = Color.BLACK;
        private Paint rightFill = Color.BLACK;
        private Paint bottomFill = Color.BLACK;
        private Paint leftFill = Color.BLACK;
        private BorderStyle topStyle = BorderStyle.SOLID;
        private BorderStyle rightStyle = BorderStyle.SOLID;
        private BorderStyle bottomStyle = BorderStyle.SOLID;
        private BorderStyle leftStyle = BorderStyle.SOLID;

        public Builder setTopLeftCornerRadius(double d) {
            this.topLeftCornerRadius = d;
            return this;
        }

        public Builder setTopRightCornerRadius(double d) {
            this.topRightCornerRadius = d;
            return this;
        }

        public Builder setBottomRightCornerRadius(double d) {
            this.bottomRightCornerRadius = d;
            return this;
        }

        public Builder setBottomLeftCornerRadius(double d) {
            this.bottomLeftCornerRadius = d;
            return this;
        }

        public Builder setTopFill(Paint paint) {
            this.topFill = paint;
            return this;
        }

        public Builder setRightFill(Paint paint) {
            this.rightFill = paint;
            return this;
        }

        public Builder setBottomFill(Paint paint) {
            this.bottomFill = paint;
            return this;
        }

        public Builder setLeftFill(Paint paint) {
            this.leftFill = paint;
            return this;
        }

        public Builder setTopStyle(BorderStyle borderStyle) {
            this.topStyle = borderStyle;
            return this;
        }

        public Builder setRightStyle(BorderStyle borderStyle) {
            this.rightStyle = borderStyle;
            return this;
        }

        public Builder setBottomStyle(BorderStyle borderStyle) {
            this.bottomStyle = borderStyle;
            return this;
        }

        public Builder setLeftStyle(BorderStyle borderStyle) {
            this.leftStyle = borderStyle;
            return this;
        }

        public StrokeBorder build() {
            if (this.topStyle != null) {
                this.topStyle.adjustForStrokeWidth(this.topWidth);
            }
            if (this.rightStyle != null) {
                this.rightStyle.adjustForStrokeWidth(this.rightWidth);
            }
            if (this.bottomStyle != null) {
                this.bottomStyle.adjustForStrokeWidth(this.bottomWidth);
            }
            if (this.leftStyle != null) {
                this.leftStyle.adjustForStrokeWidth(this.leftWidth);
            }
            return new StrokeBorder(this.topWidth, this.rightWidth, this.bottomWidth, this.leftWidth, this.proportionalWidth, this.offsets, this.topLeftCornerRadius, this.topRightCornerRadius, this.bottomLeftCornerRadius, this.bottomRightCornerRadius, this.topFill, this.rightFill, this.bottomFill, this.leftFill, this.topStyle, this.rightStyle, this.bottomStyle, this.leftStyle);
        }
    }

    private static class Holder {
        private static final LayeredBorderPaintConverter LAYERED_BORDER_PAINT_CONVERTER = new LayeredBorderPaintConverter();
        private static final BorderPaintConverter BORDER_PAINT_CONVERTER = new BorderPaintConverter();
        private static final LayeredBorderStyleConverter LAYERED_BORDER_STYLE_CONVERTER = new LayeredBorderStyleConverter();
        private static final BorderStyleSequenceConverter BORDER_STYLE_SEQUENCE_CONVERTER = new BorderStyleSequenceConverter();
        private static final BorderStyleConverter BORDER_STYLE_CONVERTER = new BorderStyleConverter();

        private Holder() {
        }
    }

    public static final class LayeredBorderPaintConverter
    extends StyleConverter<ParsedValue<ParsedValue<?, Paint>[], Paint[]>[], Paint[][]> {
        public static LayeredBorderPaintConverter getInstance() {
            return Holder.LAYERED_BORDER_PAINT_CONVERTER;
        }

        private LayeredBorderPaintConverter() {
        }

        @Override
        public Paint[][] convert(ParsedValue<ParsedValue<ParsedValue<?, Paint>[], Paint[]>[], Paint[][]> parsedValue, Font font) {
            ParsedValue<ParsedValue<?, Paint>[], Paint[]>[] parsedValueArray = parsedValue.getValue();
            Paint[][] paintArray = new Paint[parsedValueArray.length][0];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                paintArray[i] = BorderPaintConverter.getInstance().convert(parsedValueArray[i], font);
            }
            return paintArray;
        }

        public String toString() {
            return "LayeredBorderPaintType";
        }
    }

    public static final class LayeredBorderStyleConverter
    extends StyleConverter<ParsedValue<ParsedValue<ParsedValue[], BorderStyle>[], BorderStyle[]>[], BorderStyle[][]> {
        public static LayeredBorderStyleConverter getInstance() {
            return Holder.LAYERED_BORDER_STYLE_CONVERTER;
        }

        private LayeredBorderStyleConverter() {
        }

        @Override
        public BorderStyle[][] convert(ParsedValue<ParsedValue<ParsedValue<ParsedValue[], BorderStyle>[], BorderStyle[]>[], BorderStyle[][]> parsedValue, Font font) {
            ParsedValue<ParsedValue<ParsedValue[], BorderStyle>[], BorderStyle[]>[] parsedValueArray = parsedValue.getValue();
            BorderStyle[][] borderStyleArray = new BorderStyle[parsedValueArray.length][0];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                borderStyleArray[i] = parsedValueArray[i].convert(font);
            }
            return borderStyleArray;
        }

        public String toString() {
            return "LayeredBorderStyleType";
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Node, Paint[]> BORDER_COLOR = new StyleableProperty<Node, Paint[]>("-fx-border-color", (StyleConverter)LayeredBorderPaintConverter.getInstance()){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<Paint[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final StyleableProperty<Node, BorderStyle[][]> BORDER_STYLE = new StyleableProperty<Node, BorderStyle[][]>("-fx-border-style", (StyleConverter)LayeredBorderStyleConverter.getInstance()){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<BorderStyle[][]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final StyleableProperty<Node, Margins[]> BORDER_WIDTH = new StyleableProperty<Node, Margins[]>("-fx-border-width", (StyleConverter)Margins.SequenceConverter.getInstance()){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<Margins[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final StyleableProperty<Node, Margins[]> BORDER_RADIUS = new StyleableProperty<Node, Margins[]>("-fx-border-radius", (StyleConverter)Margins.SequenceConverter.getInstance()){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<Margins[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final StyleableProperty<Node, Insets[]> BORDER_INSETS = new StyleableProperty<Node, Insets[]>("-fx-border-insets", (StyleConverter)InsetsConverter.SequenceConverter.getInstance()){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<Insets[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, BORDER_COLOR, BORDER_INSETS, BORDER_RADIUS, BORDER_STYLE, BORDER_WIDTH);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

