/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql;

import java.util.Collections;
import org.eclipse.persistence.jpa.internal.jpql.AbstractPathResolver;
import org.eclipse.persistence.jpa.internal.jpql.Resolver;
import org.eclipse.persistence.jpa.internal.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

public final class CollectionValuedFieldResolver
extends AbstractPathResolver {
    private String collectionValuedField;
    private Boolean enumType;
    private IManagedType managedType;
    private boolean managedTypeResolved;

    CollectionValuedFieldResolver(Resolver parent, String path, String collectionValuedField) {
        super(parent, path);
        this.collectionValuedField = collectionValuedField;
    }

    public void accept(ResolverVisitor visitor) {
        visitor.visit(this);
    }

    IType buildType() {
        ITypeDeclaration[] typeParameters;
        IType type = this.getEnumType();
        if (type != null) {
            return type;
        }
        ITypeDeclaration typeDeclaration = this.getTypeDeclaration();
        type = typeDeclaration.getType();
        if (this.getTypeHelper().isCollectionType(type)) {
            ITypeDeclaration[] typeParameters2 = typeDeclaration.getTypeParameters();
            if (typeParameters2.length > 0) {
                type = typeParameters2[0].getType();
            }
        } else if (this.getTypeHelper().isMapType(type) && (typeParameters = typeDeclaration.getTypeParameters()).length == 2) {
            type = typeParameters[1].getType();
        }
        return this.getTypeHelper().convertPrimitive(type);
    }

    ITypeDeclaration buildTypeDeclaration() {
        IType type = this.getEnumType();
        if (type != null) {
            this.enumType = Boolean.TRUE;
            return type.getTypeDeclaration();
        }
        this.enumType = Boolean.FALSE;
        return super.buildTypeDeclaration();
    }

    public String getCollectionValuedField() {
        return this.collectionValuedField;
    }

    private IType getEnumType() {
        return this.collectionValuedField != null ? this.getTypeRepository().getEnumType(this.collectionValuedField) : null;
    }

    public IManagedType getManagedType() {
        if (this.managedType == null && !this.managedTypeResolved) {
            if (!this.getType().isEnum()) {
                this.managedType = this.resolveManagedType();
            }
            this.managedTypeResolved = true;
        }
        return this.managedType;
    }

    public boolean isEnumType() {
        if (this.enumType == null) {
            this.getType();
        }
        return this.enumType;
    }

    private IManagedType resolveManagedType() {
        IMapping mapping = this.getMapping();
        if (mapping == null) {
            return null;
        }
        ITypeDeclaration typeDeclaration = mapping.getTypeDeclaration();
        IType type = typeDeclaration.getType();
        if (this.getTypeHelper().isCollectionType(type)) {
            ITypeDeclaration[] typeParameters = typeDeclaration.getTypeParameters();
            if (typeParameters.length == 0) {
                return null;
            }
            type = typeParameters[0].getType();
        } else if (this.getTypeHelper().isMapType(type)) {
            return new MapManagedType(this.getProvider(), type);
        }
        return this.getProvider().getManagedType(type);
    }

    public String toString() {
        return this.collectionValuedField;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapManagedType
    implements IManagedType {
        private final IType mapType;
        private final IManagedTypeProvider provider;

        MapManagedType(IManagedTypeProvider provider, IType mapType) {
            this.provider = provider;
            this.mapType = mapType;
        }

        @Override
        public void accept(IManagedTypeVisitor visitor) {
        }

        @Override
        public int compareTo(IManagedType managedType) {
            return this.getType().getName().compareTo(managedType.getType().getName());
        }

        @Override
        public IMapping getMappingNamed(String name) {
            return null;
        }

        @Override
        public IManagedTypeProvider getProvider() {
            return this.provider;
        }

        @Override
        public IType getType() {
            return this.mapType;
        }

        @Override
        public Iterable<IMapping> mappings() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.getType().getName();
        }
    }
}

